/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.content.pm;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class PackageManager {

@Deprecated
public PackageManager() { throw new RuntimeException("Stub!"); }

public abstract android.content.pm.PackageInfo getPackageInfo(@android.annotation.NonNull java.lang.String packageName, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

public abstract android.content.pm.PackageInfo getPackageInfo(@android.annotation.NonNull android.content.pm.VersionedPackage versionedPackage, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

public abstract java.lang.String[] currentToCanonicalPackageNames(@android.annotation.NonNull java.lang.String[] packageNames);

public abstract java.lang.String[] canonicalToCurrentPackageNames(@android.annotation.NonNull java.lang.String[] packageNames);

@android.annotation.Nullable
public abstract android.content.Intent getLaunchIntentForPackage(@android.annotation.NonNull java.lang.String packageName);

@android.annotation.Nullable
public abstract android.content.Intent getLeanbackLaunchIntentForPackage(@android.annotation.NonNull java.lang.String packageName);

public abstract int[] getPackageGids(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException;

public abstract int[] getPackageGids(@android.annotation.NonNull java.lang.String packageName, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

public abstract int getPackageUid(@android.annotation.NonNull java.lang.String packageName, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

public abstract android.content.pm.PermissionInfo getPermissionInfo(@android.annotation.NonNull java.lang.String permName, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.PermissionInfo> queryPermissionsByGroup(@android.annotation.Nullable java.lang.String permissionGroup, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract android.content.pm.PermissionGroupInfo getPermissionGroupInfo(@android.annotation.NonNull java.lang.String groupName, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.PermissionGroupInfo> getAllPermissionGroups(int flags);

public void getPlatformPermissionsForGroup(@android.annotation.NonNull java.lang.String permissionGroupName, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.util.List<java.lang.String>> callback) { throw new RuntimeException("Stub!"); }

public void getGroupOfPlatformPermission(@android.annotation.NonNull java.lang.String permissionName, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.String> callback) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.content.pm.ApplicationInfo getApplicationInfo(@android.annotation.NonNull java.lang.String packageName, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

public int getTargetSdkVersion(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.content.pm.ActivityInfo getActivityInfo(@android.annotation.NonNull android.content.ComponentName component, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract android.content.pm.ActivityInfo getReceiverInfo(@android.annotation.NonNull android.content.ComponentName component, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract android.content.pm.ServiceInfo getServiceInfo(@android.annotation.NonNull android.content.ComponentName component, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract android.content.pm.ProviderInfo getProviderInfo(@android.annotation.NonNull android.content.ComponentName component, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public android.content.pm.ModuleInfo getModuleInfo(@android.annotation.NonNull java.lang.String packageName, int flags) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.ModuleInfo> getInstalledModules(int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.PackageInfo> getInstalledPackages(int flags);

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.PackageInfo> getPackagesHoldingPermissions(@android.annotation.NonNull java.lang.String[] permissions, int flags);

public abstract int checkPermission(@android.annotation.NonNull java.lang.String permName, @android.annotation.NonNull java.lang.String packageName);

public abstract boolean isPermissionRevokedByPolicy(@android.annotation.NonNull java.lang.String permName, @android.annotation.NonNull java.lang.String packageName);

public abstract boolean addPermission(@android.annotation.NonNull android.content.pm.PermissionInfo info);

public abstract boolean addPermissionAsync(@android.annotation.NonNull android.content.pm.PermissionInfo info);

public abstract void removePermission(@android.annotation.NonNull java.lang.String permName);

@android.annotation.NonNull
public java.util.Set<java.lang.String> getWhitelistedRestrictedPermissions(@android.annotation.NonNull java.lang.String packageName, int whitelistFlag) { throw new RuntimeException("Stub!"); }

public boolean addWhitelistedRestrictedPermission(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.lang.String permName, int whitelistFlags) { throw new RuntimeException("Stub!"); }

public boolean removeWhitelistedRestrictedPermission(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.lang.String permName, int whitelistFlags) { throw new RuntimeException("Stub!"); }

public boolean setAutoRevokeWhitelisted(@android.annotation.NonNull java.lang.String packageName, boolean whitelisted) { throw new RuntimeException("Stub!"); }

public boolean isAutoRevokeWhitelisted(@android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.CharSequence getBackgroundPermissionOptionLabel() { throw new RuntimeException("Stub!"); }

public abstract int checkSignatures(@android.annotation.NonNull java.lang.String packageName1, @android.annotation.NonNull java.lang.String packageName2);

public abstract int checkSignatures(int uid1, int uid2);

@android.annotation.Nullable
public abstract java.lang.String[] getPackagesForUid(int uid);

@android.annotation.Nullable
public abstract java.lang.String getNameForUid(int uid);

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.ApplicationInfo> getInstalledApplications(int flags);

public abstract boolean isInstantApp();

public abstract boolean isInstantApp(@android.annotation.NonNull java.lang.String packageName);

public abstract int getInstantAppCookieMaxBytes();

@android.annotation.NonNull
public abstract byte[] getInstantAppCookie();

public abstract void clearInstantAppCookie();

public abstract void updateInstantAppCookie(@android.annotation.Nullable byte[] cookie);

@android.annotation.Nullable
public abstract java.lang.String[] getSystemSharedLibraryNames();

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.SharedLibraryInfo> getSharedLibraries(int flags);

@android.annotation.Nullable
public abstract android.content.pm.ChangedPackages getChangedPackages(int sequenceNumber);

@android.annotation.NonNull
public abstract android.content.pm.FeatureInfo[] getSystemAvailableFeatures();

public abstract boolean hasSystemFeature(@android.annotation.NonNull java.lang.String featureName);

public abstract boolean hasSystemFeature(@android.annotation.NonNull java.lang.String featureName, int version);

@android.annotation.Nullable
public abstract android.content.pm.ResolveInfo resolveActivity(@android.annotation.NonNull android.content.Intent intent, int flags);

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.ResolveInfo> queryIntentActivities(@android.annotation.NonNull android.content.Intent intent, int flags);

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.ResolveInfo> queryIntentActivityOptions(@android.annotation.Nullable android.content.ComponentName caller, @android.annotation.Nullable android.content.Intent[] specifics, @android.annotation.NonNull android.content.Intent intent, int flags);

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.ResolveInfo> queryBroadcastReceivers(@android.annotation.NonNull android.content.Intent intent, int flags);

@android.annotation.Nullable
public abstract android.content.pm.ResolveInfo resolveService(@android.annotation.NonNull android.content.Intent intent, int flags);

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.ResolveInfo> queryIntentServices(@android.annotation.NonNull android.content.Intent intent, int flags);

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.ResolveInfo> queryIntentContentProviders(@android.annotation.NonNull android.content.Intent intent, int flags);

@android.annotation.Nullable
public abstract android.content.pm.ProviderInfo resolveContentProvider(@android.annotation.NonNull java.lang.String authority, int flags);

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.ProviderInfo> queryContentProviders(@android.annotation.Nullable java.lang.String processName, int uid, int flags);

@android.annotation.NonNull
public abstract android.content.pm.InstrumentationInfo getInstrumentationInfo(@android.annotation.NonNull android.content.ComponentName className, int flags) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract java.util.List<android.content.pm.InstrumentationInfo> queryInstrumentation(@android.annotation.NonNull java.lang.String targetPackage, int flags);

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getDrawable(@android.annotation.NonNull java.lang.String packageName, int resid, @android.annotation.Nullable android.content.pm.ApplicationInfo appInfo);

@android.annotation.NonNull
public abstract android.graphics.drawable.Drawable getActivityIcon(@android.annotation.NonNull android.content.ComponentName activityName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract android.graphics.drawable.Drawable getActivityIcon(@android.annotation.NonNull android.content.Intent intent) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getActivityBanner(@android.annotation.NonNull android.content.ComponentName activityName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getActivityBanner(@android.annotation.NonNull android.content.Intent intent) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract android.graphics.drawable.Drawable getDefaultActivityIcon();

@android.annotation.NonNull
public abstract android.graphics.drawable.Drawable getApplicationIcon(@android.annotation.NonNull android.content.pm.ApplicationInfo info);

@android.annotation.NonNull
public abstract android.graphics.drawable.Drawable getApplicationIcon(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getApplicationBanner(@android.annotation.NonNull android.content.pm.ApplicationInfo info);

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getApplicationBanner(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getActivityLogo(@android.annotation.NonNull android.content.ComponentName activityName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getActivityLogo(@android.annotation.NonNull android.content.Intent intent) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getApplicationLogo(@android.annotation.NonNull android.content.pm.ApplicationInfo info);

@android.annotation.Nullable
public abstract android.graphics.drawable.Drawable getApplicationLogo(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract android.graphics.drawable.Drawable getUserBadgedIcon(@android.annotation.NonNull android.graphics.drawable.Drawable drawable, @android.annotation.NonNull android.os.UserHandle user);

@android.annotation.NonNull
public abstract android.graphics.drawable.Drawable getUserBadgedDrawableForDensity(@android.annotation.NonNull android.graphics.drawable.Drawable drawable, @android.annotation.NonNull android.os.UserHandle user, @android.annotation.Nullable android.graphics.Rect badgeLocation, int badgeDensity);

@android.annotation.NonNull
public abstract java.lang.CharSequence getUserBadgedLabel(@android.annotation.NonNull java.lang.CharSequence label, @android.annotation.NonNull android.os.UserHandle user);

@android.annotation.Nullable
public abstract java.lang.CharSequence getText(@android.annotation.NonNull java.lang.String packageName, int resid, @android.annotation.Nullable android.content.pm.ApplicationInfo appInfo);

@android.annotation.Nullable
public abstract android.content.res.XmlResourceParser getXml(@android.annotation.NonNull java.lang.String packageName, int resid, @android.annotation.Nullable android.content.pm.ApplicationInfo appInfo);

@android.annotation.NonNull
public abstract java.lang.CharSequence getApplicationLabel(@android.annotation.NonNull android.content.pm.ApplicationInfo info);

@android.annotation.NonNull
public abstract android.content.res.Resources getResourcesForActivity(@android.annotation.NonNull android.content.ComponentName activityName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public abstract android.content.res.Resources getResourcesForApplication(@android.annotation.NonNull android.content.pm.ApplicationInfo app) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.NonNull
public android.content.res.Resources getResourcesForApplication(@android.annotation.NonNull android.content.pm.ApplicationInfo app, @android.annotation.Nullable android.content.res.Configuration configuration) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.content.res.Resources getResourcesForApplication(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException;

@android.annotation.Nullable
public android.content.pm.PackageInfo getPackageArchiveInfo(@android.annotation.NonNull java.lang.String archiveFilePath, int flags) { throw new RuntimeException("Stub!"); }

public abstract void verifyPendingInstall(int id, int verificationCode);

public abstract void extendVerificationTimeout(int id, int verificationCodeAtTimeout, long millisecondsToDelay);

public abstract void setInstallerPackageName(@android.annotation.NonNull java.lang.String targetPackage, @android.annotation.Nullable java.lang.String installerPackageName);

@Deprecated
@android.annotation.Nullable
public abstract java.lang.String getInstallerPackageName(@android.annotation.NonNull java.lang.String packageName);

@android.annotation.NonNull
public android.content.pm.InstallSourceInfo getInstallSourceInfo(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@Deprecated
public abstract void addPackageToPreferred(@android.annotation.NonNull java.lang.String packageName);

@Deprecated
public abstract void removePackageFromPreferred(@android.annotation.NonNull java.lang.String packageName);

@Deprecated
@android.annotation.NonNull
public abstract java.util.List<android.content.pm.PackageInfo> getPreferredPackages(int flags);

@Deprecated
public abstract void addPreferredActivity(@android.annotation.NonNull android.content.IntentFilter filter, int match, @android.annotation.Nullable android.content.ComponentName[] set, @android.annotation.NonNull android.content.ComponentName activity);

@Deprecated
public abstract void clearPackagePreferredActivities(@android.annotation.NonNull java.lang.String packageName);

@Deprecated
public abstract int getPreferredActivities(@android.annotation.NonNull java.util.List<android.content.IntentFilter> outFilters, @android.annotation.NonNull java.util.List<android.content.ComponentName> outActivities, @android.annotation.Nullable java.lang.String packageName);

public abstract void setComponentEnabledSetting(@android.annotation.NonNull android.content.ComponentName componentName, int newState, int flags);

public abstract int getComponentEnabledSetting(@android.annotation.NonNull android.content.ComponentName componentName);

public boolean getSyntheticAppDetailsActivityEnabled(@android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

public abstract void setApplicationEnabledSetting(@android.annotation.NonNull java.lang.String packageName, int newState, int flags);

public abstract int getApplicationEnabledSetting(@android.annotation.NonNull java.lang.String packageName);

public abstract boolean isSafeMode();

public boolean isPackageSuspended(@android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public boolean isPackageSuspended() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.Bundle getSuspendedPackageAppExtras() { throw new RuntimeException("Stub!"); }

public abstract void setApplicationCategoryHint(@android.annotation.NonNull java.lang.String packageName, int categoryHint);

public boolean isDeviceUpgrading() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.content.pm.PackageInstaller getPackageInstaller();

public abstract boolean canRequestPackageInstalls();

public boolean hasSigningCertificate(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull byte[] certificate, int type) { throw new RuntimeException("Stub!"); }

public boolean hasSigningCertificate(int uid, @android.annotation.NonNull byte[] certificate, int type) { throw new RuntimeException("Stub!"); }

public void requestChecksums(@android.annotation.NonNull java.lang.String packageName, boolean includeSplits, int required, @android.annotation.NonNull java.util.List<java.security.cert.Certificate> trustedInstallers, @android.annotation.NonNull android.content.pm.PackageManager.OnChecksumsReadyListener onChecksumsReadyListener) throws java.security.cert.CertificateEncodingException, android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public boolean isAutoRevokeWhitelisted() { throw new RuntimeException("Stub!"); }

public boolean isDefaultApplicationIcon(@android.annotation.NonNull android.graphics.drawable.Drawable drawable) { throw new RuntimeException("Stub!"); }

public void setMimeGroup(@android.annotation.NonNull java.lang.String mimeGroup, @android.annotation.NonNull java.util.Set<java.lang.String> mimeTypes) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<java.lang.String> getMimeGroup(@android.annotation.NonNull java.lang.String mimeGroup) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageManager.Property getProperty(@android.annotation.NonNull java.lang.String propertyName, @android.annotation.NonNull java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.pm.PackageManager.Property getProperty(@android.annotation.NonNull java.lang.String propertyName, @android.annotation.NonNull android.content.ComponentName component) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageManager.Property> queryApplicationProperty(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageManager.Property> queryActivityProperty(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageManager.Property> queryProviderProperty(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageManager.Property> queryReceiverProperty(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.content.pm.PackageManager.Property> queryServiceProperty(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

public static final int CERT_INPUT_RAW_X509 = 0; // 0x0

public static final int CERT_INPUT_SHA256 = 1; // 0x1

public static final int COMPONENT_ENABLED_STATE_DEFAULT = 0; // 0x0

public static final int COMPONENT_ENABLED_STATE_DISABLED = 2; // 0x2

public static final int COMPONENT_ENABLED_STATE_DISABLED_UNTIL_USED = 4; // 0x4

public static final int COMPONENT_ENABLED_STATE_DISABLED_USER = 3; // 0x3

public static final int COMPONENT_ENABLED_STATE_ENABLED = 1; // 0x1

public static final int DONT_KILL_APP = 1; // 0x1

public static final java.lang.String EXTRA_VERIFICATION_ID = "android.content.pm.extra.VERIFICATION_ID";

public static final java.lang.String EXTRA_VERIFICATION_RESULT = "android.content.pm.extra.VERIFICATION_RESULT";

public static final java.lang.String FEATURE_ACTIVITIES_ON_SECONDARY_DISPLAYS = "android.software.activities_on_secondary_displays";

public static final java.lang.String FEATURE_APP_WIDGETS = "android.software.app_widgets";

public static final java.lang.String FEATURE_AUDIO_LOW_LATENCY = "android.hardware.audio.low_latency";

public static final java.lang.String FEATURE_AUDIO_OUTPUT = "android.hardware.audio.output";

public static final java.lang.String FEATURE_AUDIO_PRO = "android.hardware.audio.pro";

public static final java.lang.String FEATURE_AUTOFILL = "android.software.autofill";

public static final java.lang.String FEATURE_AUTOMOTIVE = "android.hardware.type.automotive";

public static final java.lang.String FEATURE_BACKUP = "android.software.backup";

public static final java.lang.String FEATURE_BLUETOOTH = "android.hardware.bluetooth";

public static final java.lang.String FEATURE_BLUETOOTH_LE = "android.hardware.bluetooth_le";

public static final java.lang.String FEATURE_CAMERA = "android.hardware.camera";

public static final java.lang.String FEATURE_CAMERA_ANY = "android.hardware.camera.any";

public static final java.lang.String FEATURE_CAMERA_AR = "android.hardware.camera.ar";

public static final java.lang.String FEATURE_CAMERA_AUTOFOCUS = "android.hardware.camera.autofocus";

public static final java.lang.String FEATURE_CAMERA_CAPABILITY_MANUAL_POST_PROCESSING = "android.hardware.camera.capability.manual_post_processing";

public static final java.lang.String FEATURE_CAMERA_CAPABILITY_MANUAL_SENSOR = "android.hardware.camera.capability.manual_sensor";

public static final java.lang.String FEATURE_CAMERA_CAPABILITY_RAW = "android.hardware.camera.capability.raw";

public static final java.lang.String FEATURE_CAMERA_CONCURRENT = "android.hardware.camera.concurrent";

public static final java.lang.String FEATURE_CAMERA_EXTERNAL = "android.hardware.camera.external";

public static final java.lang.String FEATURE_CAMERA_FLASH = "android.hardware.camera.flash";

public static final java.lang.String FEATURE_CAMERA_FRONT = "android.hardware.camera.front";

public static final java.lang.String FEATURE_CAMERA_LEVEL_FULL = "android.hardware.camera.level.full";

public static final java.lang.String FEATURE_CANT_SAVE_STATE = "android.software.cant_save_state";

public static final java.lang.String FEATURE_COMPANION_DEVICE_SETUP = "android.software.companion_device_setup";

public static final java.lang.String FEATURE_CONNECTION_SERVICE = "android.software.connectionservice";

public static final java.lang.String FEATURE_CONSUMER_IR = "android.hardware.consumerir";

public static final java.lang.String FEATURE_CONTROLS = "android.software.controls";

public static final java.lang.String FEATURE_DEVICE_ADMIN = "android.software.device_admin";

public static final java.lang.String FEATURE_EMBEDDED = "android.hardware.type.embedded";

public static final java.lang.String FEATURE_ETHERNET = "android.hardware.ethernet";

public static final java.lang.String FEATURE_FACE = "android.hardware.biometrics.face";

public static final java.lang.String FEATURE_FAKETOUCH = "android.hardware.faketouch";

public static final java.lang.String FEATURE_FAKETOUCH_MULTITOUCH_DISTINCT = "android.hardware.faketouch.multitouch.distinct";

public static final java.lang.String FEATURE_FAKETOUCH_MULTITOUCH_JAZZHAND = "android.hardware.faketouch.multitouch.jazzhand";

public static final java.lang.String FEATURE_FINGERPRINT = "android.hardware.fingerprint";

public static final java.lang.String FEATURE_FREEFORM_WINDOW_MANAGEMENT = "android.software.freeform_window_management";

public static final java.lang.String FEATURE_GAMEPAD = "android.hardware.gamepad";

public static final java.lang.String FEATURE_HARDWARE_KEYSTORE = "android.hardware.hardware_keystore";

public static final java.lang.String FEATURE_HIFI_SENSORS = "android.hardware.sensor.hifi_sensors";

public static final java.lang.String FEATURE_HOME_SCREEN = "android.software.home_screen";

public static final java.lang.String FEATURE_IDENTITY_CREDENTIAL_HARDWARE = "android.hardware.identity_credential";

public static final java.lang.String FEATURE_IDENTITY_CREDENTIAL_HARDWARE_DIRECT_ACCESS = "android.hardware.identity_credential_direct_access";

public static final java.lang.String FEATURE_INPUT_METHODS = "android.software.input_methods";

public static final java.lang.String FEATURE_IPSEC_TUNNELS = "android.software.ipsec_tunnels";

public static final java.lang.String FEATURE_IRIS = "android.hardware.biometrics.iris";

public static final java.lang.String FEATURE_KEYSTORE_APP_ATTEST_KEY = "android.hardware.keystore.app_attest_key";

public static final java.lang.String FEATURE_KEYSTORE_LIMITED_USE_KEY = "android.hardware.keystore.limited_use_key";

public static final java.lang.String FEATURE_KEYSTORE_SINGLE_USE_KEY = "android.hardware.keystore.single_use_key";

public static final java.lang.String FEATURE_LEANBACK = "android.software.leanback";

public static final java.lang.String FEATURE_LEANBACK_ONLY = "android.software.leanback_only";

public static final java.lang.String FEATURE_LIVE_TV = "android.software.live_tv";

public static final java.lang.String FEATURE_LIVE_WALLPAPER = "android.software.live_wallpaper";

public static final java.lang.String FEATURE_LOCATION = "android.hardware.location";

public static final java.lang.String FEATURE_LOCATION_GPS = "android.hardware.location.gps";

public static final java.lang.String FEATURE_LOCATION_NETWORK = "android.hardware.location.network";

public static final java.lang.String FEATURE_MANAGED_USERS = "android.software.managed_users";

public static final java.lang.String FEATURE_MICROPHONE = "android.hardware.microphone";

public static final java.lang.String FEATURE_MIDI = "android.software.midi";

public static final java.lang.String FEATURE_NFC = "android.hardware.nfc";

public static final java.lang.String FEATURE_NFC_BEAM = "android.sofware.nfc.beam";

public static final java.lang.String FEATURE_NFC_HOST_CARD_EMULATION = "android.hardware.nfc.hce";

public static final java.lang.String FEATURE_NFC_HOST_CARD_EMULATION_NFCF = "android.hardware.nfc.hcef";

public static final java.lang.String FEATURE_NFC_OFF_HOST_CARD_EMULATION_ESE = "android.hardware.nfc.ese";

public static final java.lang.String FEATURE_NFC_OFF_HOST_CARD_EMULATION_UICC = "android.hardware.nfc.uicc";

public static final java.lang.String FEATURE_OPENGLES_DEQP_LEVEL = "android.software.opengles.deqp.level";

public static final java.lang.String FEATURE_OPENGLES_EXTENSION_PACK = "android.hardware.opengles.aep";

public static final java.lang.String FEATURE_PC = "android.hardware.type.pc";

public static final java.lang.String FEATURE_PICTURE_IN_PICTURE = "android.software.picture_in_picture";

public static final java.lang.String FEATURE_PRINTING = "android.software.print";

public static final java.lang.String FEATURE_RAM_LOW = "android.hardware.ram.low";

public static final java.lang.String FEATURE_RAM_NORMAL = "android.hardware.ram.normal";

public static final java.lang.String FEATURE_SCREEN_LANDSCAPE = "android.hardware.screen.landscape";

public static final java.lang.String FEATURE_SCREEN_PORTRAIT = "android.hardware.screen.portrait";

public static final java.lang.String FEATURE_SECURELY_REMOVES_USERS = "android.software.securely_removes_users";

public static final java.lang.String FEATURE_SECURE_LOCK_SCREEN = "android.software.secure_lock_screen";

public static final java.lang.String FEATURE_SECURITY_MODEL_COMPATIBLE = "android.hardware.security.model.compatible";

public static final java.lang.String FEATURE_SENSOR_ACCELEROMETER = "android.hardware.sensor.accelerometer";

public static final java.lang.String FEATURE_SENSOR_AMBIENT_TEMPERATURE = "android.hardware.sensor.ambient_temperature";

public static final java.lang.String FEATURE_SENSOR_BAROMETER = "android.hardware.sensor.barometer";

public static final java.lang.String FEATURE_SENSOR_COMPASS = "android.hardware.sensor.compass";

public static final java.lang.String FEATURE_SENSOR_GYROSCOPE = "android.hardware.sensor.gyroscope";

public static final java.lang.String FEATURE_SENSOR_HEART_RATE = "android.hardware.sensor.heartrate";

public static final java.lang.String FEATURE_SENSOR_HEART_RATE_ECG = "android.hardware.sensor.heartrate.ecg";

public static final java.lang.String FEATURE_SENSOR_HINGE_ANGLE = "android.hardware.sensor.hinge_angle";

public static final java.lang.String FEATURE_SENSOR_LIGHT = "android.hardware.sensor.light";

public static final java.lang.String FEATURE_SENSOR_PROXIMITY = "android.hardware.sensor.proximity";

public static final java.lang.String FEATURE_SENSOR_RELATIVE_HUMIDITY = "android.hardware.sensor.relative_humidity";

public static final java.lang.String FEATURE_SENSOR_STEP_COUNTER = "android.hardware.sensor.stepcounter";

public static final java.lang.String FEATURE_SENSOR_STEP_DETECTOR = "android.hardware.sensor.stepdetector";

public static final java.lang.String FEATURE_SE_OMAPI_ESE = "android.hardware.se.omapi.ese";

public static final java.lang.String FEATURE_SE_OMAPI_SD = "android.hardware.se.omapi.sd";

public static final java.lang.String FEATURE_SE_OMAPI_UICC = "android.hardware.se.omapi.uicc";

public static final java.lang.String FEATURE_SIP = "android.software.sip";

public static final java.lang.String FEATURE_SIP_VOIP = "android.software.sip.voip";

public static final java.lang.String FEATURE_STRONGBOX_KEYSTORE = "android.hardware.strongbox_keystore";

public static final java.lang.String FEATURE_TELEPHONY = "android.hardware.telephony";

public static final java.lang.String FEATURE_TELEPHONY_CDMA = "android.hardware.telephony.cdma";

public static final java.lang.String FEATURE_TELEPHONY_EUICC = "android.hardware.telephony.euicc";

public static final java.lang.String FEATURE_TELEPHONY_GSM = "android.hardware.telephony.gsm";

public static final java.lang.String FEATURE_TELEPHONY_IMS = "android.hardware.telephony.ims";

public static final java.lang.String FEATURE_TELEPHONY_MBMS = "android.hardware.telephony.mbms";

@Deprecated public static final java.lang.String FEATURE_TELEVISION = "android.hardware.type.television";

public static final java.lang.String FEATURE_TOUCHSCREEN = "android.hardware.touchscreen";

public static final java.lang.String FEATURE_TOUCHSCREEN_MULTITOUCH = "android.hardware.touchscreen.multitouch";

public static final java.lang.String FEATURE_TOUCHSCREEN_MULTITOUCH_DISTINCT = "android.hardware.touchscreen.multitouch.distinct";

public static final java.lang.String FEATURE_TOUCHSCREEN_MULTITOUCH_JAZZHAND = "android.hardware.touchscreen.multitouch.jazzhand";

public static final java.lang.String FEATURE_USB_ACCESSORY = "android.hardware.usb.accessory";

public static final java.lang.String FEATURE_USB_HOST = "android.hardware.usb.host";

public static final java.lang.String FEATURE_VERIFIED_BOOT = "android.software.verified_boot";

public static final java.lang.String FEATURE_VR_HEADTRACKING = "android.hardware.vr.headtracking";

@Deprecated public static final java.lang.String FEATURE_VR_MODE = "android.software.vr.mode";

public static final java.lang.String FEATURE_VR_MODE_HIGH_PERFORMANCE = "android.hardware.vr.high_performance";

public static final java.lang.String FEATURE_VULKAN_DEQP_LEVEL = "android.software.vulkan.deqp.level";

public static final java.lang.String FEATURE_VULKAN_HARDWARE_COMPUTE = "android.hardware.vulkan.compute";

public static final java.lang.String FEATURE_VULKAN_HARDWARE_LEVEL = "android.hardware.vulkan.level";

public static final java.lang.String FEATURE_VULKAN_HARDWARE_VERSION = "android.hardware.vulkan.version";

public static final java.lang.String FEATURE_WATCH = "android.hardware.type.watch";

public static final java.lang.String FEATURE_WEBVIEW = "android.software.webview";

public static final java.lang.String FEATURE_WIFI = "android.hardware.wifi";

public static final java.lang.String FEATURE_WIFI_AWARE = "android.hardware.wifi.aware";

public static final java.lang.String FEATURE_WIFI_DIRECT = "android.hardware.wifi.direct";

public static final java.lang.String FEATURE_WIFI_PASSPOINT = "android.hardware.wifi.passpoint";

public static final java.lang.String FEATURE_WIFI_RTT = "android.hardware.wifi.rtt";

public static final int FLAG_PERMISSION_WHITELIST_INSTALLER = 2; // 0x2

public static final int FLAG_PERMISSION_WHITELIST_SYSTEM = 1; // 0x1

public static final int FLAG_PERMISSION_WHITELIST_UPGRADE = 4; // 0x4

public static final int GET_ACTIVITIES = 1; // 0x1

public static final int GET_ATTRIBUTIONS = -2147483648; // 0x80000000

public static final int GET_CONFIGURATIONS = 16384; // 0x4000

@Deprecated public static final int GET_DISABLED_COMPONENTS = 512; // 0x200

@Deprecated public static final int GET_DISABLED_UNTIL_USED_COMPONENTS = 32768; // 0x8000

public static final int GET_GIDS = 256; // 0x100

public static final int GET_INSTRUMENTATION = 16; // 0x10

@Deprecated public static final int GET_INTENT_FILTERS = 32; // 0x20

public static final int GET_META_DATA = 128; // 0x80

public static final int GET_PERMISSIONS = 4096; // 0x1000

public static final int GET_PROVIDERS = 8; // 0x8

public static final int GET_RECEIVERS = 2; // 0x2

public static final int GET_RESOLVED_FILTER = 64; // 0x40

public static final int GET_SERVICES = 4; // 0x4

public static final int GET_SHARED_LIBRARY_FILES = 1024; // 0x400

@Deprecated public static final int GET_SIGNATURES = 64; // 0x40

public static final int GET_SIGNING_CERTIFICATES = 134217728; // 0x8000000

@Deprecated public static final int GET_UNINSTALLED_PACKAGES = 8192; // 0x2000

public static final int GET_URI_PERMISSION_PATTERNS = 2048; // 0x800

public static final int INSTALL_REASON_DEVICE_RESTORE = 2; // 0x2

public static final int INSTALL_REASON_DEVICE_SETUP = 3; // 0x3

public static final int INSTALL_REASON_POLICY = 1; // 0x1

public static final int INSTALL_REASON_UNKNOWN = 0; // 0x0

public static final int INSTALL_REASON_USER = 4; // 0x4

public static final int INSTALL_SCENARIO_BULK = 2; // 0x2

public static final int INSTALL_SCENARIO_BULK_SECONDARY = 3; // 0x3

public static final int INSTALL_SCENARIO_DEFAULT = 0; // 0x0

public static final int INSTALL_SCENARIO_FAST = 1; // 0x1

public static final int MATCH_ALL = 131072; // 0x20000

public static final int MATCH_APEX = 1073741824; // 0x40000000

public static final int MATCH_DEFAULT_ONLY = 65536; // 0x10000

public static final int MATCH_DIRECT_BOOT_AUTO = 268435456; // 0x10000000

public static final int MATCH_DIRECT_BOOT_AWARE = 524288; // 0x80000

public static final int MATCH_DIRECT_BOOT_UNAWARE = 262144; // 0x40000

public static final int MATCH_DISABLED_COMPONENTS = 512; // 0x200

public static final int MATCH_DISABLED_UNTIL_USED_COMPONENTS = 32768; // 0x8000

public static final int MATCH_SYSTEM_ONLY = 1048576; // 0x100000

public static final int MATCH_UNINSTALLED_PACKAGES = 8192; // 0x2000

public static final long MAXIMUM_VERIFICATION_TIMEOUT = 3600000L; // 0x36ee80L

public static final int PERMISSION_DENIED = -1; // 0xffffffff

public static final int PERMISSION_GRANTED = 0; // 0x0

public static final java.lang.String PROPERTY_MEDIA_CAPABILITIES = "android.media.PROPERTY_MEDIA_CAPABILITIES";

public static final int SIGNATURE_FIRST_NOT_SIGNED = -1; // 0xffffffff

public static final int SIGNATURE_MATCH = 0; // 0x0

public static final int SIGNATURE_NEITHER_SIGNED = 1; // 0x1

public static final int SIGNATURE_NO_MATCH = -3; // 0xfffffffd

public static final int SIGNATURE_SECOND_NOT_SIGNED = -2; // 0xfffffffe

public static final int SIGNATURE_UNKNOWN_PACKAGE = -4; // 0xfffffffc

public static final int SYNCHRONOUS = 2; // 0x2

@android.annotation.NonNull public static final java.util.List<java.security.cert.Certificate> TRUST_ALL;
static { TRUST_ALL = null; }

@android.annotation.NonNull public static final java.util.List<java.security.cert.Certificate> TRUST_NONE;
static { TRUST_NONE = null; }

public static final int VERIFICATION_ALLOW = 1; // 0x1

public static final int VERIFICATION_REJECT = -1; // 0xffffffff

public static final int VERSION_CODE_HIGHEST = -1; // 0xffffffff
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class NameNotFoundException extends android.util.AndroidException {

public NameNotFoundException() { throw new RuntimeException("Stub!"); }

public NameNotFoundException(java.lang.String name) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@java.lang.FunctionalInterface
public static interface OnChecksumsReadyListener {

public void onChecksumsReady(@android.annotation.NonNull java.util.List<android.content.pm.ApkChecksum> checksums);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Property implements android.os.Parcelable {

Property() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getPackageName() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getClassName() { throw new RuntimeException("Stub!"); }

public boolean getBoolean() { throw new RuntimeException("Stub!"); }

public boolean isBoolean() { throw new RuntimeException("Stub!"); }

public float getFloat() { throw new RuntimeException("Stub!"); }

public boolean isFloat() { throw new RuntimeException("Stub!"); }

public int getInteger() { throw new RuntimeException("Stub!"); }

public boolean isInteger() { throw new RuntimeException("Stub!"); }

public int getResourceId() { throw new RuntimeException("Stub!"); }

public boolean isResourceId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getString() { throw new RuntimeException("Stub!"); }

public boolean isString() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.content.pm.PackageManager.Property> CREATOR;
static { CREATOR = null; }
}

}

