/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.content;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface SharedPreferences {

public java.util.Map<java.lang.String,?> getAll();

@android.annotation.Nullable
public java.lang.String getString(java.lang.String key, @android.annotation.Nullable java.lang.String defValue);

@android.annotation.Nullable
public java.util.Set<java.lang.String> getStringSet(java.lang.String key, @android.annotation.Nullable java.util.Set<java.lang.String> defValues);

public int getInt(java.lang.String key, int defValue);

public long getLong(java.lang.String key, long defValue);

public float getFloat(java.lang.String key, float defValue);

public boolean getBoolean(java.lang.String key, boolean defValue);

public boolean contains(java.lang.String key);

public android.content.SharedPreferences.Editor edit();

public void registerOnSharedPreferenceChangeListener(android.content.SharedPreferences.OnSharedPreferenceChangeListener listener);

public void unregisterOnSharedPreferenceChangeListener(android.content.SharedPreferences.OnSharedPreferenceChangeListener listener);
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface Editor {

public android.content.SharedPreferences.Editor putString(java.lang.String key, @android.annotation.Nullable java.lang.String value);

public android.content.SharedPreferences.Editor putStringSet(java.lang.String key, @android.annotation.Nullable java.util.Set<java.lang.String> values);

public android.content.SharedPreferences.Editor putInt(java.lang.String key, int value);

public android.content.SharedPreferences.Editor putLong(java.lang.String key, long value);

public android.content.SharedPreferences.Editor putFloat(java.lang.String key, float value);

public android.content.SharedPreferences.Editor putBoolean(java.lang.String key, boolean value);

public android.content.SharedPreferences.Editor remove(java.lang.String key);

public android.content.SharedPreferences.Editor clear();

public boolean commit();

public void apply();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnSharedPreferenceChangeListener {

public void onSharedPreferenceChanged(android.content.SharedPreferences sharedPreferences, java.lang.String key);
}

}

