/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

import java.util.List;
import java.util.Set;

/** The response class of {@link android.app.appsearch.AppSearchSession#setSchema AppSearchSession#setSchema} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class SetSchemaResponse {

SetSchemaResponse() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.List List} of all failed {@link android.app.appsearch.SetSchemaResponse.MigrationFailure MigrationFailure}.
 *
 * <p>A {@link android.app.appsearch.SetSchemaResponse.MigrationFailure MigrationFailure} will be generated if the system trying to save a post-migrated
 * {@link android.app.appsearch.GenericDocument GenericDocument} but fail.
 *
 * <p>{@link android.app.appsearch.SetSchemaResponse.MigrationFailure MigrationFailure} contains the namespace, id and schemaType of the post-migrated
 * {@link android.app.appsearch.GenericDocument GenericDocument} and the error reason. Mostly it will be mismatch the schema it
 * migrated to.
 */

@android.annotation.NonNull
public java.util.List<android.app.appsearch.SetSchemaResponse.MigrationFailure> getMigrationFailures() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.Set Set} of deleted schema types.
 *
 * <p>A "deleted" type is a schema type that was previously a part of the database schema but
 * was not present in the {@link android.app.appsearch.SetSchemaRequest SetSchemaRequest} object provided in the
 * {@link android.app.appsearch.AppSearchSession#setSchema  <p>Documents for a deleted type are removed from the database.}
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getDeletedTypes() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.Set Set} of schema type that were migrated by the {@link android.app.appsearch.AppSearchSession#setSchema  } call.
 *
 * <p>A "migrated" type is a schema type that has triggered a {@link android.app.appsearch.Migrator Migrator} instance to
 * migrate documents of the schema type to another schema type, or to another version of the
 * schema type.
 *
 * <p>If a document fails to be migrated, a {@link android.app.appsearch.SetSchemaResponse.MigrationFailure MigrationFailure} will be generated for that
 * document.
 *
 * @see android.app.appsearch.Migrator
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getMigratedTypes() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.Set Set} of schema type whose new definitions set in the {@link android.app.appsearch.AppSearchSession#setSchema  } call were incompatible with the pre-existing schema.
 *
 * <p>If a {@link android.app.appsearch.Migrator Migrator} is provided for this type and the migration is success triggered.
 * The type will also appear in {@link #getMigratedTypes()}.
 *
 * @see android.app.appsearch.SetSchemaRequest
 * @see android.app.appsearch.AppSearchSession#setSchema
 * @see android.app.appsearch.SetSchemaRequest.Builder#setForceOverride
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getIncompatibleTypes() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.app.appsearch.SetSchemaResponse SetSchemaResponse} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/** Adds {@link android.app.appsearch.SetSchemaResponse.MigrationFailure MigrationFailure}s to the list of migration failures. */

@android.annotation.NonNull
public android.app.appsearch.SetSchemaResponse.Builder addMigrationFailures(@android.annotation.NonNull java.util.Collection<android.app.appsearch.SetSchemaResponse.MigrationFailure> migrationFailures) { throw new RuntimeException("Stub!"); }

/** Adds a {@link android.app.appsearch.SetSchemaResponse.MigrationFailure MigrationFailure} to the list of migration failures. */

@android.annotation.NonNull
public android.app.appsearch.SetSchemaResponse.Builder addMigrationFailure(@android.annotation.NonNull android.app.appsearch.SetSchemaResponse.MigrationFailure migrationFailure) { throw new RuntimeException("Stub!"); }

/** Adds deletedTypes to the list of deleted schema types. */

@android.annotation.NonNull
public android.app.appsearch.SetSchemaResponse.Builder addDeletedTypes(@android.annotation.NonNull java.util.Collection<java.lang.String> deletedTypes) { throw new RuntimeException("Stub!"); }

/** Adds one deletedType to the list of deleted schema types. */

@android.annotation.NonNull
public android.app.appsearch.SetSchemaResponse.Builder addDeletedType(@android.annotation.NonNull java.lang.String deletedType) { throw new RuntimeException("Stub!"); }

/** Adds incompatibleTypes to the list of incompatible schema types. */

@android.annotation.NonNull
public android.app.appsearch.SetSchemaResponse.Builder addIncompatibleTypes(@android.annotation.NonNull java.util.Collection<java.lang.String> incompatibleTypes) { throw new RuntimeException("Stub!"); }

/** Adds one incompatibleType to the list of incompatible schema types. */

@android.annotation.NonNull
public android.app.appsearch.SetSchemaResponse.Builder addIncompatibleType(@android.annotation.NonNull java.lang.String incompatibleType) { throw new RuntimeException("Stub!"); }

/** Adds migratedTypes to the list of migrated schema types. */

@android.annotation.NonNull
public android.app.appsearch.SetSchemaResponse.Builder addMigratedTypes(@android.annotation.NonNull java.util.Collection<java.lang.String> migratedTypes) { throw new RuntimeException("Stub!"); }

/** Adds one migratedType to the list of migrated schema types. */

@android.annotation.NonNull
public android.app.appsearch.SetSchemaResponse.Builder addMigratedType(@android.annotation.NonNull java.lang.String migratedType) { throw new RuntimeException("Stub!"); }

/** Builds a {@link android.app.appsearch.SetSchemaResponse SetSchemaResponse} object. */

@android.annotation.NonNull
public android.app.appsearch.SetSchemaResponse build() { throw new RuntimeException("Stub!"); }
}

/**
 * The class represents a post-migrated {@link android.app.appsearch.GenericDocument GenericDocument} that failed to be saved by
 * {@link android.app.appsearch.AppSearchSession#setSchema AppSearchSession#setSchema}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class MigrationFailure {

/**
 * Constructs a new {@link android.app.appsearch.SetSchemaResponse.MigrationFailure MigrationFailure}.
 *
 * @param namespace The namespace of the document which failed to be migrated.
 * @param documentId The id of the document which failed to be migrated.
 * @param schemaType The type of the document which failed to be migrated.
 * @param failedResult The reason why the document failed to be indexed.
 * @throws java.lang.IllegalArgumentException if the provided {@code failedResult} was not a failure.
 */

public MigrationFailure(@android.annotation.NonNull java.lang.String namespace, @android.annotation.NonNull java.lang.String documentId, @android.annotation.NonNull java.lang.String schemaType, @android.annotation.NonNull android.app.appsearch.AppSearchResult<?> failedResult) { throw new RuntimeException("Stub!"); }

/** Returns the namespace of the {@link android.app.appsearch.GenericDocument GenericDocument} that failed to be migrated. */

@android.annotation.NonNull
public java.lang.String getNamespace() { throw new RuntimeException("Stub!"); }

/** Returns the id of the {@link android.app.appsearch.GenericDocument GenericDocument} that failed to be migrated. */

@android.annotation.NonNull
public java.lang.String getDocumentId() { throw new RuntimeException("Stub!"); }

/** Returns the schema type of the {@link android.app.appsearch.GenericDocument GenericDocument} that failed to be migrated. */

@android.annotation.NonNull
public java.lang.String getSchemaType() { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link android.app.appsearch.AppSearchResult AppSearchResult} that indicates why the post-migration {@link android.app.appsearch.GenericDocument GenericDocument} failed to be indexed.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchResult<java.lang.Void> getAppSearchResult() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

}

