/*
 * Decompiled with CFR 0.152.
 */
package android.security.identity;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.security.identity.EphemeralPublicKeyNotFoundException;
import android.security.identity.InvalidReaderSignatureException;
import android.security.identity.InvalidRequestMessageException;
import android.security.identity.MessageDecryptionException;
import android.security.identity.NoAuthenticationKeyAvailableException;
import android.security.identity.PersonalizationData;
import android.security.identity.ResultData;
import android.security.identity.SessionTranscriptMismatchException;
import android.security.identity.UnknownAuthenticationKeyException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;

public abstract class IdentityCredential {
    IdentityCredential() {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public abstract KeyPair createEphemeralKeyPair();

    public abstract void setReaderEphemeralPublicKey(@NonNull PublicKey var1) throws InvalidKeyException;

    @NonNull
    public abstract byte[] encryptMessageToReader(@NonNull byte[] var1);

    @NonNull
    public abstract byte[] decryptMessageFromReader(@NonNull byte[] var1) throws MessageDecryptionException;

    @NonNull
    public abstract Collection<X509Certificate> getCredentialKeyCertificateChain();

    public abstract void setAllowUsingExhaustedKeys(boolean var1);

    public void setAllowUsingExpiredKeys(boolean allowUsingExpiredKeys) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public abstract ResultData getEntries(@Nullable byte[] var1, @NonNull Map<String, Collection<String>> var2, @Nullable byte[] var3, @Nullable byte[] var4) throws EphemeralPublicKeyNotFoundException, InvalidReaderSignatureException, InvalidRequestMessageException, NoAuthenticationKeyAvailableException, SessionTranscriptMismatchException;

    public abstract void setAvailableAuthenticationKeys(int var1, int var2);

    @NonNull
    public abstract Collection<X509Certificate> getAuthKeysNeedingCertification();

    @Deprecated
    public abstract void storeStaticAuthenticationData(@NonNull X509Certificate var1, @NonNull byte[] var2) throws UnknownAuthenticationKeyException;

    public void storeStaticAuthenticationData(@NonNull X509Certificate authenticationKey, @NonNull Instant expirationDate, @NonNull byte[] staticAuthData) throws UnknownAuthenticationKeyException {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public abstract int[] getAuthenticationDataUsageCount();

    @NonNull
    public byte[] proveOwnership(@NonNull byte[] challenge) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public byte[] delete(@NonNull byte[] challenge) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public byte[] update(@NonNull PersonalizationData personalizationData) {
        throw new RuntimeException("Stub!");
    }
}

