/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.provider;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class DocumentsContract {

private DocumentsContract() { throw new RuntimeException("Stub!"); }

public static android.net.Uri buildRootsUri(java.lang.String authority) { throw new RuntimeException("Stub!"); }

public static android.net.Uri buildRootUri(java.lang.String authority, java.lang.String rootId) { throw new RuntimeException("Stub!"); }

public static android.net.Uri buildRecentDocumentsUri(java.lang.String authority, java.lang.String rootId) { throw new RuntimeException("Stub!"); }

public static android.net.Uri buildTreeDocumentUri(java.lang.String authority, java.lang.String documentId) { throw new RuntimeException("Stub!"); }

public static android.net.Uri buildDocumentUri(java.lang.String authority, java.lang.String documentId) { throw new RuntimeException("Stub!"); }

public static android.net.Uri buildDocumentUriUsingTree(android.net.Uri treeUri, java.lang.String documentId) { throw new RuntimeException("Stub!"); }

public static android.net.Uri buildChildDocumentsUri(java.lang.String authority, java.lang.String parentDocumentId) { throw new RuntimeException("Stub!"); }

public static android.net.Uri buildChildDocumentsUriUsingTree(android.net.Uri treeUri, java.lang.String parentDocumentId) { throw new RuntimeException("Stub!"); }

public static android.net.Uri buildSearchDocumentsUri(java.lang.String authority, java.lang.String rootId, java.lang.String query) { throw new RuntimeException("Stub!"); }

public static boolean isDocumentUri(android.content.Context context, @android.annotation.Nullable android.net.Uri uri) { throw new RuntimeException("Stub!"); }

public static boolean isRootsUri(@android.annotation.NonNull android.content.Context context, @android.annotation.Nullable android.net.Uri uri) { throw new RuntimeException("Stub!"); }

public static boolean isRootUri(@android.annotation.NonNull android.content.Context context, @android.annotation.Nullable android.net.Uri uri) { throw new RuntimeException("Stub!"); }

public static boolean isTreeUri(android.net.Uri uri) { throw new RuntimeException("Stub!"); }

public static java.lang.String getRootId(android.net.Uri rootUri) { throw new RuntimeException("Stub!"); }

public static java.lang.String getDocumentId(android.net.Uri documentUri) { throw new RuntimeException("Stub!"); }

public static java.lang.String getTreeDocumentId(android.net.Uri documentUri) { throw new RuntimeException("Stub!"); }

public static java.lang.String getSearchDocumentsQuery(android.net.Uri searchDocumentsUri) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.graphics.Bitmap getDocumentThumbnail(@android.annotation.NonNull android.content.ContentResolver content, @android.annotation.NonNull android.net.Uri documentUri, @android.annotation.NonNull android.graphics.Point size, @android.annotation.Nullable android.os.CancellationSignal signal) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.net.Uri createDocument(@android.annotation.NonNull android.content.ContentResolver content, @android.annotation.NonNull android.net.Uri parentDocumentUri, @android.annotation.NonNull java.lang.String mimeType, @android.annotation.NonNull java.lang.String displayName) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

public static boolean isChildDocument(@android.annotation.NonNull android.content.ContentResolver content, @android.annotation.NonNull android.net.Uri parentDocumentUri, @android.annotation.NonNull android.net.Uri childDocumentUri) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.net.Uri renameDocument(@android.annotation.NonNull android.content.ContentResolver content, @android.annotation.NonNull android.net.Uri documentUri, @android.annotation.NonNull java.lang.String displayName) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

public static boolean deleteDocument(@android.annotation.NonNull android.content.ContentResolver content, @android.annotation.NonNull android.net.Uri documentUri) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.net.Uri copyDocument(@android.annotation.NonNull android.content.ContentResolver content, @android.annotation.NonNull android.net.Uri sourceDocumentUri, @android.annotation.NonNull android.net.Uri targetParentDocumentUri) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.net.Uri moveDocument(@android.annotation.NonNull android.content.ContentResolver content, @android.annotation.NonNull android.net.Uri sourceDocumentUri, @android.annotation.NonNull android.net.Uri sourceParentDocumentUri, @android.annotation.NonNull android.net.Uri targetParentDocumentUri) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

public static boolean removeDocument(@android.annotation.NonNull android.content.ContentResolver content, @android.annotation.NonNull android.net.Uri documentUri, @android.annotation.NonNull android.net.Uri parentDocumentUri) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

public static void ejectRoot(@android.annotation.NonNull android.content.ContentResolver content, @android.annotation.NonNull android.net.Uri rootUri) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.os.Bundle getDocumentMetadata(@android.annotation.NonNull android.content.ContentResolver content, @android.annotation.NonNull android.net.Uri documentUri) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.provider.DocumentsContract.Path findDocumentPath(@android.annotation.NonNull android.content.ContentResolver content, @android.annotation.NonNull android.net.Uri treeUri) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.content.IntentSender createWebLinkIntent(@android.annotation.NonNull android.content.ContentResolver content, @android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable android.os.Bundle options) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

public static final java.lang.String ACTION_DOCUMENT_SETTINGS = "android.provider.action.DOCUMENT_SETTINGS";

public static final java.lang.String EXTRA_ERROR = "error";

public static final java.lang.String EXTRA_EXCLUDE_SELF = "android.provider.extra.EXCLUDE_SELF";

public static final java.lang.String EXTRA_INFO = "info";

public static final java.lang.String EXTRA_INITIAL_URI = "android.provider.extra.INITIAL_URI";

public static final java.lang.String EXTRA_LOADING = "loading";

public static final java.lang.String EXTRA_ORIENTATION = "android.provider.extra.ORIENTATION";

public static final java.lang.String EXTRA_PROMPT = "android.provider.extra.PROMPT";

public static final java.lang.String METADATA_EXIF = "android:documentExif";

public static final java.lang.String METADATA_TREE_COUNT = "android:metadataTreeCount";

public static final java.lang.String METADATA_TREE_SIZE = "android:metadataTreeSize";

public static final java.lang.String METADATA_TYPES = "android:documentMetadataTypes";

public static final java.lang.String PROVIDER_INTERFACE = "android.content.action.DOCUMENTS_PROVIDER";

public static final java.lang.String QUERY_ARG_DISPLAY_NAME = "android:query-arg-display-name";

public static final java.lang.String QUERY_ARG_EXCLUDE_MEDIA = "android:query-arg-exclude-media";

public static final java.lang.String QUERY_ARG_FILE_SIZE_OVER = "android:query-arg-file-size-over";

public static final java.lang.String QUERY_ARG_LAST_MODIFIED_AFTER = "android:query-arg-last-modified-after";

public static final java.lang.String QUERY_ARG_MIME_TYPES = "android:query-arg-mime-types";
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Document {

private Document() { throw new RuntimeException("Stub!"); }

public static final java.lang.String COLUMN_DISPLAY_NAME = "_display_name";

public static final java.lang.String COLUMN_DOCUMENT_ID = "document_id";

public static final java.lang.String COLUMN_FLAGS = "flags";

public static final java.lang.String COLUMN_ICON = "icon";

public static final java.lang.String COLUMN_LAST_MODIFIED = "last_modified";

public static final java.lang.String COLUMN_MIME_TYPE = "mime_type";

public static final java.lang.String COLUMN_SIZE = "_size";

public static final java.lang.String COLUMN_SUMMARY = "summary";

public static final int FLAG_DIR_BLOCKS_OPEN_DOCUMENT_TREE = 32768; // 0x8000

public static final int FLAG_DIR_PREFERS_GRID = 16; // 0x10

public static final int FLAG_DIR_PREFERS_LAST_MODIFIED = 32; // 0x20

public static final int FLAG_DIR_SUPPORTS_CREATE = 8; // 0x8

public static final int FLAG_PARTIAL = 8192; // 0x2000

public static final int FLAG_SUPPORTS_COPY = 128; // 0x80

public static final int FLAG_SUPPORTS_DELETE = 4; // 0x4

public static final int FLAG_SUPPORTS_METADATA = 16384; // 0x4000

public static final int FLAG_SUPPORTS_MOVE = 256; // 0x100

public static final int FLAG_SUPPORTS_REMOVE = 1024; // 0x400

public static final int FLAG_SUPPORTS_RENAME = 64; // 0x40

public static final int FLAG_SUPPORTS_SETTINGS = 2048; // 0x800

public static final int FLAG_SUPPORTS_THUMBNAIL = 1; // 0x1

public static final int FLAG_SUPPORTS_WRITE = 2; // 0x2

public static final int FLAG_VIRTUAL_DOCUMENT = 512; // 0x200

public static final int FLAG_WEB_LINKABLE = 4096; // 0x1000

public static final java.lang.String MIME_TYPE_DIR = "vnd.android.document/directory";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Path implements android.os.Parcelable {

public Path(@android.annotation.Nullable java.lang.String rootId, java.util.List<java.lang.String> path) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getRootId() { throw new RuntimeException("Stub!"); }

public java.util.List<java.lang.String> getPath() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.provider.DocumentsContract.Path> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Root {

private Root() { throw new RuntimeException("Stub!"); }

public static final java.lang.String COLUMN_AVAILABLE_BYTES = "available_bytes";

public static final java.lang.String COLUMN_CAPACITY_BYTES = "capacity_bytes";

public static final java.lang.String COLUMN_DOCUMENT_ID = "document_id";

public static final java.lang.String COLUMN_FLAGS = "flags";

public static final java.lang.String COLUMN_ICON = "icon";

public static final java.lang.String COLUMN_MIME_TYPES = "mime_types";

public static final java.lang.String COLUMN_QUERY_ARGS = "query_args";

public static final java.lang.String COLUMN_ROOT_ID = "root_id";

public static final java.lang.String COLUMN_SUMMARY = "summary";

public static final java.lang.String COLUMN_TITLE = "title";

public static final int FLAG_EMPTY = 64; // 0x40

public static final int FLAG_LOCAL_ONLY = 2; // 0x2

public static final int FLAG_SUPPORTS_CREATE = 1; // 0x1

public static final int FLAG_SUPPORTS_EJECT = 32; // 0x20

public static final int FLAG_SUPPORTS_IS_CHILD = 16; // 0x10

public static final int FLAG_SUPPORTS_RECENTS = 4; // 0x4

public static final int FLAG_SUPPORTS_SEARCH = 8; // 0x8

public static final java.lang.String MIME_TYPE_ITEM = "vnd.android.document/root";
}

}

