/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

import java.util.concurrent.Executor;

/**
 * Provides a connection to all AppSearch databases the querying application has been granted access
 * to.
 *
 * <p>This class is thread safe.
 *
 * @see android.app.appsearch.AppSearchSession
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class GlobalSearchSession implements java.io.Closeable {

private GlobalSearchSession() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves documents from all AppSearch databases that the querying application has access to.
 *
 * <p>Applications can be granted access to documents by specifying {@link android.app.appsearch.SetSchemaRequest.Builder#setSchemaTypeVisibilityForPackage  } when building a schema.
 *
 * <p>Document access can also be granted to system UIs by specifying {@link android.app.appsearch.SetSchemaRequest.Builder#setSchemaTypeDisplayedBySystem  } when building a schema.
 *
 * <p>See {@link android.app.appsearch.AppSearchSession#search AppSearchSession#search} for a detailed explanation on forming a query string.
 *
 * <p>This method is lightweight. The heavy work will be done in {@link android.app.appsearch.SearchResults#getNextPage  }.
 *
 * @param queryExpression query string to search.
 * @param searchSpec spec for setting document filters, adding projection, setting term match
 *     type, etc.
 * @return a {@link android.app.appsearch.SearchResults SearchResults} object for retrieved matched documents.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResults search(@android.annotation.NonNull java.lang.String queryExpression, @android.annotation.NonNull android.app.appsearch.SearchSpec searchSpec) { throw new RuntimeException("Stub!"); }

/**
 * Reports that a particular document has been used from a system surface.
 *
 * <p>See {@link android.app.appsearch.AppSearchSession#reportUsage AppSearchSession#reportUsage} for a general description of document usage, as
 * well as an API that can be used by the app itself.
 *
 * <p>Usage reported via this method is accounted separately from usage reported via
 * {@link android.app.appsearch.AppSearchSession#reportUsage AppSearchSession#reportUsage} and may be accessed using the constants
 * {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_SYSTEM_USAGE_COUNT SearchSpec#RANKING_STRATEGY_SYSTEM_USAGE_COUNT} and
 * {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_SYSTEM_USAGE_LAST_USED_TIMESTAMP SearchSpec#RANKING_STRATEGY_SYSTEM_USAGE_LAST_USED_TIMESTAMP}.
 *
 * @param request The usage reporting request.
 * @param executor Executor on which to invoke the callback.
 * @param callback Callback to receive errors. If the operation succeeds, the callback will be
 *                 invoked with an {@link android.app.appsearch.AppSearchResult AppSearchResult} whose value is {@code null}. The
 *                 callback will be invoked with an {@link android.app.appsearch.AppSearchResult AppSearchResult} of
 *                 {@link android.app.appsearch.AppSearchResult#RESULT_SECURITY_ERROR AppSearchResult#RESULT_SECURITY_ERROR} if this API is invoked by an
 *                 app which is not part of the system.
 */

public void reportSystemUsage(@android.annotation.NonNull android.app.appsearch.ReportSystemUsageRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<android.app.appsearch.AppSearchResult<java.lang.Void>> callback) { throw new RuntimeException("Stub!"); }

/**
 * Closes the {@link android.app.appsearch.GlobalSearchSession GlobalSearchSession}. Persists all mutations, including usage reports, to
 * disk.
 */

public void close() { throw new RuntimeException("Stub!"); }
}

