/*
 * Copyright (C) 2007-2008 The Android Open Source Project
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */


package android.view.inputmethod;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface InputMethod {

public void attachToken(android.os.IBinder token);

public void bindInput(android.view.inputmethod.InputBinding binding);

public void unbindInput();

public void startInput(android.view.inputmethod.InputConnection inputConnection, android.view.inputmethod.EditorInfo info);

public void restartInput(android.view.inputmethod.InputConnection inputConnection, android.view.inputmethod.EditorInfo attribute);

public void createSession(android.view.inputmethod.InputMethod.SessionCallback callback);

public void setSessionEnabled(android.view.inputmethod.InputMethodSession session, boolean enabled);

public void revokeSession(android.view.inputmethod.InputMethodSession session);

public void showSoftInput(int flags, android.os.ResultReceiver resultReceiver);

public void hideSoftInput(int flags, android.os.ResultReceiver resultReceiver);

public void changeInputMethodSubtype(android.view.inputmethod.InputMethodSubtype subtype);

public static final java.lang.String SERVICE_INTERFACE = "android.view.InputMethod";

public static final java.lang.String SERVICE_META_DATA = "android.view.im";

public static final int SHOW_EXPLICIT = 1; // 0x1

public static final int SHOW_FORCED = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface SessionCallback {

public void sessionCreated(android.view.inputmethod.InputMethodSession session);
}

}

