/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.location;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GnssStatus {

private GnssStatus() { throw new RuntimeException("Stub!"); }

public int getSatelliteCount() { throw new RuntimeException("Stub!"); }

public int getConstellationType(int satelliteIndex) { throw new RuntimeException("Stub!"); }

public int getSvid(int satelliteIndex) { throw new RuntimeException("Stub!"); }

public float getCn0DbHz(int satelliteIndex) { throw new RuntimeException("Stub!"); }

public float getElevationDegrees(int satelliteIndex) { throw new RuntimeException("Stub!"); }

public float getAzimuthDegrees(int satelliteIndex) { throw new RuntimeException("Stub!"); }

public boolean hasEphemerisData(int satelliteIndex) { throw new RuntimeException("Stub!"); }

public boolean hasAlmanacData(int satelliteIndex) { throw new RuntimeException("Stub!"); }

public boolean usedInFix(int satelliteIndex) { throw new RuntimeException("Stub!"); }

public boolean hasCarrierFrequencyHz(int satelliteIndex) { throw new RuntimeException("Stub!"); }

public float getCarrierFrequencyHz(int satelliteIndex) { throw new RuntimeException("Stub!"); }

public boolean hasBasebandCn0DbHz(int satelliteIndex) { throw new RuntimeException("Stub!"); }

public float getBasebandCn0DbHz(int satelliteIndex) { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public static final int CONSTELLATION_BEIDOU = 5; // 0x5

public static final int CONSTELLATION_GALILEO = 6; // 0x6

public static final int CONSTELLATION_GLONASS = 3; // 0x3

public static final int CONSTELLATION_GPS = 1; // 0x1

public static final int CONSTELLATION_IRNSS = 7; // 0x7

public static final int CONSTELLATION_QZSS = 4; // 0x4

public static final int CONSTELLATION_SBAS = 2; // 0x2

public static final int CONSTELLATION_UNKNOWN = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssStatus.Builder addSatellite(int constellationType, int svid, float cn0DbHz, float elevation, float azimuth, boolean hasEphemeris, boolean hasAlmanac, boolean usedInFix, boolean hasCarrierFrequency, float carrierFrequency, boolean hasBasebandCn0DbHz, float basebandCn0DbHz) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssStatus.Builder clearSatellites() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.GnssStatus build() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class Callback {

public Callback() { throw new RuntimeException("Stub!"); }

public void onStarted() { throw new RuntimeException("Stub!"); }

public void onStopped() { throw new RuntimeException("Stub!"); }

public void onFirstFix(int ttffMillis) { throw new RuntimeException("Stub!"); }

public void onSatelliteStatusChanged(@android.annotation.NonNull android.location.GnssStatus status) { throw new RuntimeException("Stub!"); }
}

}

