/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// $Id: SAXSource.java 446598 2006-09-15 12:55:40Z jeremias $


package javax.xml.transform.sax;

import javax.xml.transform.Source;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/**
 * <p>Acts as an holder for SAX-style Source.</p>
 *
 * <p>Note that XSLT requires namespace support. Attempting to transform an
 * input source that is not
 * generated with a namespace-aware parser may result in errors.
 * Parsers can be made namespace aware by calling the
 * {@link javax.xml.parsers.SAXParserFactory#setNamespaceAware(boolean awareness)} method.</p>
 *
 * @author <a href="mailto:Jeff.Suttor@Sun.com">Jeff Suttor</a>
 * @version $Revision: 446598 $, $Date: 2006-09-15 05:55:40 -0700 (Fri, 15 Sep 2006) $
 * @apiSince 8
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class SAXSource implements javax.xml.transform.Source {

/**
 * <p>Zero-argument default constructor.  If this constructor is used, and
 * no SAX source is set using
 * {@link #setInputSource(InputSource inputSource)} , then the
 * <code>Transformer</code> will
 * create an empty source {@link org.xml.sax.InputSource} using
 * {@link org.xml.sax.InputSource#InputSource() new InputSource()}.</p>
 *
 * @see javax.xml.transform.Transformer#transform(Source xmlSource, Result outputTarget)
 * @apiSince 8
 */

public SAXSource() { throw new RuntimeException("Stub!"); }

/**
 * Create a <code>SAXSource</code>, using an {@link org.xml.sax.XMLReader}
 * and a SAX InputSource. The {@link javax.xml.transform.Transformer}
 * or {@link javax.xml.transform.sax.SAXTransformerFactory} will set itself
 * to be the reader's {@link org.xml.sax.ContentHandler}, and then will call
 * reader.parse(inputSource).
 *
 * @param reader An XMLReader to be used for the parse.
 * @param inputSource A SAX input source reference that must be non-null
 * and that will be passed to the reader parse method.
 * @apiSince 8
 */

public SAXSource(org.xml.sax.XMLReader reader, org.xml.sax.InputSource inputSource) { throw new RuntimeException("Stub!"); }

/**
 * Create a <code>SAXSource</code>, using a SAX <code>InputSource</code>.
 * The {@link javax.xml.transform.Transformer} or
 * {@link javax.xml.transform.sax.SAXTransformerFactory} creates a
 * reader via {@link org.xml.sax.helpers.XMLReaderFactory}
 * (if setXMLReader is not used), sets itself as
 * the reader's {@link org.xml.sax.ContentHandler}, and calls
 * reader.parse(inputSource).
 *
 * @param inputSource An input source reference that must be non-null
 * and that will be passed to the parse method of the reader.
 * @apiSince 8
 */

public SAXSource(org.xml.sax.InputSource inputSource) { throw new RuntimeException("Stub!"); }

/**
 * Set the XMLReader to be used for the Source.
 *
 * @param reader A valid XMLReader or XMLFilter reference.
 * @apiSince 8
 */

public void setXMLReader(org.xml.sax.XMLReader reader) { throw new RuntimeException("Stub!"); }

/**
 * Get the XMLReader to be used for the Source.
 *
 * @return A valid XMLReader or XMLFilter reference, or null.
 * @apiSince 8
 */

public org.xml.sax.XMLReader getXMLReader() { throw new RuntimeException("Stub!"); }

/**
 * Set the SAX InputSource to be used for the Source.
 *
 * @param inputSource A valid InputSource reference.
 * @apiSince 8
 */

public void setInputSource(org.xml.sax.InputSource inputSource) { throw new RuntimeException("Stub!"); }

/**
 * Get the SAX InputSource to be used for the Source.
 *
 * @return A valid InputSource reference, or null.
 * @apiSince 8
 */

public org.xml.sax.InputSource getInputSource() { throw new RuntimeException("Stub!"); }

/**
 * Set the system identifier for this Source.  If an input source
 * has already been set, it will set the system ID or that
 * input source, otherwise it will create a new input source.
 *
 * <p>The system identifier is optional if there is a byte stream
 * or a character stream, but it is still useful to provide one,
 * since the application can use it to resolve relative URIs
 * and can include it in error messages and warnings (the parser
 * will attempt to open a connection to the URI only if
 * no byte stream or character stream is specified).</p>
 *
 * @param systemId The system identifier as a URI string.
 * @apiSince 8
 */

public void setSystemId(java.lang.String systemId) { throw new RuntimeException("Stub!"); }

/**
 * <p>Get the base ID (URI or system ID) from where URIs
 * will be resolved.</p>
 *
 * @return Base URL for the <code>Source</code>, or <code>null</code>.
 * @apiSince 8
 */

public java.lang.String getSystemId() { throw new RuntimeException("Stub!"); }

/**
 * Attempt to obtain a SAX InputSource object from a Source
 * object.
 *
 * @param source Must be a non-null Source reference.
 *
 * @return An InputSource, or null if Source can not be converted.
 * @apiSince 8
 */

public static org.xml.sax.InputSource sourceToInputSource(javax.xml.transform.Source source) { throw new RuntimeException("Stub!"); }

/**
 * If {@link javax.xml.transform.TransformerFactory#getFeature}
 * returns true when passed this value as an argument,
 * the Transformer supports Source input of this type.
 * @apiSince 8
 */

public static final java.lang.String FEATURE = "http://javax.xml.transform.sax.SAXSource/feature";
}

