/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// $Id: DatatypeConfigurationException.java 569987 2007-08-27 04:08:46Z mrglavas $


package javax.xml.datatype;


/**
 * <p>Indicates a serious configuration error.</p>
 *
 * @author <a href="mailto:Jeff.Suttor@Sun.com">Jeff Suttor</a>
 * @version $Revision: 569987 $, $Date: 2007-08-26 21:08:46 -0700 (Sun, 26 Aug 2007) $
 * @since 1.5
 * @apiSince 8
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class DatatypeConfigurationException extends java.lang.Exception {

/**
 * <p>Create a new <code>DatatypeConfigurationException</code> with
 * no specified detail message and cause.</p>
 * @apiSince 8
 */

public DatatypeConfigurationException() { throw new RuntimeException("Stub!"); }

/**
 * <p>Create a new <code>DatatypeConfigurationException</code> with
 * the specified detail message.</p>
 *
 * @param message The detail message.
 * @apiSince 8
 */

public DatatypeConfigurationException(java.lang.String message) { throw new RuntimeException("Stub!"); }

/**
 * <p>Create a new <code>DatatypeConfigurationException</code> with
 * the specified detail message and cause.</p>
 *
 * @param message The detail message.
 * @param cause The cause.  A <code>null</code> value is permitted, and indicates that the cause is nonexistent or unknown.
 * @apiSince 8
 */

public DatatypeConfigurationException(java.lang.String message, java.lang.Throwable cause) { throw new RuntimeException("Stub!"); }

/**
 * <p>Create a new <code>DatatypeConfigurationException</code> with
 * the specified cause.</p>
 *
 * @param cause The cause.  A <code>null</code> value is permitted, and indicates that the cause is nonexistent or unknown.
 * @apiSince 8
 */

public DatatypeConfigurationException(java.lang.Throwable cause) { throw new RuntimeException("Stub!"); }

/**
 * Print the the trace of methods from where the error
 * originated.  This will trace all nested exception
 * objects, as well as this object.
 * @apiSince 8
 */

public void printStackTrace() { throw new RuntimeException("Stub!"); }

/**
 * Print the the trace of methods from where the error
 * originated.  This will trace all nested exception
 * objects, as well as this object.
 * @param s The stream where the dump will be sent to.
 * @apiSince 8
 */

public void printStackTrace(java.io.PrintStream s) { throw new RuntimeException("Stub!"); }

/**
 * Print the the trace of methods from where the error
 * originated.  This will trace all nested exception
 * objects, as well as this object.
 * @param s The writer where the dump will be sent to.
 * @apiSince 8
 */

public void printStackTrace(java.io.PrintWriter s) { throw new RuntimeException("Stub!"); }
}

