/*
 * Copyright (c) 1997, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.util;


/**
 * This exception may be thrown by methods that have detected concurrent
 * modification of an object when such modification is not permissible.
 * <p>
 * For example, it is not generally permissible for one thread to modify a Collection
 * while another thread is iterating over it.  In general, the results of the
 * iteration are undefined under these circumstances.  Some Iterator
 * implementations (including those of all the general purpose collection implementations
 * provided by the JRE) may choose to throw this exception if this behavior is
 * detected.  Iterators that do this are known as <i>fail-fast</i> iterators,
 * as they fail quickly and cleanly, rather that risking arbitrary,
 * non-deterministic behavior at an undetermined time in the future.
 * <p>
 * Note that this exception does not always indicate that an object has
 * been concurrently modified by a <i>different</i> thread.  If a single
 * thread issues a sequence of method invocations that violates the
 * contract of an object, the object may throw this exception.  For
 * example, if a thread modifies a collection directly while it is
 * iterating over the collection with a fail-fast iterator, the iterator
 * will throw this exception.
 *
 * <p>Note that fail-fast behavior cannot be guaranteed as it is, generally
 * speaking, impossible to make any hard guarantees in the presence of
 * unsynchronized concurrent modification.  Fail-fast operations
 * throw {@code ConcurrentModificationException} on a best-effort basis.
 * Therefore, it would be wrong to write a program that depended on this
 * exception for its correctness: <i>{@code ConcurrentModificationException}
 * should be used only to detect bugs.</i>
 *
 * @author  Josh Bloch
 * @see     Collection
 * @see     Iterator
 * @see     Spliterator
 * @see     ListIterator
 * @see     Vector
 * @see     LinkedList
 * @see     HashSet
 * @see     Hashtable
 * @see     TreeMap
 * @see     AbstractList
 * @since   1.2
 * @apiSince 1
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ConcurrentModificationException extends java.lang.RuntimeException {

/**
 * Constructs a ConcurrentModificationException with no
 * detail message.
 * @apiSince 1
 */

public ConcurrentModificationException() { throw new RuntimeException("Stub!"); }

/**
 * Constructs a {@code ConcurrentModificationException} with the
 * specified detail message.
 *
 * @param message the detail message pertaining to this exception.
 * @apiSince 1
 */

public ConcurrentModificationException(java.lang.String message) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new exception with the specified cause and a detail
 * message of {@code (cause==null ? null : cause.toString())} (which
 * typically contains the class and detail message of {@code cause}.
 *
 * @param  cause the cause (which is saved for later retrieval by the
 *         {@link Throwable#getCause()} method).  (A {@code null} value is
 *         permitted, and indicates that the cause is nonexistent or
 *         unknown.)
 * @since  1.7
 * @apiSince 19
 */

public ConcurrentModificationException(java.lang.Throwable cause) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new exception with the specified detail message and
 * cause.
 *
 * <p>Note that the detail message associated with <code>cause</code> is
 * <i>not</i> automatically incorporated in this exception's detail
 * message.
 *
 * @param  message the detail message (which is saved for later retrieval
 *         by the {@link Throwable#getMessage()} method).
 * @param  cause the cause (which is saved for later retrieval by the
 *         {@link Throwable#getCause()} method).  (A {@code null} value
 *         is permitted, and indicates that the cause is nonexistent or
 *         unknown.)
 * @since 1.7
 * @apiSince 19
 */

public ConcurrentModificationException(java.lang.String message, java.lang.Throwable cause) { throw new RuntimeException("Stub!"); }
}

