/*
 * Copyright (c) 1996, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.security;

import java.io.IOException;

/**
 * A transparent stream that updates the associated message digest using
 * the bits going through the stream.
 *
 * <p>To complete the message digest computation, call one of the
 * {@code digest} methods on the associated message
 * digest after your calls to one of this digest output stream's
 * {@link #write(int) write} methods.
 *
 * <p>It is possible to turn this stream on or off (see
 * {@link #on(boolean) on}). When it is on, a call to one of the
 * {@code write} methods results in
 * an update on the message digest.  But when it is off, the message
 * digest is not updated. The default is for the stream to be on.
 *
 * @see MessageDigest
 * @see DigestInputStream
 *
 * @author Benjamin Renaud
 * @apiSince 1
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class DigestOutputStream extends java.io.FilterOutputStream {

/**
 * Creates a digest output stream, using the specified output stream
 * and message digest.
 *
 * @param stream the output stream.
 *
 * @param digest the message digest to associate with this stream.
 * @apiSince 1
 */

public DigestOutputStream(java.io.OutputStream stream, java.security.MessageDigest digest) { super(null); throw new RuntimeException("Stub!"); }

/**
 * Returns the message digest associated with this stream.
 *
 * @return the message digest associated with this stream.
 * @see #setMessageDigest(java.security.MessageDigest)
 * @apiSince 1
 */

public java.security.MessageDigest getMessageDigest() { throw new RuntimeException("Stub!"); }

/**
 * Associates the specified message digest with this stream.
 *
 * @param digest the message digest to be associated with this stream.
 * @see #getMessageDigest()
 * @apiSince 1
 */

public void setMessageDigest(java.security.MessageDigest digest) { throw new RuntimeException("Stub!"); }

/**
 * Updates the message digest (if the digest function is on) using
 * the specified byte, and in any case writes the byte
 * to the output stream. That is, if the digest function is on
 * (see {@link #on(boolean) on}), this method calls
 * {@code update} on the message digest associated with this
 * stream, passing it the byte {@code b}. This method then
 * writes the byte to the output stream, blocking until the byte
 * is actually written.
 *
 * @param b the byte to be used for updating and writing to the
 * output stream.
 *
 * @exception IOException if an I/O error occurs.
 *
 * @see MessageDigest#update(byte)
 * @apiSince 1
 */

public void write(int b) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Updates the message digest (if the digest function is on) using
 * the specified subarray, and in any case writes the subarray to
 * the output stream. That is, if the digest function is on (see
 * {@link #on(boolean) on}), this method calls {@code update}
 * on the message digest associated with this stream, passing it
 * the subarray specifications. This method then writes the subarray
 * bytes to the output stream, blocking until the bytes are actually
 * written.
 *
 * @param b the array containing the subarray to be used for updating
 * and writing to the output stream.
 *
 * @param off the offset into {@code b} of the first byte to
 * be updated and written.
 *
 * @param len the number of bytes of data to be updated and written
 * from {@code b}, starting at offset {@code off}.
 *
 * @exception IOException if an I/O error occurs.
 *
 * @see MessageDigest#update(byte[], int, int)
 * @apiSince 1
 */

public void write(byte[] b, int off, int len) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Turns the digest function on or off. The default is on.  When
 * it is on, a call to one of the {@code write} methods results in an
 * update on the message digest.  But when it is off, the message
 * digest is not updated.
 *
 * @param on true to turn the digest function on, false to turn it
 * off.
 * @apiSince 1
 */

public void on(boolean on) { throw new RuntimeException("Stub!"); }

/**
 * Prints a string representation of this digest output stream and
 * its associated message digest object.
 * @apiSince 1
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * The message digest associated with this stream.
 * @apiSince 1
 */

protected java.security.MessageDigest digest;
}

