/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view;


/** Interface to let you add and remove child views to an Activity. To get an instance
 * of this class, call {@link android.content.Context#getSystemService(java.lang.String) Context.getSystemService()}.
 * @apiSince 1
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface ViewManager {

/**
 * Assign the passed LayoutParams to the passed View and add the view to the window.
 * <p>Throws {@link android.view.WindowManager.BadTokenException} for certain programming
 * errors, such as adding a second view to a window without removing the first view.
 * <p>Throws {@link android.view.WindowManager.InvalidDisplayException} if the window is on a
 * secondary {@link Display} and the specified display can't be found
 * (see {@link android.app.Presentation}).
 * @param view The view to be added to this window.
 * @param params The LayoutParams to assign to view.
 * @apiSince 1
 */

public void addView(android.view.View view, android.view.ViewGroup.LayoutParams params);

/** @apiSince 1 */

public void updateViewLayout(android.view.View view, android.view.ViewGroup.LayoutParams params);

/** @apiSince 1 */

public void removeView(android.view.View view);
}

