/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.telephony;

import android.os.Parcelable;

/**
 * A {@link CellInfo} representing a WCDMA cell that provides identity and measurement info.
 * @apiSince 18
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class CellInfoWcdma extends android.telephony.CellInfo implements android.os.Parcelable {

/** @hide */

CellInfoWcdma() { throw new RuntimeException("Stub!"); }

/**
 * @return a {@link CellIdentityWcdma} instance.
 * @apiSince 18
 */

public android.telephony.CellIdentityWcdma getCellIdentity() { throw new RuntimeException("Stub!"); }

/**
 * @return a {@link CellSignalStrengthWcdma} instance.
 * @apiSince 18
 */

public android.telephony.CellSignalStrengthWcdma getCellSignalStrength() { throw new RuntimeException("Stub!"); }

/**
 * @return hash code
 * @apiSince 18
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @apiSince 18 */

public boolean equals(java.lang.Object other) { throw new RuntimeException("Stub!"); }

/** @apiSince 18 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Implement the Parcelable interface
 * @apiSince 18
 */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Implement the Parcelable interface
 * @apiSince 18
 */

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/**
 * Implement the Parcelable interface
 * @apiSince 18
 */

@androidx.annotation.RecentlyNonNull public static final android.os.Parcelable.Creator<android.telephony.CellInfoWcdma> CREATOR;
static { CREATOR = null; }
}

