/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.drawable;


/**
 * Interface that drawables supporting animations should implement.
 * @apiSince 4
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface Animatable {

/**
 * Starts the drawable's animation.
 * @apiSince 4
 */

public void start();

/**
 * Stops the drawable's animation.
 * @apiSince 4
 */

public void stop();

/**
 * Indicates whether the animation is running.
 *
 * @return True if the animation is running, false otherwise.
 * @apiSince 4
 */

public boolean isRunning();
}

