/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * This file is available under and governed by the GNU General Public
 * License version 2 only, as published by the Free Software Foundation.
 * However, the following notice accompanied the original version of this
 * file:
 *
 * Written by Doug Lea with assistance from members of JCP JSR-166
 * Expert Group and released to the public domain, as explained at
 * http://creativecommons.org/publicdomain/zero/1.0/
 */


package java.util;


/**
 * This class provides skeletal implementations of some {@link Queue}
 * operations. The implementations in this class are appropriate when
 * the base implementation does <em>not</em> allow {@code null}
 * elements.  Methods {@link #add add}, {@link #remove remove}, and
 * {@link #element element} are based on {@link #offer offer}, {@link
 * #poll poll}, and {@link #peek peek}, respectively, but throw
 * exceptions instead of indicating failure via {@code false} or
 * {@code null} returns.
 *
 * <p>A {@code Queue} implementation that extends this class must
 * minimally define a method {@link Queue#offer} which does not permit
 * insertion of {@code null} elements, along with methods {@link
 * Queue#peek}, {@link Queue#poll}, {@link Collection#size}, and
 * {@link Collection#iterator}.  Typically, additional methods will be
 * overridden as well.  If these requirements cannot be met, consider
 * instead subclassing {@link AbstractCollection}.
 *
 * @since 1.5
 * @author Doug Lea
 * @param <E> the type of elements held in this queue
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class AbstractQueue<E> extends java.util.AbstractCollection<E> implements java.util.Queue<E> {

/**
 * Constructor for use by subclasses.
 */

protected AbstractQueue() { throw new RuntimeException("Stub!"); }

/**
 * Inserts the specified element into this queue if it is possible to do so
 * immediately without violating capacity restrictions, returning
 * {@code true} upon success and throwing an {@code IllegalStateException}
 * if no space is currently available.
 *
 * <p>This implementation returns {@code true} if {@code offer} succeeds,
 * else throws an {@code IllegalStateException}.
 *
 * @param e the element to add
 * @return {@code true} (as specified by {@link Collection#add})
 * @throws IllegalStateException if the element cannot be added at this
 *         time due to capacity restrictions
 * @throws ClassCastException if the class of the specified element
 *         prevents it from being added to this queue
 * @throws NullPointerException if the specified element is null and
 *         this queue does not permit null elements
 * @throws IllegalArgumentException if some property of this element
 *         prevents it from being added to this queue
 */

public boolean add(E e) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves and removes the head of this queue.  This method differs
 * from {@link #poll poll} only in that it throws an exception if this
 * queue is empty.
 *
 * <p>This implementation returns the result of {@code poll}
 * unless the queue is empty.
 *
 * @return the head of this queue
 * @throws NoSuchElementException if this queue is empty
 */

public E remove() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves, but does not remove, the head of this queue.  This method
 * differs from {@link #peek peek} only in that it throws an exception if
 * this queue is empty.
 *
 * <p>This implementation returns the result of {@code peek}
 * unless the queue is empty.
 *
 * @return the head of this queue
 * @throws NoSuchElementException if this queue is empty
 */

public E element() { throw new RuntimeException("Stub!"); }

/**
 * Removes all of the elements from this queue.
 * The queue will be empty after this call returns.
 *
 * <p>This implementation repeatedly invokes {@link #poll poll} until it
 * returns {@code null}.
 */

public void clear() { throw new RuntimeException("Stub!"); }

/**
 * Adds all of the elements in the specified collection to this
 * queue.  Attempts to addAll of a queue to itself result in
 * {@code IllegalArgumentException}. Further, the behavior of
 * this operation is undefined if the specified collection is
 * modified while the operation is in progress.
 *
 * <p>This implementation iterates over the specified collection,
 * and adds each element returned by the iterator to this
 * queue, in turn.  A runtime exception encountered while
 * trying to add an element (including, in particular, a
 * {@code null} element) may result in only some of the elements
 * having been successfully added when the associated exception is
 * thrown.
 *
 * @param c collection containing elements to be added to this queue
 * @return {@code true} if this queue changed as a result of the call
 * @throws ClassCastException if the class of an element of the specified
 *         collection prevents it from being added to this queue
 * @throws NullPointerException if the specified collection contains a
 *         null element and this queue does not permit null elements,
 *         or if the specified collection is null
 * @throws IllegalArgumentException if some property of an element of the
 *         specified collection prevents it from being added to this
 *         queue, or if the specified collection is this queue
 * @throws IllegalStateException if not all the elements can be added at
 *         this time due to insertion restrictions
 * @see #add(Object)
 */

public boolean addAll(java.util.Collection<? extends E> c) { throw new RuntimeException("Stub!"); }
}

