/*
 * Copyright (c) 1997, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.text;


/**
 * An Annotation object is used as a wrapper for a text attribute value if
 * the attribute has annotation characteristics. These characteristics are:
 * <ul>
 * <li>The text range that the attribute is applied to is critical to the
 * semantics of the range. That means, the attribute cannot be applied to subranges
 * of the text range that it applies to, and, if two adjacent text ranges have
 * the same value for this attribute, the attribute still cannot be applied to
 * the combined range as a whole with this value.
 * <li>The attribute or its value usually do no longer apply if the underlying text is
 * changed.
 * </ul>
 *
 * An example is grammatical information attached to a sentence:
 * For the previous sentence, you can say that "an example"
 * is the subject, but you cannot say the same about "an", "example", or "exam".
 * When the text is changed, the grammatical information typically becomes invalid.
 * Another example is Japanese reading information (yomi).
 *
 * <p>
 * Wrapping the attribute value into an Annotation object guarantees that
 * adjacent text runs don't get merged even if the attribute values are equal,
 * and indicates to text containers that the attribute should be discarded if
 * the underlying text is modified.
 *
 * @see AttributedCharacterIterator
 * @since 1.2
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class Annotation {

/**
 * Constructs an annotation record with the given value, which
 * may be null.
 *
 * @param value the value of the attribute
 */

public Annotation(java.lang.Object value) { throw new RuntimeException("Stub!"); }

/**
 * Returns the value of the attribute, which may be null.
 *
 * @return the value of the attribute
 */

public java.lang.Object getValue() { throw new RuntimeException("Stub!"); }

/**
 * Returns the String representation of this Annotation.
 *
 * @return the {@code String} representation of this {@code Annotation}
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

