/*
 * Copyright (c) 1998, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.security;


/**
 * Legacy security code; do not use.
 *
 * This exception is thrown by
 * {@code doPrivileged(PrivilegedExceptionAction)} and
 * {@code doPrivileged(PrivilegedExceptionAction,
 * AccessControlContext context)} to indicate
 * that the action being performed threw a checked exception.  The exception
 * thrown by the action can be obtained by calling the
 * {@code getException} method.  In effect, an
 * {@code PrivilegedActionException} is a "wrapper"
 * for an exception thrown by a privileged action.
 *
 * <p>As of release 1.4, this exception has been retrofitted to conform to
 * the general purpose exception-chaining mechanism.  The "exception thrown
 * by the privileged computation" that is provided at construction time and
 * accessed via the {@link #getException()} method is now known as the
 * <i>cause</i>, and may be accessed via the {@link Throwable#getCause()}
 * method, as well as the aforementioned "legacy method."
 *
 * @see PrivilegedExceptionAction
 * @see AccessController#doPrivileged(PrivilegedExceptionAction)
 * @see AccessController#doPrivileged(PrivilegedExceptionAction,AccessControlContext)
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class PrivilegedActionException extends java.lang.Exception {

/**
 * Constructs a new PrivilegedActionException &quot;wrapping&quot;
 * the specific Exception.
 *
 * @param exception The exception thrown
 */

public PrivilegedActionException(java.lang.Exception exception) { throw new RuntimeException("Stub!"); }

/**
 * Returns the exception thrown by the privileged computation that
 * resulted in this {@code PrivilegedActionException}.
 *
 * <p>This method predates the general-purpose exception chaining facility.
 * The {@link Throwable#getCause()} method is now the preferred means of
 * obtaining this information.
 *
 * @return the exception thrown by the privileged computation that
 *         resulted in this {@code PrivilegedActionException}.
 * @see PrivilegedExceptionAction
 * @see AccessController#doPrivileged(PrivilegedExceptionAction)
 * @see AccessController#doPrivileged(PrivilegedExceptionAction,
 *                                            AccessControlContext)
 */

public java.lang.Exception getException() { throw new RuntimeException("Stub!"); }

/**
 * Returns the cause of this exception (the exception thrown by
 * the privileged computation that resulted in this
 * {@code PrivilegedActionException}).
 *
 * @return  the cause of this exception.
 * @since   1.4
 */

public java.lang.Throwable getCause() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

