/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.webkit;


/**
 * Represents a request for handling an SSL error. Instances of this class are
 * created by the WebView and passed to
 * {@link WebViewClient#onReceivedSslError}. The host application must call
 * either {@link #proceed} or {@link #cancel} to set the WebView's response
 * to the request.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class SslErrorHandler extends android.os.Handler {

/**
 * @hide Only for use by WebViewProvider implementations.
 */

SslErrorHandler() { throw new RuntimeException("Stub!"); }

/**
 * Proceed with the SSL certificate.
 * <p>
 * It is not recommended to proceed past SSL errors and this method should
 * generally not be used; see {@link WebViewClient#onReceivedSslError} for
 * more information.
 */

public void proceed() { throw new RuntimeException("Stub!"); }

/**
 * Cancel this request and all pending requests for the WebView that had
 * the error.
 */

public void cancel() { throw new RuntimeException("Stub!"); }
}

