/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.text.style;


/**
 * The classes that affect character-level text formatting extend this
 * class.  Most extend its subclass {@link MetricAffectingSpan}, but simple
 * ones may just implement {@link UpdateAppearance}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class CharacterStyle {

public CharacterStyle() { throw new RuntimeException("Stub!"); }

public abstract void updateDrawState(android.text.TextPaint tp);

/**
 * A given CharacterStyle can only applied to a single region of a given
 * Spanned.  If you need to attach the same CharacterStyle to multiple
 * regions, you can use this method to wrap it with a new object that
 * will have the same effect but be a distinct object so that it can
 * also be attached without conflict.
 */

public static android.text.style.CharacterStyle wrap(android.text.style.CharacterStyle cs) { throw new RuntimeException("Stub!"); }

/**
 * Returns "this" for most CharacterStyles, but for CharacterStyles
 * that were generated by {@link #wrap}, returns the underlying
 * CharacterStyle.
 */

public android.text.style.CharacterStyle getUnderlying() { throw new RuntimeException("Stub!"); }
}

