/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */


package android.telephony.mbms;

import android.telephony.MbmsStreamingSession;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class MbmsErrors {

MbmsErrors() { throw new RuntimeException("Stub!"); }

/** Indicates that the middleware has died and the requested operation was not completed.*/

public static final int ERROR_MIDDLEWARE_LOST = 3; // 0x3

/**
 * Indicates that the app attempted to perform an operation on an instance of
 * {@link android.telephony.MbmsDownloadSession} or
 * {@link MbmsStreamingSession} without being bound to the middleware.
 */

public static final int ERROR_MIDDLEWARE_NOT_BOUND = 2; // 0x2

/**
 * Indicates that either no MBMS middleware app is installed on the device or multiple
 * middleware apps are installed on the device.
 */

public static final int ERROR_NO_UNIQUE_MIDDLEWARE = 1; // 0x1

/** Indicates that the operation was successful. */

public static final int SUCCESS = 0; // 0x0

/**
 * Indicates that the middleware has sent an error code that is not defined in the version of
 * the SDK targeted by your app. This is an illegal value for the middleware to return -- it
 * should only ever be generated by the framework.
 */

public static final int UNKNOWN = -1; // 0xffffffff
/**
 * Indicates the errors that are applicable only to the file-download use-case
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class DownloadErrors {

DownloadErrors() { throw new RuntimeException("Stub!"); }

/**
 * Indicates that the app is not allowed to change the temp file root at this time due to
 * outstanding download requests.
 */

public static final int ERROR_CANNOT_CHANGE_TEMP_FILE_ROOT = 401; // 0x191

/** Indicates that the middleware has no record of the supplied {@link DownloadRequest}. */

public static final int ERROR_UNKNOWN_DOWNLOAD_REQUEST = 402; // 0x192

/** Indicates the the middleware has no record of the supplied {@link FileInfo} */

public static final int ERROR_UNKNOWN_FILE_INFO = 403; // 0x193
}

/**
 * Indicates the errors that may occur at any point and are applicable to both
 * streaming and file-download.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class GeneralErrors {

GeneralErrors() { throw new RuntimeException("Stub!"); }

/**
 * Indicates that MBMS is not available due to the inserted SIM being from an unsupported
 * carrier.
 */

public static final int ERROR_CARRIER_CHANGE_NOT_ALLOWED = 207; // 0xcf

/**
 * Indicates that the requested operation was not performed due to being in emergency
 * callback mode.
 */

public static final int ERROR_IN_E911 = 204; // 0xcc

/**
 * Indicates that the app attempted to perform an operation before receiving notification
 * that the middleware is ready via {@link MbmsStreamingSessionCallback#onMiddlewareReady()}
 * or {@link MbmsDownloadSessionCallback#onMiddlewareReady()}.
 */

public static final int ERROR_MIDDLEWARE_NOT_YET_READY = 201; // 0xc9

/**
 * Indicates that the requested operation failed due to the middleware being unavailable due
 * to a transient condition. The app may retry the operation at a later time.
 */

public static final int ERROR_MIDDLEWARE_TEMPORARILY_UNAVAILABLE = 203; // 0xcb

/** Indicates that MBMS is not available due to the device being in roaming. */

public static final int ERROR_NOT_CONNECTED_TO_HOME_CARRIER_LTE = 205; // 0xcd

/**
 * Indicates that the middleware ran out of memory and was unable to complete the requested
 * operation.
 */

public static final int ERROR_OUT_OF_MEMORY = 202; // 0xca

/** Indicates that MBMS is not available due to a SIM read error. */

public static final int ERROR_UNABLE_TO_READ_SIM = 206; // 0xce
}

/**
 * Indicates errors that may be generated during initialization by the
 * middleware. They are applicable to both streaming and file-download use-cases.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class InitializationErrors {

InitializationErrors() { throw new RuntimeException("Stub!"); }

/** Indicates that the app is not authorized to access media via MBMS.*/

public static final int ERROR_APP_PERMISSIONS_NOT_GRANTED = 102; // 0x66

/**
 * Indicates that the app tried to create more than one instance each of
 * {@link MbmsStreamingSession} or {@link android.telephony.MbmsDownloadSession}.
 */

public static final int ERROR_DUPLICATE_INITIALIZE = 101; // 0x65

/** Indicates that the middleware was unable to initialize for this app. */

public static final int ERROR_UNABLE_TO_INITIALIZE = 103; // 0x67
}

/**
 * Indicates the errors that are applicable only to the streaming use-case
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class StreamingErrors {

StreamingErrors() { throw new RuntimeException("Stub!"); }

/** Indicates that the middleware cannot start a stream due to too many ongoing streams */

public static final int ERROR_CONCURRENT_SERVICE_LIMIT_REACHED = 301; // 0x12d

/**
 * Indicates that the app called
 * {@link MbmsStreamingSession#startStreaming(StreamingServiceInfo,
 * java.util.concurrent.Executor, StreamingServiceCallback)}
 * more than once for the same {@link StreamingServiceInfo}.
 */

public static final int ERROR_DUPLICATE_START_STREAM = 303; // 0x12f

/** Indicates that the middleware was unable to start the streaming service */

public static final int ERROR_UNABLE_TO_START_SERVICE = 302; // 0x12e
}

}

