/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.security;

import java.security.KeyPair;

/**
 * The {@code AttestedKeyPair} class contains a {@code KeyPair} instance of
 * keys generated by Keystore and owned by KeyChain, as well as an attestation
 * record for the key.
 *
 * <p>Such keys can be obtained by calling
 * {@link android.app.admin.DevicePolicyManager#generateKeyPair}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AttestedKeyPair {

/**
 * @hide Only created by the platform, no need to expose as public API.
 */

AttestedKeyPair(java.security.KeyPair keyPair, java.security.cert.Certificate[] attestationRecord) { throw new RuntimeException("Stub!"); }

/**
 * Returns the generated key pair associated with the attestation record
 * in this instance.
 */

public java.security.KeyPair getKeyPair() { throw new RuntimeException("Stub!"); }

/**
 * Returns the attestation record for the key pair in this instance.
 *
 * The attestation record is a chain of certificates. The leaf certificate links to the public
 * key of this key pair and other properties of the key or the device. If the key is in secure
 * hardware, and if the secure hardware supports attestation, the leaf certificate will be
 * signed by a chain of certificates rooted at a trustworthy CA key. Otherwise the chain will be
 * rooted at an untrusted certificate.
 *
 * The attestation record could be for properties of the key, or include device identifiers.
 *
 * See {@link android.security.keystore.KeyGenParameterSpec.Builder#setAttestationChallenge}
 * and  <a href="https://developer.android.com/training/articles/security-key-attestation.html">
 * Key Attestation</a> for the format of the attestation record inside the certificate.
 */

public java.util.List<java.security.cert.Certificate> getAttestationRecord() { throw new RuntimeException("Stub!"); }
}

