/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.RemoteViews;
import android.widget.TextView;

@RemoteViews.RemoteView
public class ImageFloatingTextView
extends TextView {
    private int mIndentLines;
    private int mResolvedDirection = -1;

    public ImageFloatingTextView(Context context) {
        this(context, null);
    }

    public ImageFloatingTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImageFloatingTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ImageFloatingTextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected Layout makeSingleLayout(int wantWidth, BoringLayout.Metrics boring, int ellipsisWidth, Layout.Alignment alignment, boolean shouldEllipsize, TextUtils.TruncateAt effectiveEllipsize, boolean useSaved) {
        CharSequence text = this.getText() == null ? "" : this.getText();
        StaticLayout.Builder builder = StaticLayout.Builder.obtain(text, 0, text.length(), this.getPaint(), wantWidth).setAlignment(alignment).setTextDirection(this.getTextDirectionHeuristic()).setLineSpacing(this.getLineSpacingExtra(), this.getLineSpacingMultiplier()).setIncludePad(this.getIncludeFontPadding()).setEllipsize(shouldEllipsize ? effectiveEllipsize : null).setEllipsizedWidth(ellipsisWidth).setBreakStrategy(1).setHyphenationFrequency(2);
        int endMargin = this.getContext().getResources().getDimensionPixelSize(17104963);
        int[] margins = null;
        if (this.mIndentLines > 0) {
            margins = new int[this.mIndentLines + 1];
            for (int i = 0; i < this.mIndentLines; ++i) {
                margins[i] = endMargin;
            }
        }
        if (this.mResolvedDirection == 1) {
            builder.setIndents(margins, null);
        } else {
            builder.setIndents(null, margins);
        }
        return builder.build();
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        if (layoutDirection != this.mResolvedDirection && this.isLayoutDirectionResolved()) {
            this.mResolvedDirection = layoutDirection;
            if (this.mIndentLines > 0) {
                this.setHint(this.getHint());
            }
        }
    }

    @RemotableViewMethod
    public void setHasImage(boolean hasImage) {
        this.setNumIndentLines(hasImage ? 2 : 0);
    }

    public boolean setNumIndentLines(int lines) {
        if (this.mIndentLines != lines) {
            this.mIndentLines = lines;
            this.setHint(this.getHint());
            return true;
        }
        return false;
    }
}

