/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.ViewDebug;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.IconMenuView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;

public class IconMenuItemView
extends TextView
implements MenuView.ItemView {
    private static final int NO_ALPHA = 255;
    private IconMenuView mIconMenuView;
    private MenuBuilder.ItemInvoker mItemInvoker;
    private MenuItemImpl mItemData;
    private Drawable mIcon;
    private int mTextAppearance;
    private Context mTextAppearanceContext;
    private float mDisabledAlpha;
    private Rect mPositionIconAvailable = new Rect();
    private Rect mPositionIconOutput = new Rect();
    private boolean mShortcutCaptionMode;
    private String mShortcutCaption;
    private static String sPrependShortcutLabel;

    public IconMenuItemView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        if (sPrependShortcutLabel == null) {
            sPrependShortcutLabel = this.getResources().getString(17040192);
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MenuView, defStyleAttr, defStyleRes);
        this.mDisabledAlpha = a.getFloat(6, 0.8f);
        this.mTextAppearance = a.getResourceId(1, -1);
        this.mTextAppearanceContext = context;
        a.recycle();
    }

    public IconMenuItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public IconMenuItemView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    void initialize(CharSequence title, Drawable icon) {
        this.setClickable(true);
        this.setFocusable(true);
        if (this.mTextAppearance != -1) {
            this.setTextAppearance(this.mTextAppearanceContext, this.mTextAppearance);
        }
        this.setTitle(title);
        this.setIcon(icon);
    }

    @Override
    public void initialize(MenuItemImpl itemData, int menuType) {
        this.mItemData = itemData;
        this.initialize(itemData.getTitleForItemView(this), itemData.getIcon());
        this.setVisibility(itemData.isVisible() ? 0 : 8);
        this.setEnabled(itemData.isEnabled());
    }

    public void setItemData(MenuItemImpl data) {
        this.mItemData = data;
    }

    @Override
    public boolean performClick() {
        if (super.performClick()) {
            return true;
        }
        if (this.mItemInvoker != null && this.mItemInvoker.invokeItem(this.mItemData)) {
            this.playSoundEffect(0);
            return true;
        }
        return false;
    }

    @Override
    public void setTitle(CharSequence title) {
        if (this.mShortcutCaptionMode) {
            this.setCaptionMode(true);
        } else if (title != null) {
            this.setText(title);
        }
    }

    void setCaptionMode(boolean shortcut) {
        if (this.mItemData == null) {
            return;
        }
        this.mShortcutCaptionMode = shortcut && this.mItemData.shouldShowShortcut();
        CharSequence text = this.mItemData.getTitleForItemView(this);
        if (this.mShortcutCaptionMode) {
            if (this.mShortcutCaption == null) {
                this.mShortcutCaption = this.mItemData.getShortcutLabel();
            }
            text = this.mShortcutCaption;
        }
        this.setText(text);
    }

    @Override
    public void setIcon(Drawable icon) {
        this.mIcon = icon;
        if (icon != null) {
            icon.setBounds(0, 0, icon.getIntrinsicWidth(), icon.getIntrinsicHeight());
            this.setCompoundDrawables(null, icon, null, null);
            this.setGravity(81);
            this.requestLayout();
        } else {
            this.setCompoundDrawables(null, null, null, null);
            this.setGravity(17);
        }
    }

    public void setItemInvoker(MenuBuilder.ItemInvoker itemInvoker) {
        this.mItemInvoker = itemInvoker;
    }

    @Override
    @ViewDebug.CapturedViewProperty(retrieveReturn=true)
    public MenuItemImpl getItemData() {
        return this.mItemData;
    }

    @Override
    public void setVisibility(int v) {
        super.setVisibility(v);
        if (this.mIconMenuView != null) {
            this.mIconMenuView.markStaleChildren();
        }
    }

    void setIconMenuView(IconMenuView iconMenuView) {
        this.mIconMenuView = iconMenuView;
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mItemData != null && this.mIcon != null) {
            boolean isInAlphaState = !this.mItemData.isEnabled() && (this.isPressed() || !this.isFocused());
            this.mIcon.setAlpha(isInAlphaState ? (int)(this.mDisabledAlpha * 255.0f) : 255);
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.positionIcon();
    }

    @Override
    protected void onTextChanged(CharSequence text, int start, int before, int after) {
        super.onTextChanged(text, start, before, after);
        this.setLayoutParams(this.getTextAppropriateLayoutParams());
    }

    IconMenuView.LayoutParams getTextAppropriateLayoutParams() {
        IconMenuView.LayoutParams lp = (IconMenuView.LayoutParams)this.getLayoutParams();
        if (lp == null) {
            lp = new IconMenuView.LayoutParams(-1, -1);
        }
        lp.desiredWidth = (int)Layout.getDesiredWidth(this.getText(), this.getPaint());
        return lp;
    }

    private void positionIcon() {
        if (this.mIcon == null) {
            return;
        }
        Rect tmpRect = this.mPositionIconOutput;
        this.getLineBounds(0, tmpRect);
        this.mPositionIconAvailable.set(0, 0, this.getWidth(), tmpRect.top);
        int layoutDirection = this.getLayoutDirection();
        Gravity.apply(8388627, this.mIcon.getIntrinsicWidth(), this.mIcon.getIntrinsicHeight(), this.mPositionIconAvailable, this.mPositionIconOutput, layoutDirection);
        this.mIcon.setBounds(this.mPositionIconOutput);
    }

    @Override
    public void setCheckable(boolean checkable) {
    }

    @Override
    public void setChecked(boolean checked) {
    }

    @Override
    public void setShortcut(boolean showShortcut, char shortcutKey) {
        if (this.mShortcutCaptionMode) {
            this.mShortcutCaption = null;
            this.setCaptionMode(true);
        }
    }

    @Override
    public boolean prefersCondensedTitle() {
        return true;
    }

    @Override
    public boolean showsIcon() {
        return true;
    }
}

