/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.icu.util.Calendar;
import android.util.AttributeSet;
import android.util.MathUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import android.widget.CalendarView;
import android.widget.DayPickerPagerAdapter;
import android.widget.ImageButton;
import android.widget.SimpleMonthView;
import com.android.internal.R;
import com.android.internal.widget.ViewPager;
import com.android.layoutlib.bridge.android.AndroidLocale;
import com.android.tools.layoutlib.java.System_Delegate;
import java.util.Locale;
import libcore.icu.LocaleData;

class DayPickerView
extends ViewGroup {
    private static final int DEFAULT_LAYOUT = 17367118;
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private static final int[] ATTRS_TEXT_COLOR = new int[]{16842904};
    private final Calendar mSelectedDay = Calendar.getInstance();
    private final Calendar mMinDate = Calendar.getInstance();
    private final Calendar mMaxDate = Calendar.getInstance();
    private final AccessibilityManager mAccessibilityManager;
    private final ViewPager mViewPager;
    private final ImageButton mPrevButton;
    private final ImageButton mNextButton;
    private final DayPickerPagerAdapter mAdapter;
    private Calendar mTempCalendar;
    private OnDaySelectedListener mOnDaySelectedListener;
    private final ViewPager.OnPageChangeListener mOnPageChangedListener = new ViewPager.OnPageChangeListener(){

        @Override
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            float alpha = Math.abs(0.5f - positionOffset) * 2.0f;
            DayPickerView.this.mPrevButton.setAlpha(alpha);
            DayPickerView.this.mNextButton.setAlpha(alpha);
        }

        @Override
        public void onPageScrollStateChanged(int state) {
        }

        @Override
        public void onPageSelected(int position) {
            DayPickerView.this.updateButtonVisibility(position);
        }
    };
    private final View.OnClickListener mOnClickListener = new View.OnClickListener(){

        @Override
        public void onClick(View v) {
            int direction;
            if (v == DayPickerView.this.mPrevButton) {
                direction = -1;
            } else if (v == DayPickerView.this.mNextButton) {
                direction = 1;
            } else {
                return;
            }
            boolean animate = !DayPickerView.this.mAccessibilityManager.isEnabled();
            int nextItem = DayPickerView.this.mViewPager.getCurrentItem() + direction;
            DayPickerView.this.mViewPager.setCurrentItem(nextItem, animate);
        }
    };

    public DayPickerView(Context context) {
        this(context, null);
    }

    public DayPickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 16843613);
    }

    public DayPickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public DayPickerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        long maxDateMillis;
        Calendar tempDate;
        this.mAccessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CalendarView, defStyleAttr, defStyleRes);
        int firstDayOfWeek = a.getInt(0, LocaleData.get((Locale)AndroidLocale.getDefault()).firstDayOfWeek);
        String minDate = a.getString(2);
        String maxDate = a.getString(3);
        int monthTextAppearanceResId = a.getResourceId(13, 16974882);
        int dayOfWeekTextAppearanceResId = a.getResourceId(11, 16974881);
        int dayTextAppearanceResId = a.getResourceId(12, 16974880);
        ColorStateList daySelectorColor = a.getColorStateList(14);
        a.recycle();
        this.mAdapter = new DayPickerPagerAdapter(context, 17367116, 16909149);
        this.mAdapter.setMonthTextAppearance(monthTextAppearanceResId);
        this.mAdapter.setDayOfWeekTextAppearance(dayOfWeekTextAppearanceResId);
        this.mAdapter.setDayTextAppearance(dayTextAppearanceResId);
        this.mAdapter.setDaySelectorColor(daySelectorColor);
        LayoutInflater inflater = LayoutInflater.from(context);
        ViewGroup content = (ViewGroup)inflater.inflate(17367118, (ViewGroup)this, false);
        while (content.getChildCount() > 0) {
            View child = content.getChildAt(0);
            content.removeViewAt(0);
            this.addView(child);
        }
        this.mPrevButton = (ImageButton)this.findViewById(16909142);
        this.mPrevButton.setOnClickListener(this.mOnClickListener);
        this.mNextButton = (ImageButton)this.findViewById(16909154);
        this.mNextButton.setOnClickListener(this.mOnClickListener);
        this.mViewPager = (ViewPager)this.findViewById(16909153);
        this.mViewPager.setAdapter(this.mAdapter);
        this.mViewPager.setOnPageChangeListener(this.mOnPageChangedListener);
        if (monthTextAppearanceResId != 0) {
            TypedArray ta = this.mContext.obtainStyledAttributes(null, ATTRS_TEXT_COLOR, 0, monthTextAppearanceResId);
            ColorStateList monthColor = ta.getColorStateList(0);
            if (monthColor != null) {
                this.mPrevButton.setImageTintList(monthColor);
                this.mNextButton.setImageTintList(monthColor);
            }
            ta.recycle();
        }
        if (!CalendarView.parseDate(minDate, tempDate = Calendar.getInstance())) {
            tempDate.set(1900, 0, 1);
        }
        long minDateMillis = tempDate.getTimeInMillis();
        if (!CalendarView.parseDate(maxDate, tempDate)) {
            tempDate.set(2100, 11, 31);
        }
        if ((maxDateMillis = tempDate.getTimeInMillis()) < minDateMillis) {
            throw new IllegalArgumentException("maxDate must be >= minDate");
        }
        long setDateMillis = MathUtils.constrain(System_Delegate.currentTimeMillis(), minDateMillis, maxDateMillis);
        this.setFirstDayOfWeek(firstDayOfWeek);
        this.setMinDate(minDateMillis);
        this.setMaxDate(maxDateMillis);
        this.setDate(setDateMillis, false);
        this.mAdapter.setOnDaySelectedListener(new DayPickerPagerAdapter.OnDaySelectedListener(){

            @Override
            public void onDaySelected(DayPickerPagerAdapter adapter, Calendar day) {
                if (DayPickerView.this.mOnDaySelectedListener != null) {
                    DayPickerView.this.mOnDaySelectedListener.onDaySelected(DayPickerView.this, day);
                }
            }
        });
    }

    private void updateButtonVisibility(int position) {
        boolean hasPrev = position > 0;
        boolean hasNext = position < this.mAdapter.getCount() - 1;
        this.mPrevButton.setVisibility(hasPrev ? 0 : 4);
        this.mNextButton.setVisibility(hasNext ? 0 : 4);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        ViewPager viewPager = this.mViewPager;
        this.measureChild(viewPager, widthMeasureSpec, heightMeasureSpec);
        int measuredWidthAndState = viewPager.getMeasuredWidthAndState();
        int measuredHeightAndState = viewPager.getMeasuredHeightAndState();
        this.setMeasuredDimension(measuredWidthAndState, measuredHeightAndState);
        int pagerWidth = viewPager.getMeasuredWidth();
        int pagerHeight = viewPager.getMeasuredHeight();
        int buttonWidthSpec = View.MeasureSpec.makeMeasureSpec(pagerWidth, Integer.MIN_VALUE);
        int buttonHeightSpec = View.MeasureSpec.makeMeasureSpec(pagerHeight, Integer.MIN_VALUE);
        this.mPrevButton.measure(buttonWidthSpec, buttonHeightSpec);
        this.mNextButton.measure(buttonWidthSpec, buttonHeightSpec);
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.requestLayout();
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        ImageButton rightButton;
        ImageButton leftButton;
        if (this.isLayoutRtl()) {
            leftButton = this.mNextButton;
            rightButton = this.mPrevButton;
        } else {
            leftButton = this.mPrevButton;
            rightButton = this.mNextButton;
        }
        int width = right - left;
        int height = bottom - top;
        this.mViewPager.layout(0, 0, width, height);
        SimpleMonthView monthView = (SimpleMonthView)this.mViewPager.getChildAt(0);
        int monthHeight = monthView.getMonthHeight();
        int cellWidth = monthView.getCellWidth();
        int leftDW = leftButton.getMeasuredWidth();
        int leftDH = leftButton.getMeasuredHeight();
        int leftIconTop = monthView.getPaddingTop() + (monthHeight - leftDH) / 2;
        int leftIconLeft = monthView.getPaddingLeft() + (cellWidth - leftDW) / 2;
        leftButton.layout(leftIconLeft, leftIconTop, leftIconLeft + leftDW, leftIconTop + leftDH);
        int rightDW = rightButton.getMeasuredWidth();
        int rightDH = rightButton.getMeasuredHeight();
        int rightIconTop = monthView.getPaddingTop() + (monthHeight - rightDH) / 2;
        int rightIconRight = width - monthView.getPaddingRight() - (cellWidth - rightDW) / 2;
        rightButton.layout(rightIconRight - rightDW, rightIconTop, rightIconRight, rightIconTop + rightDH);
    }

    public void setDayOfWeekTextAppearance(int resId) {
        this.mAdapter.setDayOfWeekTextAppearance(resId);
    }

    public int getDayOfWeekTextAppearance() {
        return this.mAdapter.getDayOfWeekTextAppearance();
    }

    public void setDayTextAppearance(int resId) {
        this.mAdapter.setDayTextAppearance(resId);
    }

    public int getDayTextAppearance() {
        return this.mAdapter.getDayTextAppearance();
    }

    public void setDate(long timeInMillis) {
        this.setDate(timeInMillis, false);
    }

    public void setDate(long timeInMillis, boolean animate) {
        this.setDate(timeInMillis, animate, true);
    }

    private void setDate(long timeInMillis, boolean animate, boolean setSelected) {
        int position;
        if (setSelected) {
            this.mSelectedDay.setTimeInMillis(timeInMillis);
        }
        if ((position = this.getPositionFromDay(timeInMillis)) != this.mViewPager.getCurrentItem()) {
            this.mViewPager.setCurrentItem(position, animate);
        }
        this.mTempCalendar.setTimeInMillis(timeInMillis);
        this.mAdapter.setSelectedDay(this.mTempCalendar);
    }

    public long getDate() {
        return this.mSelectedDay.getTimeInMillis();
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.mAdapter.setFirstDayOfWeek(firstDayOfWeek);
    }

    public int getFirstDayOfWeek() {
        return this.mAdapter.getFirstDayOfWeek();
    }

    public void setMinDate(long timeInMillis) {
        this.mMinDate.setTimeInMillis(timeInMillis);
        this.onRangeChanged();
    }

    public long getMinDate() {
        return this.mMinDate.getTimeInMillis();
    }

    public void setMaxDate(long timeInMillis) {
        this.mMaxDate.setTimeInMillis(timeInMillis);
        this.onRangeChanged();
    }

    public long getMaxDate() {
        return this.mMaxDate.getTimeInMillis();
    }

    public void onRangeChanged() {
        this.mAdapter.setRange(this.mMinDate, this.mMaxDate);
        this.setDate(this.mSelectedDay.getTimeInMillis(), false, false);
        this.updateButtonVisibility(this.mViewPager.getCurrentItem());
    }

    public void setOnDaySelectedListener(OnDaySelectedListener listener) {
        this.mOnDaySelectedListener = listener;
    }

    private int getDiffMonths(Calendar start, Calendar end) {
        int diffYears = end.get(1) - start.get(1);
        return end.get(2) - start.get(2) + 12 * diffYears;
    }

    private int getPositionFromDay(long timeInMillis) {
        int diffMonthMax = this.getDiffMonths(this.mMinDate, this.mMaxDate);
        int diffMonth = this.getDiffMonths(this.mMinDate, this.getTempCalendarForTime(timeInMillis));
        return MathUtils.constrain(diffMonth, 0, diffMonthMax);
    }

    private Calendar getTempCalendarForTime(long timeInMillis) {
        if (this.mTempCalendar == null) {
            this.mTempCalendar = Calendar.getInstance();
        }
        this.mTempCalendar.setTimeInMillis(timeInMillis);
        return this.mTempCalendar;
    }

    public int getMostVisiblePosition() {
        return this.mViewPager.getCurrentItem();
    }

    public void setPosition(int position) {
        this.mViewPager.setCurrentItem(position, false);
    }

    public static interface OnDaySelectedListener {
        public void onDaySelected(DayPickerView var1, Calendar var2);
    }
}

