/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PackageUtils {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    private PackageUtils() {
    }

    public static String computePackageCertSha256Digest(PackageManager packageManager, String packageName, int userId) {
        PackageInfo packageInfo;
        try {
            packageInfo = packageManager.getPackageInfoAsUser(packageName, 64, userId);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        return PackageUtils.computeCertSha256Digest(packageInfo.signatures[0]);
    }

    public static String computeCertSha256Digest(Signature signature) {
        return PackageUtils.computeSha256Digest(signature.toByteArray());
    }

    public static String computeSha256Digest(byte[] data) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA256");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        messageDigest.update(data);
        byte[] digest = messageDigest.digest();
        int digestLength = digest.length;
        int charCount = 2 * digestLength;
        char[] chars = new char[charCount];
        for (int i = 0; i < digestLength; ++i) {
            int byteHex = digest[i] & 0xFF;
            chars[i * 2] = HEX_ARRAY[byteHex >>> 4];
            chars[i * 2 + 1] = HEX_ARRAY[byteHex & 0xF];
        }
        return new String(chars);
    }
}

