/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.ISub;
import com.android.internal.telephony.ITelephonyRegistry;
import java.util.ArrayList;
import java.util.List;

public class SubscriptionManager {
    private static final String LOG_TAG = "SubscriptionManager";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    public static final int INVALID_SUBSCRIPTION_ID = -1;
    public static final int DUMMY_SUBSCRIPTION_ID_BASE = -2;
    public static final int INVALID_PHONE_INDEX = -1;
    public static final int INVALID_SIM_SLOT_INDEX = -1;
    public static final int DEFAULT_SUBSCRIPTION_ID = Integer.MAX_VALUE;
    public static final int DEFAULT_PHONE_INDEX = Integer.MAX_VALUE;
    public static final int DEFAULT_SIM_SLOT_INDEX = Integer.MAX_VALUE;
    public static final int MIN_SUBSCRIPTION_ID_VALUE = 0;
    public static final int MAX_SUBSCRIPTION_ID_VALUE = 0x7FFFFFFE;
    public static final Uri CONTENT_URI = Uri.parse("content://telephony/siminfo");
    public static final String UNIQUE_KEY_SUBSCRIPTION_ID = "_id";
    public static final String ICC_ID = "icc_id";
    public static final String SIM_SLOT_INDEX = "sim_id";
    public static final int SIM_NOT_INSERTED = -1;
    public static final String DISPLAY_NAME = "display_name";
    public static final String CARRIER_NAME = "carrier_name";
    public static final int DEFAULT_NAME_RES = 17039374;
    public static final String NAME_SOURCE = "name_source";
    public static final int NAME_SOURCE_UNDEFINDED = -1;
    public static final int NAME_SOURCE_DEFAULT_SOURCE = 0;
    public static final int NAME_SOURCE_SIM_SOURCE = 1;
    public static final int NAME_SOURCE_USER_INPUT = 2;
    public static final String COLOR = "color";
    public static final int COLOR_1 = 0;
    public static final int COLOR_2 = 1;
    public static final int COLOR_3 = 2;
    public static final int COLOR_4 = 3;
    public static final int COLOR_DEFAULT = 0;
    public static final String NUMBER = "number";
    public static final String DISPLAY_NUMBER_FORMAT = "display_number_format";
    public static final int DISPLAY_NUMBER_NONE = 0;
    public static final int DISPLAY_NUMBER_FIRST = 1;
    public static final int DISPLAY_NUMBER_LAST = 2;
    public static final int DISPLAY_NUMBER_DEFAULT = 1;
    public static final String DATA_ROAMING = "data_roaming";
    public static final int DATA_ROAMING_ENABLE = 1;
    public static final int DATA_ROAMING_DISABLE = 0;
    public static final int DATA_ROAMING_DEFAULT = 0;
    public static final int SIM_PROVISIONED = 0;
    public static final String MCC = "mcc";
    public static final String MNC = "mnc";
    public static final String SIM_PROVISIONING_STATUS = "sim_provisioning_status";
    public static final String CB_EXTREME_THREAT_ALERT = "enable_cmas_extreme_threat_alerts";
    public static final String CB_SEVERE_THREAT_ALERT = "enable_cmas_severe_threat_alerts";
    public static final String CB_AMBER_ALERT = "enable_cmas_amber_alerts";
    public static final String CB_EMERGENCY_ALERT = "enable_emergency_alerts";
    public static final String CB_ALERT_SOUND_DURATION = "alert_sound_duration";
    public static final String CB_ALERT_REMINDER_INTERVAL = "alert_reminder_interval";
    public static final String CB_ALERT_VIBRATE = "enable_alert_vibrate";
    public static final String CB_ALERT_SPEECH = "enable_alert_speech";
    public static final String CB_ETWS_TEST_ALERT = "enable_etws_test_alerts";
    public static final String CB_CHANNEL_50_ALERT = "enable_channel_50_alerts";
    public static final String CB_CMAS_TEST_ALERT = "enable_cmas_test_alerts";
    public static final String CB_OPT_OUT_DIALOG = "show_cmas_opt_out_dialog";
    public static final String SUB_DEFAULT_CHANGED_ACTION = "android.intent.action.SUB_DEFAULT_CHANGED";
    private final Context mContext;

    public SubscriptionManager(Context context) {
        this.mContext = context;
    }

    public static SubscriptionManager from(Context context) {
        return (SubscriptionManager)context.getSystemService("telephony_subscription_service");
    }

    public void addOnSubscriptionsChangedListener(OnSubscriptionsChangedListener listener) {
        String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        try {
            ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
            if (tr != null) {
                tr.addOnSubscriptionsChangedListener(pkgForDebug, listener.callback);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void removeOnSubscriptionsChangedListener(OnSubscriptionsChangedListener listener) {
        String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        try {
            ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
            if (tr != null) {
                tr.removeOnSubscriptionsChangedListener(pkgForDebug, listener.callback);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public SubscriptionInfo getActiveSubscriptionInfo(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return null;
        }
        SubscriptionInfo subInfo = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subInfo = iSub.getActiveSubscriptionInfo(subId, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subInfo;
    }

    public SubscriptionInfo getActiveSubscriptionInfoForIccIndex(String iccId) {
        if (iccId == null) {
            SubscriptionManager.logd("[getActiveSubscriptionInfoForIccIndex]- null iccid");
            return null;
        }
        SubscriptionInfo result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoForIccId(iccId, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int slotIdx) {
        if (!SubscriptionManager.isValidSlotId(slotIdx)) {
            SubscriptionManager.logd("[getActiveSubscriptionInfoForSimSlotIndex]- invalid slotIdx");
            return null;
        }
        SubscriptionInfo result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoForSimSlotIndex(slotIdx, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public List<SubscriptionInfo> getAllSubscriptionInfoList() {
        List<Object> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAllSubInfoList(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    public List<SubscriptionInfo> getActiveSubscriptionInfoList() {
        List<SubscriptionInfo> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public int getAllSubscriptionInfoCount() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAllSubInfoCount(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public int getActiveSubscriptionInfoCount() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubInfoCount(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public int getActiveSubscriptionInfoCountMax() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubInfoCountMax();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public Uri addSubscriptionInfoRecord(String iccId, int slotId) {
        if (iccId == null) {
            SubscriptionManager.logd("[addSubscriptionInfoRecord]- null iccId");
        }
        if (!SubscriptionManager.isValidSlotId(slotId)) {
            SubscriptionManager.logd("[addSubscriptionInfoRecord]- invalid slotId");
        }
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.addSubInfoRecord(iccId, slotId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public int setIconTint(int tint, int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setIconTint]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setIconTint(tint, subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public int setDisplayName(String displayName, int subId) {
        return this.setDisplayName(displayName, subId, -1L);
    }

    public int setDisplayName(String displayName, int subId, long nameSource) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setDisplayName]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDisplayNameUsingSrc(displayName, subId, nameSource);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public int setDisplayNumber(String number, int subId) {
        if (number == null || !SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setDisplayNumber]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDisplayNumber(number, subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public int setDataRoaming(int roaming, int subId) {
        if (roaming < 0 || !SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setDataRoaming]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDataRoaming(roaming, subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public static int getSlotId(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            // empty if block
        }
        int result = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getSlotId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public static int[] getSubId(int slotId) {
        if (!SubscriptionManager.isValidSlotId(slotId)) {
            SubscriptionManager.logd("[getSubId]- fail");
            return null;
        }
        int[] subId = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getSubId(slotId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public static int getPhoneId(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return -1;
        }
        int result = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getPhoneId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static void logd(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    public static int getDefaultSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public static int getDefaultVoiceSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultVoiceSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public void setDefaultVoiceSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultVoiceSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public SubscriptionInfo getDefaultVoiceSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultVoiceSubscriptionId());
    }

    public static int getDefaultVoicePhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultVoiceSubscriptionId());
    }

    public static int getDefaultSmsSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultSmsSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public void setDefaultSmsSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultSmsSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public SubscriptionInfo getDefaultSmsSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultSmsSubscriptionId());
    }

    public int getDefaultSmsPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultSmsSubscriptionId());
    }

    public static int getDefaultDataSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultDataSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public void setDefaultDataSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultDataSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public SubscriptionInfo getDefaultDataSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultDataSubscriptionId());
    }

    public int getDefaultDataPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultDataSubscriptionId());
    }

    public void clearSubscriptionInfo() {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.clearSubInfo();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean allDefaultsSelected() {
        if (!SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultDataSubscriptionId())) {
            return false;
        }
        if (!SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultSmsSubscriptionId())) {
            return false;
        }
        return SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultVoiceSubscriptionId());
    }

    public void clearDefaultsForInactiveSubIds() {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.clearDefaultsForInactiveSubIds();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static boolean isValidSubscriptionId(int subId) {
        return subId > -1;
    }

    public static boolean isUsableSubIdValue(int subId) {
        return subId >= 0 && subId <= 0x7FFFFFFE;
    }

    public static boolean isValidSlotId(int slotId) {
        return slotId >= 0 && slotId < TelephonyManager.getDefault().getSimCount();
    }

    public static boolean isValidPhoneId(int phoneId) {
        return phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount();
    }

    public static void putPhoneIdAndSubIdExtra(Intent intent, int phoneId) {
        int[] subIds = SubscriptionManager.getSubId(phoneId);
        if (subIds != null && subIds.length > 0) {
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId, subIds[0]);
        } else {
            SubscriptionManager.logd("putPhoneIdAndSubIdExtra: no valid subs");
        }
    }

    public static void putPhoneIdAndSubIdExtra(Intent intent, int phoneId, int subId) {
        intent.putExtra("subscription", subId);
        intent.putExtra("phone", phoneId);
        intent.putExtra("slot", phoneId);
    }

    public int[] getActiveSubscriptionIdList() {
        int[] subId = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getActiveSubIdList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (subId == null) {
            subId = new int[]{};
        }
        return subId;
    }

    public boolean isNetworkRoaming(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        if (phoneId < 0) {
            return false;
        }
        return TelephonyManager.getDefault().isNetworkRoaming(subId);
    }

    public static int getSimStateForSlotIdx(int slotIdx) {
        int simState = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                simState = iSub.getSimStateForSlotIdx(slotIdx);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return simState;
    }

    public static void setSubscriptionProperty(int subId, String propKey, String propValue) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setSubscriptionProperty(subId, propKey, propValue);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static String getSubscriptionProperty(int subId, String propKey, Context context) {
        String resultValue = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                resultValue = iSub.getSubscriptionProperty(subId, propKey, context.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return resultValue;
    }

    public static boolean getBooleanSubscriptionProperty(int subId, String propKey, boolean defValue, Context context) {
        String result = SubscriptionManager.getSubscriptionProperty(subId, propKey, context);
        if (result != null) {
            try {
                return Integer.parseInt(result) == 1;
            }
            catch (NumberFormatException err) {
                SubscriptionManager.logd("getBooleanSubscriptionProperty NumberFormat exception");
            }
        }
        return defValue;
    }

    public static int getIntegerSubscriptionProperty(int subId, String propKey, int defValue, Context context) {
        String result = SubscriptionManager.getSubscriptionProperty(subId, propKey, context);
        if (result != null) {
            try {
                return Integer.parseInt(result);
            }
            catch (NumberFormatException err) {
                SubscriptionManager.logd("getBooleanSubscriptionProperty NumberFormat exception");
            }
        }
        return defValue;
    }

    public static Resources getResourcesForSubId(Context context, int subId) {
        SubscriptionInfo subInfo = SubscriptionManager.from(context).getActiveSubscriptionInfo(subId);
        Configuration config = context.getResources().getConfiguration();
        Configuration newConfig = new Configuration();
        newConfig.setTo(config);
        if (subInfo != null) {
            newConfig.mcc = subInfo.getMcc();
            newConfig.mnc = subInfo.getMnc();
            if (newConfig.mnc == 0) {
                newConfig.mnc = 65535;
            }
        }
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        DisplayMetrics newMetrics = new DisplayMetrics();
        newMetrics.setTo(metrics);
        return new Resources(context.getResources().getAssets(), newMetrics, newConfig);
    }

    public boolean isActiveSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                return iSub.isActiveSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    public static class OnSubscriptionsChangedListener {
        private final Handler mHandler = new Handler(){

            @Override
            public void handleMessage(Message msg) {
                this.onSubscriptionsChanged();
            }
        };
        IOnSubscriptionsChangedListener callback = new IOnSubscriptionsChangedListener.Stub(){

            @Override
            public void onSubscriptionsChanged() {
                mHandler.sendEmptyMessage(0);
            }
        };

        public void onSubscriptionsChanged() {
        }

        private void log(String s) {
            Rlog.d(SubscriptionManager.LOG_TAG, s);
        }
    }
}

