/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.app.ActivityThread;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.IPackageMoveObserver;
import android.os.Binder;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.storage.DiskInfo;
import android.os.storage.IMountService;
import android.os.storage.IMountServiceListener;
import android.os.storage.IObbActionListener;
import android.os.storage.OnObbStateChangeListener;
import android.os.storage.StorageEventListener;
import android.os.storage.StorageVolume;
import android.os.storage.VolumeInfo;
import android.os.storage.VolumeRecord;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class StorageManager {
    private static final String TAG = "StorageManager";
    public static final String PROP_PRIMARY_PHYSICAL = "ro.vold.primary_physical";
    public static final String PROP_HAS_ADOPTABLE = "vold.has_adoptable";
    public static final String PROP_FORCE_ADOPTABLE = "persist.fw.force_adoptable";
    public static final String PROP_EMULATE_FBE = "persist.sys.emulate_fbe";
    public static final String PROP_SDCARDFS = "persist.sys.sdcardfs";
    public static final String UUID_PRIVATE_INTERNAL = null;
    public static final String UUID_PRIMARY_PHYSICAL = "primary_physical";
    public static final String ACTION_MANAGE_STORAGE = "android.os.storage.action.MANAGE_STORAGE";
    public static final int DEBUG_FORCE_ADOPTABLE = 1;
    public static final int DEBUG_EMULATE_FBE = 2;
    public static final int DEBUG_SDCARDFS_FORCE_ON = 4;
    public static final int DEBUG_SDCARDFS_FORCE_OFF = 8;
    public static final int FLAG_STORAGE_DE = 1;
    public static final int FLAG_STORAGE_CE = 2;
    public static final int FLAG_FOR_WRITE = 256;
    public static final int FLAG_REAL_STATE = 512;
    public static final int FLAG_INCLUDE_INVISIBLE = 1024;
    private static volatile IMountService sMountService = null;
    private static final String[] INTERNAL_STORAGE_SIZE_PATHS = new String[]{"/sys/block/mmcblk0/size", "/sys/block/sda/size"};
    private static final int INTERNAL_STORAGE_SECTOR_SIZE = 512;
    private final Context mContext;
    private final ContentResolver mResolver;
    private final IMountService mMountService;
    private final Looper mLooper;
    private final AtomicInteger mNextNonce = new AtomicInteger(0);
    private final ArrayList<StorageEventListenerDelegate> mDelegates = new ArrayList();
    private final ObbActionListener mObbActionListener = new ObbActionListener();
    private static final int DEFAULT_THRESHOLD_PERCENTAGE = 10;
    private static final long DEFAULT_THRESHOLD_MAX_BYTES = 524288000L;
    private static final long DEFAULT_FULL_THRESHOLD_BYTES = 0x100000L;
    public static final int CRYPT_TYPE_PASSWORD = 0;
    public static final int CRYPT_TYPE_DEFAULT = 1;
    public static final int CRYPT_TYPE_PATTERN = 2;
    public static final int CRYPT_TYPE_PIN = 3;
    public static final String SYSTEM_LOCALE_KEY = "SystemLocale";
    public static final String OWNER_INFO_KEY = "OwnerInfo";
    public static final String PATTERN_VISIBLE_KEY = "PatternVisible";
    public static final String PASSWORD_VISIBLE_KEY = "PasswordVisible";

    private int getNextNonce() {
        return this.mNextNonce.getAndIncrement();
    }

    @Deprecated
    public static StorageManager from(Context context) {
        return context.getSystemService(StorageManager.class);
    }

    public StorageManager(Context context, Looper looper) {
        this.mContext = context;
        this.mResolver = context.getContentResolver();
        this.mLooper = looper;
        this.mMountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        if (this.mMountService == null) {
            throw new IllegalStateException("Failed to find running mount service");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(StorageEventListener listener) {
        ArrayList<StorageEventListenerDelegate> arrayList = this.mDelegates;
        synchronized (arrayList) {
            StorageEventListenerDelegate delegate = new StorageEventListenerDelegate(listener, this.mLooper);
            try {
                this.mMountService.registerListener(delegate);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mDelegates.add(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(StorageEventListener listener) {
        ArrayList<StorageEventListenerDelegate> arrayList = this.mDelegates;
        synchronized (arrayList) {
            Iterator<StorageEventListenerDelegate> i = this.mDelegates.iterator();
            while (i.hasNext()) {
                StorageEventListenerDelegate delegate = i.next();
                if (delegate.mCallback != listener) continue;
                try {
                    this.mMountService.unregisterListener(delegate);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                i.remove();
            }
        }
    }

    @Deprecated
    public void enableUsbMassStorage() {
    }

    @Deprecated
    public void disableUsbMassStorage() {
    }

    @Deprecated
    public boolean isUsbMassStorageConnected() {
        return false;
    }

    @Deprecated
    public boolean isUsbMassStorageEnabled() {
        return false;
    }

    public boolean mountObb(String rawPath, String key, OnObbStateChangeListener listener) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        Preconditions.checkNotNull(listener, "listener cannot be null");
        try {
            String canonicalPath = new File(rawPath).getCanonicalPath();
            int nonce = this.mObbActionListener.addListener(listener);
            this.mMountService.mountObb(rawPath, canonicalPath, key, this.mObbActionListener, nonce);
            return true;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to resolve path: " + rawPath, e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean unmountObb(String rawPath, boolean force, OnObbStateChangeListener listener) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        Preconditions.checkNotNull(listener, "listener cannot be null");
        try {
            int nonce = this.mObbActionListener.addListener(listener);
            this.mMountService.unmountObb(rawPath, force, this.mObbActionListener, nonce);
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isObbMounted(String rawPath) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        try {
            return this.mMountService.isObbMounted(rawPath);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String getMountedObbPath(String rawPath) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        try {
            return this.mMountService.getMountedObbPath(rawPath);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<DiskInfo> getDisks() {
        try {
            return Arrays.asList(this.mMountService.getDisks());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public DiskInfo findDiskById(String id2) {
        Preconditions.checkNotNull(id2);
        for (DiskInfo disk : this.getDisks()) {
            if (!Objects.equals(disk.id, id2)) continue;
            return disk;
        }
        return null;
    }

    public VolumeInfo findVolumeById(String id2) {
        Preconditions.checkNotNull(id2);
        for (VolumeInfo vol : this.getVolumes()) {
            if (!Objects.equals(vol.id, id2)) continue;
            return vol;
        }
        return null;
    }

    public VolumeInfo findVolumeByUuid(String fsUuid) {
        Preconditions.checkNotNull(fsUuid);
        for (VolumeInfo vol : this.getVolumes()) {
            if (!Objects.equals(vol.fsUuid, fsUuid)) continue;
            return vol;
        }
        return null;
    }

    public VolumeRecord findRecordByUuid(String fsUuid) {
        Preconditions.checkNotNull(fsUuid);
        for (VolumeRecord rec : this.getVolumeRecords()) {
            if (!Objects.equals(rec.fsUuid, fsUuid)) continue;
            return rec;
        }
        return null;
    }

    public VolumeInfo findPrivateForEmulated(VolumeInfo emulatedVol) {
        if (emulatedVol != null) {
            return this.findVolumeById(emulatedVol.getId().replace("emulated", "private"));
        }
        return null;
    }

    public VolumeInfo findEmulatedForPrivate(VolumeInfo privateVol) {
        if (privateVol != null) {
            return this.findVolumeById(privateVol.getId().replace("private", "emulated"));
        }
        return null;
    }

    public VolumeInfo findVolumeByQualifiedUuid(String volumeUuid) {
        if (Objects.equals(UUID_PRIVATE_INTERNAL, volumeUuid)) {
            return this.findVolumeById("private");
        }
        if (Objects.equals(UUID_PRIMARY_PHYSICAL, volumeUuid)) {
            return this.getPrimaryPhysicalVolume();
        }
        return this.findVolumeByUuid(volumeUuid);
    }

    public List<VolumeInfo> getVolumes() {
        try {
            return Arrays.asList(this.mMountService.getVolumes(0));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<VolumeInfo> getWritablePrivateVolumes() {
        try {
            ArrayList<VolumeInfo> res = new ArrayList<VolumeInfo>();
            for (VolumeInfo vol : this.mMountService.getVolumes(0)) {
                if (vol.getType() != 1 || !vol.isMountedWritable()) continue;
                res.add(vol);
            }
            return res;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<VolumeRecord> getVolumeRecords() {
        try {
            return Arrays.asList(this.mMountService.getVolumeRecords(0));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String getBestVolumeDescription(VolumeInfo vol) {
        VolumeRecord rec;
        if (vol == null) {
            return null;
        }
        if (!TextUtils.isEmpty(vol.fsUuid) && (rec = this.findRecordByUuid(vol.fsUuid)) != null && !TextUtils.isEmpty(rec.nickname)) {
            return rec.nickname;
        }
        if (!TextUtils.isEmpty(vol.getDescription())) {
            return vol.getDescription();
        }
        if (vol.disk != null) {
            return vol.disk.getDescription();
        }
        return null;
    }

    public VolumeInfo getPrimaryPhysicalVolume() {
        List<VolumeInfo> vols = this.getVolumes();
        for (VolumeInfo vol : vols) {
            if (!vol.isPrimaryPhysical()) continue;
            return vol;
        }
        return null;
    }

    public void mount(String volId) {
        try {
            this.mMountService.mount(volId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unmount(String volId) {
        try {
            this.mMountService.unmount(volId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void format(String volId) {
        try {
            this.mMountService.format(volId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public long benchmark(String volId) {
        try {
            return this.mMountService.benchmark(volId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void partitionPublic(String diskId) {
        try {
            this.mMountService.partitionPublic(diskId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void partitionPrivate(String diskId) {
        try {
            this.mMountService.partitionPrivate(diskId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void partitionMixed(String diskId, int ratio) {
        try {
            this.mMountService.partitionMixed(diskId, ratio);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void wipeAdoptableDisks() {
        List<DiskInfo> disks = this.getDisks();
        for (DiskInfo disk : disks) {
            String diskId = disk.getId();
            if (disk.isAdoptable()) {
                Slog.d(TAG, "Found adoptable " + diskId + "; wiping");
                try {
                    this.mMountService.partitionPublic(diskId);
                }
                catch (Exception e) {
                    Slog.w(TAG, "Failed to wipe " + diskId + ", but soldiering onward", e);
                }
                continue;
            }
            Slog.d(TAG, "Ignorning non-adoptable disk " + disk.getId());
        }
    }

    public void setVolumeNickname(String fsUuid, String nickname) {
        try {
            this.mMountService.setVolumeNickname(fsUuid, nickname);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setVolumeInited(String fsUuid, boolean inited) {
        try {
            this.mMountService.setVolumeUserFlags(fsUuid, inited ? 1 : 0, 1);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setVolumeSnoozed(String fsUuid, boolean snoozed) {
        try {
            this.mMountService.setVolumeUserFlags(fsUuid, snoozed ? 2 : 0, 2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void forgetVolume(String fsUuid) {
        try {
            this.mMountService.forgetVolume(fsUuid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String getPrimaryStorageUuid() {
        try {
            return this.mMountService.getPrimaryStorageUuid();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setPrimaryStorageUuid(String volumeUuid, IPackageMoveObserver callback) {
        try {
            this.mMountService.setPrimaryStorageUuid(volumeUuid, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public StorageVolume getStorageVolume(File file) {
        return StorageManager.getStorageVolume(this.getVolumeList(), file);
    }

    public static StorageVolume getStorageVolume(File file, int userId) {
        return StorageManager.getStorageVolume(StorageManager.getVolumeList(userId, 0), file);
    }

    private static StorageVolume getStorageVolume(StorageVolume[] volumes, File file) {
        if (file == null) {
            return null;
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ignored) {
            Slog.d(TAG, "Could not get canonical path for " + file);
            return null;
        }
        for (StorageVolume volume : volumes) {
            File volumeFile = volume.getPathFile();
            try {
                volumeFile = volumeFile.getCanonicalFile();
            }
            catch (IOException ignored) {
                continue;
            }
            if (!FileUtils.contains(volumeFile, file)) continue;
            return volume;
        }
        return null;
    }

    @Deprecated
    public String getVolumeState(String mountPoint) {
        StorageVolume vol = this.getStorageVolume(new File(mountPoint));
        if (vol != null) {
            return vol.getState();
        }
        return "unknown";
    }

    public List<StorageVolume> getStorageVolumes() {
        ArrayList<StorageVolume> res = new ArrayList<StorageVolume>();
        Collections.addAll(res, StorageManager.getVolumeList(UserHandle.myUserId(), 1536));
        return res;
    }

    public StorageVolume getPrimaryStorageVolume() {
        return StorageManager.getVolumeList(UserHandle.myUserId(), 1536)[0];
    }

    public long getPrimaryStorageSize() {
        for (String path : INTERNAL_STORAGE_SIZE_PATHS) {
            long numberBlocks = this.readLong(path);
            if (numberBlocks <= 0L) continue;
            return numberBlocks * 512L;
        }
        return 0L;
    }

    /*
     * Exception decompiling
     */
    private long readLong(String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public StorageVolume[] getVolumeList() {
        return StorageManager.getVolumeList(this.mContext.getUserId(), 0);
    }

    public static StorageVolume[] getVolumeList(int userId, int flags) {
        IMountService mountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        try {
            int uid;
            String packageName = ActivityThread.currentOpPackageName();
            if (packageName == null) {
                String[] packageNames = ActivityThread.getPackageManager().getPackagesForUid(Process.myUid());
                if (packageNames == null || packageNames.length <= 0) {
                    return new StorageVolume[0];
                }
                packageName = packageNames[0];
            }
            if ((uid = ActivityThread.getPackageManager().getPackageUid(packageName, 0x10000000, userId)) <= 0) {
                return new StorageVolume[0];
            }
            return mountService.getVolumeList(uid, packageName, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public String[] getVolumePaths() {
        StorageVolume[] volumes = this.getVolumeList();
        int count = volumes.length;
        String[] paths = new String[count];
        for (int i = 0; i < count; ++i) {
            paths[i] = volumes[i].getPath();
        }
        return paths;
    }

    public StorageVolume getPrimaryVolume() {
        return StorageManager.getPrimaryVolume(this.getVolumeList());
    }

    public static StorageVolume getPrimaryVolume(StorageVolume[] volumes) {
        for (StorageVolume volume : volumes) {
            if (!volume.isPrimary()) continue;
            return volume;
        }
        throw new IllegalStateException("Missing primary storage");
    }

    public long getStorageBytesUntilLow(File path) {
        return path.getUsableSpace() - this.getStorageFullBytes(path);
    }

    public long getStorageLowBytes(File path) {
        long lowPercent = Settings.Global.getInt(this.mResolver, "sys_storage_threshold_percentage", 10);
        long lowBytes = path.getTotalSpace() * lowPercent / 100L;
        long maxLowBytes = Settings.Global.getLong(this.mResolver, "sys_storage_threshold_max_bytes", 524288000L);
        return Math.min(lowBytes, maxLowBytes);
    }

    public long getStorageFullBytes(File path) {
        return Settings.Global.getLong(this.mResolver, "sys_storage_full_threshold_bytes", 0x100000L);
    }

    public void createUserKey(int userId, int serialNumber, boolean ephemeral) {
        try {
            this.mMountService.createUserKey(userId, serialNumber, ephemeral);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void destroyUserKey(int userId) {
        try {
            this.mMountService.destroyUserKey(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unlockUserKey(int userId, int serialNumber, byte[] token, byte[] secret) {
        try {
            this.mMountService.unlockUserKey(userId, serialNumber, token, secret);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void lockUserKey(int userId) {
        try {
            this.mMountService.lockUserKey(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void prepareUserStorage(String volumeUuid, int userId, int serialNumber, int flags) {
        try {
            this.mMountService.prepareUserStorage(volumeUuid, userId, serialNumber, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void destroyUserStorage(String volumeUuid, int userId, int flags) {
        try {
            this.mMountService.destroyUserStorage(volumeUuid, userId, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean isUserKeyUnlocked(int userId) {
        if (sMountService == null) {
            sMountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        }
        if (sMountService == null) {
            Slog.w(TAG, "Early during boot, assuming locked");
            return false;
        }
        long token = Binder.clearCallingIdentity();
        try {
            boolean bl = sMountService.isUserKeyUnlocked(userId);
            return bl;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    public boolean isEncrypted(File file) {
        if (FileUtils.contains(Environment.getDataDirectory(), file)) {
            return StorageManager.isEncrypted();
        }
        return FileUtils.contains(Environment.getExpandDirectory(), file);
    }

    public static boolean isEncryptable() {
        String state = SystemProperties.get("ro.crypto.state", "unsupported");
        return !"unsupported".equalsIgnoreCase(state);
    }

    public static boolean isEncrypted() {
        String state = SystemProperties.get("ro.crypto.state", "");
        return "encrypted".equalsIgnoreCase(state);
    }

    public static boolean isFileEncryptedNativeOnly() {
        if (!StorageManager.isEncrypted()) {
            return false;
        }
        String status = SystemProperties.get("ro.crypto.type", "");
        return "file".equalsIgnoreCase(status);
    }

    public static boolean isBlockEncrypted() {
        if (!StorageManager.isEncrypted()) {
            return false;
        }
        String status = SystemProperties.get("ro.crypto.type", "");
        return "block".equalsIgnoreCase(status);
    }

    public static boolean isNonDefaultBlockEncrypted() {
        if (!StorageManager.isBlockEncrypted()) {
            return false;
        }
        try {
            IMountService mountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
            return mountService.getPasswordType() != 1;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error getting encryption type");
            return false;
        }
    }

    public static boolean isBlockEncrypting() {
        String state = SystemProperties.get("vold.encrypt_progress", "");
        return !"".equalsIgnoreCase(state);
    }

    public static boolean inCryptKeeperBounce() {
        String status = SystemProperties.get("vold.decrypt");
        return "trigger_restart_min_framework".equals(status);
    }

    public static boolean isFileEncryptedEmulatedOnly() {
        return SystemProperties.getBoolean(PROP_EMULATE_FBE, false);
    }

    public static boolean isFileEncryptedNativeOrEmulated() {
        return StorageManager.isFileEncryptedNativeOnly() || StorageManager.isFileEncryptedEmulatedOnly();
    }

    public static File maybeTranslateEmulatedPathToInternal(File path) {
        IMountService mountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        try {
            VolumeInfo[] vols;
            for (VolumeInfo vol : vols = mountService.getVolumes(0)) {
                File internalPath;
                if (vol.getType() != 2 && vol.getType() != 0 || !vol.isMountedReadable() || (internalPath = FileUtils.rewriteAfterRename(vol.getPath(), vol.getInternalPath(), path)) == null || !internalPath.exists()) continue;
                return internalPath;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return path;
    }

    public ParcelFileDescriptor mountAppFuse(String name) {
        try {
            return this.mMountService.mountAppFuse(name);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private class ObbListenerDelegate {
        private final WeakReference<OnObbStateChangeListener> mObbEventListenerRef;
        private final Handler mHandler;
        private final int nonce;

        ObbListenerDelegate(OnObbStateChangeListener listener) {
            this.nonce = StorageManager.this.getNextNonce();
            this.mObbEventListenerRef = new WeakReference<OnObbStateChangeListener>(listener);
            this.mHandler = new Handler(StorageManager.this.mLooper){

                @Override
                public void handleMessage(Message msg) {
                    OnObbStateChangeListener changeListener = ObbListenerDelegate.this.getListener();
                    if (changeListener == null) {
                        return;
                    }
                    changeListener.onObbStateChange((String)msg.obj, msg.arg1);
                }
            };
        }

        OnObbStateChangeListener getListener() {
            if (this.mObbEventListenerRef == null) {
                return null;
            }
            return (OnObbStateChangeListener)this.mObbEventListenerRef.get();
        }

        void sendObbStateChanged(String path, int state) {
            this.mHandler.obtainMessage(0, state, 0, path).sendToTarget();
        }
    }

    private class ObbActionListener
    extends IObbActionListener.Stub {
        private SparseArray<ObbListenerDelegate> mListeners = new SparseArray();

        private ObbActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onObbResult(String filename, int nonce, int status) {
            ObbListenerDelegate delegate;
            SparseArray<ObbListenerDelegate> sparseArray = this.mListeners;
            synchronized (sparseArray) {
                delegate = this.mListeners.get(nonce);
                if (delegate != null) {
                    this.mListeners.remove(nonce);
                }
            }
            if (delegate != null) {
                delegate.sendObbStateChanged(filename, status);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int addListener(OnObbStateChangeListener listener) {
            ObbListenerDelegate delegate = new ObbListenerDelegate(listener);
            SparseArray<ObbListenerDelegate> sparseArray = this.mListeners;
            synchronized (sparseArray) {
                this.mListeners.put(delegate.nonce, delegate);
            }
            return delegate.nonce;
        }
    }

    private static class StorageEventListenerDelegate
    extends IMountServiceListener.Stub
    implements Handler.Callback {
        private static final int MSG_STORAGE_STATE_CHANGED = 1;
        private static final int MSG_VOLUME_STATE_CHANGED = 2;
        private static final int MSG_VOLUME_RECORD_CHANGED = 3;
        private static final int MSG_VOLUME_FORGOTTEN = 4;
        private static final int MSG_DISK_SCANNED = 5;
        private static final int MSG_DISK_DESTROYED = 6;
        final StorageEventListener mCallback;
        final Handler mHandler;

        public StorageEventListenerDelegate(StorageEventListener callback, Looper looper) {
            this.mCallback = callback;
            this.mHandler = new Handler(looper, this);
        }

        @Override
        public boolean handleMessage(Message msg) {
            SomeArgs args = (SomeArgs)msg.obj;
            switch (msg.what) {
                case 1: {
                    this.mCallback.onStorageStateChanged((String)args.arg1, (String)args.arg2, (String)args.arg3);
                    args.recycle();
                    return true;
                }
                case 2: {
                    this.mCallback.onVolumeStateChanged((VolumeInfo)args.arg1, args.argi2, args.argi3);
                    args.recycle();
                    return true;
                }
                case 3: {
                    this.mCallback.onVolumeRecordChanged((VolumeRecord)args.arg1);
                    args.recycle();
                    return true;
                }
                case 4: {
                    this.mCallback.onVolumeForgotten((String)args.arg1);
                    args.recycle();
                    return true;
                }
                case 5: {
                    this.mCallback.onDiskScanned((DiskInfo)args.arg1, args.argi2);
                    args.recycle();
                    return true;
                }
                case 6: {
                    this.mCallback.onDiskDestroyed((DiskInfo)args.arg1);
                    args.recycle();
                    return true;
                }
            }
            args.recycle();
            return false;
        }

        @Override
        public void onUsbMassStorageConnectionChanged(boolean connected) throws RemoteException {
        }

        @Override
        public void onStorageStateChanged(String path, String oldState, String newState) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = path;
            args.arg2 = oldState;
            args.arg3 = newState;
            this.mHandler.obtainMessage(1, args).sendToTarget();
        }

        @Override
        public void onVolumeStateChanged(VolumeInfo vol, int oldState, int newState) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = vol;
            args.argi2 = oldState;
            args.argi3 = newState;
            this.mHandler.obtainMessage(2, args).sendToTarget();
        }

        @Override
        public void onVolumeRecordChanged(VolumeRecord rec) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = rec;
            this.mHandler.obtainMessage(3, args).sendToTarget();
        }

        @Override
        public void onVolumeForgotten(String fsUuid) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = fsUuid;
            this.mHandler.obtainMessage(4, args).sendToTarget();
        }

        @Override
        public void onDiskScanned(DiskInfo disk, int volumeCount) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = disk;
            args.argi2 = volumeCount;
            this.mHandler.obtainMessage(5, args).sendToTarget();
        }

        @Override
        public void onDiskDestroyed(DiskInfo disk) throws RemoteException {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = disk;
            this.mHandler.obtainMessage(6, args).sendToTarget();
        }
    }
}

