/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.net.wifi.IWifiScanner;
import android.net.wifi.ScanResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.WorkSource;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.Preconditions;
import java.util.List;

public class WifiScanner {
    public static final int WIFI_BAND_UNSPECIFIED = 0;
    public static final int WIFI_BAND_24_GHZ = 1;
    public static final int WIFI_BAND_5_GHZ = 2;
    public static final int WIFI_BAND_5_GHZ_DFS_ONLY = 4;
    public static final int WIFI_BAND_5_GHZ_WITH_DFS = 6;
    public static final int WIFI_BAND_BOTH = 3;
    public static final int WIFI_BAND_BOTH_WITH_DFS = 7;
    public static final int MIN_SCAN_PERIOD_MS = 1000;
    public static final int MAX_SCAN_PERIOD_MS = 1024000;
    public static final int REASON_SUCCEEDED = 0;
    public static final int REASON_UNSPECIFIED = -1;
    public static final int REASON_INVALID_LISTENER = -2;
    public static final int REASON_INVALID_REQUEST = -3;
    public static final int REASON_NOT_AUTHORIZED = -4;
    public static final int REASON_DUPLICATE_REQEUST = -5;
    public static final String GET_AVAILABLE_CHANNELS_EXTRA = "Channels";
    @Deprecated
    public static final int REPORT_EVENT_AFTER_BUFFER_FULL = 0;
    public static final int REPORT_EVENT_AFTER_EACH_SCAN = 1;
    public static final int REPORT_EVENT_FULL_SCAN_RESULT = 2;
    public static final int REPORT_EVENT_NO_BATCH = 4;
    public static final String SCAN_PARAMS_SCAN_SETTINGS_KEY = "ScanSettings";
    public static final String SCAN_PARAMS_WORK_SOURCE_KEY = "WorkSource";
    public static final String PNO_PARAMS_PNO_SETTINGS_KEY = "PnoSettings";
    public static final String PNO_PARAMS_SCAN_SETTINGS_KEY = "ScanSettings";
    private static final String TAG = "WifiScanner";
    private static final boolean DBG = false;
    private static final int BASE = 159744;
    public static final int CMD_SCAN = 159744;
    public static final int CMD_START_BACKGROUND_SCAN = 159746;
    public static final int CMD_STOP_BACKGROUND_SCAN = 159747;
    public static final int CMD_GET_SCAN_RESULTS = 159748;
    public static final int CMD_SCAN_RESULT = 159749;
    public static final int CMD_SET_HOTLIST = 159750;
    public static final int CMD_RESET_HOTLIST = 159751;
    public static final int CMD_AP_FOUND = 159753;
    public static final int CMD_AP_LOST = 159754;
    public static final int CMD_START_TRACKING_CHANGE = 159755;
    public static final int CMD_STOP_TRACKING_CHANGE = 159756;
    public static final int CMD_CONFIGURE_WIFI_CHANGE = 159757;
    public static final int CMD_WIFI_CHANGE_DETECTED = 159759;
    public static final int CMD_WIFI_CHANGES_STABILIZED = 159760;
    public static final int CMD_OP_SUCCEEDED = 159761;
    public static final int CMD_OP_FAILED = 159762;
    public static final int CMD_PERIOD_CHANGED = 159763;
    public static final int CMD_FULL_SCAN_RESULT = 159764;
    public static final int CMD_START_SINGLE_SCAN = 159765;
    public static final int CMD_STOP_SINGLE_SCAN = 159766;
    public static final int CMD_SINGLE_SCAN_COMPLETED = 159767;
    public static final int CMD_START_PNO_SCAN = 159768;
    public static final int CMD_STOP_PNO_SCAN = 159769;
    public static final int CMD_PNO_NETWORK_FOUND = 159770;
    public static final int CMD_REGISTER_SCAN_LISTENER = 159771;
    public static final int CMD_DEREGISTER_SCAN_LISTENER = 159772;
    private Context mContext;
    private IWifiScanner mService;
    private static final int INVALID_KEY = 0;
    private int mListenerKey = 1;
    private final SparseArray mListenerMap = new SparseArray();
    private final Object mListenerMapLock = new Object();
    private AsyncChannel mAsyncChannel;
    private final Handler mInternalHandler;

    public List<Integer> getAvailableChannels(int band) {
        try {
            Bundle bundle = this.mService.getAvailableChannels(band);
            return bundle.getIntegerArrayList(GET_AVAILABLE_CHANNELS_EXTRA);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void registerScanListener(ScanListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.addListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159771, 0, key);
    }

    public void deregisterScanListener(ScanListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.removeListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159772, 0, key);
    }

    public void startBackgroundScan(ScanSettings settings, ScanListener listener) {
        this.startBackgroundScan(settings, listener, null);
    }

    public void startBackgroundScan(ScanSettings settings, ScanListener listener, WorkSource workSource) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.addListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        Bundle scanParams = new Bundle();
        scanParams.putParcelable("ScanSettings", settings);
        scanParams.putParcelable(SCAN_PARAMS_WORK_SOURCE_KEY, workSource);
        this.mAsyncChannel.sendMessage(159746, 0, key, scanParams);
    }

    public void stopBackgroundScan(ScanListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.removeListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159747, 0, key);
    }

    public boolean getScanResults() {
        this.validateChannel();
        Message reply = this.mAsyncChannel.sendMessageSynchronously(159748, 0);
        return reply.what == 159761;
    }

    public void startScan(ScanSettings settings, ScanListener listener) {
        this.startScan(settings, listener, null);
    }

    public void startScan(ScanSettings settings, ScanListener listener, WorkSource workSource) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.addListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        Bundle scanParams = new Bundle();
        scanParams.putParcelable("ScanSettings", settings);
        scanParams.putParcelable(SCAN_PARAMS_WORK_SOURCE_KEY, workSource);
        this.mAsyncChannel.sendMessage(159765, 0, key, scanParams);
    }

    public void stopScan(ScanListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.removeListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159766, 0, key);
    }

    private void startPnoScan(ScanSettings scanSettings, PnoSettings pnoSettings, int key) {
        Bundle pnoParams = new Bundle();
        scanSettings.isPnoScan = true;
        pnoParams.putParcelable("ScanSettings", scanSettings);
        pnoParams.putParcelable(PNO_PARAMS_PNO_SETTINGS_KEY, pnoSettings);
        this.mAsyncChannel.sendMessage(159768, 0, key, pnoParams);
    }

    public void startConnectedPnoScan(ScanSettings scanSettings, PnoSettings pnoSettings, PnoScanListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        Preconditions.checkNotNull(pnoSettings, "pnoSettings cannot be null");
        int key = this.addListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        pnoSettings.isConnected = true;
        this.startPnoScan(scanSettings, pnoSettings, key);
    }

    public void startDisconnectedPnoScan(ScanSettings scanSettings, PnoSettings pnoSettings, PnoScanListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        Preconditions.checkNotNull(pnoSettings, "pnoSettings cannot be null");
        int key = this.addListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        pnoSettings.isConnected = false;
        this.startPnoScan(scanSettings, pnoSettings, key);
    }

    public void stopPnoScan(ScanListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.removeListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159769, 0, key);
    }

    public void configureWifiChange(int rssiSampleSize, int lostApSampleSize, int unchangedSampleSize, int minApsBreachingThreshold, int periodInMs, BssidInfo[] bssidInfos) {
        this.validateChannel();
        WifiChangeSettings settings = new WifiChangeSettings();
        settings.rssiSampleSize = rssiSampleSize;
        settings.lostApSampleSize = lostApSampleSize;
        settings.unchangedSampleSize = unchangedSampleSize;
        settings.minApsBreachingThreshold = minApsBreachingThreshold;
        settings.periodInMs = periodInMs;
        settings.bssidInfos = bssidInfos;
        this.configureWifiChange(settings);
    }

    public void startTrackingWifiChange(WifiChangeListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.addListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159755, 0, key);
    }

    public void stopTrackingWifiChange(WifiChangeListener listener) {
        int key = this.removeListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159756, 0, key);
    }

    public void configureWifiChange(WifiChangeSettings settings) {
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159757, 0, 0, settings);
    }

    public void startTrackingBssids(BssidInfo[] bssidInfos, int apLostThreshold, BssidListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.addListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        HotlistSettings settings = new HotlistSettings();
        settings.bssidInfos = bssidInfos;
        settings.apLostThreshold = apLostThreshold;
        this.mAsyncChannel.sendMessage(159750, 0, key, settings);
    }

    public void stopTrackingBssids(BssidListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.removeListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159751, 0, key);
    }

    public WifiScanner(Context context, IWifiScanner service, Looper looper) {
        this.mContext = context;
        this.mService = service;
        Messenger messenger = null;
        try {
            messenger = this.mService.getMessenger();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (messenger == null) {
            throw new IllegalStateException("getMessenger() returned null!  This is invalid.");
        }
        this.mAsyncChannel = new AsyncChannel();
        this.mInternalHandler = new ServiceHandler(looper);
        this.mAsyncChannel.connectSync(this.mContext, this.mInternalHandler, messenger);
        this.mAsyncChannel.sendMessage(69633);
    }

    private void validateChannel() {
        if (this.mAsyncChannel == null) {
            throw new IllegalStateException("No permission to access and change wifi or a bad initialization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addListener(ActionListener listener) {
        Object object = this.mListenerMapLock;
        synchronized (object) {
            boolean keyExists = this.getListenerKey(listener) != 0;
            int key = this.putListener(listener);
            if (keyExists) {
                OperationResult operationResult = new OperationResult(-5, "Outstanding request with same key not stopped yet");
                Message message = Message.obtain(this.mInternalHandler, 159762, 0, key, operationResult);
                message.sendToTarget();
                return 0;
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int putListener(Object listener) {
        int key;
        if (listener == null) {
            return 0;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            do {
                ++this.mListenerKey;
            } while (key == 0);
            this.mListenerMap.put(key, listener);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            Object listener = this.mListenerMap.get(key);
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getListenerKey(Object listener) {
        if (listener == null) {
            return 0;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            int index = this.mListenerMap.indexOfValue(listener);
            if (index == -1) {
                return 0;
            }
            return this.mListenerMap.keyAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object removeListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            Object listener = this.mListenerMap.get(key);
            this.mListenerMap.remove(key);
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeListener(Object listener) {
        int key = this.getListenerKey(listener);
        if (key == 0) {
            Log.e(TAG, "listener cannot be found");
            return key;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            this.mListenerMap.remove(key);
            return key;
        }
    }

    private class ServiceHandler
    extends Handler {
        ServiceHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 69634: {
                    return;
                }
                case 69636: {
                    Log.e(WifiScanner.TAG, "Channel connection lost");
                    WifiScanner.this.mAsyncChannel = null;
                    this.getLooper().quit();
                    return;
                }
            }
            Object listener = WifiScanner.this.getListener(msg.arg2);
            if (listener == null) {
                return;
            }
            switch (msg.what) {
                case 159761: {
                    ((ActionListener)listener).onSuccess();
                    break;
                }
                case 159762: {
                    OperationResult result = (OperationResult)msg.obj;
                    ((ActionListener)listener).onFailure(result.reason, result.description);
                    WifiScanner.this.removeListener(msg.arg2);
                    break;
                }
                case 159749: {
                    ((ScanListener)listener).onResults(((ParcelableScanData)msg.obj).getResults());
                    return;
                }
                case 159764: {
                    ScanResult result = (ScanResult)msg.obj;
                    ((ScanListener)listener).onFullResult(result);
                    return;
                }
                case 159763: {
                    ((ScanListener)listener).onPeriodChanged(msg.arg1);
                    return;
                }
                case 159753: {
                    ((BssidListener)listener).onFound(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                case 159754: {
                    ((BssidListener)listener).onLost(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                case 159759: {
                    ((WifiChangeListener)listener).onChanging(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                case 159760: {
                    ((WifiChangeListener)listener).onQuiescence(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                case 159767: {
                    WifiScanner.this.removeListener(msg.arg2);
                    break;
                }
                case 159770: {
                    ((PnoScanListener)listener).onPnoNetworkFound(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                default: {
                    return;
                }
            }
        }
    }

    public static class OperationResult
    implements Parcelable {
        public int reason;
        public String description;
        public static final Parcelable.Creator<OperationResult> CREATOR = new Parcelable.Creator<OperationResult>(){

            @Override
            public OperationResult createFromParcel(Parcel in) {
                int reason = in.readInt();
                String description = in.readString();
                return new OperationResult(reason, description);
            }

            public OperationResult[] newArray(int size) {
                return new OperationResult[size];
            }
        };

        public OperationResult(int reason, String description) {
            this.reason = reason;
            this.description = description;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.reason);
            dest.writeString(this.description);
        }
    }

    public static class HotlistSettings
    implements Parcelable {
        public BssidInfo[] bssidInfos;
        public int apLostThreshold;
        public static final Parcelable.Creator<HotlistSettings> CREATOR = new Parcelable.Creator<HotlistSettings>(){

            @Override
            public HotlistSettings createFromParcel(Parcel in) {
                HotlistSettings settings = new HotlistSettings();
                settings.apLostThreshold = in.readInt();
                int n = in.readInt();
                settings.bssidInfos = new BssidInfo[n];
                for (int i = 0; i < n; ++i) {
                    BssidInfo info = new BssidInfo();
                    info.bssid = in.readString();
                    info.low = in.readInt();
                    info.high = in.readInt();
                    info.frequencyHint = in.readInt();
                    settings.bssidInfos[i] = info;
                }
                return settings;
            }

            public HotlistSettings[] newArray(int size) {
                return new HotlistSettings[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.apLostThreshold);
            if (this.bssidInfos != null) {
                dest.writeInt(this.bssidInfos.length);
                for (int i = 0; i < this.bssidInfos.length; ++i) {
                    BssidInfo info = this.bssidInfos[i];
                    dest.writeString(info.bssid);
                    dest.writeInt(info.low);
                    dest.writeInt(info.high);
                    dest.writeInt(info.frequencyHint);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    public static interface BssidListener
    extends ActionListener {
        public void onFound(ScanResult[] var1);

        public void onLost(ScanResult[] var1);
    }

    public static interface WifiChangeListener
    extends ActionListener {
        public void onChanging(ScanResult[] var1);

        public void onQuiescence(ScanResult[] var1);
    }

    public static class WifiChangeSettings
    implements Parcelable {
        public int rssiSampleSize;
        public int lostApSampleSize;
        public int unchangedSampleSize;
        public int minApsBreachingThreshold;
        public int periodInMs;
        public BssidInfo[] bssidInfos;
        public static final Parcelable.Creator<WifiChangeSettings> CREATOR = new Parcelable.Creator<WifiChangeSettings>(){

            @Override
            public WifiChangeSettings createFromParcel(Parcel in) {
                WifiChangeSettings settings = new WifiChangeSettings();
                settings.rssiSampleSize = in.readInt();
                settings.lostApSampleSize = in.readInt();
                settings.unchangedSampleSize = in.readInt();
                settings.minApsBreachingThreshold = in.readInt();
                settings.periodInMs = in.readInt();
                int len = in.readInt();
                settings.bssidInfos = new BssidInfo[len];
                for (int i = 0; i < len; ++i) {
                    BssidInfo info = new BssidInfo();
                    info.bssid = in.readString();
                    info.low = in.readInt();
                    info.high = in.readInt();
                    info.frequencyHint = in.readInt();
                    settings.bssidInfos[i] = info;
                }
                return settings;
            }

            public WifiChangeSettings[] newArray(int size) {
                return new WifiChangeSettings[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.rssiSampleSize);
            dest.writeInt(this.lostApSampleSize);
            dest.writeInt(this.unchangedSampleSize);
            dest.writeInt(this.minApsBreachingThreshold);
            dest.writeInt(this.periodInMs);
            if (this.bssidInfos != null) {
                dest.writeInt(this.bssidInfos.length);
                for (int i = 0; i < this.bssidInfos.length; ++i) {
                    BssidInfo info = this.bssidInfos[i];
                    dest.writeString(info.bssid);
                    dest.writeInt(info.low);
                    dest.writeInt(info.high);
                    dest.writeInt(info.frequencyHint);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    public static class BssidInfo {
        public String bssid;
        public int low;
        public int high;
        public int frequencyHint;
    }

    public static interface PnoScanListener
    extends ScanListener {
        public void onPnoNetworkFound(ScanResult[] var1);
    }

    public static interface ScanListener
    extends ActionListener {
        public void onPeriodChanged(int var1);

        public void onResults(ScanData[] var1);

        public void onFullResult(ScanResult var1);
    }

    public static class PnoSettings
    implements Parcelable {
        public boolean isConnected;
        public int min5GHzRssi;
        public int min24GHzRssi;
        public int initialScoreMax;
        public int currentConnectionBonus;
        public int sameNetworkBonus;
        public int secureBonus;
        public int band5GHzBonus;
        public PnoNetwork[] networkList;
        public static final Parcelable.Creator<PnoSettings> CREATOR = new Parcelable.Creator<PnoSettings>(){

            @Override
            public PnoSettings createFromParcel(Parcel in) {
                PnoSettings settings = new PnoSettings();
                settings.isConnected = in.readInt() == 1;
                settings.min5GHzRssi = in.readInt();
                settings.min24GHzRssi = in.readInt();
                settings.initialScoreMax = in.readInt();
                settings.currentConnectionBonus = in.readInt();
                settings.sameNetworkBonus = in.readInt();
                settings.secureBonus = in.readInt();
                settings.band5GHzBonus = in.readInt();
                int numNetworks = in.readInt();
                settings.networkList = new PnoNetwork[numNetworks];
                for (int i = 0; i < numNetworks; ++i) {
                    String ssid = in.readString();
                    PnoNetwork network = new PnoNetwork(ssid);
                    network.networkId = in.readInt();
                    network.priority = in.readInt();
                    network.flags = in.readByte();
                    network.authBitField = in.readByte();
                    settings.networkList[i] = network;
                }
                return settings;
            }

            public PnoSettings[] newArray(int size) {
                return new PnoSettings[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.isConnected ? 1 : 0);
            dest.writeInt(this.min5GHzRssi);
            dest.writeInt(this.min24GHzRssi);
            dest.writeInt(this.initialScoreMax);
            dest.writeInt(this.currentConnectionBonus);
            dest.writeInt(this.sameNetworkBonus);
            dest.writeInt(this.secureBonus);
            dest.writeInt(this.band5GHzBonus);
            if (this.networkList != null) {
                dest.writeInt(this.networkList.length);
                for (int i = 0; i < this.networkList.length; ++i) {
                    dest.writeString(this.networkList[i].ssid);
                    dest.writeInt(this.networkList[i].networkId);
                    dest.writeInt(this.networkList[i].priority);
                    dest.writeByte(this.networkList[i].flags);
                    dest.writeByte(this.networkList[i].authBitField);
                }
            } else {
                dest.writeInt(0);
            }
        }

        public static class PnoNetwork {
            public static final byte FLAG_DIRECTED_SCAN = 1;
            public static final byte FLAG_A_BAND = 2;
            public static final byte FLAG_G_BAND = 4;
            public static final byte FLAG_STRICT_MATCH = 8;
            public static final byte FLAG_SAME_NETWORK = 16;
            public static final byte AUTH_CODE_OPEN = 1;
            public static final byte AUTH_CODE_PSK = 2;
            public static final byte AUTH_CODE_EAPOL = 4;
            public String ssid;
            public int networkId;
            public int priority;
            public byte flags;
            public byte authBitField;

            public PnoNetwork(String ssid) {
                this.ssid = ssid;
                this.flags = 0;
                this.authBitField = 0;
            }
        }
    }

    public static class ParcelableScanResults
    implements Parcelable {
        public ScanResult[] mResults;
        public static final Parcelable.Creator<ParcelableScanResults> CREATOR = new Parcelable.Creator<ParcelableScanResults>(){

            @Override
            public ParcelableScanResults createFromParcel(Parcel in) {
                int n = in.readInt();
                ScanResult[] results = new ScanResult[n];
                for (int i = 0; i < n; ++i) {
                    results[i] = ScanResult.CREATOR.createFromParcel(in);
                }
                return new ParcelableScanResults(results);
            }

            public ParcelableScanResults[] newArray(int size) {
                return new ParcelableScanResults[size];
            }
        };

        public ParcelableScanResults(ScanResult[] results) {
            this.mResults = results;
        }

        public ScanResult[] getResults() {
            return this.mResults;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mResults.length);
                for (int i = 0; i < this.mResults.length; ++i) {
                    ScanResult result = this.mResults[i];
                    result.writeToParcel(dest, flags);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    public static class ParcelableScanData
    implements Parcelable {
        public ScanData[] mResults;
        public static final Parcelable.Creator<ParcelableScanData> CREATOR = new Parcelable.Creator<ParcelableScanData>(){

            @Override
            public ParcelableScanData createFromParcel(Parcel in) {
                int n = in.readInt();
                ScanData[] results = new ScanData[n];
                for (int i = 0; i < n; ++i) {
                    results[i] = ScanData.CREATOR.createFromParcel(in);
                }
                return new ParcelableScanData(results);
            }

            public ParcelableScanData[] newArray(int size) {
                return new ParcelableScanData[size];
            }
        };

        public ParcelableScanData(ScanData[] results) {
            this.mResults = results;
        }

        public ScanData[] getResults() {
            return this.mResults;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mResults.length);
                for (int i = 0; i < this.mResults.length; ++i) {
                    ScanData result = this.mResults[i];
                    result.writeToParcel(dest, flags);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    public static class ScanData
    implements Parcelable {
        private int mId;
        private int mFlags;
        private int mBucketsScanned;
        private boolean mAllChannelsScanned;
        private ScanResult[] mResults;
        public static final Parcelable.Creator<ScanData> CREATOR = new Parcelable.Creator<ScanData>(){

            @Override
            public ScanData createFromParcel(Parcel in) {
                int id2 = in.readInt();
                int flags = in.readInt();
                int bucketsScanned = in.readInt();
                boolean allChannelsScanned = in.readInt() != 0;
                int n = in.readInt();
                ScanResult[] results = new ScanResult[n];
                for (int i = 0; i < n; ++i) {
                    results[i] = ScanResult.CREATOR.createFromParcel(in);
                }
                return new ScanData(id2, flags, bucketsScanned, allChannelsScanned, results);
            }

            public ScanData[] newArray(int size) {
                return new ScanData[size];
            }
        };

        ScanData() {
        }

        public ScanData(int id2, int flags, ScanResult[] results) {
            this.mId = id2;
            this.mFlags = flags;
            this.mResults = results;
        }

        public ScanData(int id2, int flags, int bucketsScanned, boolean allChannelsScanned, ScanResult[] results) {
            this.mId = id2;
            this.mFlags = flags;
            this.mBucketsScanned = bucketsScanned;
            this.mAllChannelsScanned = allChannelsScanned;
            this.mResults = results;
        }

        public ScanData(ScanData s) {
            this.mId = s.mId;
            this.mFlags = s.mFlags;
            this.mBucketsScanned = s.mBucketsScanned;
            this.mAllChannelsScanned = s.mAllChannelsScanned;
            this.mResults = new ScanResult[s.mResults.length];
            for (int i = 0; i < s.mResults.length; ++i) {
                ScanResult newResult;
                ScanResult result = s.mResults[i];
                this.mResults[i] = newResult = new ScanResult(result);
            }
        }

        public int getId() {
            return this.mId;
        }

        public int getFlags() {
            return this.mFlags;
        }

        public int getBucketsScanned() {
            return this.mBucketsScanned;
        }

        public boolean isAllChannelsScanned() {
            return this.mAllChannelsScanned;
        }

        public ScanResult[] getResults() {
            return this.mResults;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mId);
                dest.writeInt(this.mFlags);
                dest.writeInt(this.mBucketsScanned);
                dest.writeInt(this.mAllChannelsScanned ? 1 : 0);
                dest.writeInt(this.mResults.length);
                for (int i = 0; i < this.mResults.length; ++i) {
                    ScanResult result = this.mResults[i];
                    result.writeToParcel(dest, flags);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    public static class ScanSettings
    implements Parcelable {
        public int band;
        public ChannelSpec[] channels;
        public int[] hiddenNetworkIds;
        public int periodInMs;
        public int reportEvents;
        public int numBssidsPerScan;
        public int maxScansToCache;
        public int maxPeriodInMs;
        public int stepCount;
        public boolean isPnoScan;
        public static final Parcelable.Creator<ScanSettings> CREATOR = new Parcelable.Creator<ScanSettings>(){

            @Override
            public ScanSettings createFromParcel(Parcel in) {
                ScanSettings settings = new ScanSettings();
                settings.band = in.readInt();
                settings.periodInMs = in.readInt();
                settings.reportEvents = in.readInt();
                settings.numBssidsPerScan = in.readInt();
                settings.maxScansToCache = in.readInt();
                settings.maxPeriodInMs = in.readInt();
                settings.stepCount = in.readInt();
                settings.isPnoScan = in.readInt() == 1;
                int num_channels = in.readInt();
                settings.channels = new ChannelSpec[num_channels];
                for (int i = 0; i < num_channels; ++i) {
                    int frequency = in.readInt();
                    ChannelSpec spec = new ChannelSpec(frequency);
                    spec.dwellTimeMS = in.readInt();
                    spec.passive = in.readInt() == 1;
                    settings.channels[i] = spec;
                }
                settings.hiddenNetworkIds = in.createIntArray();
                return settings;
            }

            public ScanSettings[] newArray(int size) {
                return new ScanSettings[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.band);
            dest.writeInt(this.periodInMs);
            dest.writeInt(this.reportEvents);
            dest.writeInt(this.numBssidsPerScan);
            dest.writeInt(this.maxScansToCache);
            dest.writeInt(this.maxPeriodInMs);
            dest.writeInt(this.stepCount);
            dest.writeInt(this.isPnoScan ? 1 : 0);
            if (this.channels != null) {
                dest.writeInt(this.channels.length);
                for (int i = 0; i < this.channels.length; ++i) {
                    dest.writeInt(this.channels[i].frequency);
                    dest.writeInt(this.channels[i].dwellTimeMS);
                    dest.writeInt(this.channels[i].passive ? 1 : 0);
                }
            } else {
                dest.writeInt(0);
            }
            dest.writeIntArray(this.hiddenNetworkIds);
        }
    }

    public static class ChannelSpec {
        public int frequency;
        public boolean passive;
        public int dwellTimeMS;

        public ChannelSpec(int frequency) {
            this.frequency = frequency;
            this.passive = false;
            this.dwellTimeMS = 0;
        }
    }

    public static interface ActionListener {
        public void onSuccess();

        public void onFailure(int var1, String var2);
    }
}

