/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;

public class WifiEnterpriseConfig
implements Parcelable {
    public static final String EMPTY_VALUE = "NULL";
    public static final String EAP_KEY = "eap";
    public static final String PHASE2_KEY = "phase2";
    public static final String IDENTITY_KEY = "identity";
    public static final String ANON_IDENTITY_KEY = "anonymous_identity";
    public static final String PASSWORD_KEY = "password";
    public static final String SUBJECT_MATCH_KEY = "subject_match";
    public static final String ALTSUBJECT_MATCH_KEY = "altsubject_match";
    public static final String DOM_SUFFIX_MATCH_KEY = "domain_suffix_match";
    public static final String OPP_KEY_CACHING = "proactive_key_caching";
    public static final String ENGINE_ID_KEYSTORE = "keystore";
    public static final String KEYSTORE_URI = "keystore://";
    public static final String KEYSTORES_URI = "keystores://";
    public static final String ENGINE_ENABLE = "1";
    public static final String ENGINE_DISABLE = "0";
    public static final String CA_CERT_PREFIX = "keystore://CACERT_";
    public static final String CLIENT_CERT_PREFIX = "keystore://USRCERT_";
    public static final String CLIENT_CERT_KEY = "client_cert";
    public static final String CA_CERT_KEY = "ca_cert";
    public static final String CA_PATH_KEY = "ca_path";
    public static final String ENGINE_KEY = "engine";
    public static final String ENGINE_ID_KEY = "engine_id";
    public static final String PRIVATE_KEY_ID_KEY = "key_id";
    public static final String REALM_KEY = "realm";
    public static final String PLMN_KEY = "plmn";
    public static final String CA_CERT_ALIAS_DELIMITER = " ";
    private static final String[] SUPPLICANT_CONFIG_KEYS = new String[]{"identity", "anonymous_identity", "password", "client_cert", "ca_cert", "subject_match", "engine", "engine_id", "key_id", "altsubject_match", "domain_suffix_match", "ca_path"};
    private HashMap<String, String> mFields = new HashMap();
    private X509Certificate[] mCaCerts;
    private PrivateKey mClientPrivateKey;
    private X509Certificate mClientCertificate;
    private int mEapMethod = -1;
    private int mPhase2Method = 0;
    private static final String TAG = "WifiEnterpriseConfig";
    public static final Parcelable.Creator<WifiEnterpriseConfig> CREATOR = new Parcelable.Creator<WifiEnterpriseConfig>(){

        @Override
        public WifiEnterpriseConfig createFromParcel(Parcel in) {
            WifiEnterpriseConfig enterpriseConfig = new WifiEnterpriseConfig();
            int count = in.readInt();
            for (int i = 0; i < count; ++i) {
                String key = in.readString();
                String value = in.readString();
                enterpriseConfig.mFields.put(key, value);
            }
            enterpriseConfig.mEapMethod = in.readInt();
            enterpriseConfig.mPhase2Method = in.readInt();
            WifiEnterpriseConfig.access$302(enterpriseConfig, this.readCertificates(in));
            PrivateKey userKey = null;
            int len = in.readInt();
            if (len > 0) {
                try {
                    byte[] bytes = new byte[len];
                    in.readByteArray(bytes);
                    String algorithm = in.readString();
                    KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
                    userKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(bytes));
                }
                catch (NoSuchAlgorithmException e) {
                    userKey = null;
                }
                catch (InvalidKeySpecException e) {
                    userKey = null;
                }
            }
            enterpriseConfig.mClientPrivateKey = userKey;
            enterpriseConfig.mClientCertificate = this.readCertificate(in);
            return enterpriseConfig;
        }

        private X509Certificate[] readCertificates(Parcel in) {
            X509Certificate[] certs = null;
            int len = in.readInt();
            if (len > 0) {
                certs = new X509Certificate[len];
                for (int i = 0; i < len; ++i) {
                    certs[i] = this.readCertificate(in);
                }
            }
            return certs;
        }

        private X509Certificate readCertificate(Parcel in) {
            X509Certificate cert = null;
            int len = in.readInt();
            if (len > 0) {
                try {
                    byte[] bytes = new byte[len];
                    in.readByteArray(bytes);
                    CertificateFactory cFactory = CertificateFactory.getInstance("X.509");
                    cert = (X509Certificate)cFactory.generateCertificate(new ByteArrayInputStream(bytes));
                }
                catch (CertificateException e) {
                    cert = null;
                }
            }
            return cert;
        }

        public WifiEnterpriseConfig[] newArray(int size) {
            return new WifiEnterpriseConfig[size];
        }
    };

    public WifiEnterpriseConfig() {
    }

    public WifiEnterpriseConfig(WifiEnterpriseConfig source) {
        for (String key : source.mFields.keySet()) {
            this.mFields.put(key, source.mFields.get(key));
        }
        this.mEapMethod = source.mEapMethod;
        this.mPhase2Method = source.mPhase2Method;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mFields.size());
        for (Map.Entry<String, String> entry : this.mFields.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
        dest.writeInt(this.mEapMethod);
        dest.writeInt(this.mPhase2Method);
        this.writeCertificates(dest, this.mCaCerts);
        if (this.mClientPrivateKey != null) {
            String algorithm = this.mClientPrivateKey.getAlgorithm();
            byte[] userKeyBytes = this.mClientPrivateKey.getEncoded();
            dest.writeInt(userKeyBytes.length);
            dest.writeByteArray(userKeyBytes);
            dest.writeString(algorithm);
        } else {
            dest.writeInt(0);
        }
        this.writeCertificate(dest, this.mClientCertificate);
    }

    private void writeCertificates(Parcel dest, X509Certificate[] cert) {
        if (cert != null && cert.length != 0) {
            dest.writeInt(cert.length);
            for (int i = 0; i < cert.length; ++i) {
                this.writeCertificate(dest, cert[i]);
            }
        } else {
            dest.writeInt(0);
        }
    }

    private void writeCertificate(Parcel dest, X509Certificate cert) {
        if (cert != null) {
            try {
                byte[] certBytes = cert.getEncoded();
                dest.writeInt(certBytes.length);
                dest.writeByteArray(certBytes);
            }
            catch (CertificateEncodingException e) {
                dest.writeInt(0);
            }
        } else {
            dest.writeInt(0);
        }
    }

    public boolean saveToSupplicant(SupplicantSaver saver) {
        if (!this.isEapMethodValid()) {
            return false;
        }
        boolean shouldNotWriteAnonIdentity = this.mEapMethod == 4 || this.mEapMethod == 5 || this.mEapMethod == 6;
        for (String key : this.mFields.keySet()) {
            if (shouldNotWriteAnonIdentity && ANON_IDENTITY_KEY.equals(key) || saver.saveValue(key, this.mFields.get(key))) continue;
            return false;
        }
        if (!saver.saveValue(EAP_KEY, Eap.strings[this.mEapMethod])) {
            return false;
        }
        if (this.mEapMethod != 1 && this.mPhase2Method != 0) {
            boolean is_autheap = this.mEapMethod == 2 && this.mPhase2Method == 4;
            String prefix = is_autheap ? "autheap=" : "auth=";
            String value = this.convertToQuotedString(prefix + Phase2.strings[this.mPhase2Method]);
            return saver.saveValue(PHASE2_KEY, value);
        }
        if (this.mPhase2Method == 0) {
            return saver.saveValue(PHASE2_KEY, null);
        }
        Log.e(TAG, "WiFi enterprise configuration is invalid as it supplies a phase 2 method but the phase1 method does not support it.");
        return false;
    }

    public void loadFromSupplicant(SupplicantLoader loader) {
        for (String key : SUPPLICANT_CONFIG_KEYS) {
            String value = loader.loadValue(key);
            if (value == null) {
                this.mFields.put(key, EMPTY_VALUE);
                continue;
            }
            this.mFields.put(key, value);
        }
        String eapMethod = loader.loadValue(EAP_KEY);
        this.mEapMethod = this.getStringIndex(Eap.strings, eapMethod, -1);
        String phase2Method = this.removeDoubleQuotes(loader.loadValue(PHASE2_KEY));
        if (phase2Method.startsWith("auth=")) {
            phase2Method = phase2Method.substring("auth=".length());
        } else if (phase2Method.startsWith("autheap=")) {
            phase2Method = phase2Method.substring("autheap=".length());
        }
        this.mPhase2Method = this.getStringIndex(Phase2.strings, phase2Method, 0);
    }

    public void setEapMethod(int eapMethod) {
        switch (eapMethod) {
            case 1: 
            case 7: {
                this.setPhase2Method(0);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.mEapMethod = eapMethod;
                this.mFields.put(OPP_KEY_CACHING, ENGINE_ENABLE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EAP method");
            }
        }
    }

    public int getEapMethod() {
        return this.mEapMethod;
    }

    public void setPhase2Method(int phase2Method) {
        switch (phase2Method) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.mPhase2Method = phase2Method;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Phase 2 method");
            }
        }
    }

    public int getPhase2Method() {
        return this.mPhase2Method;
    }

    public void setIdentity(String identity) {
        this.setFieldValue(IDENTITY_KEY, identity, "");
    }

    public String getIdentity() {
        return this.getFieldValue(IDENTITY_KEY, "");
    }

    public void setAnonymousIdentity(String anonymousIdentity) {
        this.setFieldValue(ANON_IDENTITY_KEY, anonymousIdentity, "");
    }

    public String getAnonymousIdentity() {
        return this.getFieldValue(ANON_IDENTITY_KEY, "");
    }

    public void setPassword(String password) {
        this.setFieldValue(PASSWORD_KEY, password, "");
    }

    public String getPassword() {
        return this.getFieldValue(PASSWORD_KEY, "");
    }

    public static String encodeCaCertificateAlias(String alias) {
        byte[] bytes = alias.getBytes(StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte o : bytes) {
            sb.append(String.format("%02x", o & 0xFF));
        }
        return sb.toString();
    }

    public static String decodeCaCertificateAlias(String alias) {
        byte[] data = new byte[alias.length() >> 1];
        int n = 0;
        int position = 0;
        while (n < alias.length()) {
            data[position] = (byte)Integer.parseInt(alias.substring(n, n + 2), 16);
            n += 2;
            ++position;
        }
        try {
            return new String(data, StandardCharsets.UTF_8);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return alias;
        }
    }

    public void setCaCertificateAlias(String alias) {
        this.setFieldValue(CA_CERT_KEY, alias, CA_CERT_PREFIX);
    }

    public void setCaCertificateAliases(String[] aliases) {
        if (aliases == null) {
            this.setFieldValue(CA_CERT_KEY, null, CA_CERT_PREFIX);
        } else if (aliases.length == 1) {
            this.setCaCertificateAlias(aliases[0]);
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < aliases.length; ++i) {
                if (i > 0) {
                    sb.append(CA_CERT_ALIAS_DELIMITER);
                }
                sb.append(WifiEnterpriseConfig.encodeCaCertificateAlias("CACERT_" + aliases[i]));
            }
            this.setFieldValue(CA_CERT_KEY, sb.toString(), KEYSTORES_URI);
        }
    }

    public String getCaCertificateAlias() {
        return this.getFieldValue(CA_CERT_KEY, CA_CERT_PREFIX);
    }

    public String[] getCaCertificateAliases() {
        String[] stringArray;
        String value = this.getFieldValue(CA_CERT_KEY, "");
        if (value.startsWith(CA_CERT_PREFIX)) {
            return new String[]{this.getFieldValue(CA_CERT_KEY, CA_CERT_PREFIX)};
        }
        if (value.startsWith(KEYSTORES_URI)) {
            String values = value.substring(KEYSTORES_URI.length());
            String[] aliases = TextUtils.split(values, CA_CERT_ALIAS_DELIMITER);
            for (int i = 0; i < aliases.length; ++i) {
                aliases[i] = WifiEnterpriseConfig.decodeCaCertificateAlias(aliases[i]);
                if (!aliases[i].startsWith("CACERT_")) continue;
                aliases[i] = aliases[i].substring("CACERT_".length());
            }
            return aliases.length != 0 ? aliases : null;
        }
        if (TextUtils.isEmpty(value)) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCaCertificate(X509Certificate cert) {
        if (cert != null) {
            if (cert.getBasicConstraints() < 0) throw new IllegalArgumentException("Not a CA certificate");
            this.mCaCerts = new X509Certificate[]{cert};
            return;
        } else {
            this.mCaCerts = null;
        }
    }

    public X509Certificate getCaCertificate() {
        if (this.mCaCerts != null && this.mCaCerts.length > 0) {
            return this.mCaCerts[0];
        }
        return null;
    }

    public void setCaCertificates(X509Certificate[] certs) {
        if (certs != null) {
            X509Certificate[] newCerts = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                if (certs[i].getBasicConstraints() < 0) {
                    throw new IllegalArgumentException("Not a CA certificate");
                }
                newCerts[i] = certs[i];
            }
            this.mCaCerts = newCerts;
        } else {
            this.mCaCerts = null;
        }
    }

    public X509Certificate[] getCaCertificates() {
        if (this.mCaCerts != null && this.mCaCerts.length > 0) {
            return this.mCaCerts;
        }
        return null;
    }

    public void resetCaCertificate() {
        this.mCaCerts = null;
    }

    public void setCaPath(String path) {
        this.setFieldValue(CA_PATH_KEY, path);
    }

    public String getCaPath() {
        return this.getFieldValue(CA_PATH_KEY, "");
    }

    public void setClientCertificateAlias(String alias) {
        this.setFieldValue(CLIENT_CERT_KEY, alias, CLIENT_CERT_PREFIX);
        this.setFieldValue(PRIVATE_KEY_ID_KEY, alias, "USRPKEY_");
        if (TextUtils.isEmpty(alias)) {
            this.mFields.put(ENGINE_KEY, ENGINE_DISABLE);
            this.mFields.put(ENGINE_ID_KEY, EMPTY_VALUE);
        } else {
            this.mFields.put(ENGINE_KEY, ENGINE_ENABLE);
            this.mFields.put(ENGINE_ID_KEY, this.convertToQuotedString(ENGINE_ID_KEYSTORE));
        }
    }

    public String getClientCertificateAlias() {
        return this.getFieldValue(CLIENT_CERT_KEY, CLIENT_CERT_PREFIX);
    }

    public void setClientKeyEntry(PrivateKey privateKey, X509Certificate clientCertificate) {
        if (clientCertificate != null) {
            if (clientCertificate.getBasicConstraints() != -1) {
                throw new IllegalArgumentException("Cannot be a CA certificate");
            }
            if (privateKey == null) {
                throw new IllegalArgumentException("Client cert without a private key");
            }
            if (privateKey.getEncoded() == null) {
                throw new IllegalArgumentException("Private key cannot be encoded");
            }
        }
        this.mClientPrivateKey = privateKey;
        this.mClientCertificate = clientCertificate;
    }

    public X509Certificate getClientCertificate() {
        return this.mClientCertificate;
    }

    public void resetClientKeyEntry() {
        this.mClientPrivateKey = null;
        this.mClientCertificate = null;
    }

    public PrivateKey getClientPrivateKey() {
        return this.mClientPrivateKey;
    }

    public void setSubjectMatch(String subjectMatch) {
        this.setFieldValue(SUBJECT_MATCH_KEY, subjectMatch, "");
    }

    public String getSubjectMatch() {
        return this.getFieldValue(SUBJECT_MATCH_KEY, "");
    }

    public void setAltSubjectMatch(String altSubjectMatch) {
        this.setFieldValue(ALTSUBJECT_MATCH_KEY, altSubjectMatch, "");
    }

    public String getAltSubjectMatch() {
        return this.getFieldValue(ALTSUBJECT_MATCH_KEY, "");
    }

    public void setDomainSuffixMatch(String domain) {
        this.setFieldValue(DOM_SUFFIX_MATCH_KEY, domain);
    }

    public String getDomainSuffixMatch() {
        return this.getFieldValue(DOM_SUFFIX_MATCH_KEY, "");
    }

    public void setRealm(String realm) {
        this.setFieldValue(REALM_KEY, realm, "");
    }

    public String getRealm() {
        return this.getFieldValue(REALM_KEY, "");
    }

    public void setPlmn(String plmn) {
        this.setFieldValue(PLMN_KEY, plmn, "");
    }

    public String getPlmn() {
        return this.getFieldValue(PLMN_KEY, "");
    }

    public String getKeyId(WifiEnterpriseConfig current) {
        if (this.mEapMethod == -1) {
            return current != null ? current.getKeyId(null) : EMPTY_VALUE;
        }
        if (!this.isEapMethodValid()) {
            return EMPTY_VALUE;
        }
        return Eap.strings[this.mEapMethod] + "_" + Phase2.strings[this.mPhase2Method];
    }

    private String removeDoubleQuotes(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return "";
        }
        int length = string2.length();
        if (length > 1 && string2.charAt(0) == '\"' && string2.charAt(length - 1) == '\"') {
            return string2.substring(1, length - 1);
        }
        return string2;
    }

    private String convertToQuotedString(String string2) {
        return "\"" + string2 + "\"";
    }

    private int getStringIndex(String[] arr, String toBeFound, int defaultIndex) {
        if (TextUtils.isEmpty(toBeFound)) {
            return defaultIndex;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (!toBeFound.equals(arr[i])) continue;
            return i;
        }
        return defaultIndex;
    }

    public String getFieldValue(String key, String prefix) {
        String value = this.mFields.get(key);
        if (TextUtils.isEmpty(value) || EMPTY_VALUE.equals(value)) {
            return "";
        }
        if ((value = this.removeDoubleQuotes(value)).startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    public void setFieldValue(String key, String value, String prefix) {
        if (TextUtils.isEmpty(value)) {
            this.mFields.put(key, EMPTY_VALUE);
        } else {
            this.mFields.put(key, this.convertToQuotedString(prefix + value));
        }
    }

    public void setFieldValue(String key, String value) {
        if (TextUtils.isEmpty(value)) {
            this.mFields.put(key, EMPTY_VALUE);
        } else {
            this.mFields.put(key, this.convertToQuotedString(value));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String key : this.mFields.keySet()) {
            String value = PASSWORD_KEY.equals(key) ? "<removed>" : this.mFields.get(key);
            sb.append(key).append(CA_CERT_ALIAS_DELIMITER).append(value).append("\n");
        }
        return sb.toString();
    }

    private boolean isEapMethodValid() {
        if (this.mEapMethod == -1) {
            Log.e(TAG, "WiFi enterprise configuration is invalid as it supplies no EAP method.");
            return false;
        }
        if (this.mEapMethod < 0 || this.mEapMethod >= Eap.strings.length) {
            Log.e(TAG, "mEapMethod is invald for WiFi enterprise configuration: " + this.mEapMethod);
            return false;
        }
        if (this.mPhase2Method < 0 || this.mPhase2Method >= Phase2.strings.length) {
            Log.e(TAG, "mPhase2Method is invald for WiFi enterprise configuration: " + this.mPhase2Method);
            return false;
        }
        return true;
    }

    static /* synthetic */ X509Certificate[] access$302(WifiEnterpriseConfig x0, X509Certificate[] x1) {
        x0.mCaCerts = x1;
        return x1;
    }

    public static interface SupplicantLoader {
        public String loadValue(String var1);
    }

    public static interface SupplicantSaver {
        public boolean saveValue(String var1, String var2);
    }

    public static class Phase2 {
        public static final int NONE = 0;
        public static final int PAP = 1;
        public static final int MSCHAP = 2;
        public static final int MSCHAPV2 = 3;
        public static final int GTC = 4;
        private static final String AUTH_PREFIX = "auth=";
        private static final String AUTHEAP_PREFIX = "autheap=";
        public static final String[] strings = new String[]{"NULL", "PAP", "MSCHAP", "MSCHAPV2", "GTC"};

        private Phase2() {
        }
    }

    public static class Eap {
        public static final int NONE = -1;
        public static final int PEAP = 0;
        public static final int TLS = 1;
        public static final int TTLS = 2;
        public static final int PWD = 3;
        public static final int SIM = 4;
        public static final int AKA = 5;
        public static final int AKA_PRIME = 6;
        public static final int UNAUTH_TLS = 7;
        public static final String[] strings = new String[]{"PEAP", "TLS", "TTLS", "PWD", "SIM", "AKA", "AKA'", "WFA-UNAUTH-TLS"};

        private Eap() {
        }
    }
}

