/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.media.AudioAttributes;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;

public abstract class PlayerBase {
    protected AudioAttributes mAttributes;
    protected float mLeftVolume = 1.0f;
    protected float mRightVolume = 1.0f;
    protected float mAuxEffectSendLevel = 0.0f;
    private final IAppOpsService mAppOps;
    private final IAppOpsCallback mAppOpsCallback;
    private boolean mHasAppOpsPlayAudio = true;
    private final Object mAppOpsLock = new Object();

    PlayerBase(AudioAttributes attr2) {
        if (attr2 == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        this.mAttributes = attr2;
        IBinder b = ServiceManager.getService("appops");
        this.mAppOps = IAppOpsService.Stub.asInterface(b);
        this.updateAppOpsPlayAudio_sync();
        this.mAppOpsCallback = new IAppOpsCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void opChanged(int op, int uid, String packageName) {
                Object object = PlayerBase.this.mAppOpsLock;
                synchronized (object) {
                    if (op == 28) {
                        PlayerBase.this.updateAppOpsPlayAudio_sync();
                    }
                }
            }
        };
        try {
            this.mAppOps.startWatchingMode(28, ActivityThread.currentPackageName(), this.mAppOpsCallback);
        }
        catch (RemoteException e) {
            this.mHasAppOpsPlayAudio = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseUpdateAudioAttributes(AudioAttributes attr2) {
        if (attr2 == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        Object object = this.mAppOpsLock;
        synchronized (object) {
            this.mAttributes = attr2;
            this.updateAppOpsPlayAudio_sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseStart() {
        Object object = this.mAppOpsLock;
        synchronized (object) {
            if (this.isRestricted_sync()) {
                this.playerSetVolume(0.0f, 0.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseSetVolume(float leftVolume, float rightVolume) {
        Object object = this.mAppOpsLock;
        synchronized (object) {
            this.mLeftVolume = leftVolume;
            this.mRightVolume = rightVolume;
            if (this.isRestricted_sync()) {
                return;
            }
        }
        this.playerSetVolume(leftVolume, rightVolume);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int baseSetAuxEffectSendLevel(float level) {
        Object object = this.mAppOpsLock;
        synchronized (object) {
            this.mAuxEffectSendLevel = level;
            if (this.isRestricted_sync()) {
                return 0;
            }
        }
        return this.playerSetAuxEffectSendLevel(level);
    }

    void baseRelease() {
        try {
            this.mAppOps.stopWatchingMode(this.mAppOpsCallback);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void updateAppOpsPlayAudio_sync() {
        boolean oldHasAppOpsPlayAudio = this.mHasAppOpsPlayAudio;
        try {
            int mode = this.mAppOps.checkAudioOperation(28, this.mAttributes.getUsage(), Process.myUid(), ActivityThread.currentPackageName());
            this.mHasAppOpsPlayAudio = mode == 0;
        }
        catch (RemoteException e) {
            this.mHasAppOpsPlayAudio = false;
        }
        try {
            if (oldHasAppOpsPlayAudio != this.mHasAppOpsPlayAudio) {
                if (this.mHasAppOpsPlayAudio) {
                    this.playerSetVolume(this.mLeftVolume, this.mRightVolume);
                    this.playerSetAuxEffectSendLevel(this.mAuxEffectSendLevel);
                } else {
                    this.playerSetVolume(0.0f, 0.0f);
                    this.playerSetAuxEffectSendLevel(0.0f);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean isRestricted_sync() {
        if (this.mHasAppOpsPlayAudio) {
            return false;
        }
        return (this.mAttributes.getAllFlags() & 0x40) == 0;
    }

    abstract void playerSetVolume(float var1, float var2);

    abstract int playerSetAuxEffectSendLevel(float var1);
}

