/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.media.MediaDataSource;
import android.media.MediaHTTPService;
import android.net.Uri;
import android.os.IBinder;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;

public class MediaMetadataRetriever {
    private long mNativeContext;
    private static final int EMBEDDED_PICTURE_TYPE_ANY = 65535;
    public static final int OPTION_PREVIOUS_SYNC = 0;
    public static final int OPTION_NEXT_SYNC = 1;
    public static final int OPTION_CLOSEST_SYNC = 2;
    public static final int OPTION_CLOSEST = 3;
    public static final int METADATA_KEY_CD_TRACK_NUMBER = 0;
    public static final int METADATA_KEY_ALBUM = 1;
    public static final int METADATA_KEY_ARTIST = 2;
    public static final int METADATA_KEY_AUTHOR = 3;
    public static final int METADATA_KEY_COMPOSER = 4;
    public static final int METADATA_KEY_DATE = 5;
    public static final int METADATA_KEY_GENRE = 6;
    public static final int METADATA_KEY_TITLE = 7;
    public static final int METADATA_KEY_YEAR = 8;
    public static final int METADATA_KEY_DURATION = 9;
    public static final int METADATA_KEY_NUM_TRACKS = 10;
    public static final int METADATA_KEY_WRITER = 11;
    public static final int METADATA_KEY_MIMETYPE = 12;
    public static final int METADATA_KEY_ALBUMARTIST = 13;
    public static final int METADATA_KEY_DISC_NUMBER = 14;
    public static final int METADATA_KEY_COMPILATION = 15;
    public static final int METADATA_KEY_HAS_AUDIO = 16;
    public static final int METADATA_KEY_HAS_VIDEO = 17;
    public static final int METADATA_KEY_VIDEO_WIDTH = 18;
    public static final int METADATA_KEY_VIDEO_HEIGHT = 19;
    public static final int METADATA_KEY_BITRATE = 20;
    public static final int METADATA_KEY_TIMED_TEXT_LANGUAGES = 21;
    public static final int METADATA_KEY_IS_DRM = 22;
    public static final int METADATA_KEY_LOCATION = 23;
    public static final int METADATA_KEY_VIDEO_ROTATION = 24;
    public static final int METADATA_KEY_CAPTURE_FRAMERATE = 25;

    public MediaMetadataRetriever() {
        this.native_setup();
    }

    public void setDataSource(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        try (FileInputStream is = new FileInputStream(path);){
            FileDescriptor fd = is.getFD();
            this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
        }
        catch (FileNotFoundException fileEx) {
            throw new IllegalArgumentException();
        }
        catch (IOException ioEx) {
            throw new IllegalArgumentException();
        }
    }

    public void setDataSource(String uri, Map<String, String> headers) throws IllegalArgumentException {
        int i = 0;
        String[] keys = new String[headers.size()];
        String[] values = new String[headers.size()];
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            keys[i] = entry.getKey();
            values[i] = entry.getValue();
            ++i;
        }
        this._setDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(uri), uri, keys, values);
    }

    private void _setDataSource(IBinder iBinder, String string2, String[] stringArray, String[] stringArray2) throws IllegalArgumentException {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#_setDataSource(Landroid/os/IBinder;Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V", true, this);
    }

    public void setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IllegalArgumentException {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#setDataSource(Ljava/io/FileDescriptor;JJ)V", true, this);
    }

    public void setDataSource(FileDescriptor fd) throws IllegalArgumentException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(Context context, Uri uri) throws IllegalArgumentException, SecurityException {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(uri.getPath());
            return;
        }
        AssetFileDescriptor fd = null;
        try {
            ContentResolver resolver = context.getContentResolver();
            try {
                fd = resolver.openAssetFileDescriptor(uri, "r");
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException();
            }
            if (fd == null) {
                throw new IllegalArgumentException();
            }
            FileDescriptor descriptor = fd.getFileDescriptor();
            if (!descriptor.valid()) {
                throw new IllegalArgumentException();
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(descriptor);
            } else {
                this.setDataSource(descriptor, fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        catch (SecurityException securityException) {
        }
        finally {
            try {
                if (fd != null) {
                    fd.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.setDataSource(uri.toString());
    }

    public void setDataSource(MediaDataSource dataSource) throws IllegalArgumentException {
        this._setDataSource(dataSource);
    }

    private void _setDataSource(MediaDataSource mediaDataSource) throws IllegalArgumentException {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#_setDataSource(Landroid/media/MediaDataSource;)V", true, this);
    }

    public String extractMetadata(int n) {
        return (String)OverrideMethod.invokeA("android.media.MediaMetadataRetriever#extractMetadata(I)Ljava/lang/String;", true, this);
    }

    public Bitmap getFrameAtTime(long timeUs, int option) {
        if (option < 0 || option > 3) {
            throw new IllegalArgumentException("Unsupported option: " + option);
        }
        return this._getFrameAtTime(timeUs, option);
    }

    public Bitmap getFrameAtTime(long timeUs) {
        return this.getFrameAtTime(timeUs, 2);
    }

    public Bitmap getFrameAtTime() {
        return this.getFrameAtTime(-1L, 2);
    }

    private Bitmap _getFrameAtTime(long l, int n) {
        return (Bitmap)OverrideMethod.invokeA("android.media.MediaMetadataRetriever#_getFrameAtTime(JI)Landroid/graphics/Bitmap;", true, this);
    }

    public byte[] getEmbeddedPicture() {
        return this.getEmbeddedPicture(65535);
    }

    private byte[] getEmbeddedPicture(int n) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaMetadataRetriever#getEmbeddedPicture(I)[B", true, this);
    }

    public void release() {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#release()V", true, this);
    }

    private void native_setup() {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#native_setup()V", true, this);
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#native_init()V", true, null);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#native_finalize()V", true, this);
    }

    protected void finalize() throws Throwable {
        try {
            this.native_finalize();
        }
        finally {
            super.finalize();
        }
    }

    static {
        System.loadLibrary("media_jni");
        MediaMetadataRetriever.native_init();
    }
}

