/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class Icon
implements Parcelable {
    private static final String TAG = "Icon";
    public static final int TYPE_BITMAP = 1;
    public static final int TYPE_RESOURCE = 2;
    public static final int TYPE_DATA = 3;
    public static final int TYPE_URI = 4;
    private static final int VERSION_STREAM_SERIALIZER = 1;
    private final int mType;
    private ColorStateList mTintList;
    static final PorterDuff.Mode DEFAULT_TINT_MODE = Drawable.DEFAULT_TINT_MODE;
    private PorterDuff.Mode mTintMode = DEFAULT_TINT_MODE;
    private Object mObj1;
    private String mString1;
    private int mInt1;
    private int mInt2;
    public static final int MIN_ASHMEM_ICON_SIZE = 131072;
    public static final Parcelable.Creator<Icon> CREATOR = new Parcelable.Creator<Icon>(){

        @Override
        public Icon createFromParcel(Parcel in) {
            return new Icon(in);
        }

        public Icon[] newArray(int size) {
            return new Icon[size];
        }
    };

    public int getType() {
        return this.mType;
    }

    public Bitmap getBitmap() {
        if (this.mType != 1) {
            throw new IllegalStateException("called getBitmap() on " + this);
        }
        return (Bitmap)this.mObj1;
    }

    private void setBitmap(Bitmap b) {
        this.mObj1 = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDataLength() {
        if (this.mType != 3) {
            throw new IllegalStateException("called getDataLength() on " + this);
        }
        Icon icon = this;
        synchronized (icon) {
            return this.mInt1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDataOffset() {
        if (this.mType != 3) {
            throw new IllegalStateException("called getDataOffset() on " + this);
        }
        Icon icon = this;
        synchronized (icon) {
            return this.mInt2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDataBytes() {
        if (this.mType != 3) {
            throw new IllegalStateException("called getDataBytes() on " + this);
        }
        Icon icon = this;
        synchronized (icon) {
            return (byte[])this.mObj1;
        }
    }

    public Resources getResources() {
        if (this.mType != 2) {
            throw new IllegalStateException("called getResources() on " + this);
        }
        return (Resources)this.mObj1;
    }

    public String getResPackage() {
        if (this.mType != 2) {
            throw new IllegalStateException("called getResPackage() on " + this);
        }
        return this.mString1;
    }

    public int getResId() {
        if (this.mType != 2) {
            throw new IllegalStateException("called getResId() on " + this);
        }
        return this.mInt1;
    }

    public String getUriString() {
        if (this.mType != 4) {
            throw new IllegalStateException("called getUriString() on " + this);
        }
        return this.mString1;
    }

    public Uri getUri() {
        return Uri.parse(this.getUriString());
    }

    private static String typeToString(int x) {
        switch (x) {
            case 1: {
                return "BITMAP";
            }
            case 3: {
                return "DATA";
            }
            case 2: {
                return "RESOURCE";
            }
            case 4: {
                return "URI";
            }
        }
        return "UNKNOWN";
    }

    public void loadDrawableAsync(Context context, Message andThen) {
        if (andThen.getTarget() == null) {
            throw new IllegalArgumentException("callback message must have a target handler");
        }
        new LoadDrawableTask(context, andThen).runAsync();
    }

    public void loadDrawableAsync(Context context, OnDrawableLoadedListener listener, Handler handler) {
        new LoadDrawableTask(context, handler, listener).runAsync();
    }

    public Drawable loadDrawable(Context context) {
        Drawable result = this.loadDrawableInner(context);
        if (result != null && (this.mTintList != null || this.mTintMode != DEFAULT_TINT_MODE)) {
            result.mutate();
            result.setTintList(this.mTintList);
            result.setTintMode(this.mTintMode);
        }
        return result;
    }

    private Drawable loadDrawableInner(Context context) {
        switch (this.mType) {
            case 1: {
                return new BitmapDrawable(context.getResources(), this.getBitmap());
            }
            case 2: {
                if (this.getResources() == null) {
                    String resPackage = this.getResPackage();
                    if (TextUtils.isEmpty(resPackage)) {
                        resPackage = context.getPackageName();
                    }
                    if ("android".equals(resPackage)) {
                        this.mObj1 = Resources.getSystem();
                    } else {
                        PackageManager pm = context.getPackageManager();
                        try {
                            ApplicationInfo ai = pm.getApplicationInfo(resPackage, 8192);
                            if (ai == null) break;
                            this.mObj1 = pm.getResourcesForApplication(ai);
                        }
                        catch (PackageManager.NameNotFoundException e) {
                            Log.e(TAG, String.format("Unable to find pkg=%s for icon %s", resPackage, this), e);
                            break;
                        }
                    }
                }
                try {
                    return this.getResources().getDrawable(this.getResId(), context.getTheme());
                }
                catch (RuntimeException e) {
                    Log.e(TAG, String.format("Unable to load resource 0x%08x from pkg=%s", this.getResId(), this.getResPackage()), e);
                    break;
                }
            }
            case 3: {
                return new BitmapDrawable(context.getResources(), BitmapFactory.decodeByteArray(this.getDataBytes(), this.getDataOffset(), this.getDataLength()));
            }
            case 4: {
                Uri uri = this.getUri();
                String scheme = uri.getScheme();
                InputStream is = null;
                if ("content".equals(scheme) || "file".equals(scheme)) {
                    try {
                        is = context.getContentResolver().openInputStream(uri);
                    }
                    catch (Exception e) {
                        Log.w(TAG, "Unable to load image from URI: " + uri, e);
                    }
                } else {
                    try {
                        is = new FileInputStream(new File(this.mString1));
                    }
                    catch (FileNotFoundException e) {
                        Log.w(TAG, "Unable to load image from path: " + uri, e);
                    }
                }
                if (is == null) break;
                return new BitmapDrawable(context.getResources(), BitmapFactory.decodeStream(is));
            }
        }
        return null;
    }

    public Drawable loadDrawableAsUser(Context context, int userId) {
        if (this.mType == 2) {
            String resPackage = this.getResPackage();
            if (TextUtils.isEmpty(resPackage)) {
                resPackage = context.getPackageName();
            }
            if (this.getResources() == null && !this.getResPackage().equals("android")) {
                PackageManager pm = context.getPackageManager();
                try {
                    this.mObj1 = pm.getResourcesForApplicationAsUser(resPackage, userId);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e(TAG, String.format("Unable to find pkg=%s user=%d", this.getResPackage(), userId), e);
                }
            }
        }
        return this.loadDrawable(context);
    }

    public void convertToAshmem() {
        if (this.mType == 1 && this.getBitmap().isMutable() && this.getBitmap().getAllocationByteCount() >= 131072) {
            this.setBitmap(this.getBitmap().createAshmemBitmap());
        }
    }

    public void writeToStream(OutputStream stream) throws IOException {
        DataOutputStream dataStream = new DataOutputStream(stream);
        dataStream.writeInt(1);
        dataStream.writeByte(this.mType);
        switch (this.mType) {
            case 1: {
                this.getBitmap().compress(Bitmap.CompressFormat.PNG, 100, dataStream);
                break;
            }
            case 3: {
                dataStream.writeInt(this.getDataLength());
                dataStream.write(this.getDataBytes(), this.getDataOffset(), this.getDataLength());
                break;
            }
            case 2: {
                dataStream.writeUTF(this.getResPackage());
                dataStream.writeInt(this.getResId());
                break;
            }
            case 4: {
                dataStream.writeUTF(this.getUriString());
            }
        }
    }

    private Icon(int mType) {
        this.mType = mType;
    }

    public static Icon createFromStream(InputStream stream) throws IOException {
        DataInputStream inputStream = new DataInputStream(stream);
        int version = inputStream.readInt();
        if (version >= 1) {
            byte type = inputStream.readByte();
            switch (type) {
                case 1: {
                    return Icon.createWithBitmap(BitmapFactory.decodeStream(inputStream));
                }
                case 3: {
                    int length = inputStream.readInt();
                    byte[] data = new byte[length];
                    inputStream.read(data, 0, length);
                    return Icon.createWithData(data, 0, length);
                }
                case 2: {
                    String packageName = inputStream.readUTF();
                    int resId = inputStream.readInt();
                    return Icon.createWithResource(packageName, resId);
                }
                case 4: {
                    String uriOrPath = inputStream.readUTF();
                    return Icon.createWithContentUri(uriOrPath);
                }
            }
        }
        return null;
    }

    public boolean sameAs(Icon otherIcon) {
        if (otherIcon == this) {
            return true;
        }
        if (this.mType != otherIcon.getType()) {
            return false;
        }
        switch (this.mType) {
            case 1: {
                return this.getBitmap() == otherIcon.getBitmap();
            }
            case 3: {
                return this.getDataLength() == otherIcon.getDataLength() && this.getDataOffset() == otherIcon.getDataOffset() && this.getDataBytes() == otherIcon.getDataBytes();
            }
            case 2: {
                return this.getResId() == otherIcon.getResId() && Objects.equals(this.getResPackage(), otherIcon.getResPackage());
            }
            case 4: {
                return Objects.equals(this.getUriString(), otherIcon.getUriString());
            }
        }
        return false;
    }

    public static Icon createWithResource(Context context, int resId) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        Icon rep = new Icon(2);
        rep.mInt1 = resId;
        rep.mString1 = context.getPackageName();
        return rep;
    }

    public static Icon createWithResource(Resources res, int resId) {
        if (res == null) {
            throw new IllegalArgumentException("Resource must not be null.");
        }
        Icon rep = new Icon(2);
        rep.mInt1 = resId;
        rep.mString1 = res.getResourcePackageName(resId);
        return rep;
    }

    public static Icon createWithResource(String resPackage, int resId) {
        if (resPackage == null) {
            throw new IllegalArgumentException("Resource package name must not be null.");
        }
        Icon rep = new Icon(2);
        rep.mInt1 = resId;
        rep.mString1 = resPackage;
        return rep;
    }

    public static Icon createWithBitmap(Bitmap bits) {
        if (bits == null) {
            throw new IllegalArgumentException("Bitmap must not be null.");
        }
        Icon rep = new Icon(1);
        rep.setBitmap(bits);
        return rep;
    }

    public static Icon createWithData(byte[] data, int offset, int length) {
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null.");
        }
        Icon rep = new Icon(3);
        rep.mObj1 = data;
        rep.mInt1 = length;
        rep.mInt2 = offset;
        return rep;
    }

    public static Icon createWithContentUri(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Uri must not be null.");
        }
        Icon rep = new Icon(4);
        rep.mString1 = uri;
        return rep;
    }

    public static Icon createWithContentUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Uri must not be null.");
        }
        Icon rep = new Icon(4);
        rep.mString1 = uri.toString();
        return rep;
    }

    public Icon setTint(int tint) {
        return this.setTintList(ColorStateList.valueOf(tint));
    }

    public Icon setTintList(ColorStateList tintList) {
        this.mTintList = tintList;
        return this;
    }

    public Icon setTintMode(PorterDuff.Mode mode) {
        this.mTintMode = mode;
        return this;
    }

    public boolean hasTint() {
        return this.mTintList != null || this.mTintMode != DEFAULT_TINT_MODE;
    }

    public static Icon createWithFilePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        Icon rep = new Icon(4);
        rep.mString1 = path;
        return rep;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Icon(typ=").append(Icon.typeToString(this.mType));
        switch (this.mType) {
            case 1: {
                sb.append(" size=").append(this.getBitmap().getWidth()).append("x").append(this.getBitmap().getHeight());
                break;
            }
            case 2: {
                sb.append(" pkg=").append(this.getResPackage()).append(" id=").append(String.format("0x%08x", this.getResId()));
                break;
            }
            case 3: {
                sb.append(" len=").append(this.getDataLength());
                if (this.getDataOffset() == 0) break;
                sb.append(" off=").append(this.getDataOffset());
                break;
            }
            case 4: {
                sb.append(" uri=").append(this.getUriString());
            }
        }
        if (this.mTintList != null) {
            sb.append(" tint=");
            String sep = "";
            for (int c : this.mTintList.getColors()) {
                sb.append(String.format("%s0x%08x", sep, c));
                sep = "|";
            }
        }
        if (this.mTintMode != DEFAULT_TINT_MODE) {
            sb.append(" mode=").append((Object)this.mTintMode);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return this.mType == 1 || this.mType == 3 ? 1 : 0;
    }

    private Icon(Parcel in) {
        this(in.readInt());
        switch (this.mType) {
            case 1: {
                Bitmap bits = Bitmap.CREATOR.createFromParcel(in);
                this.mObj1 = bits;
                break;
            }
            case 2: {
                String pkg = in.readString();
                int resId = in.readInt();
                this.mString1 = pkg;
                this.mInt1 = resId;
                break;
            }
            case 3: {
                int len = in.readInt();
                byte[] a = in.readBlob();
                if (len != a.length) {
                    throw new RuntimeException("internal unparceling error: blob length (" + a.length + ") != expected length (" + len + ")");
                }
                this.mInt1 = len;
                this.mObj1 = a;
                break;
            }
            case 4: {
                String uri;
                this.mString1 = uri = in.readString();
                break;
            }
            default: {
                throw new RuntimeException("invalid " + this.getClass().getSimpleName() + " type in parcel: " + this.mType);
            }
        }
        if (in.readInt() == 1) {
            this.mTintList = ColorStateList.CREATOR.createFromParcel(in);
        }
        this.mTintMode = PorterDuff.intToMode(in.readInt());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        switch (this.mType) {
            case 1: {
                Bitmap bits = this.getBitmap();
                this.getBitmap().writeToParcel(dest, flags);
                break;
            }
            case 2: {
                dest.writeString(this.getResPackage());
                dest.writeInt(this.getResId());
                break;
            }
            case 3: {
                dest.writeInt(this.getDataLength());
                dest.writeBlob(this.getDataBytes(), this.getDataOffset(), this.getDataLength());
                break;
            }
            case 4: {
                dest.writeString(this.getUriString());
            }
        }
        if (this.mTintList == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            this.mTintList.writeToParcel(dest, flags);
        }
        dest.writeInt(PorterDuff.modeToInt(this.mTintMode));
    }

    private class LoadDrawableTask
    implements Runnable {
        final Context mContext;
        final Message mMessage;

        public LoadDrawableTask(Context context, Handler handler, final OnDrawableLoadedListener listener) {
            this.mContext = context;
            this.mMessage = Message.obtain(handler, new Runnable(){

                @Override
                public void run() {
                    listener.onDrawableLoaded((Drawable)LoadDrawableTask.this.mMessage.obj);
                }
            });
        }

        public LoadDrawableTask(Context context, Message message) {
            this.mContext = context;
            this.mMessage = message;
        }

        @Override
        public void run() {
            this.mMessage.obj = Icon.this.loadDrawable(this.mContext);
            this.mMessage.sendToTarget();
        }

        public void runAsync() {
            AsyncTask.THREAD_POOL_EXECUTOR.execute(this);
        }
    }

    public static interface OnDrawableLoadedListener {
        public void onDrawableLoaded(Drawable var1);
    }
}

