/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Trace;
import android.util.DisplayMetrics;
import android.util.Log;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import libcore.util.NativeAllocationRegistry;

public class Bitmap
implements Parcelable {
    private static final String TAG = "Bitmap";
    public static final int DENSITY_NONE = 0;
    private static final long NATIVE_ALLOCATION_SIZE = 32L;
    private byte[] mBuffer;
    private final long mNativePtr;
    private final boolean mIsMutable;
    private boolean mRequestPremultiplied;
    private byte[] mNinePatchChunk;
    private NinePatch.InsetStruct mNinePatchInsets;
    private int mWidth;
    private int mHeight;
    private boolean mRecycled;
    int mDensity = Bitmap.getDefaultDensity();
    private static volatile Matrix sScaleMatrix;
    private static volatile int sDefaultDensity;
    private static final int WORKING_COMPRESS_STORAGE = 4096;
    public static final Parcelable.Creator<Bitmap> CREATOR;

    public static void setDefaultDensity(int density) {
        sDefaultDensity = density;
    }

    static int getDefaultDensity() {
        if (sDefaultDensity >= 0) {
            return sDefaultDensity;
        }
        sDefaultDensity = DisplayMetrics.DENSITY_DEVICE;
        return sDefaultDensity;
    }

    Bitmap(long nativeBitmap, byte[] buffer, int width, int height, int density, boolean isMutable, boolean requestPremultiplied, byte[] ninePatchChunk, NinePatch.InsetStruct ninePatchInsets) {
        if (nativeBitmap == 0L) {
            throw new RuntimeException("internal error: native bitmap is 0");
        }
        this.mWidth = width;
        this.mHeight = height;
        this.mIsMutable = isMutable;
        this.mRequestPremultiplied = requestPremultiplied;
        this.mBuffer = buffer;
        this.mNinePatchChunk = ninePatchChunk;
        this.mNinePatchInsets = ninePatchInsets;
        if (density >= 0) {
            this.mDensity = density;
        }
        this.mNativePtr = nativeBitmap;
        long nativeSize = 32L;
        if (buffer == null) {
            nativeSize += (long)this.getByteCount();
        }
        NativeAllocationRegistry registry = new NativeAllocationRegistry(Bitmap.class.getClassLoader(), Bitmap.nativeGetNativeFinalizer(), nativeSize);
        registry.registerNativeAllocation((Object)this, nativeBitmap);
    }

    long getNativeInstance() {
        return this.mNativePtr;
    }

    void reinit(int width, int height, boolean requestPremultiplied) {
        this.mWidth = width;
        this.mHeight = height;
        this.mRequestPremultiplied = requestPremultiplied;
    }

    public int getDensity() {
        if (this.mRecycled) {
            Log.w(TAG, "Called getDensity() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return this.mDensity;
    }

    public void setDensity(int density) {
        this.mDensity = density;
    }

    public void reconfigure(int width, int height, Config config) {
        this.checkRecycled("Can't call reconfigure() on a recycled bitmap");
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        if (!this.isMutable()) {
            throw new IllegalStateException("only mutable bitmaps may be reconfigured");
        }
        if (this.mBuffer == null) {
            throw new IllegalStateException("native-backed bitmaps may not be reconfigured");
        }
        Bitmap.nativeReconfigure(this.mNativePtr, width, height, config.nativeInt, this.mBuffer.length, this.mRequestPremultiplied);
        this.mWidth = width;
        this.mHeight = height;
    }

    public void setWidth(int width) {
        this.reconfigure(width, this.getHeight(), this.getConfig());
    }

    public void setHeight(int height) {
        this.reconfigure(this.getWidth(), height, this.getConfig());
    }

    public void setConfig(Config config) {
        this.reconfigure(this.getWidth(), this.getHeight(), config);
    }

    public void setNinePatchChunk(byte[] chunk) {
        this.mNinePatchChunk = chunk;
    }

    public void recycle() {
        if (!this.mRecycled && this.mNativePtr != 0L) {
            if (Bitmap.nativeRecycle(this.mNativePtr)) {
                this.mBuffer = null;
                this.mNinePatchChunk = null;
            }
            this.mRecycled = true;
        }
    }

    public boolean isRecycled() {
        return this.mRecycled;
    }

    public int getGenerationId() {
        if (this.mRecycled) {
            Log.w(TAG, "Called getGenerationId() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeGenerationId(this.mNativePtr);
    }

    private void checkRecycled(String errorMessage) {
        if (this.mRecycled) {
            throw new IllegalStateException(errorMessage);
        }
    }

    private static void checkXYSign(int x, int y) {
        if (x < 0) {
            throw new IllegalArgumentException("x must be >= 0");
        }
        if (y < 0) {
            throw new IllegalArgumentException("y must be >= 0");
        }
    }

    private static void checkWidthHeight(int width, int height) {
        if (width <= 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("height must be > 0");
        }
    }

    public void copyPixelsToBuffer(Buffer dst) {
        int shift;
        int elements = dst.remaining();
        if (dst instanceof ByteBuffer) {
            shift = 0;
        } else if (dst instanceof ShortBuffer) {
            shift = 1;
        } else if (dst instanceof IntBuffer) {
            shift = 2;
        } else {
            throw new RuntimeException("unsupported Buffer subclass");
        }
        long bufferSize = (long)elements << shift;
        long pixelSize = this.getByteCount();
        if (bufferSize < pixelSize) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        Bitmap.nativeCopyPixelsToBuffer(this.mNativePtr, dst);
        int position = dst.position();
        position = (int)((long)position + (pixelSize >> shift));
        dst.position(position);
    }

    public void copyPixelsFromBuffer(Buffer src) {
        int shift;
        this.checkRecycled("copyPixelsFromBuffer called on recycled bitmap");
        int elements = src.remaining();
        if (src instanceof ByteBuffer) {
            shift = 0;
        } else if (src instanceof ShortBuffer) {
            shift = 1;
        } else if (src instanceof IntBuffer) {
            shift = 2;
        } else {
            throw new RuntimeException("unsupported Buffer subclass");
        }
        long bufferBytes = (long)elements << shift;
        long bitmapBytes = this.getByteCount();
        if (bufferBytes < bitmapBytes) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        Bitmap.nativeCopyPixelsFromBuffer(this.mNativePtr, src);
        int position = src.position();
        position = (int)((long)position + (bitmapBytes >> shift));
        src.position(position);
    }

    public Bitmap copy(Config config, boolean isMutable) {
        this.checkRecycled("Can't copy a recycled bitmap");
        Bitmap b = Bitmap.nativeCopy(this.mNativePtr, config.nativeInt, isMutable);
        if (b != null) {
            b.setPremultiplied(this.mRequestPremultiplied);
            b.mDensity = this.mDensity;
        }
        return b;
    }

    public Bitmap createAshmemBitmap() {
        this.checkRecycled("Can't copy a recycled bitmap");
        Bitmap b = Bitmap.nativeCopyAshmem(this.mNativePtr);
        if (b != null) {
            b.setPremultiplied(this.mRequestPremultiplied);
            b.mDensity = this.mDensity;
        }
        return b;
    }

    public Bitmap createAshmemBitmap(Config config) {
        this.checkRecycled("Can't copy a recycled bitmap");
        Bitmap b = Bitmap.nativeCopyAshmemConfig(this.mNativePtr, config.nativeInt);
        if (b != null) {
            b.setPremultiplied(this.mRequestPremultiplied);
            b.mDensity = this.mDensity;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap createScaledBitmap(Bitmap src, int dstWidth, int dstHeight, boolean filter) {
        Class<Bitmap> clazz = Bitmap.class;
        synchronized (Bitmap.class) {
            Matrix m = sScaleMatrix;
            sScaleMatrix = null;
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (m == null) {
                m = new Matrix();
            }
            int width = src.getWidth();
            int height = src.getHeight();
            float sx = (float)dstWidth / (float)width;
            float sy = (float)dstHeight / (float)height;
            m.setScale(sx, sy);
            Bitmap b = Bitmap.createBitmap(src, 0, 0, width, height, m, filter);
            Class<Bitmap> clazz2 = Bitmap.class;
            synchronized (Bitmap.class) {
                if (sScaleMatrix == null) {
                    sScaleMatrix = m;
                }
                // ** MonitorExit[var10_12] (shouldn't be in output)
                return b;
            }
        }
    }

    public static Bitmap createBitmap(Bitmap src) {
        return Bitmap.createBitmap(src, 0, 0, src.getWidth(), src.getHeight());
    }

    public static Bitmap createBitmap(Bitmap source, int x, int y, int width, int height) {
        return Bitmap.createBitmap(source, x, y, width, height, null, false);
    }

    public static Bitmap createBitmap(Bitmap source, int x, int y, int width, int height, Matrix m, boolean filter) {
        Paint paint;
        Bitmap bitmap;
        Bitmap.checkXYSign(x, y);
        Bitmap.checkWidthHeight(width, height);
        if (x + width > source.getWidth()) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        if (y + height > source.getHeight()) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        if (!source.isMutable() && x == 0 && y == 0 && width == source.getWidth() && height == source.getHeight() && (m == null || m.isIdentity())) {
            return source;
        }
        int neww = width;
        int newh = height;
        Canvas canvas = new Canvas();
        Rect srcR = new Rect(x, y, x + width, y + height);
        RectF dstR = new RectF(0.0f, 0.0f, width, height);
        Config newConfig = Config.ARGB_8888;
        Config config = source.getConfig();
        if (config != null) {
            switch (config) {
                case RGB_565: {
                    newConfig = Config.RGB_565;
                    break;
                }
                case ALPHA_8: {
                    newConfig = Config.ALPHA_8;
                    break;
                }
                default: {
                    newConfig = Config.ARGB_8888;
                }
            }
        }
        if (m == null || m.isIdentity()) {
            bitmap = Bitmap.createBitmap(neww, newh, newConfig, source.hasAlpha());
            paint = null;
        } else {
            boolean transformed = !m.rectStaysRect();
            RectF deviceR = new RectF();
            m.mapRect(deviceR, dstR);
            neww = Math.round(deviceR.width());
            newh = Math.round(deviceR.height());
            bitmap = Bitmap.createBitmap(neww, newh, transformed ? Config.ARGB_8888 : newConfig, transformed || source.hasAlpha());
            canvas.translate(-deviceR.left, -deviceR.top);
            canvas.concat(m);
            paint = new Paint();
            paint.setFilterBitmap(filter);
            if (transformed) {
                paint.setAntiAlias(true);
            }
        }
        bitmap.mDensity = source.mDensity;
        bitmap.setHasAlpha(source.hasAlpha());
        bitmap.setPremultiplied(source.mRequestPremultiplied);
        canvas.setBitmap(bitmap);
        canvas.drawBitmap(source, srcR, dstR, paint);
        canvas.setBitmap(null);
        return bitmap;
    }

    public static Bitmap createBitmap(int width, int height, Config config) {
        return Bitmap.createBitmap(width, height, config, true);
    }

    public static Bitmap createBitmap(DisplayMetrics display, int width, int height, Config config) {
        return Bitmap.createBitmap(display, width, height, config, true);
    }

    private static Bitmap createBitmap(int width, int height, Config config, boolean hasAlpha) {
        return Bitmap.createBitmap(null, width, height, config, hasAlpha);
    }

    private static Bitmap createBitmap(DisplayMetrics display, int width, int height, Config config, boolean hasAlpha) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        Bitmap bm = Bitmap.nativeCreate(null, 0, width, width, height, config.nativeInt, true);
        if (display != null) {
            bm.mDensity = display.densityDpi;
        }
        bm.setHasAlpha(hasAlpha);
        if (config == Config.ARGB_8888 && !hasAlpha) {
            Bitmap.nativeErase(bm.mNativePtr, -16777216);
        }
        return bm;
    }

    public static Bitmap createBitmap(int[] colors, int offset, int stride, int width, int height, Config config) {
        return Bitmap.createBitmap(null, colors, offset, stride, width, height, config);
    }

    public static Bitmap createBitmap(DisplayMetrics display, int[] colors, int offset, int stride, int width, int height, Config config) {
        Bitmap.checkWidthHeight(width, height);
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        Bitmap bm = Bitmap.nativeCreate(colors, offset, stride, width, height, config.nativeInt, false);
        if (display != null) {
            bm.mDensity = display.densityDpi;
        }
        return bm;
    }

    public static Bitmap createBitmap(int[] colors, int width, int height, Config config) {
        return Bitmap.createBitmap(null, colors, 0, width, width, height, config);
    }

    public static Bitmap createBitmap(DisplayMetrics display, int[] colors, int width, int height, Config config) {
        return Bitmap.createBitmap(display, colors, 0, width, width, height, config);
    }

    public byte[] getNinePatchChunk() {
        return this.mNinePatchChunk;
    }

    public void getOpticalInsets(Rect outInsets) {
        if (this.mNinePatchInsets == null) {
            outInsets.setEmpty();
        } else {
            outInsets.set(this.mNinePatchInsets.opticalRect);
        }
    }

    public NinePatch.InsetStruct getNinePatchInsets() {
        return this.mNinePatchInsets;
    }

    public boolean compress(CompressFormat format, int quality, OutputStream stream) {
        this.checkRecycled("Can't compress a recycled bitmap");
        if (stream == null) {
            throw new NullPointerException();
        }
        if (quality < 0 || quality > 100) {
            throw new IllegalArgumentException("quality must be 0..100");
        }
        Trace.traceBegin(8192L, "Bitmap.compress");
        boolean result = Bitmap.nativeCompress(this.mNativePtr, format.nativeInt, quality, stream, new byte[4096]);
        Trace.traceEnd(8192L);
        return result;
    }

    public boolean isMutable() {
        return this.mIsMutable;
    }

    public boolean isPremultiplied() {
        if (this.mRecycled) {
            Log.w(TAG, "Called isPremultiplied() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeIsPremultiplied(this.mNativePtr);
    }

    public void setPremultiplied(boolean premultiplied) {
        this.checkRecycled("setPremultiplied called on a recycled bitmap");
        this.mRequestPremultiplied = premultiplied;
        Bitmap.nativeSetPremultiplied(this.mNativePtr, premultiplied);
    }

    public int getWidth() {
        if (this.mRecycled) {
            Log.w(TAG, "Called getWidth() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return this.mWidth;
    }

    public int getHeight() {
        if (this.mRecycled) {
            Log.w(TAG, "Called getHeight() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return this.mHeight;
    }

    public int getScaledWidth(Canvas canvas) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, canvas.mDensity);
    }

    public int getScaledHeight(Canvas canvas) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, canvas.mDensity);
    }

    public int getScaledWidth(DisplayMetrics metrics) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, metrics.densityDpi);
    }

    public int getScaledHeight(DisplayMetrics metrics) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, metrics.densityDpi);
    }

    public int getScaledWidth(int targetDensity) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, targetDensity);
    }

    public int getScaledHeight(int targetDensity) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, targetDensity);
    }

    public static int scaleFromDensity(int size, int sdensity, int tdensity) {
        if (sdensity == 0 || tdensity == 0 || sdensity == tdensity) {
            return size;
        }
        return (size * tdensity + (sdensity >> 1)) / sdensity;
    }

    public int getRowBytes() {
        if (this.mRecycled) {
            Log.w(TAG, "Called getRowBytes() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeRowBytes(this.mNativePtr);
    }

    public int getByteCount() {
        return this.getRowBytes() * this.getHeight();
    }

    public int getAllocationByteCount() {
        if (this.mBuffer == null) {
            return this.getByteCount();
        }
        return this.mBuffer.length;
    }

    public Config getConfig() {
        if (this.mRecycled) {
            Log.w(TAG, "Called getConfig() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Config.nativeToConfig(Bitmap.nativeConfig(this.mNativePtr));
    }

    public boolean hasAlpha() {
        if (this.mRecycled) {
            Log.w(TAG, "Called hasAlpha() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeHasAlpha(this.mNativePtr);
    }

    public void setHasAlpha(boolean hasAlpha) {
        this.checkRecycled("setHasAlpha called on a recycled bitmap");
        Bitmap.nativeSetHasAlpha(this.mNativePtr, hasAlpha, this.mRequestPremultiplied);
    }

    public boolean hasMipMap() {
        if (this.mRecycled) {
            Log.w(TAG, "Called hasMipMap() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeHasMipMap(this.mNativePtr);
    }

    public void setHasMipMap(boolean hasMipMap) {
        this.checkRecycled("setHasMipMap called on a recycled bitmap");
        Bitmap.nativeSetHasMipMap(this.mNativePtr, hasMipMap);
    }

    public void eraseColor(int c) {
        this.checkRecycled("Can't erase a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException("cannot erase immutable bitmaps");
        }
        Bitmap.nativeErase(this.mNativePtr, c);
    }

    public int getPixel(int x, int y) {
        this.checkRecycled("Can't call getPixel() on a recycled bitmap");
        this.checkPixelAccess(x, y);
        return Bitmap.nativeGetPixel(this.mNativePtr, x, y);
    }

    public void getPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        this.checkRecycled("Can't call getPixels() on a recycled bitmap");
        if (width == 0 || height == 0) {
            return;
        }
        this.checkPixelsAccess(x, y, width, height, offset, stride, pixels);
        Bitmap.nativeGetPixels(this.mNativePtr, pixels, offset, stride, x, y, width, height);
    }

    private void checkPixelAccess(int x, int y) {
        Bitmap.checkXYSign(x, y);
        if (x >= this.getWidth()) {
            throw new IllegalArgumentException("x must be < bitmap.width()");
        }
        if (y >= this.getHeight()) {
            throw new IllegalArgumentException("y must be < bitmap.height()");
        }
    }

    private void checkPixelsAccess(int x, int y, int width, int height, int offset, int stride, int[] pixels) {
        Bitmap.checkXYSign(x, y);
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (x + width > this.getWidth()) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        if (y + height > this.getHeight()) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = pixels.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void setPixel(int x, int y, int color2) {
        this.checkRecycled("Can't call setPixel() on a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException();
        }
        this.checkPixelAccess(x, y);
        Bitmap.nativeSetPixel(this.mNativePtr, x, y, color2);
    }

    public void setPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        this.checkRecycled("Can't call setPixels() on a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException();
        }
        if (width == 0 || height == 0) {
            return;
        }
        this.checkPixelsAccess(x, y, width, height, offset, stride, pixels);
        Bitmap.nativeSetPixels(this.mNativePtr, pixels, offset, stride, x, y, width, height);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel p, int flags) {
        this.checkRecycled("Can't parcel a recycled bitmap");
        if (!Bitmap.nativeWriteToParcel(this.mNativePtr, this.mIsMutable, this.mDensity, p)) {
            throw new RuntimeException("native writeToParcel failed");
        }
    }

    public Bitmap extractAlpha() {
        return this.extractAlpha(null, null);
    }

    public Bitmap extractAlpha(Paint paint, int[] offsetXY) {
        this.checkRecycled("Can't extractAlpha on a recycled bitmap");
        long nativePaint = paint != null ? paint.getNativeInstance() : 0L;
        Bitmap bm = Bitmap.nativeExtractAlpha(this.mNativePtr, nativePaint, offsetXY);
        if (bm == null) {
            throw new RuntimeException("Failed to extractAlpha on Bitmap");
        }
        bm.mDensity = this.mDensity;
        return bm;
    }

    public boolean sameAs(Bitmap other) {
        this.checkRecycled("Can't call sameAs on a recycled bitmap!");
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.isRecycled()) {
            throw new IllegalArgumentException("Can't compare to a recycled bitmap!");
        }
        return Bitmap.nativeSameAs(this.mNativePtr, other.mNativePtr);
    }

    public void prepareToDraw() {
        this.checkRecycled("Can't prepareToDraw on a recycled bitmap!");
        Bitmap.nativePrepareToDraw(this.mNativePtr);
    }

    public long refSkPixelRef() {
        this.checkRecycled("Can't refSkPixelRef on a recycled bitmap!");
        return Bitmap.nativeRefPixelRef(this.mNativePtr);
    }

    @LayoutlibDelegate
    private static Bitmap nativeCreate(int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        return Bitmap_Delegate.nativeCreate(nArray, n, n2, n3, n4, n5, bl);
    }

    @LayoutlibDelegate
    private static Bitmap nativeCopy(long l, int n, boolean bl) {
        return Bitmap_Delegate.nativeCopy(l, n, bl);
    }

    @LayoutlibDelegate
    private static Bitmap nativeCopyAshmem(long l) {
        return Bitmap_Delegate.nativeCopyAshmem(l);
    }

    @LayoutlibDelegate
    private static Bitmap nativeCopyAshmemConfig(long l, int n) {
        return Bitmap_Delegate.nativeCopyAshmemConfig(l, n);
    }

    @LayoutlibDelegate
    private static long nativeGetNativeFinalizer() {
        return Bitmap_Delegate.nativeGetNativeFinalizer();
    }

    @LayoutlibDelegate
    private static boolean nativeRecycle(long l) {
        return Bitmap_Delegate.nativeRecycle(l);
    }

    @LayoutlibDelegate
    private static void nativeReconfigure(long l, int n, int n2, int n3, int n4, boolean bl) {
        Bitmap_Delegate.nativeReconfigure(l, n, n2, n3, n4, bl);
    }

    @LayoutlibDelegate
    private static boolean nativeCompress(long l, int n, int n2, OutputStream outputStream, byte[] byArray) {
        return Bitmap_Delegate.nativeCompress(l, n, n2, outputStream, byArray);
    }

    @LayoutlibDelegate
    private static void nativeErase(long l, int n) {
        Bitmap_Delegate.nativeErase(l, n);
    }

    @LayoutlibDelegate
    private static int nativeRowBytes(long l) {
        return Bitmap_Delegate.nativeRowBytes(l);
    }

    @LayoutlibDelegate
    private static int nativeConfig(long l) {
        return Bitmap_Delegate.nativeConfig(l);
    }

    @LayoutlibDelegate
    private static int nativeGetPixel(long l, int n, int n2) {
        return Bitmap_Delegate.nativeGetPixel(l, n, n2);
    }

    @LayoutlibDelegate
    private static void nativeGetPixels(long l, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        Bitmap_Delegate.nativeGetPixels(l, nArray, n, n2, n3, n4, n5, n6);
    }

    @LayoutlibDelegate
    private static void nativeSetPixel(long l, int n, int n2, int n3) {
        Bitmap_Delegate.nativeSetPixel(l, n, n2, n3);
    }

    @LayoutlibDelegate
    private static void nativeSetPixels(long l, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        Bitmap_Delegate.nativeSetPixels(l, nArray, n, n2, n3, n4, n5, n6);
    }

    @LayoutlibDelegate
    private static void nativeCopyPixelsToBuffer(long l, Buffer buffer) {
        Bitmap_Delegate.nativeCopyPixelsToBuffer(l, buffer);
    }

    @LayoutlibDelegate
    private static void nativeCopyPixelsFromBuffer(long l, Buffer buffer) {
        Bitmap_Delegate.nativeCopyPixelsFromBuffer(l, buffer);
    }

    @LayoutlibDelegate
    private static int nativeGenerationId(long l) {
        return Bitmap_Delegate.nativeGenerationId(l);
    }

    @LayoutlibDelegate
    private static Bitmap nativeCreateFromParcel(Parcel parcel) {
        return Bitmap_Delegate.nativeCreateFromParcel(parcel);
    }

    @LayoutlibDelegate
    private static boolean nativeWriteToParcel(long l, boolean bl, int n, Parcel parcel) {
        return Bitmap_Delegate.nativeWriteToParcel(l, bl, n, parcel);
    }

    @LayoutlibDelegate
    private static Bitmap nativeExtractAlpha(long l, long l2, int[] nArray) {
        return Bitmap_Delegate.nativeExtractAlpha(l, l2, nArray);
    }

    @LayoutlibDelegate
    private static boolean nativeHasAlpha(long l) {
        return Bitmap_Delegate.nativeHasAlpha(l);
    }

    @LayoutlibDelegate
    private static boolean nativeIsPremultiplied(long l) {
        return Bitmap_Delegate.nativeIsPremultiplied(l);
    }

    @LayoutlibDelegate
    private static void nativeSetPremultiplied(long l, boolean bl) {
        Bitmap_Delegate.nativeSetPremultiplied(l, bl);
    }

    @LayoutlibDelegate
    private static void nativeSetHasAlpha(long l, boolean bl, boolean bl2) {
        Bitmap_Delegate.nativeSetHasAlpha(l, bl, bl2);
    }

    @LayoutlibDelegate
    private static boolean nativeHasMipMap(long l) {
        return Bitmap_Delegate.nativeHasMipMap(l);
    }

    @LayoutlibDelegate
    private static void nativeSetHasMipMap(long l, boolean bl) {
        Bitmap_Delegate.nativeSetHasMipMap(l, bl);
    }

    @LayoutlibDelegate
    private static boolean nativeSameAs(long l, long l2) {
        return Bitmap_Delegate.nativeSameAs(l, l2);
    }

    @LayoutlibDelegate
    private static long nativeRefPixelRef(long l) {
        return Bitmap_Delegate.nativeRefPixelRef(l);
    }

    @LayoutlibDelegate
    private static void nativePrepareToDraw(long l) {
        Bitmap_Delegate.nativePrepareToDraw((long)l);
    }

    static {
        sDefaultDensity = -1;
        CREATOR = new Parcelable.Creator<Bitmap>(){

            @Override
            public Bitmap createFromParcel(Parcel p) {
                Bitmap bm = Bitmap.nativeCreateFromParcel(p);
                if (bm == null) {
                    throw new RuntimeException("Failed to unparcel Bitmap");
                }
                return bm;
            }

            public Bitmap[] newArray(int size) {
                return new Bitmap[size];
            }
        };
    }

    public static enum CompressFormat {
        JPEG(0),
        PNG(1),
        WEBP(2);

        final int nativeInt;

        private CompressFormat(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum Config {
        ALPHA_8(1),
        RGB_565(3),
        ARGB_4444(4),
        ARGB_8888(5);

        final int nativeInt;
        private static Config[] sConfigs;

        private Config(int ni) {
            this.nativeInt = ni;
        }

        static Config nativeToConfig(int ni) {
            return sConfigs[ni];
        }

        static {
            sConfigs = new Config[]{null, ALPHA_8, null, RGB_565, ARGB_4444, ARGB_8888};
        }
    }
}

