/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;

public class UserInfo
implements Parcelable {
    public static final int FLAG_MASK_USER_TYPE = 65535;
    public static final int FLAG_PRIMARY = 1;
    public static final int FLAG_ADMIN = 2;
    public static final int FLAG_GUEST = 4;
    public static final int FLAG_RESTRICTED = 8;
    public static final int FLAG_INITIALIZED = 16;
    public static final int FLAG_MANAGED_PROFILE = 32;
    public static final int FLAG_DISABLED = 64;
    public static final int FLAG_QUIET_MODE = 128;
    public static final int FLAG_EPHEMERAL = 256;
    public static final int FLAG_DEMO = 512;
    public static final int NO_PROFILE_GROUP_ID = -10000;
    public int id;
    public int serialNumber;
    public String name;
    public String iconPath;
    public int flags;
    public long creationTime;
    public long lastLoggedInTime;
    public String lastLoggedInFingerprint;
    public int profileGroupId;
    public int restrictedProfileParentId;
    public boolean partial;
    public boolean guestToRemove;
    public static final Parcelable.Creator<UserInfo> CREATOR = new Parcelable.Creator<UserInfo>(){

        @Override
        public UserInfo createFromParcel(Parcel source) {
            return new UserInfo(source);
        }

        public UserInfo[] newArray(int size) {
            return new UserInfo[size];
        }
    };

    public UserInfo(int id2, String name, int flags) {
        this(id2, name, null, flags);
    }

    public UserInfo(int id2, String name, String iconPath, int flags) {
        this.id = id2;
        this.name = name;
        this.flags = flags;
        this.iconPath = iconPath;
        this.profileGroupId = -10000;
        this.restrictedProfileParentId = -10000;
    }

    public boolean isPrimary() {
        return (this.flags & 1) == 1;
    }

    public boolean isAdmin() {
        return (this.flags & 2) == 2;
    }

    public boolean isGuest() {
        return (this.flags & 4) == 4;
    }

    public boolean isRestricted() {
        return (this.flags & 8) == 8;
    }

    public boolean isManagedProfile() {
        return (this.flags & 0x20) == 32;
    }

    public boolean isEnabled() {
        return (this.flags & 0x40) != 64;
    }

    public boolean isQuietModeEnabled() {
        return (this.flags & 0x80) == 128;
    }

    public boolean isEphemeral() {
        return (this.flags & 0x100) == 256;
    }

    public boolean isInitialized() {
        return (this.flags & 0x10) == 16;
    }

    public boolean isDemo() {
        return (this.flags & 0x200) == 512;
    }

    public boolean isSystemOnly() {
        return UserInfo.isSystemOnly(this.id);
    }

    public static boolean isSystemOnly(int userId) {
        return userId == 0 && UserManager.isSplitSystemUser();
    }

    public boolean supportsSwitchTo() {
        if (this.isEphemeral() && !this.isEnabled()) {
            return false;
        }
        return !this.isManagedProfile() || SystemProperties.getBoolean("fw.show_hidden_users", false);
    }

    public boolean supportsSwitchToByUser() {
        boolean hideSystemUser = UserManager.isSplitSystemUser();
        return (!hideSystemUser || this.id != 0) && this.supportsSwitchTo();
    }

    public boolean canHaveProfile() {
        if (this.isManagedProfile() || this.isGuest() || this.isRestricted()) {
            return false;
        }
        if (UserManager.isSplitSystemUser()) {
            return this.id != 0;
        }
        return this.id == 0;
    }

    public UserInfo() {
    }

    public UserInfo(UserInfo orig) {
        this.name = orig.name;
        this.iconPath = orig.iconPath;
        this.id = orig.id;
        this.flags = orig.flags;
        this.serialNumber = orig.serialNumber;
        this.creationTime = orig.creationTime;
        this.lastLoggedInTime = orig.lastLoggedInTime;
        this.lastLoggedInFingerprint = orig.lastLoggedInFingerprint;
        this.partial = orig.partial;
        this.profileGroupId = orig.profileGroupId;
        this.restrictedProfileParentId = orig.restrictedProfileParentId;
        this.guestToRemove = orig.guestToRemove;
    }

    public UserHandle getUserHandle() {
        return new UserHandle(this.id);
    }

    public String toString() {
        return "UserInfo{" + this.id + ":" + this.name + ":" + Integer.toHexString(this.flags) + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeInt(this.id);
        dest.writeString(this.name);
        dest.writeString(this.iconPath);
        dest.writeInt(this.flags);
        dest.writeInt(this.serialNumber);
        dest.writeLong(this.creationTime);
        dest.writeLong(this.lastLoggedInTime);
        dest.writeString(this.lastLoggedInFingerprint);
        dest.writeInt(this.partial ? 1 : 0);
        dest.writeInt(this.profileGroupId);
        dest.writeInt(this.guestToRemove ? 1 : 0);
        dest.writeInt(this.restrictedProfileParentId);
    }

    private UserInfo(Parcel source) {
        this.id = source.readInt();
        this.name = source.readString();
        this.iconPath = source.readString();
        this.flags = source.readInt();
        this.serialNumber = source.readInt();
        this.creationTime = source.readLong();
        this.lastLoggedInTime = source.readLong();
        this.lastLoggedInFingerprint = source.readString();
        this.partial = source.readInt() != 0;
        this.profileGroupId = source.readInt();
        this.guestToRemove = source.readInt() != 0;
        this.restrictedProfileParentId = source.readInt();
    }
}

