/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.BackupObserver;
import android.app.backup.BackupProgress;
import android.app.backup.IBackupManager;
import android.app.backup.IBackupObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreObserver;
import android.app.backup.RestoreSession;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Pair;

public class BackupManager {
    private static final String TAG = "BackupManager";
    public static final int SUCCESS = 0;
    public static final int ERROR_BACKUP_NOT_ALLOWED = -2001;
    public static final int ERROR_PACKAGE_NOT_FOUND = -2002;
    public static final int ERROR_TRANSPORT_ABORTED = -1000;
    public static final int ERROR_TRANSPORT_PACKAGE_REJECTED = -1002;
    public static final int ERROR_TRANSPORT_QUOTA_EXCEEDED = -1005;
    public static final int ERROR_AGENT_FAILURE = -1003;
    public static final String EXTRA_BACKUP_SERVICES_AVAILABLE = "backup_services_available";
    private Context mContext;
    private static IBackupManager sService;

    private static void checkServiceBinder() {
        if (sService == null) {
            sService = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
        }
    }

    public BackupManager(Context context) {
        this.mContext = context;
    }

    public void dataChanged() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.dataChanged(this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.d(TAG, "dataChanged() couldn't connect");
            }
        }
    }

    public static void dataChanged(String packageName) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.dataChanged(packageName);
            }
            catch (RemoteException e) {
                Log.e(TAG, "dataChanged(pkg) couldn't connect");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestRestore(RestoreObserver observer) {
        int result = -1;
        BackupManager.checkServiceBinder();
        if (sService != null) {
            RestoreSession session = null;
            try {
                IRestoreSession binder = sService.beginRestoreSession(this.mContext.getPackageName(), null);
                if (binder != null) {
                    session = new RestoreSession(this.mContext, binder);
                    result = session.restorePackage(this.mContext.getPackageName(), observer);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "restoreSelf() unable to contact service");
            }
            finally {
                if (session != null) {
                    session.endRestoreSession();
                }
            }
        }
        return result;
    }

    public RestoreSession beginRestoreSession() {
        RestoreSession session = null;
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                IRestoreSession binder = sService.beginRestoreSession(null, null);
                if (binder != null) {
                    session = new RestoreSession(this.mContext, binder);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "beginRestoreSession() couldn't connect");
            }
        }
        return session;
    }

    public void setBackupEnabled(boolean isEnabled) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.setBackupEnabled(isEnabled);
            }
            catch (RemoteException e) {
                Log.e(TAG, "setBackupEnabled() couldn't connect");
            }
        }
    }

    public boolean isBackupEnabled() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.isBackupEnabled();
            }
            catch (RemoteException e) {
                Log.e(TAG, "isBackupEnabled() couldn't connect");
            }
        }
        return false;
    }

    public void setAutoRestore(boolean isEnabled) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.setAutoRestore(isEnabled);
            }
            catch (RemoteException e) {
                Log.e(TAG, "setAutoRestore() couldn't connect");
            }
        }
    }

    public String getCurrentTransport() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.getCurrentTransport();
            }
            catch (RemoteException e) {
                Log.e(TAG, "getCurrentTransport() couldn't connect");
            }
        }
        return null;
    }

    public String[] listAllTransports() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.listAllTransports();
            }
            catch (RemoteException e) {
                Log.e(TAG, "listAllTransports() couldn't connect");
            }
        }
        return null;
    }

    public String selectBackupTransport(String transport) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.selectBackupTransport(transport);
            }
            catch (RemoteException e) {
                Log.e(TAG, "selectBackupTransport() couldn't connect");
            }
        }
        return null;
    }

    public void backupNow() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.backupNow();
            }
            catch (RemoteException e) {
                Log.e(TAG, "backupNow() couldn't connect");
            }
        }
    }

    public long getAvailableRestoreToken(String packageName) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.getAvailableRestoreToken(packageName);
            }
            catch (RemoteException e) {
                Log.e(TAG, "getAvailableRestoreToken() couldn't connect");
            }
        }
        return 0L;
    }

    public boolean isAppEligibleForBackup(String packageName) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.isAppEligibleForBackup(packageName);
            }
            catch (RemoteException e) {
                Log.e(TAG, "isAppEligibleForBackup(pkg) couldn't connect");
            }
        }
        return false;
    }

    public int requestBackup(String[] packages, BackupObserver observer) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                BackupObserverWrapper observerWrapper = observer == null ? null : new BackupObserverWrapper(this.mContext, observer);
                return sService.requestBackup(packages, observerWrapper);
            }
            catch (RemoteException e) {
                Log.e(TAG, "requestBackup() couldn't connect");
            }
        }
        return -1;
    }

    private class BackupObserverWrapper
    extends IBackupObserver.Stub {
        final Handler mHandler;
        final BackupObserver mObserver;
        static final int MSG_UPDATE = 1;
        static final int MSG_RESULT = 2;
        static final int MSG_FINISHED = 3;

        BackupObserverWrapper(Context context, BackupObserver observer) {
            this.mHandler = new Handler(context.getMainLooper()){

                @Override
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            Pair obj = (Pair)msg.obj;
                            BackupObserverWrapper.this.mObserver.onUpdate((String)obj.first, (BackupProgress)obj.second);
                            break;
                        }
                        case 2: {
                            BackupObserverWrapper.this.mObserver.onResult((String)msg.obj, msg.arg1);
                            break;
                        }
                        case 3: {
                            BackupObserverWrapper.this.mObserver.backupFinished(msg.arg1);
                            break;
                        }
                        default: {
                            Log.w(BackupManager.TAG, "Unknown message: " + msg);
                        }
                    }
                }
            };
            this.mObserver = observer;
        }

        @Override
        public void onUpdate(String currentPackage, BackupProgress backupProgress) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, Pair.create(currentPackage, backupProgress)));
        }

        @Override
        public void onResult(String currentPackage, int status) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, status, 0, currentPackage));
        }

        @Override
        public void backupFinished(int status) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, status, 0));
        }
    }
}

