/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.ActivityThread;
import android.app.Application;
import android.util.ArrayMap;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnimatorSet
extends Animator {
    private static final String TAG = "AnimatorSet";
    private ArrayList<Animator> mPlayingSet = new ArrayList();
    private ArrayMap<Animator, Node> mNodeMap = new ArrayMap();
    private ArrayList<Node> mNodes = new ArrayList();
    private AnimatorSetListener mSetListener = new AnimatorSetListener(this);
    private boolean mTerminated = false;
    private boolean mDependencyDirty = false;
    private boolean mStarted = false;
    private long mStartDelay = 0L;
    private ValueAnimator mDelayAnim = ValueAnimator.ofFloat(0.0f, 1.0f).setDuration(0L);
    private Node mRootNode = new Node(this.mDelayAnim);
    private long mDuration = -1L;
    private TimeInterpolator mInterpolator = null;
    private boolean mReversible = true;
    private long mTotalDuration = 0L;
    private final boolean mShouldIgnoreEndWithoutStart;

    public AnimatorSet() {
        this.mNodeMap.put(this.mDelayAnim, this.mRootNode);
        this.mNodes.add(this.mRootNode);
        Application app = ActivityThread.currentApplication();
        this.mShouldIgnoreEndWithoutStart = app == null || app.getApplicationInfo() == null ? true : app.getApplicationInfo().targetSdkVersion < 24;
    }

    public void playTogether(Animator ... items) {
        if (items != null) {
            Builder builder = this.play(items[0]);
            for (int i = 1; i < items.length; ++i) {
                builder.with(items[i]);
            }
        }
    }

    public void playTogether(Collection<Animator> items) {
        if (items != null && items.size() > 0) {
            Builder builder = null;
            for (Animator anim2 : items) {
                if (builder == null) {
                    builder = this.play(anim2);
                    continue;
                }
                builder.with(anim2);
            }
        }
    }

    public void playSequentially(Animator ... items) {
        if (items != null) {
            if (items.length == 1) {
                this.play(items[0]);
            } else {
                this.mReversible = false;
                for (int i = 0; i < items.length - 1; ++i) {
                    this.play(items[i]).before(items[i + 1]);
                }
            }
        }
    }

    public void playSequentially(List<Animator> items) {
        if (items != null && items.size() > 0) {
            if (items.size() == 1) {
                this.play(items.get(0));
            } else {
                this.mReversible = false;
                for (int i = 0; i < items.size() - 1; ++i) {
                    this.play(items.get(i)).before(items.get(i + 1));
                }
            }
        }
    }

    public ArrayList<Animator> getChildAnimations() {
        ArrayList<Animator> childList = new ArrayList<Animator>();
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node == this.mRootNode) continue;
            childList.add(node.mAnimation);
        }
        return childList;
    }

    @Override
    public void setTarget(Object target) {
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            Animator animation = node.mAnimation;
            if (animation instanceof AnimatorSet) {
                ((AnimatorSet)animation).setTarget(target);
                continue;
            }
            if (!(animation instanceof ObjectAnimator)) continue;
            ((ObjectAnimator)animation).setTarget(target);
        }
    }

    @Override
    public int getChangingConfigurations() {
        int conf = super.getChangingConfigurations();
        int nodeCount = this.mNodes.size();
        for (int i = 0; i < nodeCount; ++i) {
            conf |= this.mNodes.get((int)i).mAnimation.getChangingConfigurations();
        }
        return conf;
    }

    @Override
    public void setInterpolator(TimeInterpolator interpolator2) {
        this.mInterpolator = interpolator2;
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    public Builder play(Animator anim2) {
        if (anim2 != null) {
            return new Builder(anim2);
        }
        return null;
    }

    @Override
    public void cancel() {
        this.mTerminated = true;
        if (this.isStarted()) {
            ArrayList tmpListeners = null;
            if (this.mListeners != null) {
                tmpListeners = (ArrayList)this.mListeners.clone();
                int size = tmpListeners.size();
                for (int i = 0; i < size; ++i) {
                    ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationCancel(this);
                }
            }
            ArrayList<Animator> playingSet = new ArrayList<Animator>(this.mPlayingSet);
            int setSize = playingSet.size();
            for (int i = 0; i < setSize; ++i) {
                playingSet.get(i).cancel();
            }
            if (tmpListeners != null) {
                int size = tmpListeners.size();
                for (int i = 0; i < size; ++i) {
                    ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    @Override
    public void end() {
        if (this.mShouldIgnoreEndWithoutStart && !this.isStarted()) {
            return;
        }
        this.mTerminated = true;
        if (this.isStarted()) {
            this.endRemainingAnimations();
        }
        if (this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            for (int i = 0; i < tmpListeners.size(); ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this);
            }
        }
        this.mStarted = false;
    }

    private void endRemainingAnimations() {
        ArrayList<Animator> remainingList = new ArrayList<Animator>(this.mNodes.size());
        remainingList.addAll(this.mPlayingSet);
        int index = 0;
        while (index < remainingList.size()) {
            Animator anim2 = (Animator)remainingList.get(index);
            anim2.end();
            ++index;
            Node node = this.mNodeMap.get(anim2);
            if (node.mChildNodes == null) continue;
            int childSize = node.mChildNodes.size();
            for (int i = 0; i < childSize; ++i) {
                Node child = node.mChildNodes.get(i);
                if (child.mLatestParent != node) continue;
                remainingList.add(child.mAnimation);
            }
        }
    }

    @Override
    public boolean isRunning() {
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node == this.mRootNode || !node.mAnimation.isStarted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    @Override
    public long getStartDelay() {
        return this.mStartDelay;
    }

    @Override
    public void setStartDelay(long startDelay) {
        long delta;
        if (startDelay < 0L) {
            Log.w(TAG, "Start delay should always be non-negative");
            startDelay = 0L;
        }
        if ((delta = startDelay - this.mStartDelay) == 0L) {
            return;
        }
        this.mStartDelay = startDelay;
        if (this.mStartDelay > 0L) {
            this.mReversible = false;
        }
        if (!this.mDependencyDirty) {
            int size = this.mNodes.size();
            for (int i = 0; i < size; ++i) {
                Node node = this.mNodes.get(i);
                if (node == this.mRootNode) {
                    node.mEndTime = this.mStartDelay;
                    continue;
                }
                node.mStartTime = node.mStartTime == -1L ? -1L : node.mStartTime + delta;
                node.mEndTime = node.mEndTime == -1L ? -1L : node.mEndTime + delta;
            }
            if (this.mTotalDuration != -1L) {
                this.mTotalDuration += delta;
            }
        }
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    public AnimatorSet setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration must be a value of zero or greater");
        }
        this.mDependencyDirty = true;
        this.mDuration = duration;
        return this;
    }

    @Override
    public void setupStartValues() {
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node == this.mRootNode) continue;
            node.mAnimation.setupStartValues();
        }
    }

    @Override
    public void setupEndValues() {
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node == this.mRootNode) continue;
            node.mAnimation.setupEndValues();
        }
    }

    @Override
    public void pause() {
        boolean previouslyPaused = this.mPaused;
        super.pause();
        if (!previouslyPaused && this.mPaused) {
            if (this.mDelayAnim.isStarted()) {
                this.mDelayAnim.pause();
            } else {
                int size = this.mNodes.size();
                for (int i = 0; i < size; ++i) {
                    Node node = this.mNodes.get(i);
                    if (node == this.mRootNode) continue;
                    node.mAnimation.pause();
                }
            }
        }
    }

    @Override
    public void resume() {
        boolean previouslyPaused = this.mPaused;
        super.resume();
        if (previouslyPaused && !this.mPaused) {
            if (this.mDelayAnim.isStarted()) {
                this.mDelayAnim.resume();
            } else {
                int size = this.mNodes.size();
                for (int i = 0; i < size; ++i) {
                    Node node = this.mNodes.get(i);
                    if (node == this.mRootNode) continue;
                    node.mAnimation.resume();
                }
            }
        }
    }

    @Override
    public void start() {
        Node node;
        int i;
        this.mTerminated = false;
        this.mStarted = true;
        this.mPaused = false;
        int size = this.mNodes.size();
        for (i = 0; i < size; ++i) {
            node = this.mNodes.get(i);
            node.mEnded = false;
            node.mAnimation.setAllowRunningAsynchronously(false);
        }
        if (this.mInterpolator != null) {
            for (i = 0; i < size; ++i) {
                node = this.mNodes.get(i);
                node.mAnimation.setInterpolator(this.mInterpolator);
            }
        }
        this.updateAnimatorsDuration();
        this.createDependencyGraph();
        boolean setIsEmpty = false;
        if (this.mStartDelay > 0L) {
            this.start(this.mRootNode);
        } else if (this.mNodes.size() > 1) {
            this.onChildAnimatorEnded(this.mDelayAnim);
        } else {
            setIsEmpty = true;
        }
        if (this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i2 = 0; i2 < numListeners; ++i2) {
                ((Animator.AnimatorListener)tmpListeners.get(i2)).onAnimationStart(this);
            }
        }
        if (setIsEmpty) {
            this.onChildAnimatorEnded(this.mDelayAnim);
        }
    }

    private void updateAnimatorsDuration() {
        if (this.mDuration >= 0L) {
            int size = this.mNodes.size();
            for (int i = 0; i < size; ++i) {
                Node node = this.mNodes.get(i);
                node.mAnimation.setDuration(this.mDuration);
            }
        }
        this.mDelayAnim.setDuration(this.mStartDelay);
    }

    void start(Node node) {
        Animator anim2 = node.mAnimation;
        this.mPlayingSet.add(anim2);
        anim2.addListener(this.mSetListener);
        anim2.start();
    }

    @Override
    public AnimatorSet clone() {
        Node node;
        int n;
        AnimatorSet anim2 = (AnimatorSet)super.clone();
        int nodeCount = this.mNodes.size();
        anim2.mTerminated = false;
        anim2.mStarted = false;
        anim2.mPlayingSet = new ArrayList();
        anim2.mNodeMap = new ArrayMap();
        anim2.mNodes = new ArrayList(nodeCount);
        anim2.mReversible = this.mReversible;
        anim2.mSetListener = new AnimatorSetListener(anim2);
        for (n = 0; n < nodeCount; ++n) {
            node = this.mNodes.get(n);
            Node nodeClone = node.clone();
            node.mTmpClone = nodeClone;
            anim2.mNodes.add(nodeClone);
            anim2.mNodeMap.put(nodeClone.mAnimation, nodeClone);
            ArrayList<Animator.AnimatorListener> cloneListeners = nodeClone.mAnimation.getListeners();
            if (cloneListeners == null) continue;
            for (int i = cloneListeners.size() - 1; i >= 0; --i) {
                Animator.AnimatorListener listener = cloneListeners.get(i);
                if (!(listener instanceof AnimatorSetListener)) continue;
                cloneListeners.remove(i);
            }
        }
        anim2.mRootNode = this.mRootNode.mTmpClone;
        anim2.mDelayAnim = (ValueAnimator)anim2.mRootNode.mAnimation;
        for (int i = 0; i < nodeCount; ++i) {
            int j;
            node = this.mNodes.get(i);
            ((Node)node).mTmpClone.mLatestParent = node.mLatestParent == null ? null : node.mLatestParent.mTmpClone;
            int size = node.mChildNodes == null ? 0 : node.mChildNodes.size();
            for (j = 0; j < size; ++j) {
                ((Node)node).mTmpClone.mChildNodes.set(j, node.mChildNodes.get(j).mTmpClone);
            }
            size = node.mSiblings == null ? 0 : node.mSiblings.size();
            for (j = 0; j < size; ++j) {
                ((Node)node).mTmpClone.mSiblings.set(j, node.mSiblings.get(j).mTmpClone);
            }
            size = node.mParents == null ? 0 : node.mParents.size();
            for (j = 0; j < size; ++j) {
                ((Node)node).mTmpClone.mParents.set(j, node.mParents.get(j).mTmpClone);
            }
        }
        for (n = 0; n < nodeCount; ++n) {
            this.mNodes.get(n).mTmpClone = null;
        }
        return anim2;
    }

    private void onChildAnimatorEnded(Animator animation) {
        Node animNode = this.mNodeMap.get(animation);
        animNode.mEnded = true;
        if (!this.mTerminated) {
            ArrayList<Node> children = animNode.mChildNodes;
            int childrenSize = children == null ? 0 : children.size();
            for (int i = 0; i < childrenSize; ++i) {
                if (((Node)children.get((int)i)).mLatestParent != animNode) continue;
                this.start((Node)children.get(i));
            }
            boolean allDone = true;
            int size = this.mNodes.size();
            for (int i = 0; i < size; ++i) {
                if (this.mNodes.get((int)i).mEnded) continue;
                allDone = false;
                break;
            }
            if (allDone) {
                if (this.mListeners != null) {
                    ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                    int numListeners = tmpListeners.size();
                    for (int i = 0; i < numListeners; ++i) {
                        ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this);
                    }
                }
                this.mStarted = false;
                this.mPaused = false;
            }
        }
    }

    @Override
    public boolean canReverse() {
        if (!this.mReversible) {
            return false;
        }
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node.mAnimation.canReverse() && node.mAnimation.getStartDelay() <= 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reverse() {
        if (this.canReverse()) {
            int size = this.mNodes.size();
            for (int i = 0; i < size; ++i) {
                Node node = this.mNodes.get(i);
                node.mAnimation.reverse();
            }
        }
    }

    public String toString() {
        String returnVal = "AnimatorSet@" + Integer.toHexString(this.hashCode()) + "{";
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            returnVal = returnVal + "\n    " + node.mAnimation.toString();
        }
        return returnVal + "\n}";
    }

    private void printChildCount() {
        ArrayList<Node> list = new ArrayList<Node>(this.mNodes.size());
        list.add(this.mRootNode);
        Log.d(TAG, "Current tree: ");
        int index = 0;
        while (index < list.size()) {
            int listSize = list.size();
            StringBuilder builder = new StringBuilder();
            while (index < listSize) {
                Node node = (Node)list.get(index);
                int num = 0;
                if (node.mChildNodes != null) {
                    for (int i = 0; i < node.mChildNodes.size(); ++i) {
                        Node child = node.mChildNodes.get(i);
                        if (child.mLatestParent != node) continue;
                        ++num;
                        list.add(child);
                    }
                }
                builder.append(" ");
                builder.append(num);
                ++index;
            }
            Log.d(TAG, builder.toString());
        }
    }

    private void createDependencyGraph() {
        Node node;
        int i;
        if (!this.mDependencyDirty) {
            boolean durationChanged = false;
            for (i = 0; i < this.mNodes.size(); ++i) {
                Animator anim2 = this.mNodes.get((int)i).mAnimation;
                if (this.mNodes.get((int)i).mTotalDuration == anim2.getTotalDuration()) continue;
                durationChanged = true;
                break;
            }
            if (!durationChanged) {
                return;
            }
        }
        this.mDependencyDirty = false;
        int size = this.mNodes.size();
        for (i = 0; i < size; ++i) {
            this.mNodes.get((int)i).mParentsAdded = false;
        }
        for (i = 0; i < size; ++i) {
            int j;
            node = this.mNodes.get(i);
            if (node.mParentsAdded) continue;
            node.mParentsAdded = true;
            if (node.mSiblings == null) continue;
            this.findSiblings(node, node.mSiblings);
            node.mSiblings.remove(node);
            int siblingSize = node.mSiblings.size();
            for (j = 0; j < siblingSize; ++j) {
                node.addParents(node.mSiblings.get((int)j).mParents);
            }
            for (j = 0; j < siblingSize; ++j) {
                Node sibling = node.mSiblings.get(j);
                sibling.addParents(node.mParents);
                sibling.mParentsAdded = true;
            }
        }
        for (i = 0; i < size; ++i) {
            node = this.mNodes.get(i);
            if (node == this.mRootNode || node.mParents != null) continue;
            node.addParent(this.mRootNode);
        }
        ArrayList<Node> visited = new ArrayList<Node>(this.mNodes.size());
        this.mRootNode.mStartTime = 0L;
        this.mRootNode.mEndTime = this.mDelayAnim.getDuration();
        this.updatePlayTime(this.mRootNode, visited);
        long maxEndTime = 0L;
        for (int i2 = 0; i2 < size; ++i2) {
            Node node2 = this.mNodes.get(i2);
            node2.mTotalDuration = node2.mAnimation.getTotalDuration();
            if (node2.mEndTime == -1L) {
                maxEndTime = -1L;
                break;
            }
            maxEndTime = node2.mEndTime > maxEndTime ? node2.mEndTime : maxEndTime;
        }
        this.mTotalDuration = maxEndTime;
    }

    private void updatePlayTime(Node parent, ArrayList<Node> visited) {
        if (parent.mChildNodes == null) {
            if (parent == this.mRootNode) {
                for (int i = 0; i < this.mNodes.size(); ++i) {
                    Node node = this.mNodes.get(i);
                    if (node == this.mRootNode) continue;
                    node.mStartTime = -1L;
                    node.mEndTime = -1L;
                }
            }
            return;
        }
        visited.add(parent);
        int childrenSize = parent.mChildNodes.size();
        for (int i = 0; i < childrenSize; ++i) {
            Node child = parent.mChildNodes.get(i);
            int index = visited.indexOf(child);
            if (index >= 0) {
                for (int j = index; j < visited.size(); ++j) {
                    visited.get((int)j).mLatestParent = null;
                    visited.get((int)j).mStartTime = -1L;
                    visited.get((int)j).mEndTime = -1L;
                }
                child.mStartTime = -1L;
                child.mEndTime = -1L;
                child.mLatestParent = null;
                Log.w(TAG, "Cycle found in AnimatorSet: " + this);
                continue;
            }
            if (child.mStartTime != -1L) {
                if (parent.mEndTime == -1L) {
                    child.mLatestParent = parent;
                    child.mStartTime = -1L;
                    child.mEndTime = -1L;
                } else {
                    long duration;
                    if (parent.mEndTime >= child.mStartTime) {
                        child.mLatestParent = parent;
                        child.mStartTime = parent.mEndTime;
                    }
                    child.mEndTime = (duration = child.mAnimation.getTotalDuration()) == -1L ? -1L : child.mStartTime + duration;
                }
            }
            this.updatePlayTime(child, visited);
        }
        visited.remove(parent);
    }

    private void findSiblings(Node node, ArrayList<Node> siblings) {
        if (!siblings.contains(node)) {
            siblings.add(node);
            if (node.mSiblings == null) {
                return;
            }
            for (int i = 0; i < node.mSiblings.size(); ++i) {
                this.findSiblings(node.mSiblings.get(i), siblings);
            }
        }
    }

    public boolean shouldPlayTogether() {
        this.updateAnimatorsDuration();
        this.createDependencyGraph();
        return this.mRootNode.mChildNodes == null || this.mRootNode.mChildNodes.size() == this.mNodes.size() - 1;
    }

    @Override
    public long getTotalDuration() {
        this.updateAnimatorsDuration();
        this.createDependencyGraph();
        return this.mTotalDuration;
    }

    private Node getNodeForAnimation(Animator anim2) {
        Node node = this.mNodeMap.get(anim2);
        if (node == null) {
            node = new Node(anim2);
            this.mNodeMap.put(anim2, node);
            this.mNodes.add(node);
        }
        return node;
    }

    public class Builder {
        private Node mCurrentNode;

        Builder(Animator anim2) {
            AnimatorSet.this.mDependencyDirty = true;
            this.mCurrentNode = AnimatorSet.this.getNodeForAnimation(anim2);
        }

        public Builder with(Animator anim2) {
            Node node = AnimatorSet.this.getNodeForAnimation(anim2);
            this.mCurrentNode.addSibling(node);
            return this;
        }

        public Builder before(Animator anim2) {
            AnimatorSet.this.mReversible = false;
            Node node = AnimatorSet.this.getNodeForAnimation(anim2);
            this.mCurrentNode.addChild(node);
            return this;
        }

        public Builder after(Animator anim2) {
            AnimatorSet.this.mReversible = false;
            Node node = AnimatorSet.this.getNodeForAnimation(anim2);
            this.mCurrentNode.addParent(node);
            return this;
        }

        public Builder after(long delay) {
            ValueAnimator anim2 = ValueAnimator.ofFloat(0.0f, 1.0f);
            anim2.setDuration(delay);
            this.after(anim2);
            return this;
        }
    }

    private static class Node
    implements Cloneable {
        Animator mAnimation;
        ArrayList<Node> mChildNodes = null;
        private Node mTmpClone = null;
        boolean mEnded = false;
        ArrayList<Node> mSiblings;
        ArrayList<Node> mParents;
        Node mLatestParent = null;
        boolean mParentsAdded = false;
        long mStartTime = 0L;
        long mEndTime = 0L;
        long mTotalDuration = 0L;

        public Node(Animator animation) {
            this.mAnimation = animation;
        }

        public Node clone() {
            try {
                Node node = (Node)super.clone();
                node.mAnimation = this.mAnimation.clone();
                if (this.mChildNodes != null) {
                    node.mChildNodes = new ArrayList<Node>(this.mChildNodes);
                }
                if (this.mSiblings != null) {
                    node.mSiblings = new ArrayList<Node>(this.mSiblings);
                }
                if (this.mParents != null) {
                    node.mParents = new ArrayList<Node>(this.mParents);
                }
                node.mEnded = false;
                return node;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        void addChild(Node node) {
            if (this.mChildNodes == null) {
                this.mChildNodes = new ArrayList();
            }
            if (!this.mChildNodes.contains(node)) {
                this.mChildNodes.add(node);
                node.addParent(this);
            }
        }

        public void addSibling(Node node) {
            if (this.mSiblings == null) {
                this.mSiblings = new ArrayList();
            }
            if (!this.mSiblings.contains(node)) {
                this.mSiblings.add(node);
                node.addSibling(this);
            }
        }

        public void addParent(Node node) {
            if (this.mParents == null) {
                this.mParents = new ArrayList();
            }
            if (!this.mParents.contains(node)) {
                this.mParents.add(node);
                node.addChild(this);
            }
        }

        public void addParents(ArrayList<Node> parents) {
            if (parents == null) {
                return;
            }
            int size = parents.size();
            for (int i = 0; i < size; ++i) {
                this.addParent(parents.get(i));
            }
        }
    }

    private static class AnimatorSetListener
    implements Animator.AnimatorListener {
        private AnimatorSet mAnimatorSet;

        AnimatorSetListener(AnimatorSet animatorSet) {
            this.mAnimatorSet = animatorSet;
        }

        @Override
        public void onAnimationCancel(Animator animation) {
            ArrayList listeners;
            if (!this.mAnimatorSet.mTerminated && this.mAnimatorSet.mPlayingSet.size() == 0 && (listeners = this.mAnimatorSet.mListeners) != null) {
                int numListeners = listeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((Animator.AnimatorListener)listeners.get(i)).onAnimationCancel(this.mAnimatorSet);
                }
            }
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            animation.removeListener(this);
            this.mAnimatorSet.mPlayingSet.remove(animation);
            this.mAnimatorSet.onChildAnimatorEnded(animation);
        }

        @Override
        public void onAnimationRepeat(Animator animation) {
        }

        @Override
        public void onAnimationStart(Animator animation) {
        }
    }
}

