/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.bars.Config;
import com.android.layoutlib.bridge.bars.IconLoader;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.Density;
import com.android.resources.LayoutDirection;
import com.android.resources.ResourceType;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

abstract class CustomBar
extends LinearLayout {
    private final int mSimulatedPlatformVersion;

    protected abstract TextView getStyleableTextView();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CustomBar(BridgeContext context, int orientation, String layoutPath, String name, int simulatedPlatformVersion) {
        super(context);
        XmlPullParser parser;
        this.mSimulatedPlatformVersion = simulatedPlatformVersion;
        this.setOrientation(orientation);
        if (orientation == 0) {
            this.setGravity(16);
        } else {
            this.setGravity(1);
        }
        LayoutInflater inflater = LayoutInflater.from(this.mContext);
        try {
            parser = ParserFactory.create(this.getClass().getResourceAsStream(layoutPath), name);
        }
        catch (XmlPullParserException e) {
            throw new AssertionError((Object)e);
        }
        BridgeXmlBlockParser bridgeParser = new BridgeXmlBlockParser(parser, context, false);
        try {
            inflater.inflate(bridgeParser, (ViewGroup)this, true);
        }
        finally {
            bridgeParser.ensurePopped();
        }
    }

    protected void loadIcon(int index, String iconName, Density density) {
        this.loadIcon(index, iconName, density, false);
    }

    protected void loadIcon(int index, String iconName, Density density, boolean isRtl) {
        View child = this.getChildAt(index);
        if (child instanceof ImageView) {
            ImageView imageView = (ImageView)child;
            Object dir = isRtl ? LayoutDirection.RTL : null;
            IconLoader iconLoader = new IconLoader(iconName, density, this.mSimulatedPlatformVersion, (LayoutDirection)dir);
            InputStream stream = iconLoader.getIcon();
            if (stream != null) {
                density = iconLoader.getDensity();
                String path = iconLoader.getPath();
                Bitmap bitmap = Bridge.getCachedBitmap(path, Boolean.TRUE);
                if (bitmap == null) {
                    try {
                        bitmap = Bitmap_Delegate.createBitmap(stream, false, density);
                        Bridge.setCachedBitmap(path, bitmap, Boolean.TRUE);
                    }
                    catch (IOException e) {
                        return;
                    }
                }
                if (bitmap != null) {
                    BitmapDrawable drawable2 = new BitmapDrawable(this.getContext().getResources(), bitmap);
                    imageView.setImageDrawable(drawable2);
                }
            }
        }
    }

    protected TextView setText(int index, String string2, boolean reference) {
        View child = this.getChildAt(index);
        if (child instanceof TextView) {
            TextView textView = (TextView)child;
            this.setText(textView, string2, reference);
            return textView;
        }
        return null;
    }

    private void setText(TextView textView, String string2, boolean reference) {
        ResourceValue value;
        if (reference && (value = this.getResourceValue(string2)) != null) {
            string2 = value.getValue();
        }
        textView.setText(string2);
    }

    protected void setStyle(String themeEntryName) {
        TextView textView;
        Drawable d;
        BridgeContext bridgeContext = this.getContext();
        RenderResources res = bridgeContext.getRenderResources();
        ResourceValue value = res.findItemInTheme(themeEntryName, true);
        if (!((value = res.resolveResValue(value)) instanceof StyleResourceValue)) {
            return;
        }
        StyleResourceValue style2 = (StyleResourceValue)value;
        ResourceValue backgroundValue = res.findItemInStyle(style2, "background", true);
        if ((backgroundValue = res.resolveResValue(backgroundValue)) != null && (d = ResourceHelper.getDrawable(backgroundValue, bridgeContext)) != null) {
            this.setBackground(d);
        }
        if ((textView = this.getStyleableTextView()) != null) {
            ResourceValue textStyleValue = res.findItemInStyle(style2, "titleTextStyle", true);
            if ((textStyleValue = res.resolveResValue(textStyleValue)) instanceof StyleResourceValue) {
                ColorStateList stateList;
                StyleResourceValue textStyle = (StyleResourceValue)textStyleValue;
                ResourceValue textSize = res.findItemInStyle(textStyle, "textSize", true);
                if ((textSize = res.resolveResValue(textSize)) != null) {
                    TypedValue out = new TypedValue();
                    if (ResourceHelper.parseFloatAttribute("textSize", textSize.getValue(), out, true)) {
                        textView.setTextSize(0, out.getDimension(bridgeContext.getResources().getDisplayMetrics()));
                    }
                }
                ResourceValue textColor = res.findItemInStyle(textStyle, "textColor", true);
                if ((textColor = res.resolveResValue(textColor)) != null && (stateList = ResourceHelper.getColorStateList(textColor, bridgeContext)) != null) {
                    textView.setTextColor(stateList);
                }
            }
        }
    }

    @Override
    public BridgeContext getContext() {
        return (BridgeContext)this.mContext;
    }

    protected int getBarColor(String colorAttrName, String translucentAttrName) {
        if (!Config.isGreaterOrEqual(this.mSimulatedPlatformVersion, 21)) {
            return 0;
        }
        RenderResources renderResources = this.getContext().getRenderResources();
        boolean translucent = ResourceHelper.getBooleanThemeValue(renderResources, translucentAttrName, true, false);
        if (translucent) {
            return 0x66000000;
        }
        boolean transparent = ResourceHelper.getBooleanThemeValue(renderResources, "windowDrawsSystemBarBackgrounds", true, false);
        if (transparent) {
            return CustomBar.getColor(renderResources, colorAttrName);
        }
        return 0;
    }

    private static int getColor(RenderResources renderResources, String attr2) {
        ResourceType type;
        ResourceValue resource = renderResources.findItemInTheme(attr2, true);
        if ((resource = renderResources.resolveResValue(resource)) != null && ((type = resource.getResourceType()) == null || type == ResourceType.COLOR)) {
            try {
                return ResourceHelper.getColor(resource.getValue());
            }
            catch (NumberFormatException e) {
                Bridge.getLog().warning("resources.format", "Theme attribute @android:" + attr2 + " does not reference a color, instead is '" + resource.getValue() + "'.", (Object)resource);
            }
        }
        return 0;
    }

    private ResourceValue getResourceValue(String reference) {
        RenderResources res = this.getContext().getRenderResources();
        ResourceValue value = res.findResValue(reference, false);
        return res.resolveResValue(value);
    }
}

