/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.Bundle;
import android.os.IProgressListener;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.MathUtils;
import com.android.internal.annotations.GuardedBy;

public class ProgressReporter {
    private static final int STATE_INIT = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_FINISHED = 2;
    private final int mId;
    @GuardedBy(value="this")
    private final RemoteCallbackList<IProgressListener> mListeners = new RemoteCallbackList();
    @GuardedBy(value="this")
    private int mState = 0;
    @GuardedBy(value="this")
    private int mProgress = 0;
    @GuardedBy(value="this")
    private Bundle mExtras = new Bundle();
    @GuardedBy(value="this")
    private int[] mSegmentRange = new int[]{0, 100};

    public ProgressReporter(int id2) {
        this.mId = id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IProgressListener listener) {
        if (listener == null) {
            return;
        }
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            this.mListeners.register(listener);
            switch (this.mState) {
                case 0: {
                    break;
                }
                case 1: {
                    try {
                        listener.onStarted(this.mId, null);
                        listener.onProgress(this.mId, this.mProgress, this.mExtras);
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                case 2: {
                    try {
                        listener.onFinished(this.mId, null);
                        break;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void setProgress(int progress) {
        this.setProgress(progress, 100, null);
    }

    public void setProgress(int progress, CharSequence title) {
        this.setProgress(progress, 100, title);
    }

    public void setProgress(int n, int m) {
        this.setProgress(n, m, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgress(int n, int m, CharSequence title) {
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            if (this.mState != 1) {
                throw new IllegalStateException("Must be started to change progress");
            }
            this.mProgress = this.mSegmentRange[0] + MathUtils.constrain(n * this.mSegmentRange[1] / m, 0, this.mSegmentRange[1]);
            if (title != null) {
                this.mExtras.putCharSequence("android.intent.extra.TITLE", title);
            }
            this.notifyProgress(this.mId, this.mProgress, this.mExtras);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] startSegment(int size) {
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            int[] lastRange = this.mSegmentRange;
            this.mSegmentRange = new int[]{this.mProgress, size * this.mSegmentRange[1] / 100};
            return lastRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSegment(int[] lastRange) {
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            this.mProgress = this.mSegmentRange[0] + this.mSegmentRange[1];
            this.mSegmentRange = lastRange;
        }
    }

    int getProgress() {
        return this.mProgress;
    }

    int[] getSegmentRange() {
        return this.mSegmentRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            this.mState = 1;
            this.notifyStarted(this.mId, null);
            this.notifyProgress(this.mId, this.mProgress, this.mExtras);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            this.mState = 2;
            this.notifyFinished(this.mId, null);
            this.mListeners.kill();
        }
    }

    private void notifyStarted(int id2, Bundle extras) {
        for (int i = this.mListeners.beginBroadcast() - 1; i >= 0; --i) {
            try {
                this.mListeners.getBroadcastItem(i).onStarted(id2, extras);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mListeners.finishBroadcast();
    }

    private void notifyProgress(int id2, int progress, Bundle extras) {
        for (int i = this.mListeners.beginBroadcast() - 1; i >= 0; --i) {
            try {
                this.mListeners.getBroadcastItem(i).onProgress(id2, progress, extras);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mListeners.finishBroadcast();
    }

    private void notifyFinished(int id2, Bundle extras) {
        for (int i = this.mListeners.beginBroadcast() - 1; i >= 0; --i) {
            try {
                this.mListeners.getBroadcastItem(i).onFinished(id2, extras);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mListeners.finishBroadcast();
    }
}

