/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.MergeCookie;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.MockView;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.android.support.DrawerLayoutUtil;
import com.android.layoutlib.bridge.android.support.RecyclerViewUtil;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.layoutlib.bridge.util.ReflectionUtils;
import com.android.resources.ResourceType;
import com.android.util.Pair;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;

public final class BridgeInflater
extends LayoutInflater {
    private final LayoutlibCallback mLayoutlibCallback;
    private boolean mIsInMerge = false;
    private ResourceReference mResourceReference;
    private Map<View, String> mOpenDrawerLayouts;
    private static final int[] ATTRS_THEME = new int[]{0x1010000};
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.webkit.", "android.app."};

    public static String[] getClassPrefixList() {
        return sClassPrefixList;
    }

    protected BridgeInflater(LayoutInflater original, Context newContext) {
        super(original, newContext);
        newContext = BridgeContext.getBaseContext(newContext);
        this.mLayoutlibCallback = newContext instanceof BridgeContext ? ((BridgeContext)newContext).getLayoutlibCallback() : null;
    }

    public BridgeInflater(Context context, LayoutlibCallback layoutlibCallback) {
        super(context);
        this.mLayoutlibCallback = layoutlibCallback;
        this.mConstructorArgs[0] = context;
    }

    @Override
    public View onCreateView(String name, AttributeSet attrs) throws ClassNotFoundException {
        View view = null;
        try {
            for (String prefix : sClassPrefixList) {
                try {
                    view = this.createView(name, prefix, attrs);
                    if (view == null) continue;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            try {
                if (view == null) {
                    view = super.onCreateView(name, attrs);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (view == null) {
                view = this.loadCustomView(name, attrs);
            }
        }
        catch (InflateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassNotFoundException("onCreateView", e);
        }
        this.setupViewInContext(view, attrs);
        return view;
    }

    @Override
    public View createViewFromTag(View parent, String name, Context context, AttributeSet attrs, boolean ignoreThemeAttr) {
        View view;
        try {
            view = super.createViewFromTag(parent, name, context, attrs, ignoreThemeAttr);
        }
        catch (InflateException e) {
            if (!ignoreThemeAttr) {
                TypedArray ta = context.obtainStyledAttributes(attrs, ATTRS_THEME);
                int themeResId = ta.getResourceId(0, 0);
                if (themeResId != 0) {
                    context = new ContextThemeWrapper(context, themeResId);
                }
                ta.recycle();
            }
            if (!(e.getCause() instanceof ClassNotFoundException)) {
                view = new MockView(context, attrs);
                ((MockView)view).setText(name);
                Bridge.getLog().error("broken", e.getMessage(), (Throwable)e, null);
            }
            Object lastContext = this.mConstructorArgs[0];
            this.mConstructorArgs[0] = context;
            try {
                view = this.loadCustomView(name, attrs);
            }
            catch (Exception e2) {
                InflateException exception = new InflateException();
                if (!e2.getClass().equals(ClassNotFoundException.class)) {
                    exception.initCause(e2);
                } else {
                    exception.initCause(e);
                }
                throw exception;
            }
            finally {
                this.mConstructorArgs[0] = lastContext;
            }
        }
        this.setupViewInContext(view, attrs);
        return view;
    }

    @Override
    public View inflate(int resource, ViewGroup root) {
        Context context = this.getContext();
        if ((context = BridgeContext.getBaseContext(context)) instanceof BridgeContext) {
            File f;
            BridgeContext bridgeContext = (BridgeContext)context;
            ResourceValue value = null;
            Pair layoutInfo = Bridge.resolveResourceId(resource);
            if (layoutInfo != null) {
                value = bridgeContext.getRenderResources().getFrameworkResource(ResourceType.LAYOUT, (String)layoutInfo.getSecond());
            } else {
                layoutInfo = this.mLayoutlibCallback.resolveResourceId(resource);
                if (layoutInfo != null) {
                    value = bridgeContext.getRenderResources().getProjectResource(ResourceType.LAYOUT, (String)layoutInfo.getSecond());
                }
            }
            if (value != null && (f = new File(value.getValue())).isFile()) {
                try {
                    XmlPullParser parser = ParserFactory.create(f, true);
                    BridgeXmlBlockParser bridgeParser = new BridgeXmlBlockParser(parser, bridgeContext, value.isFramework());
                    return this.inflate(bridgeParser, root);
                }
                catch (Exception e) {
                    Bridge.getLog().error("resources.read", "Failed to parse file " + f.getAbsolutePath(), (Throwable)e, null);
                    return null;
                }
            }
        }
        return null;
    }

    private View loadCustomView(String name, AttributeSet attrs) throws Exception {
        if (this.mLayoutlibCallback != null) {
            if (name.equals("view")) {
                name = attrs.getAttributeValue(null, "class");
            }
            this.mConstructorArgs[1] = attrs;
            Object customView = this.mLayoutlibCallback.loadView(name, mConstructorSignature, this.mConstructorArgs);
            if (customView instanceof View) {
                return (View)customView;
            }
        }
        return null;
    }

    private void setupViewInContext(View view, AttributeSet attrs) {
        Context context = this.getContext();
        if ((context = BridgeContext.getBaseContext(context)) instanceof BridgeContext) {
            String attrVal;
            String scrollPosY;
            String scrollPosX;
            BridgeContext bc = (BridgeContext)context;
            Object viewKey = BridgeInflater.getViewKeyFromParser(attrs, bc, this.mResourceReference, this.mIsInMerge);
            if (viewKey != null) {
                bc.addViewKey(view, viewKey);
            }
            if ((scrollPosX = attrs.getAttributeValue("http://schemas.android.com/apk/res/android", "scrollX")) != null && scrollPosX.endsWith("px")) {
                int value = Integer.parseInt(scrollPosX.substring(0, scrollPosX.length() - 2));
                bc.setScrollXPos(view, value);
            }
            if ((scrollPosY = attrs.getAttributeValue("http://schemas.android.com/apk/res/android", "scrollY")) != null && scrollPosY.endsWith("px")) {
                int value = Integer.parseInt(scrollPosY.substring(0, scrollPosY.length() - 2));
                bc.setScrollYPos(view, value);
            }
            if (ReflectionUtils.isInstanceOf(view, "android.support.v7.widget.RecyclerView")) {
                Integer resourceId = null;
                String attrVal2 = attrs.getAttributeValue("http://schemas.android.com/tools", "listitem");
                if (attrVal2 != null && !attrVal2.isEmpty()) {
                    ResourceValue resValue = bc.getRenderResources().findResValue(attrVal2, false);
                    resourceId = resValue.isFramework() ? Bridge.getResourceId(resValue.getResourceType(), resValue.getName()) : this.mLayoutlibCallback.getResourceId(resValue.getResourceType(), resValue.getName());
                }
                if (resourceId == null) {
                    resourceId = 0;
                }
                RecyclerViewUtil.setAdapter(view, bc, this.mLayoutlibCallback, resourceId);
            } else if (ReflectionUtils.isInstanceOf(view, "android.support.v4.widget.DrawerLayout") && (attrVal = attrs.getAttributeValue("http://schemas.android.com/tools", "openDrawer")) != null) {
                this.getDrawerLayoutMap().put(view, attrVal);
            }
        }
    }

    public void setIsInMerge(boolean isInMerge) {
        this.mIsInMerge = isInMerge;
    }

    public void setResourceReference(ResourceReference reference) {
        this.mResourceReference = reference;
    }

    @Override
    public LayoutInflater cloneInContext(Context newContext) {
        return new BridgeInflater(this, newContext);
    }

    static Object getViewKeyFromParser(AttributeSet attrs, BridgeContext bc, ResourceReference resourceReference, boolean isInMerge) {
        if (!(attrs instanceof BridgeXmlBlockParser)) {
            return null;
        }
        BridgeXmlBlockParser parser = (BridgeXmlBlockParser)attrs;
        Object viewKey = parser.getViewCookie();
        if (viewKey == null) {
            int currentDepth = parser.getDepth();
            BridgeXmlBlockParser previousParser = bc.getPreviousParser();
            if (previousParser != null) {
                int testDepth;
                int n = testDepth = isInMerge ? 2 : 1;
                if (currentDepth == testDepth && (viewKey = previousParser.getViewCookie()) != null && isInMerge) {
                    viewKey = new MergeCookie(viewKey);
                }
            } else if (resourceReference != null && currentDepth == 1) {
                viewKey = resourceReference;
            }
        }
        return viewKey;
    }

    public void postInflateProcess(View view) {
        if (this.mOpenDrawerLayouts != null) {
            String gravity = this.mOpenDrawerLayouts.get(view);
            if (gravity != null) {
                DrawerLayoutUtil.openDrawer(view, gravity);
            }
            this.mOpenDrawerLayouts.remove(view);
        }
    }

    private Map<View, String> getDrawerLayoutMap() {
        if (this.mOpenDrawerLayouts == null) {
            this.mOpenDrawerLayouts = new HashMap<View, String>(4);
        }
        return this.mOpenDrawerLayouts;
    }

    public void onDoneInflation() {
        if (this.mOpenDrawerLayouts != null) {
            this.mOpenDrawerLayouts.clear();
        }
    }
}

