/*
 * Decompiled with CFR 0.152.
 */
package android.util.jar;

import android.util.jar.StrictJarManifestReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import libcore.io.Streams;

public class StrictJarManifest
implements Cloneable {
    static final int LINE_LENGTH_LIMIT = 72;
    private static final byte[] LINE_SEPARATOR = new byte[]{13, 10};
    private static final byte[] VALUE_SEPARATOR = new byte[]{58, 32};
    private final Attributes mainAttributes;
    private final HashMap<String, Attributes> entries;
    private HashMap<String, Chunk> chunks;
    private int mainEnd;

    public StrictJarManifest() {
        this.entries = new HashMap();
        this.mainAttributes = new Attributes();
    }

    public StrictJarManifest(InputStream is) throws IOException {
        this();
        this.read(Streams.readFully(is));
    }

    public StrictJarManifest(StrictJarManifest man) {
        this.mainAttributes = (Attributes)man.mainAttributes.clone();
        this.entries = (HashMap)((HashMap)man.getEntries()).clone();
    }

    StrictJarManifest(byte[] manifestBytes, boolean readChunks) throws IOException {
        this();
        if (readChunks) {
            this.chunks = new HashMap();
        }
        this.read(manifestBytes);
    }

    public void clear() {
        this.entries.clear();
        this.mainAttributes.clear();
    }

    public Attributes getAttributes(String name) {
        return this.getEntries().get(name);
    }

    public Map<String, Attributes> getEntries() {
        return this.entries;
    }

    public Attributes getMainAttributes() {
        return this.mainAttributes;
    }

    public Object clone() {
        return new StrictJarManifest(this);
    }

    public void write(OutputStream os) throws IOException {
        StrictJarManifest.write(this, os);
    }

    public void read(InputStream is) throws IOException {
        this.read(Streams.readFullyNoClose(is));
    }

    private void read(byte[] buf) throws IOException {
        if (buf.length == 0) {
            return;
        }
        StrictJarManifestReader im = new StrictJarManifestReader(buf, this.mainAttributes);
        this.mainEnd = im.getEndOfMainSection();
        im.readEntries(this.entries, this.chunks);
    }

    public int hashCode() {
        return this.mainAttributes.hashCode() ^ this.getEntries().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!this.mainAttributes.equals(((StrictJarManifest)o).mainAttributes)) {
            return false;
        }
        return this.getEntries().equals(((StrictJarManifest)o).getEntries());
    }

    Chunk getChunk(String name) {
        return this.chunks.get(name);
    }

    void removeChunks() {
        this.chunks = null;
    }

    int getMainAttributesEnd() {
        return this.mainEnd;
    }

    static void write(StrictJarManifest manifest, OutputStream out) throws IOException {
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        ByteBuffer buffer = ByteBuffer.allocate(72);
        Attributes.Name versionName = Attributes.Name.MANIFEST_VERSION;
        String version = manifest.mainAttributes.getValue(versionName);
        if (version == null) {
            versionName = Attributes.Name.SIGNATURE_VERSION;
            version = manifest.mainAttributes.getValue(versionName);
        }
        if (version != null) {
            StrictJarManifest.writeEntry(out, versionName, version, encoder, buffer);
            for (Attributes.Name name : manifest.mainAttributes.keySet()) {
                if (name.equals(versionName)) continue;
                StrictJarManifest.writeEntry(out, name, manifest.mainAttributes.getValue(name), encoder, buffer);
            }
        }
        out.write(LINE_SEPARATOR);
        for (String string2 : manifest.getEntries().keySet()) {
            StrictJarManifest.writeEntry(out, Attributes.Name.NAME, string2, encoder, buffer);
            Attributes attributes = manifest.entries.get(string2);
            for (Attributes.Name name : attributes.keySet()) {
                StrictJarManifest.writeEntry(out, name, attributes.getValue(name), encoder, buffer);
            }
            out.write(LINE_SEPARATOR);
        }
    }

    private static void writeEntry(OutputStream os, Attributes.Name name, String value, CharsetEncoder encoder, ByteBuffer bBuf) throws IOException {
        String nameString = name.toString();
        os.write(nameString.getBytes(StandardCharsets.US_ASCII));
        os.write(VALUE_SEPARATOR);
        encoder.reset();
        bBuf.clear().limit(72 - nameString.length() - 2);
        CharBuffer cBuf = CharBuffer.wrap(value);
        while (true) {
            CoderResult r;
            if (CoderResult.UNDERFLOW == (r = encoder.encode(cBuf, bBuf, true))) {
                r = encoder.flush(bBuf);
            }
            os.write(bBuf.array(), bBuf.arrayOffset(), bBuf.position());
            os.write(LINE_SEPARATOR);
            if (CoderResult.UNDERFLOW == r) break;
            os.write(32);
            bBuf.clear().limit(71);
        }
    }

    static class Chunk {
        final int start;
        final int end;

        Chunk(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

