/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.UserHandle;
import android.os.ZygoteStartFailedEx;
import android.system.Os;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Process {
    private static final String LOG_TAG = "Process";
    public static final String ZYGOTE_SOCKET = "zygote";
    public static final String SECONDARY_ZYGOTE_SOCKET = "zygote_secondary";
    public static final int ROOT_UID = 0;
    public static final int SYSTEM_UID = 1000;
    public static final int PHONE_UID = 1001;
    public static final int SHELL_UID = 2000;
    public static final int LOG_UID = 1007;
    public static final int WIFI_UID = 1010;
    public static final int MEDIA_UID = 1013;
    public static final int DRM_UID = 1019;
    public static final int VPN_UID = 1016;
    public static final int NFC_UID = 1027;
    public static final int BLUETOOTH_UID = 1002;
    public static final int MEDIA_RW_GID = 1023;
    public static final int PACKAGE_INFO_GID = 1032;
    public static final int SHARED_RELRO_UID = 1037;
    public static final int AUDIOSERVER_UID = 1041;
    public static final int CAMERASERVER_UID = 1047;
    public static final int FIRST_APPLICATION_UID = 10000;
    public static final int LAST_APPLICATION_UID = 19999;
    public static final int FIRST_ISOLATED_UID = 99000;
    public static final int LAST_ISOLATED_UID = 99999;
    public static final int SHARED_USER_GID = 9997;
    public static final int FIRST_SHARED_APPLICATION_GID = 50000;
    public static final int LAST_SHARED_APPLICATION_GID = 59999;
    public static final int THREAD_PRIORITY_DEFAULT = 0;
    public static final int THREAD_PRIORITY_LOWEST = 19;
    public static final int THREAD_PRIORITY_BACKGROUND = 10;
    public static final int THREAD_PRIORITY_FOREGROUND = -2;
    public static final int THREAD_PRIORITY_DISPLAY = -4;
    public static final int THREAD_PRIORITY_URGENT_DISPLAY = -8;
    public static final int THREAD_PRIORITY_AUDIO = -16;
    public static final int THREAD_PRIORITY_URGENT_AUDIO = -19;
    public static final int THREAD_PRIORITY_MORE_FAVORABLE = -1;
    public static final int THREAD_PRIORITY_LESS_FAVORABLE = 1;
    public static final int SCHED_OTHER = 0;
    public static final int SCHED_FIFO = 1;
    public static final int SCHED_RR = 2;
    public static final int SCHED_BATCH = 3;
    public static final int SCHED_IDLE = 5;
    public static final int THREAD_GROUP_DEFAULT = -1;
    public static final int THREAD_GROUP_BG_NONINTERACTIVE = 0;
    private static final int THREAD_GROUP_FOREGROUND = 1;
    public static final int THREAD_GROUP_SYSTEM = 2;
    public static final int THREAD_GROUP_AUDIO_APP = 3;
    public static final int THREAD_GROUP_AUDIO_SYS = 4;
    public static final int THREAD_GROUP_TOP_APP = 5;
    public static final int SIGNAL_QUIT = 3;
    public static final int SIGNAL_KILL = 9;
    public static final int SIGNAL_USR1 = 10;
    private static long sStartElapsedRealtime;
    private static long sStartUptimeMillis;
    static ZygoteState primaryZygoteState;
    static ZygoteState secondaryZygoteState;
    static final int ZYGOTE_RETRY_MILLIS = 500;
    public static final int PROC_TERM_MASK = 255;
    public static final int PROC_ZERO_TERM = 0;
    public static final int PROC_SPACE_TERM = 32;
    public static final int PROC_TAB_TERM = 9;
    public static final int PROC_COMBINE = 256;
    public static final int PROC_PARENS = 512;
    public static final int PROC_QUOTES = 1024;
    public static final int PROC_CHAR = 2048;
    public static final int PROC_OUT_STRING = 4096;
    public static final int PROC_OUT_LONG = 8192;
    public static final int PROC_OUT_FLOAT = 16384;

    public static ProcessStartResult start(String processClass, String niceName, int uid, int gid, int[] gids, int debugFlags, int mountExternal, int targetSdkVersion, String seInfo, String abi, String instructionSet, String appDataDir, String[] zygoteArgs) {
        try {
            return Process.startViaZygote(processClass, niceName, uid, gid, gids, debugFlags, mountExternal, targetSdkVersion, seInfo, abi, instructionSet, appDataDir, zygoteArgs);
        }
        catch (ZygoteStartFailedEx ex) {
            Log.e(LOG_TAG, "Starting VM process through Zygote failed");
            throw new RuntimeException("Starting VM process through Zygote failed", ex);
        }
    }

    private static String getAbiList(BufferedWriter writer, DataInputStream inputStream) throws IOException {
        writer.write("1");
        writer.newLine();
        writer.write("--query-abi-list");
        writer.newLine();
        writer.flush();
        int numBytes = inputStream.readInt();
        byte[] bytes = new byte[numBytes];
        inputStream.readFully(bytes);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    private static ProcessStartResult zygoteSendArgsAndGetResult(ZygoteState zygoteState, ArrayList<String> args) throws ZygoteStartFailedEx {
        try {
            int sz = args.size();
            for (int i = 0; i < sz; ++i) {
                if (args.get(i).indexOf(10) < 0) continue;
                throw new ZygoteStartFailedEx("embedded newlines not allowed");
            }
            BufferedWriter writer = zygoteState.writer;
            DataInputStream inputStream = zygoteState.inputStream;
            writer.write(Integer.toString(args.size()));
            writer.newLine();
            for (int i = 0; i < sz; ++i) {
                String arg = args.get(i);
                writer.write(arg);
                writer.newLine();
            }
            writer.flush();
            ProcessStartResult result = new ProcessStartResult();
            result.pid = inputStream.readInt();
            result.usingWrapper = inputStream.readBoolean();
            if (result.pid < 0) {
                throw new ZygoteStartFailedEx("fork() failed");
            }
            return result;
        }
        catch (IOException ex) {
            zygoteState.close();
            throw new ZygoteStartFailedEx(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProcessStartResult startViaZygote(String processClass, String niceName, int uid, int gid, int[] gids, int debugFlags, int mountExternal, int targetSdkVersion, String seInfo, String abi, String instructionSet, String appDataDir, String[] extraArgs) throws ZygoteStartFailedEx {
        Class<Process> clazz = Process.class;
        synchronized (Process.class) {
            ArrayList<String> argsForZygote = new ArrayList<String>();
            argsForZygote.add("--runtime-args");
            argsForZygote.add("--setuid=" + uid);
            argsForZygote.add("--setgid=" + gid);
            if ((debugFlags & 0x10) != 0) {
                argsForZygote.add("--enable-jni-logging");
            }
            if ((debugFlags & 8) != 0) {
                argsForZygote.add("--enable-safemode");
            }
            if ((debugFlags & 1) != 0) {
                argsForZygote.add("--enable-debugger");
            }
            if ((debugFlags & 2) != 0) {
                argsForZygote.add("--enable-checkjni");
            }
            if ((debugFlags & 0x20) != 0) {
                argsForZygote.add("--generate-debug-info");
            }
            if ((debugFlags & 0x40) != 0) {
                argsForZygote.add("--always-jit");
            }
            if ((debugFlags & 0x80) != 0) {
                argsForZygote.add("--native-debuggable");
            }
            if ((debugFlags & 4) != 0) {
                argsForZygote.add("--enable-assert");
            }
            if (mountExternal == 1) {
                argsForZygote.add("--mount-external-default");
            } else if (mountExternal == 2) {
                argsForZygote.add("--mount-external-read");
            } else if (mountExternal == 3) {
                argsForZygote.add("--mount-external-write");
            }
            argsForZygote.add("--target-sdk-version=" + targetSdkVersion);
            if (gids != null && gids.length > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("--setgroups=");
                int sz = gids.length;
                for (int i = 0; i < sz; ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append(gids[i]);
                }
                argsForZygote.add(sb.toString());
            }
            if (niceName != null) {
                argsForZygote.add("--nice-name=" + niceName);
            }
            if (seInfo != null) {
                argsForZygote.add("--seinfo=" + seInfo);
            }
            if (instructionSet != null) {
                argsForZygote.add("--instruction-set=" + instructionSet);
            }
            if (appDataDir != null) {
                argsForZygote.add("--app-data-dir=" + appDataDir);
            }
            argsForZygote.add(processClass);
            if (extraArgs != null) {
                for (String arg : extraArgs) {
                    argsForZygote.add(arg);
                }
            }
            // ** MonitorExit[var13_13] (shouldn't be in output)
            return Process.zygoteSendArgsAndGetResult(Process.openZygoteSocketIfNeeded(abi), argsForZygote);
        }
    }

    public static void establishZygoteConnectionForAbi(String abi) {
        try {
            Process.openZygoteSocketIfNeeded(abi);
        }
        catch (ZygoteStartFailedEx ex) {
            throw new RuntimeException("Unable to connect to zygote for abi: " + abi, ex);
        }
    }

    private static ZygoteState openZygoteSocketIfNeeded(String abi) throws ZygoteStartFailedEx {
        if (primaryZygoteState == null || primaryZygoteState.isClosed()) {
            try {
                primaryZygoteState = ZygoteState.connect(ZYGOTE_SOCKET);
            }
            catch (IOException ioe) {
                throw new ZygoteStartFailedEx("Error connecting to primary zygote", ioe);
            }
        }
        if (primaryZygoteState.matches(abi)) {
            return primaryZygoteState;
        }
        if (secondaryZygoteState == null || secondaryZygoteState.isClosed()) {
            try {
                secondaryZygoteState = ZygoteState.connect(SECONDARY_ZYGOTE_SOCKET);
            }
            catch (IOException ioe) {
                throw new ZygoteStartFailedEx("Error connecting to secondary zygote", ioe);
            }
        }
        if (secondaryZygoteState.matches(abi)) {
            return secondaryZygoteState;
        }
        throw new ZygoteStartFailedEx("Unsupported zygote ABI: " + abi);
    }

    public static long getElapsedCpuTime() {
        return OverrideMethod.invokeL("android.os.Process#getElapsedCpuTime()J", true, null);
    }

    public static long getStartElapsedRealtime() {
        return sStartElapsedRealtime;
    }

    public static long getStartUptimeMillis() {
        return sStartUptimeMillis;
    }

    public static void setStartTimes(long elapsedRealtime, long uptimeMillis) {
        sStartElapsedRealtime = elapsedRealtime;
        sStartUptimeMillis = uptimeMillis;
    }

    public static boolean is64Bit() {
        return VMRuntime.getRuntime().is64Bit();
    }

    public static int myPid() {
        return Os.getpid();
    }

    public static int myPpid() {
        return Os.getppid();
    }

    public static int myTid() {
        return Os.gettid();
    }

    public static int myUid() {
        return Os.getuid();
    }

    public static UserHandle myUserHandle() {
        return UserHandle.of(UserHandle.getUserId(Process.myUid()));
    }

    public static boolean isApplicationUid(int uid) {
        return UserHandle.isApp(uid);
    }

    public static boolean isIsolated() {
        return Process.isIsolated(Process.myUid());
    }

    public static boolean isIsolated(int uid) {
        return (uid = UserHandle.getAppId(uid)) >= 99000 && uid <= 99999;
    }

    public static int getUidForName(String string2) {
        return OverrideMethod.invokeI("android.os.Process#getUidForName(Ljava/lang/String;)I", true, null);
    }

    public static int getGidForName(String string2) {
        return OverrideMethod.invokeI("android.os.Process#getGidForName(Ljava/lang/String;)I", true, null);
    }

    public static int getUidForPid(int pid) {
        String[] procStatusLabels = new String[]{"Uid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + pid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    public static int getParentPid(int pid) {
        String[] procStatusLabels = new String[]{"PPid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + pid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    public static int getThreadGroupLeader(int tid) {
        String[] procStatusLabels = new String[]{"Tgid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + tid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    public static void setThreadPriority(int n, int n2) throws IllegalArgumentException, SecurityException {
        OverrideMethod.invokeV("android.os.Process#setThreadPriority(II)V", true, null);
    }

    public static void setCanSelfBackground(boolean bl) {
        OverrideMethod.invokeV("android.os.Process#setCanSelfBackground(Z)V", true, null);
    }

    public static void setThreadGroup(int n, int n2) throws IllegalArgumentException, SecurityException {
        OverrideMethod.invokeV("android.os.Process#setThreadGroup(II)V", true, null);
    }

    public static void setProcessGroup(int n, int n2) throws IllegalArgumentException, SecurityException {
        OverrideMethod.invokeV("android.os.Process#setProcessGroup(II)V", true, null);
    }

    public static int getProcessGroup(int n) throws IllegalArgumentException, SecurityException {
        return OverrideMethod.invokeI("android.os.Process#getProcessGroup(I)I", true, null);
    }

    public static int[] getExclusiveCores() {
        return (int[])OverrideMethod.invokeA("android.os.Process#getExclusiveCores()[I", true, null);
    }

    public static void setThreadPriority(int n) throws IllegalArgumentException, SecurityException {
        OverrideMethod.invokeV("android.os.Process#setThreadPriority(I)V", true, null);
    }

    public static int getThreadPriority(int n) throws IllegalArgumentException {
        return OverrideMethod.invokeI("android.os.Process#getThreadPriority(I)I", true, null);
    }

    public static void setThreadScheduler(int n, int n2, int n3) throws IllegalArgumentException {
        OverrideMethod.invokeV("android.os.Process#setThreadScheduler(III)V", true, null);
    }

    @Deprecated
    public static boolean supportsProcesses() {
        return true;
    }

    public static boolean setSwappiness(int n, boolean bl) {
        return OverrideMethod.invokeI("android.os.Process#setSwappiness(IZ)Z", true, null) != 0;
    }

    public static void setArgV0(String string2) {
        OverrideMethod.invokeV("android.os.Process#setArgV0(Ljava/lang/String;)V", true, null);
    }

    public static void killProcess(int pid) {
        Process.sendSignal(pid, 9);
    }

    public static int setUid(int n) {
        return OverrideMethod.invokeI("android.os.Process#setUid(I)I", true, null);
    }

    public static int setGid(int n) {
        return OverrideMethod.invokeI("android.os.Process#setGid(I)I", true, null);
    }

    public static void sendSignal(int n, int n2) {
        OverrideMethod.invokeV("android.os.Process#sendSignal(II)V", true, null);
    }

    public static void killProcessQuiet(int pid) {
        Process.sendSignalQuiet(pid, 9);
    }

    public static void sendSignalQuiet(int n, int n2) {
        OverrideMethod.invokeV("android.os.Process#sendSignalQuiet(II)V", true, null);
    }

    public static long getFreeMemory() {
        return OverrideMethod.invokeL("android.os.Process#getFreeMemory()J", true, null);
    }

    public static long getTotalMemory() {
        return OverrideMethod.invokeL("android.os.Process#getTotalMemory()J", true, null);
    }

    public static void readProcLines(String string2, String[] stringArray, long[] lArray) {
        OverrideMethod.invokeV("android.os.Process#readProcLines(Ljava/lang/String;[Ljava/lang/String;[J)V", true, null);
    }

    public static int[] getPids(String string2, int[] nArray) {
        return (int[])OverrideMethod.invokeA("android.os.Process#getPids(Ljava/lang/String;[I)[I", true, null);
    }

    public static boolean readProcFile(String string2, int[] nArray, String[] stringArray, long[] lArray, float[] fArray) {
        return OverrideMethod.invokeI("android.os.Process#readProcFile(Ljava/lang/String;[I[Ljava/lang/String;[J[F)Z", true, null) != 0;
    }

    public static boolean parseProcLine(byte[] byArray, int n, int n2, int[] nArray, String[] stringArray, long[] lArray, float[] fArray) {
        return OverrideMethod.invokeI("android.os.Process#parseProcLine([BII[I[Ljava/lang/String;[J[F)Z", true, null) != 0;
    }

    public static int[] getPidsForCommands(String[] stringArray) {
        return (int[])OverrideMethod.invokeA("android.os.Process#getPidsForCommands([Ljava/lang/String;)[I", true, null);
    }

    public static long getPss(int n) {
        return OverrideMethod.invokeL("android.os.Process#getPss(I)J", true, null);
    }

    public static int killProcessGroup(int n, int n2) {
        return OverrideMethod.invokeI("android.os.Process#killProcessGroup(II)I", true, null);
    }

    public static void removeAllProcessGroups() {
        OverrideMethod.invokeV("android.os.Process#removeAllProcessGroups()V", true, null);
    }

    public static class ProcessStartResult {
        public int pid;
        public boolean usingWrapper;
    }

    public static class ZygoteState {
        final LocalSocket socket;
        final DataInputStream inputStream;
        final BufferedWriter writer;
        final List<String> abiList;
        boolean mClosed;

        private ZygoteState(LocalSocket socket, DataInputStream inputStream, BufferedWriter writer, List<String> abiList) {
            this.socket = socket;
            this.inputStream = inputStream;
            this.writer = writer;
            this.abiList = abiList;
        }

        public static ZygoteState connect(String socketAddress) throws IOException {
            DataInputStream zygoteInputStream = null;
            BufferedWriter zygoteWriter = null;
            LocalSocket zygoteSocket = new LocalSocket();
            try {
                zygoteSocket.connect(new LocalSocketAddress(socketAddress, LocalSocketAddress.Namespace.RESERVED));
                zygoteInputStream = new DataInputStream(zygoteSocket.getInputStream());
                zygoteWriter = new BufferedWriter(new OutputStreamWriter(zygoteSocket.getOutputStream()), 256);
            }
            catch (IOException ex) {
                try {
                    zygoteSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw ex;
            }
            String abiListString = Process.getAbiList(zygoteWriter, zygoteInputStream);
            Log.i("Zygote", "Process: zygote socket opened, supported ABIS: " + abiListString);
            return new ZygoteState(zygoteSocket, zygoteInputStream, zygoteWriter, Arrays.asList(abiListString.split(",")));
        }

        boolean matches(String abi) {
            return this.abiList.contains(abi);
        }

        public void close() {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                Log.e(Process.LOG_TAG, "I/O exception on routine close", ex);
            }
            this.mClosed = true;
        }

        boolean isClosed() {
            return this.mClosed;
        }
    }
}

