/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.Application;
import android.app.ApplicationLoaders;
import android.app.ContextImpl;
import android.app.IActivityManager;
import android.app.IServiceConnection;
import android.app.Instrumentation;
import android.app.IntentReceiverLeaked;
import android.app.ServiceConnectionLeaked;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.StrictMode;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.view.DisplayAdjustments;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;

public class LoadedApk {
    private static final String TAG = "LoadedApk";
    private final ActivityThread mActivityThread;
    final String mPackageName;
    private ApplicationInfo mApplicationInfo;
    private String mAppDir;
    private String mResDir;
    private String[] mSplitAppDirs;
    private String[] mSplitResDirs;
    private String[] mOverlayDirs;
    private String[] mSharedLibraries;
    private String mDataDir;
    private String mLibDir;
    private File mDataDirFile;
    private File mDeviceProtectedDataDirFile;
    private File mCredentialProtectedDataDirFile;
    private final ClassLoader mBaseClassLoader;
    private final boolean mSecurityViolation;
    private final boolean mIncludeCode;
    private final boolean mRegisterPackage;
    private final DisplayAdjustments mDisplayAdjustments = new DisplayAdjustments();
    Resources mResources;
    private ClassLoader mClassLoader;
    private Application mApplication;
    private final ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> mReceivers = new ArrayMap();
    private final ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> mUnregisteredReceivers = new ArrayMap();
    private final ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> mServices = new ArrayMap();
    private final ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> mUnboundServices = new ArrayMap();
    int mClientCount = 0;

    Application getApplication() {
        return this.mApplication;
    }

    public LoadedApk(ActivityThread activityThread, ApplicationInfo aInfo, CompatibilityInfo compatInfo, ClassLoader baseLoader, boolean securityViolation, boolean includeCode, boolean registerPackage) {
        this.mActivityThread = activityThread;
        this.setApplicationInfo(aInfo);
        this.mPackageName = aInfo.packageName;
        this.mBaseClassLoader = baseLoader;
        this.mSecurityViolation = securityViolation;
        this.mIncludeCode = includeCode;
        this.mRegisterPackage = registerPackage;
        this.mDisplayAdjustments.setCompatibilityInfo(compatInfo);
    }

    private static ApplicationInfo adjustNativeLibraryPaths(ApplicationInfo info) {
        if (info.primaryCpuAbi != null && info.secondaryCpuAbi != null) {
            String runtimeIsa = VMRuntime.getRuntime().vmInstructionSet();
            String secondaryIsa = VMRuntime.getInstructionSet(info.secondaryCpuAbi);
            String secondaryDexCodeIsa = SystemProperties.get("ro.dalvik.vm.isa." + secondaryIsa);
            String string2 = secondaryIsa = secondaryDexCodeIsa.isEmpty() ? secondaryIsa : secondaryDexCodeIsa;
            if (runtimeIsa.equals(secondaryIsa)) {
                ApplicationInfo modified = new ApplicationInfo(info);
                modified.nativeLibraryDir = modified.secondaryNativeLibraryDir;
                modified.primaryCpuAbi = modified.secondaryCpuAbi;
                return modified;
            }
        }
        return info;
    }

    LoadedApk(ActivityThread activityThread) {
        this.mActivityThread = activityThread;
        this.mApplicationInfo = new ApplicationInfo();
        this.mApplicationInfo.packageName = "android";
        this.mPackageName = "android";
        this.mAppDir = null;
        this.mResDir = null;
        this.mSplitAppDirs = null;
        this.mSplitResDirs = null;
        this.mOverlayDirs = null;
        this.mSharedLibraries = null;
        this.mDataDir = null;
        this.mDataDirFile = null;
        this.mDeviceProtectedDataDirFile = null;
        this.mCredentialProtectedDataDirFile = null;
        this.mLibDir = null;
        this.mBaseClassLoader = null;
        this.mSecurityViolation = false;
        this.mIncludeCode = true;
        this.mRegisterPackage = false;
        this.mClassLoader = ClassLoader.getSystemClassLoader();
        this.mResources = Resources.getSystem();
    }

    void installSystemApplicationInfo(ApplicationInfo info, ClassLoader classLoader) {
        assert (info.packageName.equals("android"));
        this.mApplicationInfo = info;
        this.mClassLoader = classLoader;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.mApplicationInfo;
    }

    public int getTargetSdkVersion() {
        return this.mApplicationInfo.targetSdkVersion;
    }

    public boolean isSecurityViolation() {
        return this.mSecurityViolation;
    }

    public CompatibilityInfo getCompatibilityInfo() {
        return this.mDisplayAdjustments.getCompatibilityInfo();
    }

    public void setCompatibilityInfo(CompatibilityInfo compatInfo) {
        this.mDisplayAdjustments.setCompatibilityInfo(compatInfo);
    }

    private static String[] getLibrariesFor(String packageName) {
        ApplicationInfo ai = null;
        try {
            ai = ActivityThread.getPackageManager().getApplicationInfo(packageName, 1024, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (ai == null) {
            return null;
        }
        return ai.sharedLibraryFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateApplicationInfo(ApplicationInfo aInfo, List<String> oldPaths) {
        this.setApplicationInfo(aInfo);
        ArrayList<String> newPaths = new ArrayList<String>();
        LoadedApk.makePaths(this.mActivityThread, aInfo, newPaths, null);
        ArrayList<String> addedPaths = new ArrayList<String>(newPaths.size());
        if (oldPaths != null) {
            for (String path : newPaths) {
                String apkName = path.substring(path.lastIndexOf(File.separator));
                boolean match = false;
                for (String oldPath : oldPaths) {
                    String oldApkName = oldPath.substring(path.lastIndexOf(File.separator));
                    if (!apkName.equals(oldApkName)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                addedPaths.add(path);
            }
        } else {
            addedPaths.addAll(newPaths);
        }
        LoadedApk loadedApk = this;
        synchronized (loadedApk) {
            this.createOrUpdateClassLoaderLocked(addedPaths);
            if (this.mResources != null) {
                this.mResources = this.mActivityThread.getTopLevelResources(this.mResDir, this.mSplitResDirs, this.mOverlayDirs, this.mApplicationInfo.sharedLibraryFiles, 0, this);
            }
        }
    }

    private void setApplicationInfo(ApplicationInfo aInfo) {
        int myUid = Process.myUid();
        this.mApplicationInfo = aInfo = LoadedApk.adjustNativeLibraryPaths(aInfo);
        this.mAppDir = aInfo.sourceDir;
        this.mResDir = aInfo.uid == myUid ? aInfo.sourceDir : aInfo.publicSourceDir;
        this.mSplitAppDirs = aInfo.splitSourceDirs;
        this.mSplitResDirs = aInfo.uid == myUid ? aInfo.splitSourceDirs : aInfo.splitPublicSourceDirs;
        this.mOverlayDirs = aInfo.resourceDirs;
        this.mSharedLibraries = aInfo.sharedLibraryFiles;
        this.mDataDir = aInfo.dataDir;
        this.mLibDir = aInfo.nativeLibraryDir;
        this.mDataDirFile = FileUtils.newFileOrNull(aInfo.dataDir);
        this.mDeviceProtectedDataDirFile = FileUtils.newFileOrNull(aInfo.deviceProtectedDataDir);
        this.mCredentialProtectedDataDirFile = FileUtils.newFileOrNull(aInfo.credentialProtectedDataDir);
    }

    public static void makePaths(ActivityThread activityThread, ApplicationInfo aInfo, List<String> outZipPaths, List<String> outLibPaths) {
        String appDir = aInfo.sourceDir;
        String[] splitAppDirs = aInfo.splitSourceDirs;
        String libDir = aInfo.nativeLibraryDir;
        String[] sharedLibraries = aInfo.sharedLibraryFiles;
        outZipPaths.clear();
        outZipPaths.add(appDir);
        if (splitAppDirs != null) {
            Collections.addAll(outZipPaths, splitAppDirs);
        }
        if (outLibPaths != null) {
            outLibPaths.clear();
        }
        String instrumentationPackageName = activityThread.mInstrumentationPackageName;
        String instrumentationAppDir = activityThread.mInstrumentationAppDir;
        String[] instrumentationSplitAppDirs = activityThread.mInstrumentationSplitAppDirs;
        String instrumentationLibDir = activityThread.mInstrumentationLibDir;
        String instrumentedAppDir = activityThread.mInstrumentedAppDir;
        String[] instrumentedSplitAppDirs = activityThread.mInstrumentedSplitAppDirs;
        String instrumentedLibDir = activityThread.mInstrumentedLibDir;
        String[] instrumentationLibs = null;
        if (appDir.equals(instrumentationAppDir) || appDir.equals(instrumentedAppDir)) {
            outZipPaths.clear();
            outZipPaths.add(instrumentationAppDir);
            if (instrumentationSplitAppDirs != null) {
                Collections.addAll(outZipPaths, instrumentationSplitAppDirs);
            }
            if (!instrumentationAppDir.equals(instrumentedAppDir)) {
                outZipPaths.add(instrumentedAppDir);
                if (instrumentedSplitAppDirs != null) {
                    Collections.addAll(outZipPaths, instrumentedSplitAppDirs);
                }
            }
            if (outLibPaths != null) {
                outLibPaths.add(instrumentationLibDir);
                if (!instrumentationLibDir.equals(instrumentedLibDir)) {
                    outLibPaths.add(instrumentedLibDir);
                }
            }
            if (!instrumentedAppDir.equals(instrumentationAppDir)) {
                instrumentationLibs = LoadedApk.getLibrariesFor(instrumentationPackageName);
            }
        }
        if (outLibPaths != null) {
            if (outLibPaths.isEmpty()) {
                outLibPaths.add(libDir);
            }
            if (aInfo.primaryCpuAbi != null) {
                if (aInfo.targetSdkVersion <= 23) {
                    outLibPaths.add("/system/fake-libs" + (VMRuntime.is64BitAbi(aInfo.primaryCpuAbi) ? "64" : ""));
                }
                for (String apk : outZipPaths) {
                    outLibPaths.add(apk + "!/lib/" + aInfo.primaryCpuAbi);
                }
            }
            if (aInfo.isSystemApp() && !aInfo.isUpdatedSystemApp()) {
                outLibPaths.add(System.getProperty("java.library.path"));
            }
        }
        if (sharedLibraries != null) {
            for (String string2 : sharedLibraries) {
                if (outZipPaths.contains(string2)) continue;
                outZipPaths.add(0, string2);
            }
        }
        if (instrumentationLibs != null) {
            for (String string3 : instrumentationLibs) {
                if (outZipPaths.contains(string3)) continue;
                outZipPaths.add(0, string3);
            }
        }
    }

    private void createOrUpdateClassLoaderLocked(List<String> addedPaths) {
        if (this.mPackageName.equals("android")) {
            if (this.mClassLoader != null) {
                return;
            }
            this.mClassLoader = this.mBaseClassLoader != null ? this.mBaseClassLoader : ClassLoader.getSystemClassLoader();
            return;
        }
        if (!Objects.equals(this.mPackageName, ActivityThread.currentPackageName())) {
            VMRuntime.getRuntime().vmInstructionSet();
            try {
                ActivityThread.getPackageManager().notifyPackageUse(this.mPackageName, 6);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        if (this.mRegisterPackage) {
            try {
                ActivityManagerNative.getDefault().addPackageDependency(this.mPackageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        ArrayList<String> zipPaths = new ArrayList<String>(10);
        ArrayList<String> libPaths = new ArrayList<String>(10);
        LoadedApk.makePaths(this.mActivityThread, this.mApplicationInfo, zipPaths, libPaths);
        boolean isBundledApp = this.mApplicationInfo.isSystemApp() && !this.mApplicationInfo.isUpdatedSystemApp();
        String libraryPermittedPath = this.mDataDir;
        if (isBundledApp) {
            libraryPermittedPath = libraryPermittedPath + File.pathSeparator + System.getProperty("java.library.path");
        }
        String librarySearchPath = TextUtils.join((CharSequence)File.pathSeparator, libPaths);
        if (!this.mIncludeCode) {
            if (this.mClassLoader == null) {
                StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
                this.mClassLoader = ApplicationLoaders.getDefault().getClassLoader("", this.mApplicationInfo.targetSdkVersion, isBundledApp, librarySearchPath, libraryPermittedPath, this.mBaseClassLoader);
                StrictMode.setThreadPolicy(oldPolicy);
            }
            return;
        }
        String zip = zipPaths.size() == 1 ? (String)zipPaths.get(0) : TextUtils.join((CharSequence)File.pathSeparator, zipPaths);
        boolean needToSetupJitProfiles = false;
        if (this.mClassLoader == null) {
            StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
            this.mClassLoader = ApplicationLoaders.getDefault().getClassLoader(zip, this.mApplicationInfo.targetSdkVersion, isBundledApp, librarySearchPath, libraryPermittedPath, this.mBaseClassLoader);
            StrictMode.setThreadPolicy(oldPolicy);
            needToSetupJitProfiles = true;
        }
        if (addedPaths != null && addedPaths.size() > 0) {
            String add = TextUtils.join((CharSequence)File.pathSeparator, addedPaths);
            ApplicationLoaders.getDefault().addPath(this.mClassLoader, add);
            needToSetupJitProfiles = true;
        }
        if (needToSetupJitProfiles && !ActivityThread.isSystem()) {
            this.setupJitProfileSupport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        LoadedApk loadedApk = this;
        synchronized (loadedApk) {
            if (this.mClassLoader == null) {
                this.createOrUpdateClassLoaderLocked(null);
            }
            return this.mClassLoader;
        }
    }

    private static File getPrimaryProfileFile(String packageName) {
        File profileDir = Environment.getDataProfilesDePackageDirectory(UserHandle.myUserId(), packageName);
        return new File(profileDir, "primary.prof");
    }

    private void setupJitProfileSupport() {
        if (!SystemProperties.getBoolean("dalvik.vm.usejitprofiles", false)) {
            return;
        }
        if (this.mApplicationInfo.uid != Process.myUid()) {
            return;
        }
        ArrayList<String> codePaths = new ArrayList<String>();
        if ((this.mApplicationInfo.flags & 4) != 0) {
            codePaths.add(this.mApplicationInfo.sourceDir);
        }
        if (this.mApplicationInfo.splitSourceDirs != null) {
            Collections.addAll(codePaths, this.mApplicationInfo.splitSourceDirs);
        }
        if (codePaths.isEmpty()) {
            return;
        }
        File profileFile = LoadedApk.getPrimaryProfileFile(this.mPackageName);
        File foreignDexProfilesFile = Environment.getDataProfilesDeForeignDexDirectory(UserHandle.myUserId());
        VMRuntime.registerAppInfo(profileFile.getPath(), this.mApplicationInfo.dataDir, codePaths.toArray(new String[codePaths.size()]), foreignDexProfilesFile.getPath());
    }

    private void initializeJavaContextClassLoader() {
        PackageInfo pi;
        IPackageManager pm = ActivityThread.getPackageManager();
        try {
            pi = pm.getPackageInfo(this.mPackageName, 0x10000000, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (pi == null) {
            throw new IllegalStateException("Unable to get package info for " + this.mPackageName + "; is package not installed?");
        }
        boolean sharedUserIdSet = pi.sharedUserId != null;
        boolean processNameNotDefault = pi.applicationInfo != null && !this.mPackageName.equals(pi.applicationInfo.processName);
        boolean sharable = sharedUserIdSet || processNameNotDefault;
        ClassLoader contextClassLoader = sharable ? new WarningContextClassLoader() : this.mClassLoader;
        Thread.currentThread().setContextClassLoader(contextClassLoader);
    }

    public String getAppDir() {
        return this.mAppDir;
    }

    public String getLibDir() {
        return this.mLibDir;
    }

    public String getResDir() {
        return this.mResDir;
    }

    public String[] getSplitAppDirs() {
        return this.mSplitAppDirs;
    }

    public String[] getSplitResDirs() {
        return this.mSplitResDirs;
    }

    public String[] getOverlayDirs() {
        return this.mOverlayDirs;
    }

    public String getDataDir() {
        return this.mDataDir;
    }

    public File getDataDirFile() {
        return this.mDataDirFile;
    }

    public File getDeviceProtectedDataDirFile() {
        return this.mDeviceProtectedDataDirFile;
    }

    public File getCredentialProtectedDataDirFile() {
        return this.mCredentialProtectedDataDirFile;
    }

    public AssetManager getAssets(ActivityThread mainThread) {
        return this.getResources(mainThread).getAssets();
    }

    public Resources getResources(ActivityThread mainThread) {
        if (this.mResources == null) {
            this.mResources = mainThread.getTopLevelResources(this.mResDir, this.mSplitResDirs, this.mOverlayDirs, this.mApplicationInfo.sharedLibraryFiles, 0, this);
        }
        return this.mResources;
    }

    public Application makeApplication(boolean forceDefaultAppClass, Instrumentation instrumentation) {
        Application app;
        block10: {
            block9: {
                if (this.mApplication != null) {
                    return this.mApplication;
                }
                Trace.traceBegin(64L, "makeApplication");
                app = null;
                String appClass = this.mApplicationInfo.className;
                if (forceDefaultAppClass || appClass == null) {
                    appClass = "android.app.Application";
                }
                try {
                    ClassLoader cl = this.getClassLoader();
                    if (!this.mPackageName.equals("android")) {
                        Trace.traceBegin(64L, "initializeJavaContextClassLoader");
                        this.initializeJavaContextClassLoader();
                        Trace.traceEnd(64L);
                    }
                    ContextImpl appContext = ContextImpl.createAppContext(this.mActivityThread, this);
                    app = this.mActivityThread.mInstrumentation.newApplication(cl, appClass, appContext);
                    appContext.setOuterContext(app);
                }
                catch (Exception e) {
                    if (this.mActivityThread.mInstrumentation.onException(app, e)) break block9;
                    Trace.traceEnd(64L);
                    throw new RuntimeException("Unable to instantiate application " + appClass + ": " + e.toString(), e);
                }
            }
            this.mActivityThread.mAllApplications.add(app);
            this.mApplication = app;
            if (instrumentation != null) {
                try {
                    instrumentation.callApplicationOnCreate(app);
                }
                catch (Exception e) {
                    if (instrumentation.onException(app, e)) break block10;
                    Trace.traceEnd(64L);
                    throw new RuntimeException("Unable to create application " + app.getClass().getName() + ": " + e.toString(), e);
                }
            }
        }
        SparseArray<String> packageIdentifiers = this.getAssets(this.mActivityThread).getAssignedPackageIdentifiers();
        int N = packageIdentifiers.size();
        for (int i = 0; i < N; ++i) {
            int id2 = packageIdentifiers.keyAt(i);
            if (id2 == 1 || id2 == 127) continue;
            this.rewriteRValues(this.getClassLoader(), packageIdentifiers.valueAt(i), id2);
        }
        Trace.traceEnd(64L);
        return app;
    }

    private void rewriteRValues(ClassLoader cl, String packageName, int id2) {
        Throwable cause;
        Method callback;
        Class<?> rClazz;
        try {
            rClazz = cl.loadClass(packageName + ".R");
        }
        catch (ClassNotFoundException e) {
            Log.i(TAG, "No resource references to update in package " + packageName);
            return;
        }
        try {
            callback = rClazz.getMethod("onResourcesLoaded", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        try {
            callback.invoke(null, id2);
            return;
        }
        catch (IllegalAccessException e) {
            cause = e;
        }
        catch (InvocationTargetException e) {
            cause = e.getCause();
        }
        throw new RuntimeException("Failed to rewrite resource references for " + packageName, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextRegistrations(Context context, String who, String what) {
        AndroidRuntimeException leak;
        int i;
        boolean reportRegistrationLeaks = StrictMode.vmRegistrationLeaksEnabled();
        ArrayMap<Context, ArrayMap<Object, Object>> arrayMap = this.mReceivers;
        synchronized (arrayMap) {
            ArrayMap<BroadcastReceiver, ReceiverDispatcher> rmap = this.mReceivers.remove(context);
            if (rmap != null) {
                for (i = 0; i < rmap.size(); ++i) {
                    ReceiverDispatcher rd = rmap.valueAt(i);
                    leak = new IntentReceiverLeaked(what + " " + who + " has leaked IntentReceiver " + rd.getIntentReceiver() + " that was " + "originally registered here. Are you missing a " + "call to unregisterReceiver()?");
                    leak.setStackTrace(rd.getLocation().getStackTrace());
                    Slog.e("ActivityThread", leak.getMessage(), leak);
                    if (reportRegistrationLeaks) {
                        StrictMode.onIntentReceiverLeaked(leak);
                    }
                    try {
                        ActivityManagerNative.getDefault().unregisterReceiver(rd.getIIntentReceiver());
                        continue;
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
            this.mUnregisteredReceivers.remove(context);
        }
        arrayMap = this.mServices;
        synchronized (arrayMap) {
            ArrayMap<ServiceConnection, ServiceDispatcher> smap = this.mServices.remove(context);
            if (smap != null) {
                for (i = 0; i < smap.size(); ++i) {
                    ServiceDispatcher sd = smap.valueAt(i);
                    leak = new ServiceConnectionLeaked(what + " " + who + " has leaked ServiceConnection " + sd.getServiceConnection() + " that was originally bound here");
                    leak.setStackTrace(sd.getLocation().getStackTrace());
                    Slog.e("ActivityThread", leak.getMessage(), leak);
                    if (reportRegistrationLeaks) {
                        StrictMode.onServiceConnectionLeaked(leak);
                    }
                    try {
                        ActivityManagerNative.getDefault().unbindService(sd.getIServiceConnection());
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                    sd.doForget();
                }
            }
            this.mUnboundServices.remove(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIntentReceiver getReceiverDispatcher(BroadcastReceiver r, Context context, Handler handler, Instrumentation instrumentation, boolean registered) {
        ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> arrayMap = this.mReceivers;
        synchronized (arrayMap) {
            ReceiverDispatcher rd = null;
            ArrayMap<BroadcastReceiver, ReceiverDispatcher> map = null;
            if (registered && (map = this.mReceivers.get(context)) != null) {
                rd = map.get(r);
            }
            if (rd == null) {
                rd = new ReceiverDispatcher(r, context, handler, instrumentation, registered);
                if (registered) {
                    if (map == null) {
                        map = new ArrayMap();
                        this.mReceivers.put(context, map);
                    }
                    map.put(r, rd);
                }
            } else {
                rd.validate(context, handler);
            }
            rd.mForgotten = false;
            return rd.getIIntentReceiver();
        }
    }

    public IIntentReceiver forgetReceiverDispatcher(Context context, BroadcastReceiver r) {
        ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> arrayMap = this.mReceivers;
        synchronized (arrayMap) {
            ArrayMap<BroadcastReceiver, ReceiverDispatcher> map = this.mReceivers.get(context);
            ReceiverDispatcher rd = null;
            if (map != null && (rd = map.get(r)) != null) {
                map.remove(r);
                if (map.size() == 0) {
                    this.mReceivers.remove(context);
                }
                if (r.getDebugUnregister()) {
                    ArrayMap<BroadcastReceiver, ReceiverDispatcher> holder = this.mUnregisteredReceivers.get(context);
                    if (holder == null) {
                        holder = new ArrayMap();
                        this.mUnregisteredReceivers.put(context, holder);
                    }
                    IllegalArgumentException ex = new IllegalArgumentException("Originally unregistered here:");
                    ex.fillInStackTrace();
                    rd.setUnregisterLocation(ex);
                    holder.put(r, rd);
                }
                rd.mForgotten = true;
                return rd.getIIntentReceiver();
            }
            ArrayMap<BroadcastReceiver, ReceiverDispatcher> holder = this.mUnregisteredReceivers.get(context);
            if (holder != null && (rd = holder.get(r)) != null) {
                RuntimeException ex = rd.getUnregisterLocation();
                throw new IllegalArgumentException("Unregistering Receiver " + r + " that was already unregistered", ex);
            }
            if (context == null) {
                throw new IllegalStateException("Unbinding Receiver " + r + " from Context that is no longer in use: " + context);
            }
            throw new IllegalArgumentException("Receiver not registered: " + r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceConnection getServiceDispatcher(ServiceConnection c, Context context, Handler handler, int flags) {
        ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> arrayMap = this.mServices;
        synchronized (arrayMap) {
            ServiceDispatcher sd = null;
            ArrayMap<ServiceConnection, ServiceDispatcher> map = this.mServices.get(context);
            if (map != null) {
                sd = map.get(c);
            }
            if (sd == null) {
                sd = new ServiceDispatcher(c, context, handler, flags);
                if (map == null) {
                    map = new ArrayMap();
                    this.mServices.put(context, map);
                }
                map.put(c, sd);
            } else {
                sd.validate(context, handler);
            }
            return sd.getIServiceConnection();
        }
    }

    public IServiceConnection forgetServiceDispatcher(Context context, ServiceConnection c) {
        ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> arrayMap = this.mServices;
        synchronized (arrayMap) {
            ArrayMap<ServiceConnection, ServiceDispatcher> map = this.mServices.get(context);
            ServiceDispatcher sd = null;
            if (map != null && (sd = map.get(c)) != null) {
                map.remove(c);
                sd.doForget();
                if (map.size() == 0) {
                    this.mServices.remove(context);
                }
                if ((sd.getFlags() & 2) != 0) {
                    ArrayMap<ServiceConnection, ServiceDispatcher> holder = this.mUnboundServices.get(context);
                    if (holder == null) {
                        holder = new ArrayMap();
                        this.mUnboundServices.put(context, holder);
                    }
                    IllegalArgumentException ex = new IllegalArgumentException("Originally unbound here:");
                    ex.fillInStackTrace();
                    sd.setUnbindLocation(ex);
                    holder.put(c, sd);
                }
                return sd.getIServiceConnection();
            }
            ArrayMap<ServiceConnection, ServiceDispatcher> holder = this.mUnboundServices.get(context);
            if (holder != null && (sd = holder.get(c)) != null) {
                RuntimeException ex = sd.getUnbindLocation();
                throw new IllegalArgumentException("Unbinding Service " + c + " that was already unbound", ex);
            }
            if (context == null) {
                throw new IllegalStateException("Unbinding Service " + c + " from Context that is no longer in use: " + context);
            }
            throw new IllegalArgumentException("Service not registered: " + c);
        }
    }

    static class ServiceDispatcher {
        private final InnerConnection mIServiceConnection;
        private final ServiceConnection mConnection;
        private final Context mContext;
        private final Handler mActivityThread;
        private final ServiceConnectionLeaked mLocation;
        private final int mFlags;
        private RuntimeException mUnbindLocation;
        private boolean mForgotten;
        private final ArrayMap<ComponentName, ConnectionInfo> mActiveConnections = new ArrayMap();

        ServiceDispatcher(ServiceConnection conn, Context context, Handler activityThread, int flags) {
            this.mIServiceConnection = new InnerConnection(this);
            this.mConnection = conn;
            this.mContext = context;
            this.mActivityThread = activityThread;
            this.mLocation = new ServiceConnectionLeaked(null);
            this.mLocation.fillInStackTrace();
            this.mFlags = flags;
        }

        void validate(Context context, Handler activityThread) {
            if (this.mContext != context) {
                throw new RuntimeException("ServiceConnection " + this.mConnection + " registered with differing Context (was " + this.mContext + " now " + context + ")");
            }
            if (this.mActivityThread != activityThread) {
                throw new RuntimeException("ServiceConnection " + this.mConnection + " registered with differing handler (was " + this.mActivityThread + " now " + activityThread + ")");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doForget() {
            ServiceDispatcher serviceDispatcher = this;
            synchronized (serviceDispatcher) {
                for (int i = 0; i < this.mActiveConnections.size(); ++i) {
                    ConnectionInfo ci = this.mActiveConnections.valueAt(i);
                    ci.binder.unlinkToDeath(ci.deathMonitor, 0);
                }
                this.mActiveConnections.clear();
                this.mForgotten = true;
            }
        }

        ServiceConnectionLeaked getLocation() {
            return this.mLocation;
        }

        ServiceConnection getServiceConnection() {
            return this.mConnection;
        }

        IServiceConnection getIServiceConnection() {
            return this.mIServiceConnection;
        }

        int getFlags() {
            return this.mFlags;
        }

        void setUnbindLocation(RuntimeException ex) {
            this.mUnbindLocation = ex;
        }

        RuntimeException getUnbindLocation() {
            return this.mUnbindLocation;
        }

        public void connected(ComponentName name, IBinder service) {
            if (this.mActivityThread != null) {
                this.mActivityThread.post(new RunConnection(name, service, 0));
            } else {
                this.doConnected(name, service);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void death(ComponentName name, IBinder service) {
            ServiceDispatcher serviceDispatcher = this;
            synchronized (serviceDispatcher) {
                ConnectionInfo old = this.mActiveConnections.remove(name);
                if (old == null || old.binder != service) {
                    return;
                }
                old.binder.unlinkToDeath(old.deathMonitor, 0);
            }
            if (this.mActivityThread != null) {
                this.mActivityThread.post(new RunConnection(name, service, 1));
            } else {
                this.doDeath(name, service);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doConnected(ComponentName name, IBinder service) {
            ConnectionInfo old;
            ServiceDispatcher serviceDispatcher = this;
            synchronized (serviceDispatcher) {
                if (this.mForgotten) {
                    return;
                }
                old = this.mActiveConnections.get(name);
                if (old != null && old.binder == service) {
                    return;
                }
                if (service != null) {
                    ConnectionInfo info = new ConnectionInfo();
                    info.binder = service;
                    info.deathMonitor = new DeathMonitor(name, service);
                    try {
                        service.linkToDeath(info.deathMonitor, 0);
                        this.mActiveConnections.put(name, info);
                    }
                    catch (RemoteException e) {
                        this.mActiveConnections.remove(name);
                        return;
                    }
                } else {
                    this.mActiveConnections.remove(name);
                }
                if (old != null) {
                    old.binder.unlinkToDeath(old.deathMonitor, 0);
                }
            }
            if (old != null) {
                this.mConnection.onServiceDisconnected(name);
            }
            if (service != null) {
                this.mConnection.onServiceConnected(name, service);
            }
        }

        public void doDeath(ComponentName name, IBinder service) {
            this.mConnection.onServiceDisconnected(name);
        }

        private class DeathMonitor
        implements IBinder.DeathRecipient {
            final ComponentName mName;
            final IBinder mService;

            DeathMonitor(ComponentName name, IBinder service) {
                this.mName = name;
                this.mService = service;
            }

            @Override
            public void binderDied() {
                ServiceDispatcher.this.death(this.mName, this.mService);
            }
        }

        private class RunConnection
        implements Runnable {
            final ComponentName mName;
            final IBinder mService;
            final int mCommand;

            RunConnection(ComponentName name, IBinder service, int command) {
                this.mName = name;
                this.mService = service;
                this.mCommand = command;
            }

            @Override
            public void run() {
                if (this.mCommand == 0) {
                    ServiceDispatcher.this.doConnected(this.mName, this.mService);
                } else if (this.mCommand == 1) {
                    ServiceDispatcher.this.doDeath(this.mName, this.mService);
                }
            }
        }

        private static class InnerConnection
        extends IServiceConnection.Stub {
            final WeakReference<ServiceDispatcher> mDispatcher;

            InnerConnection(ServiceDispatcher sd) {
                this.mDispatcher = new WeakReference<ServiceDispatcher>(sd);
            }

            @Override
            public void connected(ComponentName name, IBinder service) throws RemoteException {
                ServiceDispatcher sd = (ServiceDispatcher)this.mDispatcher.get();
                if (sd != null) {
                    sd.connected(name, service);
                }
            }
        }

        private static class ConnectionInfo {
            IBinder binder;
            IBinder.DeathRecipient deathMonitor;

            private ConnectionInfo() {
            }
        }
    }

    static class ReceiverDispatcher {
        final IIntentReceiver.Stub mIIntentReceiver;
        final BroadcastReceiver mReceiver;
        final Context mContext;
        final Handler mActivityThread;
        final Instrumentation mInstrumentation;
        final boolean mRegistered;
        final IntentReceiverLeaked mLocation;
        RuntimeException mUnregisterLocation;
        boolean mForgotten;

        ReceiverDispatcher(BroadcastReceiver receiver, Context context, Handler activityThread, Instrumentation instrumentation, boolean registered) {
            if (activityThread == null) {
                throw new NullPointerException("Handler must not be null");
            }
            this.mIIntentReceiver = new InnerReceiver(this, !registered);
            this.mReceiver = receiver;
            this.mContext = context;
            this.mActivityThread = activityThread;
            this.mInstrumentation = instrumentation;
            this.mRegistered = registered;
            this.mLocation = new IntentReceiverLeaked(null);
            this.mLocation.fillInStackTrace();
        }

        void validate(Context context, Handler activityThread) {
            if (this.mContext != context) {
                throw new IllegalStateException("Receiver " + this.mReceiver + " registered with differing Context (was " + this.mContext + " now " + context + ")");
            }
            if (this.mActivityThread != activityThread) {
                throw new IllegalStateException("Receiver " + this.mReceiver + " registered with differing handler (was " + this.mActivityThread + " now " + activityThread + ")");
            }
        }

        IntentReceiverLeaked getLocation() {
            return this.mLocation;
        }

        BroadcastReceiver getIntentReceiver() {
            return this.mReceiver;
        }

        IIntentReceiver getIIntentReceiver() {
            return this.mIIntentReceiver;
        }

        void setUnregisterLocation(RuntimeException ex) {
            this.mUnregisterLocation = ex;
        }

        RuntimeException getUnregisterLocation() {
            return this.mUnregisterLocation;
        }

        public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
            Args args = new Args(intent, resultCode, data, extras, ordered, sticky, sendingUser);
            if (intent == null) {
                Log.wtf(LoadedApk.TAG, "Null intent received");
            }
            if ((intent == null || !this.mActivityThread.post(args)) && this.mRegistered && ordered) {
                IActivityManager mgr = ActivityManagerNative.getDefault();
                args.sendFinished(mgr);
            }
        }

        class Args
        extends BroadcastReceiver.PendingResult
        implements Runnable {
            private Intent mCurIntent;
            private final boolean mOrdered;
            private boolean mDispatched;

            public Args(Intent intent, int resultCode, String resultData, Bundle resultExtras, boolean ordered, boolean sticky, int sendingUser) {
                super(resultCode, resultData, resultExtras, ReceiverDispatcher.this.mRegistered ? 1 : 2, ordered, sticky, ReceiverDispatcher.this.mIIntentReceiver.asBinder(), sendingUser, intent.getFlags());
                this.mCurIntent = intent;
                this.mOrdered = ordered;
            }

            @Override
            public void run() {
                BroadcastReceiver receiver;
                block7: {
                    receiver = ReceiverDispatcher.this.mReceiver;
                    boolean ordered = this.mOrdered;
                    IActivityManager mgr = ActivityManagerNative.getDefault();
                    Intent intent = this.mCurIntent;
                    if (intent == null) {
                        Log.wtf(LoadedApk.TAG, "Null intent being dispatched, mDispatched=" + this.mDispatched);
                    }
                    this.mCurIntent = null;
                    this.mDispatched = true;
                    if (receiver == null || intent == null || ReceiverDispatcher.this.mForgotten) {
                        if (ReceiverDispatcher.this.mRegistered && ordered) {
                            this.sendFinished(mgr);
                        }
                        return;
                    }
                    Trace.traceBegin(64L, "broadcastReceiveReg");
                    try {
                        ClassLoader cl = ReceiverDispatcher.this.mReceiver.getClass().getClassLoader();
                        intent.setExtrasClassLoader(cl);
                        intent.prepareToEnterProcess();
                        this.setExtrasClassLoader(cl);
                        receiver.setPendingResult(this);
                        receiver.onReceive(ReceiverDispatcher.this.mContext, intent);
                    }
                    catch (Exception e) {
                        if (ReceiverDispatcher.this.mRegistered && ordered) {
                            this.sendFinished(mgr);
                        }
                        if (ReceiverDispatcher.this.mInstrumentation != null && ReceiverDispatcher.this.mInstrumentation.onException(ReceiverDispatcher.this.mReceiver, e)) break block7;
                        Trace.traceEnd(64L);
                        throw new RuntimeException("Error receiving broadcast " + intent + " in " + ReceiverDispatcher.this.mReceiver, e);
                    }
                }
                if (receiver.getPendingResult() != null) {
                    this.finish();
                }
                Trace.traceEnd(64L);
            }
        }

        static class InnerReceiver
        extends IIntentReceiver.Stub {
            final WeakReference<ReceiverDispatcher> mDispatcher;
            final ReceiverDispatcher mStrongRef;

            InnerReceiver(ReceiverDispatcher rd, boolean strong) {
                this.mDispatcher = new WeakReference<ReceiverDispatcher>(rd);
                this.mStrongRef = strong ? rd : null;
            }

            @Override
            public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                ReceiverDispatcher rd;
                if (intent == null) {
                    Log.wtf(LoadedApk.TAG, "Null intent received");
                    rd = null;
                } else {
                    rd = (ReceiverDispatcher)this.mDispatcher.get();
                }
                if (rd != null) {
                    rd.performReceive(intent, resultCode, data, extras, ordered, sticky, sendingUser);
                } else {
                    IActivityManager mgr = ActivityManagerNative.getDefault();
                    try {
                        if (extras != null) {
                            extras.setAllowFds(false);
                        }
                        mgr.finishReceiver(this, resultCode, data, extras, false, intent.getFlags());
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
        }
    }

    private static class WarningContextClassLoader
    extends ClassLoader {
        private static boolean warned = false;

        private WarningContextClassLoader() {
        }

        private void warn(String methodName) {
            if (warned) {
                return;
            }
            warned = true;
            Thread.currentThread().setContextClassLoader(this.getParent());
            Slog.w("ActivityThread", "ClassLoader." + methodName + ": " + "The class loader returned by " + "Thread.getContextClassLoader() may fail for processes " + "that host multiple applications. You should explicitly " + "specify a context class loader. For example: " + "Thread.setContextClassLoader(getClass().getClassLoader());");
        }

        @Override
        public URL getResource(String resName) {
            this.warn("getResource");
            return this.getParent().getResource(resName);
        }

        @Override
        public Enumeration<URL> getResources(String resName) throws IOException {
            this.warn("getResources");
            return this.getParent().getResources(resName);
        }

        @Override
        public InputStream getResourceAsStream(String resName) {
            this.warn("getResourceAsStream");
            return this.getParent().getResourceAsStream(resName);
        }

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            this.warn("loadClass");
            return this.getParent().loadClass(className);
        }

        @Override
        public void setClassAssertionStatus(String cname, boolean enable) {
            this.warn("setClassAssertionStatus");
            this.getParent().setClassAssertionStatus(cname, enable);
        }

        @Override
        public void setPackageAssertionStatus(String pname, boolean enable) {
            this.warn("setPackageAssertionStatus");
            this.getParent().setPackageAssertionStatus(pname, enable);
        }

        @Override
        public void setDefaultAssertionStatus(boolean enable) {
            this.warn("setDefaultAssertionStatus");
            this.getParent().setDefaultAssertionStatus(enable);
        }

        @Override
        public void clearAssertionStatus() {
            this.warn("clearAssertionStatus");
            this.getParent().clearAssertionStatus();
        }
    }
}

