/*
* Copyright (c) 1997, 2015, Oracle and/or its affiliates. All rights reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
*
* This code is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License version 2 only, as
* published by the Free Software Foundation.  Oracle designates this
* particular file as subject to the "Classpath" exception as provided
* by Oracle in the LICENSE file that accompanied this code.
*
* This code is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
* version 2 for more details (a copy is included in the LICENSE file that
* accompanied this code).
*
* You should have received a copy of the GNU General Public License version
* 2 along with this work; if not, write to the Free Software Foundation,
* Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
*
* Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
* or visit www.oracle.com if you need additional information or have any
* questions.
*/

package java.util;
public interface Map<K, V>
{
public static interface Entry<K, V>
{
public abstract  K getKey();
public abstract  V getValue();
public abstract  V setValue(V value);
public abstract  boolean equals(java.lang.Object o);
public abstract  int hashCode();
public static <K extends java.lang.Comparable<? super K>, V> java.util.Comparator<java.util.Map.Entry<K, V>> comparingByKey() { throw new RuntimeException("Stub!"); }
public static <K, V extends java.lang.Comparable<? super V>> java.util.Comparator<java.util.Map.Entry<K, V>> comparingByValue() { throw new RuntimeException("Stub!"); }
public static <K, V> java.util.Comparator<java.util.Map.Entry<K, V>> comparingByKey(java.util.Comparator<? super K> cmp) { throw new RuntimeException("Stub!"); }
public static <K, V> java.util.Comparator<java.util.Map.Entry<K, V>> comparingByValue(java.util.Comparator<? super V> cmp) { throw new RuntimeException("Stub!"); }
}
public abstract  int size();
public abstract  boolean isEmpty();
public abstract  boolean containsKey(java.lang.Object key);
public abstract  boolean containsValue(java.lang.Object value);
public abstract  V get(java.lang.Object key);
public abstract  V put(K key, V value);
public abstract  V remove(java.lang.Object key);
public abstract  void putAll(java.util.Map<? extends K, ? extends V> m);
public abstract  void clear();
public abstract  java.util.Set<K> keySet();
public abstract  java.util.Collection<V> values();
public abstract  java.util.Set<java.util.Map.Entry<K, V>> entrySet();
public abstract  boolean equals(java.lang.Object o);
public abstract  int hashCode();
default public  V getOrDefault(java.lang.Object key, V defaultValue) { throw new RuntimeException("Stub!"); }
default public  void forEach(java.util.function.BiConsumer<? super K, ? super V> action) { throw new RuntimeException("Stub!"); }
default public  void replaceAll(java.util.function.BiFunction<? super K, ? super V, ? extends V> function) { throw new RuntimeException("Stub!"); }
default public  V putIfAbsent(K key, V value) { throw new RuntimeException("Stub!"); }
default public  boolean remove(java.lang.Object key, java.lang.Object value) { throw new RuntimeException("Stub!"); }
default public  boolean replace(K key, V oldValue, V newValue) { throw new RuntimeException("Stub!"); }
default public  V replace(K key, V value) { throw new RuntimeException("Stub!"); }
default public  V computeIfAbsent(K key, java.util.function.Function<? super K, ? extends V> mappingFunction) { throw new RuntimeException("Stub!"); }
default public  V computeIfPresent(K key, java.util.function.BiFunction<? super K, ? super V, ? extends V> remappingFunction) { throw new RuntimeException("Stub!"); }
default public  V compute(K key, java.util.function.BiFunction<? super K, ? super V, ? extends V> remappingFunction) { throw new RuntimeException("Stub!"); }
default public  V merge(K key, V value, java.util.function.BiFunction<? super V, ? super V, ? extends V> remappingFunction) { throw new RuntimeException("Stub!"); }
}
