/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.fortress;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.harmony.security.fortress.Engine;

public class Services {
    private static Provider.Service cachedSecureRandomService;
    private static boolean needRefresh;
    private static int cacheVersion;
    private static final ArrayList<Provider> providers;
    private static final HashMap<String, Provider> providersNames;

    private static boolean initProvider(String providerClassName, ClassLoader classLoader) {
        try {
            Class<?> providerClass = Class.forName(providerClassName.trim(), true, classLoader);
            Provider p = (Provider)providerClass.newInstance();
            providers.add(p);
            providersNames.put(p.getName(), p);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return false;
    }

    public static synchronized ArrayList<Provider> getProviders() {
        return providers;
    }

    public static synchronized Provider getProvider(String name) {
        if (name == null) {
            return null;
        }
        return providersNames.get(name);
    }

    public static synchronized int insertProviderAt(Provider provider, int position) {
        int size = providers.size();
        if (position < 1 || position > size) {
            position = size + 1;
        }
        providers.add(position - 1, provider);
        providersNames.put(provider.getName(), provider);
        Services.setNeedRefresh();
        return position;
    }

    public static synchronized void removeProvider(int providerNumber) {
        Provider p = providers.remove(providerNumber - 1);
        providersNames.remove(p.getName());
        Services.setNeedRefresh();
    }

    public static synchronized ArrayList<Provider.Service> getServices(String type, String algorithm) {
        ArrayList<Provider.Service> services = null;
        for (Provider p : providers) {
            Provider.Service s = p.getService(type, algorithm);
            if (s == null) continue;
            if (services == null) {
                services = new ArrayList<Provider.Service>(providers.size());
            }
            services.add(s);
        }
        return services;
    }

    private static synchronized Provider.Service getFirstServiceOfType(String type) {
        for (Provider p : providers) {
            Provider.Service s = Engine.door.getService(p, type);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public static synchronized Provider.Service getSecureRandomService() {
        Services.getCacheVersion();
        return cachedSecureRandomService;
    }

    public static synchronized void setNeedRefresh() {
        needRefresh = true;
    }

    public static synchronized int getCacheVersion() {
        if (needRefresh) {
            ++cacheVersion;
            cachedSecureRandomService = Services.getFirstServiceOfType("SecureRandom");
            needRefresh = false;
        }
        return cacheVersion;
    }

    static {
        cacheVersion = 1;
        providers = new ArrayList(20);
        providersNames = new HashMap(20);
        String providerClassName = null;
        int i = 1;
        ClassLoader cl = Services.class.getClassLoader();
        while ((providerClassName = Security.getProperty("security.provider." + i++)) != null) {
            if (Services.initProvider(providerClassName, cl) || Services.initProvider(providerClassName, ClassLoader.getSystemClassLoader())) continue;
        }
        Engine.door.renumProviders();
        Services.setNeedRefresh();
    }
}

