/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import android.system.ErrnoException;
import com.android.tools.layoutlib.java.Charsets;
import com.android.tools.layoutlib.java.System_Delegate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import libcore.io.BufferIterator;
import libcore.io.MemoryMappedFile;
import libcore.util.BasicLruCache;
import libcore.util.ZoneInfo;

public class ZoneInfoDB {
    private static final TzData DATA = new TzData(System.getenv("ANDROID_DATA") + "/misc/zoneinfo/current/tzdata", System.getenv("ANDROID_ROOT") + "/usr/share/zoneinfo/tzdata");

    private ZoneInfoDB() {
    }

    public static TzData getInstance() {
        return DATA;
    }

    public static class TzData {
        private MemoryMappedFile mappedFile;
        private String version;
        private String zoneTab;
        private String[] ids;
        private int[] byteOffsets;
        private int[] rawUtcOffsetsCache;
        private static final int CACHE_SIZE = 1;
        private final BasicLruCache<String, ZoneInfo> cache = new BasicLruCache<String, ZoneInfo>(1){

            @Override
            protected ZoneInfo create(String id2) {
                int index = Arrays.binarySearch(TzData.this.ids, id2);
                if (index < 0) {
                    return null;
                }
                BufferIterator it = TzData.this.mappedFile.bigEndianIterator();
                it.skip(TzData.this.byteOffsets[index]);
                return ZoneInfo.makeTimeZone(id2, it);
            }
        };

        public TzData(String ... paths) {
            for (String path : paths) {
                if (!this.loadData(path)) continue;
                return;
            }
            System_Delegate.log("Couldn't find any tzdata!");
            this.version = "missing";
            this.zoneTab = "# Emergency fallback data.\n";
            this.ids = new String[]{"GMT"};
            this.rawUtcOffsetsCache = new int[1];
            this.byteOffsets = this.rawUtcOffsetsCache;
        }

        private boolean loadData(String path) {
            try {
                this.mappedFile = MemoryMappedFile.mmapRO(path);
            }
            catch (ErrnoException errnoException) {
                return false;
            }
            try {
                this.readHeader();
                return true;
            }
            catch (Exception ex) {
                System_Delegate.log("tzdata file \"" + path + "\" was present but invalid!", ex);
                return false;
            }
        }

        private void readHeader() {
            BufferIterator it = this.mappedFile.bigEndianIterator();
            byte[] tzdata_version = new byte[12];
            it.readByteArray(tzdata_version, 0, tzdata_version.length);
            String magic = new String(tzdata_version, 0, 6, Charsets.US_ASCII);
            if (!magic.equals("tzdata") || tzdata_version[11] != 0) {
                throw new RuntimeException("bad tzdata magic: " + Arrays.toString(tzdata_version));
            }
            this.version = new String(tzdata_version, 6, 5, Charsets.US_ASCII);
            int index_offset = it.readInt();
            int data_offset = it.readInt();
            int zonetab_offset = it.readInt();
            this.readIndex(it, index_offset, data_offset);
            this.readZoneTab(it, zonetab_offset, (int)this.mappedFile.size() - zonetab_offset);
        }

        private void readZoneTab(BufferIterator it, int zoneTabOffset, int zoneTabSize) {
            byte[] bytes = new byte[zoneTabSize];
            it.seek(zoneTabOffset);
            it.readByteArray(bytes, 0, bytes.length);
            this.zoneTab = new String(bytes, 0, bytes.length, Charsets.US_ASCII);
        }

        private void readIndex(BufferIterator it, int indexOffset, int dataOffset) {
            it.seek(indexOffset);
            int SIZEOF_TZNAME = 40;
            int SIZEOF_TZINT = 4;
            byte[] idBytes = new byte[40];
            int indexSize = dataOffset - indexOffset;
            int entryCount = indexSize / 52;
            char[] idChars = new char[entryCount * 40];
            int[] idEnd = new int[entryCount];
            int idOffset = 0;
            this.byteOffsets = new int[entryCount];
            for (int i = 0; i < entryCount; ++i) {
                it.readByteArray(idBytes, 0, idBytes.length);
                this.byteOffsets[i] = it.readInt();
                int n = i;
                this.byteOffsets[n] = this.byteOffsets[n] + dataOffset;
                int length = it.readInt();
                if (length < 44) {
                    throw new AssertionError((Object)"length in index file < sizeof(tzhead)");
                }
                it.skip(4);
                int len = idBytes.length;
                for (int j = 0; j < len && idBytes[j] != 0; ++j) {
                    idChars[idOffset++] = (char)(idBytes[j] & 0xFF);
                }
                idEnd[i] = idOffset;
            }
            String allIds = new String(idChars, 0, idOffset);
            this.ids = new String[entryCount];
            for (int i = 0; i < entryCount; ++i) {
                this.ids[i] = allIds.substring(i == 0 ? 0 : idEnd[i - 1], idEnd[i]);
            }
        }

        public String[] getAvailableIDs() {
            return (String[])this.ids.clone();
        }

        public String[] getAvailableIDs(int rawUtcOffset) {
            ArrayList<String> matches = new ArrayList<String>();
            int[] rawUtcOffsets = this.getRawUtcOffsets();
            for (int i = 0; i < rawUtcOffsets.length; ++i) {
                if (rawUtcOffsets[i] != rawUtcOffset) continue;
                matches.add(this.ids[i]);
            }
            return matches.toArray(new String[matches.size()]);
        }

        private synchronized int[] getRawUtcOffsets() {
            if (this.rawUtcOffsetsCache != null) {
                return this.rawUtcOffsetsCache;
            }
            this.rawUtcOffsetsCache = new int[this.ids.length];
            for (int i = 0; i < this.ids.length; ++i) {
                this.rawUtcOffsetsCache[i] = this.cache.get(this.ids[i]).getRawOffset();
            }
            return this.rawUtcOffsetsCache;
        }

        public String getVersion() {
            return this.version;
        }

        public String getZoneTab() {
            return this.zoneTab;
        }

        public ZoneInfo makeTimeZone(String id2) throws IOException {
            ZoneInfo zoneInfo = this.cache.get(id2);
            return zoneInfo == null ? null : (ZoneInfo)zoneInfo.clone();
        }

        public boolean hasTimeZone(String id2) throws IOException {
            return this.cache.get(id2) != null;
        }
    }
}

