/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import com.android.tools.layoutlib.create.OverrideMethod;
import com.android.tools.layoutlib.java.AutoCloseable;
import dalvik.system.CloseGuard;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.JarVerifier;
import java.util.jar.Manifest;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import libcore.io.IoUtils;
import libcore.io.Streams;

public class StrictJarFile {
    private final long nativeHandle;
    private final RandomAccessFile raf;
    private final Manifest manifest;
    private final JarVerifier verifier;
    private final boolean isSigned;
    private final CloseGuard guard = CloseGuard.get();
    private boolean closed;

    public StrictJarFile(String fileName) throws IOException, SecurityException {
        this.nativeHandle = StrictJarFile.nativeOpenJarFile(fileName);
        this.raf = new RandomAccessFile(fileName, "r");
        try {
            HashMap<String, byte[]> metaEntries = this.getMetaEntries();
            this.manifest = new Manifest(metaEntries.get("META-INF/MANIFEST.MF"), true);
            this.verifier = new JarVerifier(fileName, this.manifest, metaEntries);
            Set<String> files = this.manifest.getEntries().keySet();
            for (String file : files) {
                if (this.findEntry(file) != null) continue;
                throw new SecurityException(fileName + ": File " + file + " in manifest does not exist");
            }
            this.isSigned = this.verifier.readCertificates() && this.verifier.isSignedJar();
        }
        catch (IOException | SecurityException e) {
            StrictJarFile.nativeClose(this.nativeHandle);
            IoUtils.closeQuietly((AutoCloseable)((Object)this.raf));
            throw e;
        }
        this.guard.open("close");
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public Iterator<ZipEntry> iterator() throws IOException {
        return new EntryIterator(this.nativeHandle, "");
    }

    public ZipEntry findEntry(String name) {
        return StrictJarFile.nativeFindEntry(this.nativeHandle, name);
    }

    public Certificate[][] getCertificateChains(ZipEntry ze) {
        if (this.isSigned) {
            return this.verifier.getCertificateChains(ze.getName());
        }
        return null;
    }

    @Deprecated
    public Certificate[] getCertificates(ZipEntry ze) {
        if (this.isSigned) {
            Certificate[][] certChains = this.verifier.getCertificateChains(ze.getName());
            int count = 0;
            for (Certificate[] chain : certChains) {
                count += chain.length;
            }
            Certificate[] certs = new Certificate[count];
            int i = 0;
            for (Certificate[] chain : certChains) {
                System.arraycopy(chain, 0, certs, i, chain.length);
                i += chain.length;
            }
            return certs;
        }
        return null;
    }

    public InputStream getInputStream(ZipEntry ze) {
        InputStream is = this.getZipInputStream(ze);
        if (this.isSigned) {
            JarVerifier.VerifierEntry entry = this.verifier.initEntry(ze.getName());
            if (entry == null) {
                return is;
            }
            return new JarFile.JarFileInputStream(is, ze.getSize(), entry);
        }
        return is;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.guard.close();
            StrictJarFile.nativeClose(this.nativeHandle);
            IoUtils.closeQuietly((AutoCloseable)((Object)this.raf));
            this.closed = true;
        }
    }

    private InputStream getZipInputStream(ZipEntry ze) {
        if (ze.getMethod() == 0) {
            return new ZipFile.RAFStream(this.raf, ze.getDataOffset(), ze.getDataOffset() + ze.getSize());
        }
        ZipFile.RAFStream wrapped = new ZipFile.RAFStream(this.raf, ze.getDataOffset(), ze.getDataOffset() + ze.getCompressedSize());
        int bufSize = Math.max(1024, (int)Math.min(ze.getSize(), 65535L));
        return new ZipFile.ZipInflaterInputStream(wrapped, new Inflater(true), bufSize, ze);
    }

    private HashMap<String, byte[]> getMetaEntries() throws IOException {
        HashMap<String, byte[]> metaEntries = new HashMap<String, byte[]>();
        EntryIterator entryIterator = new EntryIterator(this.nativeHandle, "META-INF/");
        while (entryIterator.hasNext()) {
            ZipEntry entry = (ZipEntry)entryIterator.next();
            metaEntries.put(entry.getName(), Streams.readFully(this.getInputStream(entry)));
        }
        return metaEntries;
    }

    private static long nativeOpenJarFile(String string2) throws IOException {
        return OverrideMethod.invokeL("java.util.jar.StrictJarFile#nativeOpenJarFile(Ljava/lang/String;)J", true, null);
    }

    private static long nativeStartIteration(long l, String string2) {
        return OverrideMethod.invokeL("java.util.jar.StrictJarFile#nativeStartIteration(JLjava/lang/String;)J", true, null);
    }

    private static ZipEntry nativeNextEntry(long l) {
        return (ZipEntry)OverrideMethod.invokeA("java.util.jar.StrictJarFile#nativeNextEntry(J)Ljava/util/zip/ZipEntry;", true, null);
    }

    private static ZipEntry nativeFindEntry(long l, String string2) {
        return (ZipEntry)OverrideMethod.invokeA("java.util.jar.StrictJarFile#nativeFindEntry(JLjava/lang/String;)Ljava/util/zip/ZipEntry;", true, null);
    }

    private static void nativeClose(long l) {
        OverrideMethod.invokeV("java.util.jar.StrictJarFile#nativeClose(J)V", true, null);
    }

    static class EntryIterator
    implements Iterator<ZipEntry> {
        private final long iterationHandle;
        private ZipEntry nextEntry;

        EntryIterator(long nativeHandle, String prefix) throws IOException {
            this.iterationHandle = StrictJarFile.nativeStartIteration(nativeHandle, prefix);
        }

        @Override
        public ZipEntry next() {
            if (this.nextEntry != null) {
                ZipEntry ze = this.nextEntry;
                this.nextEntry = null;
                return ze;
            }
            return StrictJarFile.nativeNextEntry(this.iterationHandle);
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry != null) {
                return true;
            }
            ZipEntry ze = StrictJarFile.nativeNextEntry(this.iterationHandle);
            if (ze == null) {
                return false;
            }
            this.nextEntry = ze;
            return true;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

