/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import android.system.ErrnoException;
import android.system.OsConstants;
import java.io.FileDescriptor;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketUtils;
import java.nio.ByteBuffer;
import java.nio.FileChannelImpl;
import java.nio.FileDescriptorChannel;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.spi.SelectorProvider;
import java.util.Arrays;
import libcore.io.IoBridge;
import libcore.io.IoUtils;
import libcore.io.Libcore;

class SocketChannelImpl
extends SocketChannel
implements FileDescriptorChannel {
    private static final int SOCKET_STATUS_UNINITIALIZED = -1;
    private static final int SOCKET_STATUS_UNCONNECTED = 0;
    private static final int SOCKET_STATUS_PENDING = 1;
    private static final int SOCKET_STATUS_CONNECTED = 2;
    private static final int SOCKET_STATUS_CLOSED = 3;
    private final FileDescriptor fd;
    private SocketAdapter socket = null;
    private InetSocketAddress connectAddress = null;
    private InetAddress localAddress = null;
    private int localPort;
    private int status = -1;
    private volatile boolean isBound = false;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();

    public SocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        this(selectorProvider, true);
    }

    public SocketChannelImpl(SelectorProvider selectorProvider, boolean connect) throws IOException {
        super(selectorProvider);
        this.status = 0;
        this.fd = connect ? IoBridge.socket(true) : new FileDescriptor();
    }

    public SocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor existingFd) throws IOException {
        super(selectorProvider);
        this.status = 2;
        this.fd = existingFd;
    }

    @Override
    public synchronized Socket socket() {
        if (this.socket == null) {
            try {
                InetAddress addr = null;
                int port = 0;
                if (this.connectAddress != null) {
                    addr = this.connectAddress.getAddress();
                    port = this.connectAddress.getPort();
                }
                this.socket = new SocketAdapter(new PlainSocketImpl(this.fd, this.localPort, addr, port), this);
            }
            catch (SocketException e) {
                return null;
            }
        }
        return this.socket;
    }

    void onBind(boolean updateSocketState) {
        SocketAddress sa;
        try {
            sa = Libcore.os.getsockname(this.fd);
        }
        catch (ErrnoException errnoException) {
            throw new AssertionError((Object)errnoException);
        }
        this.isBound = true;
        InetSocketAddress localSocketAddress = (InetSocketAddress)sa;
        this.localAddress = localSocketAddress.getAddress();
        this.localPort = localSocketAddress.getPort();
        if (updateSocketState && this.socket != null) {
            this.socket.onBind(this.localAddress, this.localPort);
        }
    }

    @Override
    public synchronized boolean isConnected() {
        return this.status == 2;
    }

    @Override
    public synchronized boolean isConnectionPending() {
        return this.status == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(SocketAddress socketAddress) throws IOException {
        int newStatus;
        InetSocketAddress inetSocketAddress;
        block11: {
            this.checkUnconnected();
            inetSocketAddress = SocketChannelImpl.validateAddress(socketAddress);
            InetAddress normalAddr = inetSocketAddress.getAddress();
            int port = inetSocketAddress.getPort();
            if (normalAddr.isAnyLocalAddress()) {
                normalAddr = InetAddress.getLocalHost();
            }
            boolean isBlocking = this.isBlocking();
            boolean finished = false;
            try {
                if (isBlocking) {
                    this.begin();
                }
                IoBridge.connect(this.fd, normalAddr, port);
                newStatus = isBlocking ? 2 : 1;
                finished = true;
            }
            catch (IOException e) {
                if (this.isEINPROGRESS(e)) {
                    newStatus = 1;
                    break block11;
                }
                if (this.isOpen()) {
                    this.close();
                    finished = true;
                }
                throw e;
            }
            finally {
                if (isBlocking) {
                    this.end(finished);
                }
            }
        }
        if (!this.isBound) {
            this.onBind(true);
        }
        this.onConnectStatusChanged(inetSocketAddress, newStatus, true);
        return this.status == 2;
    }

    void onConnectStatusChanged(InetSocketAddress address, int status, boolean updateSocketState) {
        this.status = status;
        this.connectAddress = address;
        if (status == 2 && updateSocketState && this.socket != null) {
            this.socket.onConnect(this.connectAddress.getAddress(), this.connectAddress.getPort());
        }
    }

    private boolean isEINPROGRESS(IOException e) {
        Throwable cause;
        if (this.isBlocking()) {
            return false;
        }
        if (e instanceof ConnectException && (cause = e.getCause()) instanceof ErrnoException) {
            return ((ErrnoException)cause).errno == OsConstants.EINPROGRESS;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean finishConnect() throws IOException {
        SocketChannelImpl socketChannelImpl = this;
        synchronized (socketChannelImpl) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.status == 2) {
                return true;
            }
            if (this.status != 1) {
                throw new NoConnectionPendingException();
            }
        }
        boolean finished = false;
        try {
            this.begin();
            InetAddress inetAddress = this.connectAddress.getAddress();
            int port = this.connectAddress.getPort();
            finished = IoBridge.isConnected(this.fd, inetAddress, port, 0, 0);
        }
        catch (ConnectException e) {
            if (this.isOpen()) {
                this.close();
                finished = true;
            }
            throw e;
        }
        finally {
            this.end(finished);
        }
        SocketChannelImpl socketChannelImpl2 = this;
        synchronized (socketChannelImpl2) {
            int n = this.status = finished ? 2 : this.status;
            if (finished && this.socket != null) {
                this.socket.onConnect(this.connectAddress.getAddress(), this.connectAddress.getPort());
            }
        }
        return finished;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        dst.checkWritable();
        this.checkOpenConnected();
        if (!dst.hasRemaining()) {
            return 0;
        }
        return this.readImpl(dst);
    }

    @Override
    public long read(ByteBuffer[] targets, int offset, int length) throws IOException {
        Arrays.checkOffsetAndCount((int)targets.length, (int)offset, (int)length);
        this.checkOpenConnected();
        int totalCount = FileChannelImpl.calculateTotalRemaining(targets, offset, length, true);
        if (totalCount == 0) {
            return 0L;
        }
        byte[] readArray = new byte[totalCount];
        ByteBuffer readBuffer = ByteBuffer.wrap(readArray);
        int readCount = this.readImpl(readBuffer);
        readBuffer.flip();
        if (readCount > 0) {
            int putLength;
            int index = offset;
            for (int left = readCount; left > 0; left -= putLength) {
                putLength = Math.min(targets[index].remaining(), left);
                targets[index].put(readArray, readCount - left, putLength);
                ++index;
            }
        }
        return readCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readImpl(ByteBuffer dst) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            int readCount = 0;
            try {
                if (this.isBlocking()) {
                    this.begin();
                }
                readCount = IoBridge.recvfrom(true, this.fd, dst, 0, null, false);
            }
            catch (Throwable throwable) {
                if (this.isBlocking()) {
                    this.end(readCount > 0);
                }
                throw throwable;
            }
            if (this.isBlocking()) {
                this.end(readCount > 0);
            }
            return readCount;
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        this.checkOpenConnected();
        if (!src.hasRemaining()) {
            return 0;
        }
        return this.writeImpl(src);
    }

    @Override
    public long write(ByteBuffer[] sources, int offset, int length) throws IOException {
        int gap;
        int result;
        Arrays.checkOffsetAndCount((int)sources.length, (int)offset, (int)length);
        this.checkOpenConnected();
        int count = FileChannelImpl.calculateTotalRemaining(sources, offset, length, false);
        if (count == 0) {
            return 0L;
        }
        ByteBuffer writeBuf = ByteBuffer.allocate(count);
        for (int val = offset; val < length + offset; ++val) {
            ByteBuffer source = sources[val];
            int oldPosition = source.position();
            writeBuf.put(source);
            source.position(oldPosition);
        }
        writeBuf.flip();
        int val = offset;
        int written = result;
        for (result = this.writeImpl(writeBuf); result > 0; result -= gap) {
            ByteBuffer source = sources[val];
            gap = Math.min(result, source.remaining());
            source.position(source.position() + gap);
            ++val;
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeImpl(ByteBuffer src) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (!src.hasRemaining()) {
                return 0;
            }
            int writeCount = 0;
            try {
                if (this.isBlocking()) {
                    this.begin();
                }
                writeCount = IoBridge.sendto(this.fd, src, 0, null, 0);
            }
            catch (Throwable throwable) {
                if (this.isBlocking()) {
                    this.end(writeCount >= 0);
                }
                throw throwable;
            }
            if (this.isBlocking()) {
                this.end(writeCount >= 0);
            }
            return writeCount;
        }
    }

    private synchronized void checkOpenConnected() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
    }

    private synchronized void checkUnconnected() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.status == 2) {
            throw new AlreadyConnectedException();
        }
        if (this.status == 1) {
            throw new ConnectionPendingException();
        }
    }

    static InetSocketAddress validateAddress(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new IllegalArgumentException("socketAddress == null");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        return inetSocketAddress;
    }

    @Override
    protected synchronized void implCloseSelectableChannel() throws IOException {
        if (this.status != 3) {
            this.status = 3;
            IoBridge.closeAndSignalBlockedThreads(this.fd);
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.onClose();
            }
        }
    }

    @Override
    protected void implConfigureBlocking(boolean blocking) throws IOException {
        IoUtils.setBlocking(this.fd, blocking);
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    public void onAccept(InetSocketAddress remoteAddress, boolean updateSocketState) {
        this.onBind(updateSocketState);
        this.onConnectStatusChanged(remoteAddress, 2, updateSocketState);
    }

    private static class BlockingCheckInputStream
    extends FilterInputStream {
        private final SocketChannel channel;

        public BlockingCheckInputStream(InputStream in, SocketChannel channel) {
            super(in);
            this.channel = channel;
        }

        @Override
        public int read() throws IOException {
            this.checkBlocking();
            return this.in.read();
        }

        @Override
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            this.checkBlocking();
            return this.in.read(buffer, byteOffset, byteCount);
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            this.checkBlocking();
            return this.in.read(buffer);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.channel.close();
        }

        private void checkBlocking() {
            if (!this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
        }
    }

    private static class BlockingCheckOutputStream
    extends FilterOutputStream {
        private final SocketChannel channel;

        public BlockingCheckOutputStream(OutputStream out, SocketChannel channel) {
            super(out);
            this.channel = channel;
        }

        @Override
        public void write(byte[] buffer, int offset, int byteCount) throws IOException {
            this.checkBlocking();
            this.out.write(buffer, offset, byteCount);
        }

        @Override
        public void write(int oneByte) throws IOException {
            this.checkBlocking();
            this.out.write(oneByte);
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            this.checkBlocking();
            this.out.write(buffer);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.channel.close();
        }

        private void checkBlocking() {
            if (!this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
        }
    }

    private static class SocketAdapter
    extends Socket {
        private final SocketChannelImpl channel;
        private final PlainSocketImpl socketImpl;

        SocketAdapter(PlainSocketImpl socketImpl, SocketChannelImpl channel) throws SocketException {
            super((SocketImpl)socketImpl);
            this.socketImpl = socketImpl;
            this.channel = channel;
            SocketUtils.setCreated(this);
            if (channel.isBound) {
                this.onBind(channel.localAddress, channel.localPort);
            }
            if (channel.isConnected()) {
                this.onConnect(channel.connectAddress.getAddress(), channel.connectAddress.getPort());
            }
            if (!channel.isOpen()) {
                this.onClose();
            }
        }

        @Override
        public SocketChannel getChannel() {
            return this.channel;
        }

        @Override
        public void connect(SocketAddress remoteAddr, int timeout) throws IOException {
            if (!this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            if (this.isConnected()) {
                throw new AlreadyConnectedException();
            }
            super.connect(remoteAddr, timeout);
            this.channel.onBind(false);
            if (super.isConnected()) {
                InetSocketAddress remoteInetAddress = (InetSocketAddress)remoteAddr;
                this.channel.onConnectStatusChanged(remoteInetAddress, 2, false);
            }
        }

        @Override
        public void bind(SocketAddress localAddr) throws IOException {
            if (this.channel.isConnected()) {
                throw new AlreadyConnectedException();
            }
            if (1 == this.channel.status) {
                throw new ConnectionPendingException();
            }
            super.bind(localAddr);
            this.channel.onBind(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            SocketChannelImpl socketChannelImpl = this.channel;
            synchronized (socketChannelImpl) {
                super.close();
                if (this.channel.isOpen()) {
                    this.channel.close();
                }
            }
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new BlockingCheckOutputStream(super.getOutputStream(), this.channel);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new BlockingCheckInputStream(super.getInputStream(), this.channel);
        }

        public FileDescriptor getFileDescriptor$() {
            return this.socketImpl.getFD$();
        }
    }
}

