/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import com.android.tools.layoutlib.create.OverrideMethod;
import com.android.tools.layoutlib.java.System_Delegate;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

public class FinalizerReference<T>
extends Reference<T> {
    public static final ReferenceQueue<Object> queue = new ReferenceQueue();
    private static final Object LIST_LOCK = new Object();
    private static FinalizerReference<?> head = null;
    private FinalizerReference<?> prev;
    private FinalizerReference<?> next;
    private T zombie;

    public FinalizerReference(T r, ReferenceQueue<? super T> q) {
        super(r, q);
    }

    @Override
    public T get() {
        return this.zombie;
    }

    @Override
    public void clear() {
        this.zombie = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Object referent) {
        FinalizerReference<Object> reference = new FinalizerReference<Object>(referent, queue);
        Object object = LIST_LOCK;
        synchronized (object) {
            reference.prev = null;
            reference.next = head;
            if (head != null) {
                FinalizerReference.head.prev = reference;
            }
            head = reference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(FinalizerReference<?> reference) {
        Object object = LIST_LOCK;
        synchronized (object) {
            FinalizerReference<?> next = reference.next;
            FinalizerReference<?> prev = reference.prev;
            reference.next = null;
            reference.prev = null;
            if (prev != null) {
                prev.next = next;
            } else {
                head = next;
            }
            if (next != null) {
                next.prev = prev;
            }
        }
    }

    public static void finalizeAllEnqueued(long timeout) throws InterruptedException {
        Sentinel sentinel;
        while (!FinalizerReference.enqueueSentinelReference(sentinel = new Sentinel())) {
        }
        sentinel.awaitFinalization(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean enqueueSentinelReference(Sentinel sentinel) {
        Object object = LIST_LOCK;
        synchronized (object) {
            FinalizerReference<?> r = head;
            while (r != null) {
                if (r.referent == sentinel) {
                    FinalizerReference<?> sentinelReference = r;
                    sentinelReference.referent = null;
                    sentinelReference.zombie = sentinel;
                    if (!super.makeCircularListIfUnenqueued()) {
                        return false;
                    }
                    ReferenceQueue.add(sentinelReference);
                    return true;
                }
                r = r.next;
            }
        }
        throw new AssertionError((Object)"newly-created live Sentinel not on list!");
    }

    private boolean makeCircularListIfUnenqueued() {
        return OverrideMethod.invokeI("java.lang.ref.FinalizerReference#makeCircularListIfUnenqueued()Z", true, this) != 0;
    }

    private static class Sentinel {
        boolean finalized = false;

        private Sentinel() {
        }

        protected synchronized void finalize() throws Throwable {
            if (this.finalized) {
                throw new AssertionError();
            }
            this.finalized = true;
            this.notifyAll();
        }

        synchronized void awaitFinalization(long timeout) throws InterruptedException {
            long startTime = System_Delegate.nanoTime();
            long endTime = startTime + timeout;
            while (!this.finalized) {
                if (timeout != 0L) {
                    long currentTime = System_Delegate.nanoTime();
                    if (currentTime >= endTime) break;
                    long deltaTime = endTime - currentTime;
                    this.wait(deltaTime / 1000000L, (int)(deltaTime % 1000000L));
                    continue;
                }
                this.wait();
            }
        }
    }
}

