/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.system.ErrnoException;
import android.system.OsConstants;
import android.system.StructStat;
import com.android.tools.layoutlib.java.System_Delegate;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import libcore.io.IoUtils;
import libcore.io.Libcore;

class DexPathList {
    private static final String DEX_SUFFIX = ".dex";
    private static final String zipSeparator = "!/";
    private final ClassLoader definingContext;
    private final Element[] dexElements;
    private final Element[] nativeLibraryPathElements;
    private final List<File> nativeLibraryDirectories;
    private final List<File> systemNativeLibraryDirectories;
    private final IOException[] dexElementsSuppressedExceptions;

    public DexPathList(ClassLoader definingContext, String dexPath, String libraryPath, File optimizedDirectory) {
        if (definingContext == null) {
            throw new NullPointerException("definingContext == null");
        }
        if (dexPath == null) {
            throw new NullPointerException("dexPath == null");
        }
        if (optimizedDirectory != null) {
            if (!optimizedDirectory.exists()) {
                throw new IllegalArgumentException("optimizedDirectory doesn't exist: " + optimizedDirectory);
            }
            if (!optimizedDirectory.canRead() || !optimizedDirectory.canWrite()) {
                throw new IllegalArgumentException("optimizedDirectory not readable/writable: " + optimizedDirectory);
            }
        }
        this.definingContext = definingContext;
        ArrayList<IOException> suppressedExceptions = new ArrayList<IOException>();
        this.dexElements = DexPathList.makePathElements(DexPathList.splitDexPath(dexPath), optimizedDirectory, suppressedExceptions);
        this.nativeLibraryDirectories = DexPathList.splitPaths(libraryPath, false);
        this.systemNativeLibraryDirectories = DexPathList.splitPaths(System.getProperty("java.library.path"), true);
        ArrayList<File> allNativeLibraryDirectories = new ArrayList<File>(this.nativeLibraryDirectories);
        allNativeLibraryDirectories.addAll(this.systemNativeLibraryDirectories);
        this.nativeLibraryPathElements = DexPathList.makePathElements(allNativeLibraryDirectories, null, suppressedExceptions);
        this.dexElementsSuppressedExceptions = suppressedExceptions.size() > 0 ? suppressedExceptions.toArray(new IOException[suppressedExceptions.size()]) : null;
    }

    public String toString() {
        ArrayList<File> allNativeLibraryDirectories = new ArrayList<File>(this.nativeLibraryDirectories);
        allNativeLibraryDirectories.addAll(this.systemNativeLibraryDirectories);
        Object[] nativeLibraryDirectoriesArray = allNativeLibraryDirectories.toArray(new File[allNativeLibraryDirectories.size()]);
        return "DexPathList[" + Arrays.toString(this.dexElements) + ",nativeLibraryDirectories=" + Arrays.toString(nativeLibraryDirectoriesArray) + "]";
    }

    public List<File> getNativeLibraryDirectories() {
        return this.nativeLibraryDirectories;
    }

    private static List<File> splitDexPath(String path) {
        return DexPathList.splitPaths(path, false);
    }

    private static List<File> splitPaths(String searchPath, boolean directoriesOnly) {
        ArrayList<File> result = new ArrayList<File>();
        if (searchPath != null) {
            for (String path : searchPath.split(File.pathSeparator)) {
                if (directoriesOnly) {
                    try {
                        StructStat sb = Libcore.os.stat(path);
                        if (!OsConstants.S_ISDIR(sb.st_mode)) {
                        }
                    }
                    catch (ErrnoException ignored) {}
                    continue;
                }
                result.add(new File(path));
            }
        }
        return result;
    }

    private static Element[] makePathElements(List<File> files, File optimizedDirectory, List<IOException> suppressedExceptions) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (File file : files) {
            File zip = null;
            File dir = new File("");
            DexFile dex = null;
            String path = file.getPath();
            String name = file.getName();
            if (path.contains(zipSeparator)) {
                String[] split = path.split(zipSeparator, 2);
                zip = new File(split[0]);
                dir = new File(split[1]);
            } else if (file.isDirectory()) {
                elements.add(new Element(file, true, null, null));
            } else if (file.isFile()) {
                if (name.endsWith(DEX_SUFFIX)) {
                    try {
                        dex = DexPathList.loadDexFile(file, optimizedDirectory);
                    }
                    catch (IOException ex) {
                        System_Delegate.log("Unable to load dex file: " + file, ex);
                    }
                } else {
                    zip = file;
                    try {
                        dex = DexPathList.loadDexFile(file, optimizedDirectory);
                    }
                    catch (IOException suppressed) {
                        suppressedExceptions.add(suppressed);
                    }
                }
            } else {
                System_Delegate.log("ClassLoader referenced unknown path: " + file);
            }
            if (zip == null && dex == null) continue;
            elements.add(new Element(dir, false, zip, dex));
        }
        return elements.toArray(new Element[elements.size()]);
    }

    private static DexFile loadDexFile(File file, File optimizedDirectory) throws IOException {
        if (optimizedDirectory == null) {
            return new DexFile(file);
        }
        String optimizedPath = DexPathList.optimizedPathFor(file, optimizedDirectory);
        return DexFile.loadDex(file.getPath(), optimizedPath, 0);
    }

    private static String optimizedPathFor(File path, File optimizedDirectory) {
        String fileName = path.getName();
        if (!fileName.endsWith(DEX_SUFFIX)) {
            int lastDot = fileName.lastIndexOf(".");
            if (lastDot < 0) {
                fileName = fileName + DEX_SUFFIX;
            } else {
                StringBuilder sb = new StringBuilder(lastDot + 4);
                sb.append(fileName, 0, lastDot);
                sb.append(DEX_SUFFIX);
                fileName = sb.toString();
            }
        }
        File result = new File(optimizedDirectory, fileName);
        return result.getPath();
    }

    public Class findClass(String name, List<Throwable> suppressed) {
        for (Element element : this.dexElements) {
            Class clazz;
            DexFile dex = element.dexFile;
            if (dex == null || (clazz = dex.loadClassBinaryName(name, this.definingContext, suppressed)) == null) continue;
            return clazz;
        }
        if (this.dexElementsSuppressedExceptions != null) {
            suppressed.addAll(Arrays.asList(this.dexElementsSuppressedExceptions));
        }
        return null;
    }

    public URL findResource(String name) {
        for (Element element : this.dexElements) {
            URL url = element.findResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public Enumeration<URL> findResources(String name) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Element element : this.dexElements) {
            URL url = element.findResource(name);
            if (url == null) continue;
            result.add(url);
        }
        return Collections.enumeration(result);
    }

    public String findLibrary(String libraryName) {
        String fileName = System.mapLibraryName(libraryName);
        for (Element element : this.nativeLibraryPathElements) {
            String path = element.findNativeLibrary(fileName);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    static class Element {
        private final File dir;
        private final boolean isDirectory;
        private final File zip;
        private final DexFile dexFile;
        private ZipFile zipFile;
        private boolean initialized;

        public Element(File dir, boolean isDirectory, File zip, DexFile dexFile) {
            this.dir = dir;
            this.isDirectory = isDirectory;
            this.zip = zip;
            this.dexFile = dexFile;
        }

        public String toString() {
            if (this.isDirectory) {
                return "directory \"" + this.dir + "\"";
            }
            if (this.zip != null) {
                return "zip file \"" + this.zip + "\"" + (this.dir != null && !this.dir.getPath().isEmpty() ? ", dir \"" + this.dir + "\"" : "");
            }
            return "dex file \"" + this.dexFile + "\"";
        }

        public synchronized void maybeInit() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            if (this.isDirectory || this.zip == null) {
                return;
            }
            try {
                this.zipFile = new ZipFile(this.zip);
            }
            catch (IOException ioe) {
                System_Delegate.log("Unable to open zip file: " + this.zip, ioe);
                this.zipFile = null;
            }
        }

        private boolean isZipEntryExistsAndStored(ZipFile zipFile, String path) {
            ZipEntry entry = zipFile.getEntry(path);
            return entry != null && entry.getMethod() == 0;
        }

        public String findNativeLibrary(String name) {
            String entryName;
            this.maybeInit();
            if (this.isDirectory) {
                String path = new File(this.dir, name).getPath();
                if (IoUtils.canOpenReadOnly(path)) {
                    return path;
                }
            } else if (this.zipFile != null && this.isZipEntryExistsAndStored(this.zipFile, entryName = new File(this.dir, name).getPath())) {
                return this.zip.getPath() + DexPathList.zipSeparator + entryName;
            }
            return null;
        }

        public URL findResource(String name) {
            File resourceFile;
            this.maybeInit();
            if (this.isDirectory && (resourceFile = new File(this.dir, name)).exists()) {
                try {
                    return resourceFile.toURI().toURL();
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (this.zipFile == null || this.zipFile.getEntry(name) == null) {
                return null;
            }
            try {
                return new URL("jar:" + this.zip.toURL() + DexPathList.zipSeparator + name);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

